/* Somaplayer - Copyright (C) 2003-5 bakunin - Andrea Marchesini 
 *                                     <bakunin@autistici.org>
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This program is released under the GPL with the additional exemption that
 * compiling, linking, and/or using OpenSSL is allowed.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#else
# error Use configure; make; make install
#endif

#ifdef ENABLE_GTK

#include "../player.h"
#include "../other.h"
#include "gdaemon.h"

GtkWidget *af_active;

/* Hide and show the autofader window */
void
autofader_hide (GtkWidget * w, gpointer data)
{
  gtk_widget_hide (autofader);
}

void
autofader_show (GtkWidget * w, gpointer data)
{
  gtk_widget_show (autofader);
}

/* Update the graphic element and the output values */
void
autofader_value_changed (GtkWidget * widget, gpointer user_data)
{
  GtkAdjustment *v;

  if (!gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (af_active)))
    return;

  v = gtk_range_get_adjustment (GTK_RANGE (widget));
  play->daemon->autofader = (int) v->value;
}

/* Active the widget AF */
void
autofader_toggled (GtkWidget * widget, gpointer user_data)
{
  daemon_client *c = (daemon_client *) user_data;

  if (!c)
    fatal (_("Internal error."));

  if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (widget)) == TRUE)
    {
      c->autofader = 1;
      return;
    }

  c->autofader = 0;
}

/* Create the window */
GtkWidget *
create_autofader (void)
{
  GtkWidget *window;
  GtkWidget *frame;
  GtkWidget *af;
  GtkWidget *box;

  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_size_request (window, 400, -1);
  gtk_window_set_title (GTK_WINDOW (window), _("SdS - autofader"));

  frame = gtk_frame_new (NULL);
  gtk_widget_show (frame);
  gtk_container_add (GTK_CONTAINER (window), frame);

  box = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (box);
  gtk_container_add (GTK_CONTAINER (frame), box);

  af_active = gtk_check_button_new_with_mnemonic (_("_Active"));
  gtk_widget_show (af_active);
  gtk_box_pack_start (GTK_BOX (box), af_active, FALSE, FALSE, 0);

  af =
    gtk_hscale_new (GTK_ADJUSTMENT
		    (gtk_adjustment_new (70, 0, 100, 5, 10, 0)));
  gtk_widget_show (af);
  gtk_box_pack_start (GTK_BOX (box), af, TRUE, TRUE, 0);

  g_signal_connect ((gpointer) window, "delete_event",
		    G_CALLBACK (autofader_hide), NULL);
  g_signal_connect ((gpointer) af, "value_changed",
		    G_CALLBACK (autofader_value_changed), NULL);

  return window;
}

#endif

/* EOF */
