/* Somaplayer - Copyright (C) 2003-5 bakunin - Andrea Marchesini 
 *                                     <bakunin@autistici.org>
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This program is released under the GPL with the additional exemption that
 * compiling, linking, and/or using OpenSSL is allowed.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#else
# error Use configure; make; make install
#endif

#include "../player.h"
#include "../audio.h"
#include "../output.h"
#include "graphic.h"

static int output_win = 1;

gint output_list_popup (GtkWidget *, GdkEvent *, gpointer);

void
output_list_select_stop (GtkWidget * w, GtkTreeSelection * selection)
{

  GtkTreeModel *model;
  GtkTreeIter iter;
  audio *ao;

  if (!selection)
    return;

  if (gtk_tree_selection_get_selected (selection, &model, &iter))
    {

      gtk_tree_model_get (model, &iter, 1, &ao, -1);

      if (!ao)
	return;

      if (ao->stop)
	ao->stop = 0;
      else
	ao->stop = 1;

      output_list_refresh ();

      gtk_tree_selection_unselect_all (selection);
      gtk_tree_selection_select_iter (selection, &iter);
    }
}

void
output_list_select_show (GtkWidget * w, GtkTreeSelection * selection)
{

  GtkTreeModel *model;
  GtkTreeIter iter;
  audio *ao;

  if (!selection)
    return;

  if (gtk_tree_selection_get_selected (selection, &model, &iter))
    {

      gtk_tree_model_get (model, &iter, 1, &ao, -1);

      if (!ao)
	return;

      switch (ao->audio_type)
	{
#ifdef ENABLE_AO
	case USE_ESD:
	case USE_ARTS:
	case USE_SUN:
	case USE_OSS:
	case USE_AUDIO:
	case USE_ALSA:
	case USE_ALSA09:
	case USE_NULL:
	case USE_STDOUT:
	  on_ao_show_activate (NULL, ao);
	  break;
#endif
#ifdef ENABLE_SNDFILE
	case USE_WAV:
	case USE_AIFF:
	case USE_AU:
	case USE_RAW:
	case USE_PAF:
	case USE_SVX:
	case USE_NIST:
	case USE_VOC:
	case USE_IRCAM:
	case USE_W64:
	case USE_MAT4:
	case USE_MAT5:
	case USE_PVF:
	case USE_XI:
	case USE_HTK:
#ifdef USE_MIDI
	case USE_MIDI:
#endif
#ifdef USE_AVR
	case USE_AVR:
#endif
#ifdef USE_WAVEX
	case USE_WAVEX:
#endif
	  on_write_a_file_show_activate (NULL, ao);
	  break;
#endif

#ifdef ENABLE_STREAMING
#ifdef ENABLE_ICECAST
	case USE_ICECAST:
	  on_icecast_show_activate (NULL, ao);
	  break;
#endif

#ifdef ENABLE_ICECAST2
	case USE_ICECAST2:
	  on_icecast2_show_activate (NULL, ao);
	  break;
#endif

#ifdef ENABLE_SHOUTCAST
	case USE_SHOUTCAST:
	  on_shoutcast_show_activate (NULL, ao);
	  break;
#endif
#endif

#ifdef ENABLE_LAME
	case USE_LAME:
	  on_lame_show_activate (NULL, ao);
	  break;
#endif

#ifdef ENABLE_OGG
	case USE_OGG:
	  on_ogg_show_activate (NULL, ao);
	  break;
#endif

#ifdef ENABLE_DAEMON
	case USE_DAEMON:
	  on_sds_show_activate (NULL, ao);
	  break;
#endif

	case USE_MONITOR:
	  on_monitor_show_activate (NULL, ao);
	  break;
	}
    }
}

void
output_list_select_remove (GtkWidget * w, GtkTreeSelection * selection)
{

  GtkTreeModel *model;
  GtkTreeIter iter;

  if (!selection)
    return;

  if (gtk_tree_selection_get_selected (selection, &model, &iter))
    {

      if (dialog_ask (_("Sure to delete this output?")) == GTK_RESPONSE_OK)
	{
	  audio *ao;

	  gtk_tree_model_get (model, &iter, 1, &ao, -1);
	  gtk_list_store_remove (GTK_LIST_STORE (model), &iter);

	  if (!ao)
	    return;

	  output_lock ();

	  while (1)
	    {
	      if (ao->status == OUTPUT_DONE || ao->status == OUTPUT_ERROR)
		break;
	    }

	  ao->status = OUTPUT_CLOSE;
	  pthread_cond_signal (&ao->cond);

	  while (1)
	    {
	      pthread_mutex_lock (&ao->mutex);

	      if (ao->status == OUTPUT_DONE || ao->status == OUTPUT_ERROR)
		break;

	      pthread_mutex_unlock (&ao->mutex);
	    }

	  pthread_mutex_unlock (&ao->mutex);

	  output_remove_nb (ao);

	  output_unlock ();
	}
    }
}

void
output_list_add (audio * ao, int where)
{
  GtkTreeView *view = GTK_TREE_VIEW (output_list);
  GtkTreeModel *model;
  GtkTreeIter iter;
  char str[SIZE_BUFFER];

  if (!ao)
    return;

  model = gtk_tree_view_get_model (GTK_TREE_VIEW (view));

  switch (ao->audio_type)
    {
#ifdef ENABLE_STREAMING
#ifdef ENABLE_ICECAST
    case USE_ICECAST:
      {
	audio_data_streaming *data = (audio_data_streaming *) ao->data;

	if (!data)
	  snprintf (str, SIZE_BUFFER,
		    _("%sICECAST streaming server %ld Kbytes - %s"),
		    ao->stop ? "STOPPED " : "", play->ao_rate,
		    play->ao_channels == 1 ? "mono" : "stereo");
	else
	  snprintf (str, SIZE_BUFFER,
		    _
		    ("%sICECAST streaming server: http://%s:%d/%s %ld Kbytes - %s"),
		    ao->stop ? "STOPPED " : "", data->server, data->port,
		    data->mount, play->ao_rate,
		    play->ao_channels == 1 ? "mono" : "stereo");
      }
      break;
#endif

#ifdef ENABLE_ICECAST2
    case USE_ICECAST2:
      {
	audio_data_streaming *data = (audio_data_streaming *) ao->data;

	if (!data)
	  snprintf (str, SIZE_BUFFER,
		    _("%sICECAST2 streaming server %ld Kbytes - %s"),
		    ao->stop ? "STOPPED " : "", play->ao_rate,
		    play->ao_channels == 1 ? "mono" : "stereo");
	else
	  snprintf (str, SIZE_BUFFER,
		    _
		    ("%sICECAST2 streaming server: http://%s:%d/%s %ld Kbytes - %s"),
		    ao->stop ? "STOPPED " : "", data->server, data->port,
		    data->mount, play->ao_rate,
		    play->ao_channels == 1 ? "mono" : "stereo");
      }
      break;
#endif

#ifdef ENABLE_SHOUTCAST
    case USE_SHOUTCAST:
      {
	audio_data_streaming *data = (audio_data_streaming *) ao->data;

	if (!data)
	  snprintf (str, SIZE_BUFFER,
		    _("%sSHOUTCAST streaming server %ld Kbytes - %s"),
		    ao->stop ? "STOPPED " : "", play->ao_rate,
		    play->ao_channels == 1 ? "mono" : "stereo");
	else
	  snprintf (str, SIZE_BUFFER,
		    _
		    ("%sSHOUTCAST streaming server: http://%s:%d/%s %ld Kbytes - %s"),
		    ao->stop ? "STOPPED " : "", data->server, data->port,
		    data->mount, play->ao_rate,
		    play->ao_channels == 1 ? "mono" : "stereo");
      }
      break;
#endif
#endif

#ifdef ENABLE_LAME
    case USE_LAME:
      {
	audio_data_lame *data = (audio_data_lame *) ao->data;

	if (!data)
	  snprintf (str, SIZE_BUFFER, _("%sEncode Mp3 file %ld Kbytes - %s"),
		    ao->stop ? "STOPPED " : "", play->ao_rate,
		    play->ao_channels == 1 ? "mono" : "stereo");
	else
	  snprintf (str, SIZE_BUFFER,
		    _("%sEconde Mp3 output file %s %ld Kbytes - %s"),
		    ao->stop ? "STOPPED " : "", data->file, play->ao_rate,
		    play->ao_channels == 1 ? "mono" : "stereo");

      }
      break;
#endif

#ifdef ENABLE_OGG
    case USE_OGG:
      {
	audio_data_vorbis *data = (audio_data_vorbis *) ao->data;

	if (!data)
	  snprintf (str, SIZE_BUFFER,
		    _("%sEncode Ogg/Vorbis file %ld Kbytes - %s"),
		    ao->stop ? "STOPPED " : "", play->ao_rate,
		    play->ao_channels == 1 ? "mono" : "stereo");
	else
	  snprintf (str, SIZE_BUFFER,
		    _("%sEconde Ogg/Vorbis output file %s %ld Kbytes - %s"),
		    ao->stop ? "STOPPED " : "", data->file, play->ao_rate,
		    play->ao_channels == 1 ? "mono" : "stereo");
      }
      break;
#endif

#ifdef ENABLE_DAEMON
    case USE_DAEMON:
      if (!ao->audio_dev)
	snprintf (str, SIZE_BUFFER,
		  _("%sSoma Distirbuited Sound %ld Kbytes - %s"),
		  ao->stop ? "STOPPED " : "", play->ao_rate,
		  play->ao_channels == 1 ? "mono" : "stereo");
      else
	snprintf (str, SIZE_BUFFER,
		  _("%sSoma Distribuited Sound %s %ld Kbytes - %s"),
		  ao->stop ? "STOPPED " : "", ao->audio_dev, play->ao_rate,
		  play->ao_channels == 1 ? "mono" : "stereo");

      break;
#endif

#ifdef ENABLE_AO
    case USE_ESD:
      snprintf (str, SIZE_BUFFER, _("%sESD output %ld Kbytes - %s"),
		ao->stop ? "STOPPED " : "", play->ao_rate,
		play->ao_channels == 1 ? "mono" : "stereo");
      break;
    case USE_ARTS:
      snprintf (str, SIZE_BUFFER, _("%sARTS output %ld Kbytes - %s"),
		ao->stop ? "STOPPED " : "", play->ao_rate,
		play->ao_channels == 1 ? "mono" : "stereo");
      break;
    case USE_SUN:
      snprintf (str, SIZE_BUFFER, _("%sSUN output %ld Kbytes - %s"),
		ao->stop ? "STOPPED " : "", play->ao_rate,
		play->ao_channels == 1 ? "mono" : "stereo");
      break;
    case USE_AUDIO:
      snprintf (str, SIZE_BUFFER, _("%sAudio Interface %ld Kbytes - %s"),
		ao->stop ? "STOPPED " : "", play->ao_rate,
		play->ao_channels == 1 ? "mono" : "stereo");
      break;
    case USE_OSS:
      snprintf (str, SIZE_BUFFER, _("%sOSS output %ld Kbytes - %s"),
		ao->stop ? "STOPPED " : "", play->ao_rate,
		play->ao_channels == 1 ? "mono" : "stereo");
      break;
    case USE_ALSA09:
      snprintf (str, SIZE_BUFFER, _("%sALSA v0.9 output %ld Kbytes - %s"),
		ao->stop ? "STOPPED " : "", play->ao_rate,
		play->ao_channels == 1 ? "mono" : "stereo");
      break;
    case USE_ALSA:
      snprintf (str, SIZE_BUFFER, _("%sALSA output %ld Kbytes - %s"),
		ao->stop ? "STOPPED " : "", play->ao_rate,
		play->ao_channels == 1 ? "mono" : "stereo");
      break;
    case USE_STDOUT:
      snprintf (str, SIZE_BUFFER, _("%sSTDOUT output %ld Kbytes - %s"),
		ao->stop ? "STOPPED " : "", play->ao_rate,
		play->ao_channels == 1 ? "mono" : "stereo");
      break;
    case USE_NULL:
      snprintf (str, SIZE_BUFFER, _("%sNULL output %ld Kbytes - %s"),
		ao->stop ? "STOPPED " : "", play->ao_rate,
		play->ao_channels == 1 ? "mono" : "stereo");
      break;
#endif

#ifdef ENABLE_SNDFILE
    case USE_WAV:
      snprintf (str, SIZE_BUFFER, _("%sWAV output: %s %ld Kbytes - %s"),
		ao->stop ? "STOPPED " : "", ao->audio_dev, play->ao_rate,
		play->ao_channels == 1 ? "mono" : "stereo");
      break;

    case USE_AIFF:
      snprintf (str, SIZE_BUFFER, _("%sAIFF output: %s %ld Kbytes - %s"),
		ao->stop ? "STOPPED " : "", ao->audio_dev, play->ao_rate,
		play->ao_channels == 1 ? "mono" : "stereo");
      break;

    case USE_AU:
      snprintf (str, SIZE_BUFFER, _("%sAU output: %s %ld Kbytes - %s"),
		ao->stop ? "STOPPED " : "", ao->audio_dev, play->ao_rate,
		play->ao_channels == 1 ? "mono" : "stereo");
      break;

    case USE_RAW:
      snprintf (str, SIZE_BUFFER, _("%sRAW output: %s %ld Kbytes - %s"),
		ao->stop ? "STOPPED " : "", ao->audio_dev, play->ao_rate,
		play->ao_channels == 1 ? "mono" : "stereo");
      break;

    case USE_PAF:
      snprintf (str, SIZE_BUFFER, _("%sPAF output: %s %ld Kbytes - %s"),
		ao->stop ? "STOPPED " : "", ao->audio_dev, play->ao_rate,
		play->ao_channels == 1 ? "mono" : "stereo");
      break;

    case USE_SVX:
      snprintf (str, SIZE_BUFFER, _("%sSVX output: %s %ld Kbytes - %s"),
		ao->stop ? "STOPPED " : "", ao->audio_dev, play->ao_rate,
		play->ao_channels == 1 ? "mono" : "stereo");
      break;

    case USE_NIST:
      snprintf (str, SIZE_BUFFER, _("%sNIST output: %s %ld Kbytes - %s"),
		ao->stop ? "STOPPED " : "", ao->audio_dev, play->ao_rate,
		play->ao_channels == 1 ? "mono" : "stereo");
      break;

    case USE_VOC:
      snprintf (str, SIZE_BUFFER, _("%sVOC output: %s %ld Kbytes - %s"),
		ao->stop ? "STOPPED " : "", ao->audio_dev, play->ao_rate,
		play->ao_channels == 1 ? "mono" : "stereo");
      break;

    case USE_IRCAM:
      snprintf (str, SIZE_BUFFER, _("%sIRCAM output: %s %ld Kbytes - %s"),
		ao->stop ? "STOPPED " : "", ao->audio_dev, play->ao_rate,
		play->ao_channels == 1 ? "mono" : "stereo");
      break;

    case USE_W64:
      snprintf (str, SIZE_BUFFER, _("%sW64 output: %s %ld Kbytes - %s"),
		ao->stop ? "STOPPED " : "", ao->audio_dev, play->ao_rate,
		play->ao_channels == 1 ? "mono" : "stereo");
      break;

    case USE_MAT4:
      snprintf (str, SIZE_BUFFER, _("%sMAT4 output: %s %ld Kbytes - %s"),
		ao->stop ? "STOPPED " : "", ao->audio_dev, play->ao_rate,
		play->ao_channels == 1 ? "mono" : "stereo");
      break;

    case USE_MAT5:
      snprintf (str, SIZE_BUFFER, _("%sMAT5 output: %s %ld Kbytes - %s"),
		ao->stop ? "STOPPED " : "", ao->audio_dev, play->ao_rate,
		play->ao_channels == 1 ? "mono" : "stereo");
      break;

    case USE_PVF:
      snprintf (str, SIZE_BUFFER, _("%sPVF output: %s %ld Kbytes - %s"),
		ao->stop ? "STOPPED " : "", ao->audio_dev, play->ao_rate,
		play->ao_channels == 1 ? "mono" : "stereo");
      break;

    case USE_XI:
      snprintf (str, SIZE_BUFFER, _("%sXI output: %s %ld Kbytes - %s"),
		ao->stop ? "STOPPED " : "", ao->audio_dev, play->ao_rate,
		play->ao_channels == 1 ? "mono" : "stereo");
      break;

    case USE_HTK:
      snprintf (str, SIZE_BUFFER, _("%sHTK output: %s %ld Kbytes - %s"),
		ao->stop ? "STOPPED " : "", ao->audio_dev, play->ao_rate,
		play->ao_channels == 1 ? "mono" : "stereo");
      break;

#ifdef USE_MIDI
    case USE_MIDI:
      snprintf (str, SIZE_BUFFER, _("%sMIDI output: %s %ld Kbytes - %s"),
		ao->stop ? "STOPPED " : "", ao->audio_dev, play->ao_rate,
		play->ao_channels == 1 ? "mono" : "stereo");
      break;
#endif

#ifdef USE_AVR
    case USE_AVR:
      snprintf (str, SIZE_BUFFER, _("%sAVR output: %s %ld Kbytes - %s"),
		ao->stop ? "STOPPED " : "", ao->audio_dev, play->ao_rate,
		play->ao_channels == 1 ? "mono" : "stereo");
      break;
#endif

#ifdef USE_WAVEX
    case USE_WAVEX:
      snprintf (str, SIZE_BUFFER, _("%sWAVEX output: %s %ld Kbytes - %s"),
		ao->stop ? "STOPPED " : "", ao->audio_dev, play->ao_rate,
		play->ao_channels == 1 ? "mono" : "stereo");
      break;
#endif

#endif

    case USE_MONITOR:
      snprintf (str, SIZE_BUFFER, _("%sMONITOR output: %s %ld Kbytes - %s"),
		ao->stop ? "STOPPED " : "", ao->audio_dev, play->ao_rate,
		play->ao_channels == 1 ? "mono" : "stereo");
      break;

    default:
      snprintf (str, SIZE_BUFFER, _("Audio output"));
      break;
    }

  if (where == PREPEND)
    gtk_list_store_prepend (GTK_LIST_STORE (model), &iter);
  else
    gtk_list_store_append (GTK_LIST_STORE (model), &iter);
  gtk_list_store_set (GTK_LIST_STORE (model), &iter, 0, str, 1, ao, -1);
}

void
output_list_refresh (void)
{
  GtkTreeModel *model;
  GtkTreeIter iter;
  audio *ao;

  output_lock ();

  model = gtk_tree_view_get_model (GTK_TREE_VIEW (output_list));
  while (gtk_tree_model_iter_nth_child
	 (GTK_TREE_MODEL (model), &iter, NULL, 0))
    gtk_list_store_remove (GTK_LIST_STORE (model), &iter);

  ao = play->output;
  while (ao)
    {
      output_list_add (ao, APPEND);
      ao = ao->next;
    }

  output_unlock ();
}

gboolean
output_list_m_show (GtkWidget * w, GdkEventButton * event, gpointer menu)
{
  if (event->button == 3)
    {
      gtk_menu_popup (GTK_MENU (w), NULL, NULL, NULL, NULL, event->button,
		      event->time);
      return TRUE;
    }

  return FALSE;
}

GtkWidget *
create_output_list_menu (GtkTreeSelection * selection)
{
  GtkWidget *menu;
  GtkWidget *menu_s;
  GtkWidget *item;

  menu = gtk_menu_new ();

  item = gtk_menu_item_new_with_mnemonic (_("Add"));
  gtk_widget_show (item);
  gtk_container_add (GTK_CONTAINER (menu), item);

  menu_s = output_list_menu ();
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (item), menu_s);

  item = gtk_menu_item_new_with_mnemonic (_("Remove"));
  gtk_widget_show (item);
  gtk_container_add (GTK_CONTAINER (menu), item);

  g_signal_connect ((gpointer) item, "activate",
		    G_CALLBACK (output_list_select_remove), selection);

  item = gtk_menu_item_new_with_mnemonic (_("Show"));
  gtk_widget_show (item);
  gtk_container_add (GTK_CONTAINER (menu), item);

  g_signal_connect ((gpointer) item, "activate",
		    G_CALLBACK (output_list_select_show), selection);

  item = gtk_menu_item_new_with_mnemonic (_("Stop/Start"));
  gtk_widget_show (item);
  gtk_container_add (GTK_CONTAINER (menu), item);

  g_signal_connect ((gpointer) item, "activate",
		    G_CALLBACK (output_list_select_stop), selection);


  return menu;
}

GtkWidget *
output_list_menu (void)
{
  GtkWidget *menu;
  GtkWidget *audio;
#ifdef ENABLE_DAEMON
  GtkWidget *sds;
#endif

#ifdef ENABLE_LAME
  GtkWidget *lame;
#endif

#ifdef ENABLE_OGG
  GtkWidget *ogg;
#endif

#ifdef ENABLE_SNDFILE
  GtkWidget *write_a_file;
#endif

#ifdef ENABLE_STREAMING
#ifdef ENABLE_ICECAST
  GtkWidget *icecast;
#endif

#ifdef ENABLE_ICECAST2
  GtkWidget *icecast2;
#endif

#ifdef ENABLE_SHOUTCAST
  GtkWidget *shoutcast;
#endif
#endif

  menu = gtk_menu_new ();

#ifdef ENABLE_AO
  audio = gtk_menu_item_new_with_mnemonic (_("audio"));
  gtk_widget_show (audio);
  gtk_container_add (GTK_CONTAINER (menu), audio);

  g_signal_connect ((gpointer) audio, "activate",
		    G_CALLBACK (on_ao_new_activate), NULL);
#endif

#ifdef ENABLE_DAEMON
  sds = gtk_menu_item_new_with_mnemonic (_("Soma Distribuited Sound"));
  gtk_widget_show (sds);
  gtk_container_add (GTK_CONTAINER (menu), sds);

  g_signal_connect ((gpointer) sds, "activate",
		    G_CALLBACK (on_sds_new_activate), NULL);
#endif

#ifdef ENABLE_LAME
  lame = gtk_menu_item_new_with_mnemonic (_("Encode Mp3"));
  gtk_widget_show (lame);
  gtk_container_add (GTK_CONTAINER (menu), lame);

  g_signal_connect ((gpointer) lame, "activate",
		    G_CALLBACK (on_lame_new_activate), NULL);
#endif

#ifdef ENABLE_OGG
  ogg = gtk_menu_item_new_with_mnemonic (_("Encode Ogg"));
  gtk_widget_show (ogg);
  gtk_container_add (GTK_CONTAINER (menu), ogg);

  g_signal_connect ((gpointer) ogg, "activate",
		    G_CALLBACK (on_ogg_new_activate), NULL);
#endif

#ifdef ENABLE_SNDFILE
  write_a_file = gtk_menu_item_new_with_mnemonic (_("Write a file"));
  gtk_widget_show (write_a_file);
  gtk_container_add (GTK_CONTAINER (menu), write_a_file);

  g_signal_connect ((gpointer) write_a_file, "activate",
		    G_CALLBACK (on_write_a_file_new_activate), NULL);
#endif

#ifdef ENABLE_STREAMING

#ifdef ENABLE_ICECAST
  icecast = gtk_menu_item_new_with_mnemonic (_("Icecast"));
  gtk_widget_show (icecast);
  gtk_container_add (GTK_CONTAINER (menu), icecast);

  g_signal_connect ((gpointer) icecast, "activate",
		    G_CALLBACK (on_icecast_new_activate), NULL);
#endif

#ifdef ENABLE_ICECAST2
  icecast2 = gtk_menu_item_new_with_mnemonic (_("Icecast2"));
  gtk_widget_show (icecast2);
  gtk_container_add (GTK_CONTAINER (menu), icecast2);

  g_signal_connect ((gpointer) icecast2, "activate",
		    G_CALLBACK (on_icecast2_new_activate), NULL);
#endif

#ifdef ENABLE_SHOUTCAST
  shoutcast = gtk_menu_item_new_with_mnemonic (_("Shoutcast"));
  gtk_widget_show (shoutcast);
  gtk_container_add (GTK_CONTAINER (menu), shoutcast);

  g_signal_connect ((gpointer) shoutcast, "activate",
		    G_CALLBACK (on_shoutcast_new_activate), NULL);
#endif

#endif

  return menu;
}

gint
output_list_popup (GtkWidget * widget, GdkEvent * event, gpointer menu)
{

  if (event->type == GDK_BUTTON_PRESS)
    {
      GdkEventButton *bevent = (GdkEventButton *) event;

      gtk_menu_popup (GTK_MENU (menu), NULL, NULL, popup_position, widget, bevent->button, bevent->time);
      return TRUE;
    }

  return FALSE;
}

GtkWidget *
create_output_list (void)
{
  GtkWidget *scrolledwindow;
  GtkListStore *model;
  GtkCellRenderer *renderer;
  GtkTreeSelection *selection;

  scrolledwindow = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (scrolledwindow);
  gtk_widget_set_size_request (scrolledwindow, 250, -1);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow),
				  GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  model = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_POINTER);
  output_list = gtk_tree_view_new_with_model (GTK_TREE_MODEL (model));
  gtk_tree_view_set_enable_search (GTK_TREE_VIEW (output_list), FALSE);
  selection = gtk_tree_view_get_selection (GTK_TREE_VIEW (output_list));
  gtk_tree_selection_set_mode (selection, GTK_SELECTION_SINGLE);
  gtk_tree_view_set_rules_hint (GTK_TREE_VIEW (output_list), TRUE);
  gtk_tree_view_set_search_column (GTK_TREE_VIEW (output_list), 0);

  renderer = gtk_cell_renderer_text_new ();
  gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (output_list),
					       -1, _("Outputs"), renderer,
					       "text", 0, NULL);

  gtk_widget_show (output_list);
  g_object_unref (model);

  gtk_container_add (GTK_CONTAINER (scrolledwindow), output_list);

  return scrolledwindow;
}

int
output_window_show (GtkWidget * w, gpointer data)
{

  if (data || !output_win)
    {
      output_win = 1;
      gtk_widget_hide (winoutput);
    }
  else if (output_win)
    {
      output_list_refresh ();
      gtk_widget_show (winoutput);
      output_win = 0;
    }

  return TRUE;
}

gboolean
output_key_event (GtkWidget * w, GdkEventKey * event, gpointer dummy)
{
  if (event->keyval == GDK_Escape)
    {
      output_window_show (NULL, NULL);
      return TRUE;
    }

  return FALSE;
}

GtkWidget *
create_winoutput (void)
{
  GtkWidget *window;
  GtkWidget *box;
  GtkWidget *hbox;

  GtkWidget *vbox;
  GtkWidget *add;
  GtkWidget *alignment;
  GtkWidget *image;
  GtkWidget *label;
  GtkWidget *remove;
  GtkWidget *show;
  GtkWidget *stop;

  GtkWidget *scrolledwindow;
  GtkTreeSelection *selection;

  char s[SIZE_BUFFER];

  GtkWidget *menu = output_list_menu ();

  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  sprintf (s, _("%s %s - Output Window"), NAME, VERSION);
  gtk_window_set_title (GTK_WINDOW (window), s);

  box = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (box);
  gtk_container_add (GTK_CONTAINER (window), box);

  scrolledwindow = create_output_list ();
  gtk_box_pack_start (GTK_BOX (box), scrolledwindow, TRUE, TRUE, 0);

  vbox = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox);
  gtk_box_pack_start (GTK_BOX (box), vbox, TRUE, TRUE, 0);

  add = gtk_button_new ();
  gtk_widget_show (add);
  gtk_box_pack_start (GTK_BOX (vbox), add, FALSE, FALSE, 0);

  g_signal_connect (GTK_OBJECT (add), "event",
			     GTK_SIGNAL_FUNC (output_list_popup), menu);

  alignment = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (alignment);
  gtk_container_add (GTK_CONTAINER (add), alignment);

  hbox = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox);
  gtk_container_add (GTK_CONTAINER (alignment), hbox);

  image = gtk_image_new_from_stock ("gtk-add", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image);
  gtk_box_pack_start (GTK_BOX (hbox), image, FALSE, FALSE, 0);

  label = gtk_label_new_with_mnemonic (_("Add Output"));
  gtk_widget_show (label);
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);

  remove = gtk_button_new ();
  gtk_widget_show (remove);
  gtk_box_pack_start (GTK_BOX (vbox), remove, FALSE, FALSE, 0);

  alignment = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (alignment);
  gtk_container_add (GTK_CONTAINER (remove), alignment);

  hbox = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox);
  gtk_container_add (GTK_CONTAINER (alignment), hbox);

  image = gtk_image_new_from_stock ("gtk-remove", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image);
  gtk_box_pack_start (GTK_BOX (hbox), image, FALSE, FALSE, 0);

  label = gtk_label_new_with_mnemonic (_("Remove Output"));
  gtk_widget_show (label);
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);

  selection = gtk_tree_view_get_selection (GTK_TREE_VIEW (output_list));

  g_signal_connect ((gpointer) remove, "clicked",
		    G_CALLBACK (output_list_select_remove), selection);

  show = gtk_button_new ();
  gtk_widget_show (show);
  gtk_box_pack_start (GTK_BOX (vbox), show, FALSE, FALSE, 0);

  alignment = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (alignment);
  gtk_container_add (GTK_CONTAINER (show), alignment);

  hbox = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox);
  gtk_container_add (GTK_CONTAINER (alignment), hbox);

  image = gtk_image_new_from_stock ("gtk-index", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image);
  gtk_box_pack_start (GTK_BOX (hbox), image, FALSE, FALSE, 0);

  label = gtk_label_new_with_mnemonic (_("Show Description"));
  gtk_widget_show (label);
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);

  g_signal_connect ((gpointer) show, "clicked",
		    G_CALLBACK (output_list_select_show), selection);

  stop = gtk_button_new ();
  gtk_widget_show (stop);
  gtk_box_pack_start (GTK_BOX (vbox), stop, FALSE, FALSE, 0);

  alignment = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (alignment);
  gtk_container_add (GTK_CONTAINER (stop), alignment);

  hbox = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox);
  gtk_container_add (GTK_CONTAINER (alignment), hbox);

  image = gtk_image_new_from_stock ("gtk-index", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image);
  gtk_box_pack_start (GTK_BOX (hbox), image, FALSE, FALSE, 0);

  label = gtk_label_new_with_mnemonic (_("Stop/Start Output"));
  gtk_widget_show (label);
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);

  g_signal_connect ((gpointer) stop, "clicked",
		    G_CALLBACK (output_list_select_stop), selection);

  g_signal_connect ((gpointer) window, "delete_event",
		    G_CALLBACK (output_window_show), window);

  g_signal_connect ((gpointer) window, "key-press-event",
		    GTK_SIGNAL_FUNC (output_key_event), NULL);

  return window;
}

/* EOF */
