/*  Sonicmail - POP3 email notifier
 *  Copyright (C) 2000  Cameron Edwards
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "sonicmail-properties.h"

void sonicmail_properties_load(SonicmailVars *vars)
{
   int r, g, b;
   char buff[1024];
   
   /* Server settings: */
   vars->servername = gnome_config_get_string("/sonicmail/server_settings/servername=");
   vars->username = gnome_config_get_string("/sonicmail/server_settings/username=");
   vars->pword = gnome_config_private_get_string("/sonicmail/server_settings/passwd=");
   vars->mins = gnome_config_get_int("/sonicmail/server_settings/check_mins=5");
   vars->secs = gnome_config_get_int("/sonicmail/server_settings/check_secs=0");

   /* Pixmap settings: */
   gnome_config_push_prefix("/sonicmail/pixmap_settings/");
    sprintf(buff, "%s=%s%s", "empty_xpm", XPMSPATH, SM_DEFAULT_EMPTY_XPM);
    vars->empty_pm_filename = gnome_config_get_string(buff);
   
    sprintf(buff, "%s=%s%s", "full_xpm", XPMSPATH, SM_DEFAULT_FULL_XPM);
    vars->full_pm_filename = gnome_config_get_string(buff);
   
    sprintf(buff, "%s=%s%s", "offline_xpm", XPMSPATH, SM_DEFAULT_OFFLINE_XPM);
    vars->offline_pm_filename = gnome_config_get_string(buff);
   gnome_config_pop_prefix();
   
   r = gnome_config_get_int("/sonicmail/pixmap_settings/col_red=0");
   g = gnome_config_get_int("/sonicmail/pixmap_settings/col_green=0");
   b = gnome_config_get_int("/sonicmail/pixmap_settings/col_blue=0");
   
   vars->transp_col.red = (unsigned short)r;
   vars->transp_col.green = (unsigned short)g;
   vars->transp_col.blue = (unsigned short)b;
   
   /* Audio settings: */
   gnome_config_push_prefix("/sonicmail/audio_settings/");
    vars->audio_on = gnome_config_get_bool("audio_on=true");
    vars->audio_repeat_on = gnome_config_get_bool("audio_repeat_on=true");
    sprintf(buff, "%s=%s%s", "wavfile_filename", WAVSPATH, SM_DEFAULT_WAV);
    vars->wavfile_filename = gnome_config_get_string(buff);
   gnome_config_pop_prefix();
   /* Load in the new pixmaps: */
   sonicmail_pixmap_gdk_load( &(vars->pixmaps.offline_pixmap), vars, vars->offline_pm_filename);
   sonicmail_pixmap_gdk_load( &(vars->pixmaps.empty_pixmap), vars, vars->empty_pm_filename);
   sonicmail_pixmap_gdk_load( &(vars->pixmaps.full_pixmap), vars, vars->full_pm_filename);
   sonicmail_pixmap_refresh(vars);
}

void sonicmail_properties_save(SonicmailVars *vars)
{
   /* Server settings: */
   gnome_config_set_string("/sonicmail/server_settings/servername",vars->servername);
   gnome_config_set_string("/sonicmail/server_settings/username",vars->username);
   gnome_config_private_set_string("/sonicmail/server_settings/passwd",vars->pword);
   gnome_config_set_int("/sonicmail/server_settings/check_mins",vars->mins);
   gnome_config_set_int("/sonicmail/server_settings/check_secs",vars->secs);
   
   /* Pixmap settings: */
   gnome_config_set_string("/sonicmail/pixmap_settings/empty_xpm", vars->empty_pm_filename);
   gnome_config_set_string("/sonicmail/pixmap_settings/full_xpm", vars->full_pm_filename);
   gnome_config_set_string("/sonicmail/pixmap_settings/offline_xpm", vars->offline_pm_filename);
   gnome_config_set_int("/sonicmail/pixmap_settings/col_red", vars->transp_col.red);
   gnome_config_set_int("/sonicmail/pixmap_settings/col_green", vars->transp_col.green);
   gnome_config_set_int("/sonicmail/pixmap_settings/col_blue", vars->transp_col.blue);
   
   /* Audio settings: */
   gnome_config_set_bool("/sonicmail/audio_settings/audio_on", vars->audio_on);
   gnome_config_set_bool("/sonicmail/audio_settings/audio_repeat_on", vars->audio_repeat_on);
   gnome_config_set_string("/sonicmail/audio_settings/wavfile_filename",vars->wavfile_filename);
   
   gnome_config_sync();
}
