/*  Sonicmail - POP3 email notifier
 *  Copyright (C) 2000  Cameron Edwards
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "sonicmail-vars.h"

void sonicmail_vars_init(SonicmailVars **vars)
{
   SonicmailVars *the_vars;
   
   *vars = malloc(sizeof(SonicmailVars));
   the_vars = *vars;
   
   the_vars->state = Sonicmail_Offline;
   
   if( !( (the_vars->applet) = applet_widget_new("sonicmail")) ) {
      g_error("Error creating applet. Exiting\n");
      exit(-1);
   }
   
   /* signals handled by the applet -- 
      Added to make applet respond to mouse click - Saravanan   */
   gtk_widget_set_events (the_vars->applet, 
                          gtk_widget_get_events(the_vars->applet) |
                          GDK_BUTTON_PRESS_MASK);
   
   the_vars->box = gtk_vbox_new(TRUE, 0);
   applet_widget_add(APPLET_WIDGET(the_vars->applet), the_vars->box);
   gtk_widget_show(the_vars->box);
   
   the_vars->tooltips = gtk_tooltips_new();
   gtk_tooltips_set_tip(GTK_TOOLTIPS (the_vars->tooltips), the_vars->applet, "Offline", "");
   gtk_widget_realize(GTK_WIDGET(the_vars->applet));
   
   the_vars->pixmaps.display_pixmap = NULL;
   the_vars->pixmaps.offline_pixmap = NULL;
   the_vars->pixmaps.empty_pixmap = NULL;
   the_vars->pixmaps.full_pixmap = NULL;
   
   the_vars->servername = "";
   the_vars->username = "";
   the_vars->pword = "";
   the_vars->empty_pm_filename = "";
   the_vars->full_pm_filename = "";
   the_vars->offline_pm_filename = "";
   the_vars->wavfile_filename = "";
   
   the_vars->prev_num_mails = 0;
   the_vars->curr_num_mails = 0;
   
   pthread_mutex_init(&(the_vars->mut), NULL);
   the_vars->mailcheck_thread_pid = -1;
}
