<?php
/*
 * $Horde: vacation/main.php,v 1.1.1.1.2.10 2005/01/03 11:26:07 jan Exp $
 *
 * Copyright 2001-2005 Eric Rostetter <eric.rostetter@physics.utexas.edu>
 *
 * See the enclosed file LICENSE for license information (BSD). If you
 * did not receive this file, see http://www.horde.org/bsdl.php.
 */

define('VACATION_BASE', dirname(__FILE__));
require_once VACATION_BASE . '/lib/base.php';

require_once VACATION_BASE . '/config/conf.php';

// create a driver
require_once VACATION_BASE . "/lib/Driver.php";
$driver = &Vacation_Driver::factory($conf['server']['driver'],
                                    $conf['server']['params']);

// Get the current login username and realm
$split  = explode('@', Auth::getAuth());
$user = @$split[0]; $realm = @$split[1];
if (empty($realm)) {
    $realm = "default";
}

$submit = Horde::getFormData('submit', false);

if ( $submit ) {
    $vacationmode=Horde::getFormData('mode', "error");
    if ($vacationmode === "error") {
        Horde::raiseMessage(_("You must specify the mode"), HORDE_WARNING);
    }

    // Check for refused usernames, using current horde username

    if (in_array($user, $conf['user']['refused'])) {
        $msg=sprintf (_("You can't change vacation notice for user %s"),$user);
        Horde::raiseMessage($msg,HORDE_ERROR);
        $vacationmode = "error";
    }

    if ($driver->getParam('hordeauth', $realm)) {
        $oldpassword = Auth::getCredential('password');
    } else {
        $oldpassword=Horde::getFormData('oldpassword', false);
        if (empty($oldpassword)) {
            Horde::raiseMessage(_("You must give your password"),HORDE_WARNING);
            $vacationmode = "error";
        }
    }

    // call the requested function

    switch ($vacationmode) {
    case "error":
        break;

    case "set":
        $alias=Horde::getFormData('alias', '');
        $vacationmsg=Horde::getFormData('mess', false);
        if (!$vacationmsg) {
            Horde::raiseMessage(_("You must give a vacation message"),
                   HORDE_WARNING);
        } elseif (!empty($conf['vacation']['validation_pattern']) &&
                  !@preg_match($conf['vacation']['validation_pattern'], $vacationmsg)) {
            // Validation is required, and wasn't matched.
            Horde::raiseMessage(_("Your vacation message is not in the proper format."),
                                HORDE_WARNING);
        } else {
            // Try and make sure to send Unix linefeeds.
            $vacationmsg = str_replace("\r\n", "\n", $vacationmsg);
            $vacationmsg = str_replace("\r", "\n", $vacationmsg);

            if ($driver->set_vacation($user, $realm, $oldpassword,
                                      $vacationmsg, $alias)) {
                Horde::raiseMessage(_("Vacation notice set!"),HORDE_SUCCESS);
            } else {
                Horde::raiseMessage( _("Failure in modifying vacation notice: ")
                    .  $driver->err_str, HORDE_ERROR);
            }
        }
        break;

    case "unset":
        if ($driver->unset_vacation($user, $realm, $oldpassword)) {
            Horde::raiseMessage(_("Vacation notice removed!"), HORDE_SUCCESS);
        } else {
            Horde::raiseMessage( _("Failure in removing vacation notice: ") .
                    $driver->err_str, HORDE_ERROR);
        }
        break;

    default:
        break;
    }
}

include $registry->getTemplatePath() . '/common-header.inc';
include_once $registry->getTemplatePath('horde') . '/javascript/open_help_win.js';
require $registry->getFileRoot() . '/status.php';
require $registry->getTemplatePath() . '/main/javascript.inc';
include $registry->getTemplatePath() . '/main/main.inc';
include $registry->getTemplatePath() . '/common-footer.inc';
