/***********************************************************************
 * main.c
 ***********************************************************************/

/***********************************************************************
 *  This file is part of SpaceChart.
 *  Copyright (C) 2000 Miguel Coca <e970095@zipi.fi.upm.es>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 ***********************************************************************/

#include <stdlib.h>
#include <math.h>
#include "../include/starmap.h"
#include "../include/gui.h"

const char *app_name = PACKAGE;
const char *app_version = VERSION;
const char *app_authors[] = { "Miguel Coca Barrionuevo "
                              "( e970095@zipi.fi.upm.es )", NULL };
double default_color[3] = { 1.0, 0.0, 0.0 };

int main( int argc, char** argv ) 
{
        gui_t *gui;

        setbuf(stdout, NULL);           /* Unbuffered */
        setbuf(stdin, NULL);

        bindtextdomain(PACKAGE, LOCALEDIR);  
        textdomain(PACKAGE);

        gnome_init( app_name, app_version, argc, argv );
        
        gui = gui_new();

        if(!gui) exit(EXIT_FAILURE);

        /* Here we go... */
        gtk_main();

        gui_destroy( gui );

        return 0;
}
