/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Mon Jan 25 12:52:11 2021

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_43 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 8677, "epsg", 8677,
        "MGI 1901 / Balkans zone 5", 0, 0,
        "Bessel 1841", "Greenwich",
        "MGI_1901", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=0.9999 +x_0=5500000 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=bessel +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI 1901 / Balkans zone 5\",GEOGCS[\"MGI 1901\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"MGI_1901\",SPHEROID[\"Bessel 1841\",6377397.155");
    add_srs_wkt (p, 2,
        ",299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"1031\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"3906\"]],PRO");
    add_srs_wkt (p, 6,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 7,
        "_origin\",0],PARAMETER[\"central_meridian\",15],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"scale_factor\",0.9999],PARAMETER[\"false_easting\",5");
    add_srs_wkt (p, 9,
        "500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1");
    add_srs_wkt (p, 10,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AX");
    add_srs_wkt (p, 11,
        "IS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"8677\"]]");
    p = add_epsg_def_ex (filter, first, last, 8678, "epsg", 8678,
        "MGI 1901 / Balkans zone 6", 0, 0,
        "Bessel 1841", "Greenwich",
        "MGI_1901", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=18 +k=0.9999 +x_0=6500000 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=bessel +towgs84=682,-203,480,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI 1901 / Balkans zone 6\",GEOGCS[\"MGI 1901\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"MGI_1901\",SPHEROID[\"Bessel 1841\",6377397.155");
    add_srs_wkt (p, 2,
        ",299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"1031\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"3906\"]],PRO");
    add_srs_wkt (p, 6,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 7,
        "_origin\",0],PARAMETER[\"central_meridian\",18],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"scale_factor\",0.9999],PARAMETER[\"false_easting\",6");
    add_srs_wkt (p, 9,
        "500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1");
    add_srs_wkt (p, 10,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AX");
    add_srs_wkt (p, 11,
        "IS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"8678\"]]");
    p = add_epsg_def_ex (filter, first, last, 8679, "epsg", 8679,
        "MGI 1901 / Balkans zone 8", 0, 0,
        "Bessel 1841", "Greenwich",
        "MGI_1901", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=24 +k=0.9999 +x_0=8500000 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=bessel +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI 1901 / Balkans zone 8\",GEOGCS[\"MGI 1901\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"MGI_1901\",SPHEROID[\"Bessel 1841\",6377397.155");
    add_srs_wkt (p, 2,
        ",299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"1031\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"3906\"]],PRO");
    add_srs_wkt (p, 6,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 7,
        "_origin\",0],PARAMETER[\"central_meridian\",24],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"scale_factor\",0.9999],PARAMETER[\"false_easting\",8");
    add_srs_wkt (p, 9,
        "500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1");
    add_srs_wkt (p, 10,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AX");
    add_srs_wkt (p, 11,
        "IS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"8679\"]]");
    p = add_epsg_def_ex (filter, first, last, 8682, "epsg", 8682,
        "SRB_ETRS89 / UTM zone 34N", 0, 0,
        "GRS 1980", "Greenwich",
        "Serbian_Spatial_Reference_System_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=34 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SRB_ETRS89 / UTM zone 34N\",GEOGCS[\"SRB_ETRS89");
    add_srs_wkt (p, 1,
        "\",DATUM[\"Serbian_Spatial_Reference_System_2000\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7019\"]],AUTHORITY[\"EPSG\",\"1214\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"8685\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",21],PARAMETER[\"scale_factor\",0.9996],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"8682\"]]");
    p = add_epsg_def_ex (filter, first, last, 8684, "epsg", 8684,
        "SRB_ETRS89", 1, 1,
        "GRS 1980", "Greenwich",
        "Serbian_Spatial_Reference_System_2000", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"SRB_ETRS89\",DATUM[\"Serbian Spatial Reference");
    add_srs_wkt (p, 1,
        " System 2000\",ELLIPSOID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 2,
        "101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANG");
    add_srs_wkt (p, 3,
        "LEUNIT[\"degree\",0.0174532925199433]],CS[ellipsoidal,3]");
    add_srs_wkt (p, 4,
        ",AXIS[\"geodetic latitude (Lat)\",north,ORDER[1],ANGLEUN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433]],AXIS[\"geodetic longi");
    add_srs_wkt (p, 6,
        "tude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.017453");
    add_srs_wkt (p, 7,
        "2925199433]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3]");
    add_srs_wkt (p, 8,
        ",LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"Geodesy.\"],AREA");
    add_srs_wkt (p, 9,
        "[\"Serbia including Vojvodina.\"],BBOX[42.232494354248,1");
    add_srs_wkt (p, 10,
        "8.81702041626,46.18111038208,23.004997253418]],ID[\"EPSG");
    add_srs_wkt (p, 11,
        "\",8684]]");
    p = add_epsg_def_ex (filter, first, last, 8685, "epsg", 8685,
        "SRB_ETRS89", 1, 1,
        "GRS 1980", "Greenwich",
        "Serbian_Spatial_Reference_System_2000", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"SRB_ETRS89\",DATUM[\"Serbian_Spatial_Reference_");
    add_srs_wkt (p, 1,
        "System_2000\",SPHEROID[\"GRS 1980\",6378137,298.25722210");
    add_srs_wkt (p, 2,
        "1,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"121");
    add_srs_wkt (p, 3,
        "4\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 4,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",");
    add_srs_wkt (p, 6,
        "EAST],AUTHORITY[\"EPSG\",\"8685\"]]");
    p = add_epsg_def_ex (filter, first, last, 8686, "epsg", 8686,
        "MGI 1901 / Slovenia Grid", 0, 0,
        "Bessel 1841", "Greenwich",
        "MGI_1901", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=0.9999 +x_0=500000 +y_");
    add_proj4text (p, 1,
        "0=0 +ellps=bessel +towgs84=476.08,125.947,417.81,4.61086");
    add_proj4text (p, 2,
        "2,2.388137,-11.942335,9.896638 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI 1901 / Slovenia Grid\",GEOGCS[\"MGI 1901\",");
    add_srs_wkt (p, 1,
        "DATUM[\"MGI_1901\",SPHEROID[\"Bessel 1841\",6377397.155,");
    add_srs_wkt (p, 2,
        "299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"1031\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"3906\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",15],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"scale_factor\",0.9999],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 9,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 10,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"8686\"]]");
    p = add_epsg_def_ex (filter, first, last, 8687, "epsg", 8687,
        "Slovenia 1996 / UTM zone 33N", 0, 0,
        "GRS 1980", "Greenwich",
        "Slovenia_Geodetic_Datum_1996", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=33 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Slovenia 1996 / UTM zone 33N\",GEOGCS[\"Sloveni");
    add_srs_wkt (p, 1,
        "a 1996\",DATUM[\"Slovenia_Geodetic_Datum_1996\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],AUTHORITY[\"EPSG\",\"6765\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4765\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",15],PARAMETER[\"scale_factor\",0.9996],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"8687\"]]");
    p = add_epsg_def_ex (filter, first, last, 8692, "epsg", 8692,
        "NAD83(MA11) / UTM zone 54N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_MA11", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=54 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(MA11) / UTM zone 54N\",GEOGCS[\"NAD83(MA1");
    add_srs_wkt (p, 1,
        "1)\",DATUM[\"NAD83_National_Spatial_Reference_System_MA1");
    add_srs_wkt (p, 2,
        "1\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1118\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"6325\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"central_meridian\",141],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 9,
        ".9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"8692\"]]");
    p = add_epsg_def_ex (filter, first, last, 8693, "epsg", 8693,
        "NAD83(MA11) / UTM zone 55N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_MA11", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=55 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(MA11) / UTM zone 55N\",GEOGCS[\"NAD83(MA1");
    add_srs_wkt (p, 1,
        "1)\",DATUM[\"NAD83_National_Spatial_Reference_System_MA1");
    add_srs_wkt (p, 2,
        "1\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1118\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"6325\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"central_meridian\",147],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 9,
        ".9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"8693\"]]");
    p = add_epsg_def_ex (filter, first, last, 8694, "epsg", 8694,
        "Camacupa 2015", 1, 1,
        "Clarke 1880 (RGS)", "Greenwich",
        "Camacupa_2015", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378249.145 +rf=293.465 +towgs84=-93.79");
    add_proj4text (p, 1,
        "9,-132.737,-219.073,-1.844,0.648,-6.37,-0.169 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Camacupa 2015\",DATUM[\"Camacupa_2015\",SPHEROI");
    add_srs_wkt (p, 1,
        "D[\"Clarke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"");
    add_srs_wkt (p, 2,
        "EPSG\",\"7012\"]],AUTHORITY[\"EPSG\",\"1217\"]],PRIMEM[\"");
    add_srs_wkt (p, 3,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 4,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 5,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"8694\"]]");
    p = add_epsg_def_ex (filter, first, last, 8698, "epsg", 8698,
        "RSAO13", 1, 1,
        "GRS 1980", "Greenwich",
        "Reference_System_de_Angola_2013", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"RSAO13\",DATUM[\"Reference System de Angola 20");
    add_srs_wkt (p, 1,
        "13\",ELLIPSOID[\"GRS 1980\",6378137,298.257222101,LENGTH");
    add_srs_wkt (p, 2,
        "UNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"d");
    add_srs_wkt (p, 3,
        "egree\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"ge");
    add_srs_wkt (p, 4,
        "odetic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433]],AXIS[\"geodetic longitude (Lon)");
    add_srs_wkt (p, 6,
        "\",east,ORDER[2],ANGLEUNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 7,
        "]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUNI");
    add_srs_wkt (p, 8,
        "T[\"metre\",1]],USAGE[SCOPE[\"Geodesy.\"],AREA[\"Angola ");
    add_srs_wkt (p, 9,
        "- onshore and offshore.\"],BBOX[-18.02,8.2,-4.38,24.09]]");
    add_srs_wkt (p, 10,
        ",ID[\"EPSG\",8698]]");
    p = add_epsg_def_ex (filter, first, last, 8699, "epsg", 8699,
        "RSAO13", 1, 1,
        "GRS 1980", "Greenwich",
        "Reference_System_de_Angola_2013", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"RSAO13\",DATUM[\"Reference_System_de_Angola_201");
    add_srs_wkt (p, 1,
        "3\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 2,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1220\"]],PRIM");
    add_srs_wkt (p, 3,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 4,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 5,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"8699\"]]");
    p = add_epsg_def_ex (filter, first, last, 8700, "epsg", 8700,
        "NAD83 / Arizona East (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31 +lon_0=-110.166666666667 +k=0.9999");
    add_proj4text (p, 1,
        " +x_0=213360 +y_0=0 +datum=NAD83 +units=ft +vunits=ft +n");
    add_proj4text (p, 2,
        "o_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Arizona East (ft) + NAVD88 height (ft");
    add_srs_wkt (p, 1,
        ")\",PROJCS[\"NAD83 / Arizona East (ft)\",GEOGCS[\"NAD83\"");
    add_srs_wkt (p, 2,
        ",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 3,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4269\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",31],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 9,
        "-110.166666666667],PARAMETER[\"scale_factor\",0.9999],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_easting\",700000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 11,
        "hing\",0],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"9002");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"2222\"]],VERT_CS[\"NAVD88 height (ft)\"");
    add_srs_wkt (p, 14,
        ",VERT_DATUM[\"North American Vertical Datum 1988\",2005,");
    add_srs_wkt (p, 15,
        "AUTHORITY[\"EPSG\",\"5103\"]],UNIT[\"foot\",0.3048,AUTHO");
    add_srs_wkt (p, 16,
        "RITY[\"EPSG\",\"9002\"]],AXIS[\"Gravity-related height\"");
    add_srs_wkt (p, 17,
        ",UP],AUTHORITY[\"EPSG\",\"8228\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 18,
        "8700\"]]");
    p = add_epsg_def_ex (filter, first, last, 8701, "epsg", 8701,
        "NAD83 / Arizona Central (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31 +lon_0=-111.916666666667 +k=0.9999");
    add_proj4text (p, 1,
        " +x_0=213360 +y_0=0 +datum=NAD83 +units=ft +vunits=ft +n");
    add_proj4text (p, 2,
        "o_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Arizona Central (ft) + NAVD88 height ");
    add_srs_wkt (p, 1,
        "(ft)\",PROJCS[\"NAD83 / Arizona Central (ft)\",GEOGCS[\"");
    add_srs_wkt (p, 2,
        "NAD83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"G");
    add_srs_wkt (p, 3,
        "RS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"701");
    add_srs_wkt (p, 4,
        "9\"]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 5,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 6,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 7,
        "SG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 8,
        "METER[\"latitude_of_origin\",31],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",-111.916666666667],PARAMETER[\"scale_factor\",0.");
    add_srs_wkt (p, 10,
        "9999],PARAMETER[\"false_easting\",700000],PARAMETER[\"fa");
    add_srs_wkt (p, 11,
        "lse_northing\",0],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"9002\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 13,
        "TH],AUTHORITY[\"EPSG\",\"2223\"]],VERT_CS[\"NAVD88 heigh");
    add_srs_wkt (p, 14,
        "t (ft)\",VERT_DATUM[\"North American Vertical Datum 1988");
    add_srs_wkt (p, 15,
        "\",2005,AUTHORITY[\"EPSG\",\"5103\"]],UNIT[\"foot\",0.30");
    add_srs_wkt (p, 16,
        "48,AUTHORITY[\"EPSG\",\"9002\"]],AXIS[\"Gravity-related ");
    add_srs_wkt (p, 17,
        "height\",UP],AUTHORITY[\"EPSG\",\"8228\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 18,
        "PSG\",\"8701\"]]");
    p = add_epsg_def_ex (filter, first, last, 8702, "epsg", 8702,
        "NAD83 / Arizona West (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31 +lon_0=-113.75 +k=0.999933333 +x_0");
    add_proj4text (p, 1,
        "=213360 +y_0=0 +datum=NAD83 +units=ft +vunits=ft +no_def");
    add_proj4text (p, 2,
        "s");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Arizona West (ft) + NAVD88 height (ft");
    add_srs_wkt (p, 1,
        ")\",PROJCS[\"NAD83 / Arizona West (ft)\",GEOGCS[\"NAD83\"");
    add_srs_wkt (p, 2,
        ",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 3,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4269\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",31],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 9,
        "-113.75],PARAMETER[\"scale_factor\",0.999933333],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_easting\",700000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",0],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]],A");
    add_srs_wkt (p, 12,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"2224\"]],VERT_CS[\"NAVD88 height (ft)\",VERT");
    add_srs_wkt (p, 14,
        "_DATUM[\"North American Vertical Datum 1988\",2005,AUTHO");
    add_srs_wkt (p, 15,
        "RITY[\"EPSG\",\"5103\"]],UNIT[\"foot\",0.3048,AUTHORITY[");
    add_srs_wkt (p, 16,
        "\"EPSG\",\"9002\"]],AXIS[\"Gravity-related height\",UP],");
    add_srs_wkt (p, 17,
        "AUTHORITY[\"EPSG\",\"8228\"]],AUTHORITY[\"EPSG\",\"8702\"");
    add_srs_wkt (p, 18,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 8703, "epsg", 8703,
        "NAD83 / Michigan North (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=44.7833333333333 +lon_0=-87 +lat_1=47.0");
    add_proj4text (p, 1,
        "833333333333 +lat_2=45.4833333333333 +x_0=7999999.999968");
    add_proj4text (p, 2,
        " +y_0=0 +datum=NAD83 +units=ft +vunits=ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Michigan North (ft) + NAVD88 height (");
    add_srs_wkt (p, 1,
        "ft)\",PROJCS[\"NAD83 / Michigan North (ft)\",GEOGCS[\"NA");
    add_srs_wkt (p, 2,
        "D83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS");
    add_srs_wkt (p, 3,
        " 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 4,
        "]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 6,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4269\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"latitude_of_origin\",44.7833333333333],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"central_meridian\",-87],PARAMETER[\"standard_para");
    add_srs_wkt (p, 10,
        "llel_1\",47.0833333333333],PARAMETER[\"standard_parallel");
    add_srs_wkt (p, 11,
        "_2\",45.4833333333333],PARAMETER[\"false_easting\",26246");
    add_srs_wkt (p, 12,
        "719.16],PARAMETER[\"false_northing\",0],UNIT[\"foot\",0.");
    add_srs_wkt (p, 13,
        "3048,AUTHORITY[\"EPSG\",\"9002\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 14,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2251\"]]");
    add_srs_wkt (p, 15,
        ",VERT_CS[\"NAVD88 height (ft)\",VERT_DATUM[\"North Ameri");
    add_srs_wkt (p, 16,
        "can Vertical Datum 1988\",2005,AUTHORITY[\"EPSG\",\"5103");
    add_srs_wkt (p, 17,
        "\"]],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]],");
    add_srs_wkt (p, 18,
        "AXIS[\"Gravity-related height\",UP],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 19,
        "8228\"]],AUTHORITY[\"EPSG\",\"8703\"]]");
    p = add_epsg_def_ex (filter, first, last, 8704, "epsg", 8704,
        "NAD83 / Michigan Central (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=43.3166666666667 +lon_0=-84.36666666666");
    add_proj4text (p, 1,
        "67 +lat_1=45.7 +lat_2=44.1833333333333 +x_0=5999999.9999");
    add_proj4text (p, 2,
        "76 +y_0=0 +datum=NAD83 +units=ft +vunits=ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Michigan Central (ft) + NAVD88 height");
    add_srs_wkt (p, 1,
        " (ft)\",PROJCS[\"NAD83 / Michigan Central (ft)\",GEOGCS[");
    add_srs_wkt (p, 2,
        "\"NAD83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"");
    add_srs_wkt (p, 3,
        "GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 4,
        "19\"]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 5,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 6,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 7,
        "SG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP");
    add_srs_wkt (p, 8,
        "\"],PARAMETER[\"latitude_of_origin\",43.3166666666667],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"central_meridian\",-84.3666666666667],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"standard_parallel_1\",45.7],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 11,
        "rallel_2\",44.1833333333333],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 12,
        ",19685039.37],PARAMETER[\"false_northing\",0],UNIT[\"foo");
    add_srs_wkt (p, 13,
        "t\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 14,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"225");
    add_srs_wkt (p, 15,
        "2\"]],VERT_CS[\"NAVD88 height (ft)\",VERT_DATUM[\"North ");
    add_srs_wkt (p, 16,
        "American Vertical Datum 1988\",2005,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 17,
        "5103\"]],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"");
    add_srs_wkt (p, 18,
        "]],AXIS[\"Gravity-related height\",UP],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 19,
        ",\"8228\"]],AUTHORITY[\"EPSG\",\"8704\"]]");
    p = add_epsg_def_ex (filter, first, last, 8705, "epsg", 8705,
        "NAD83 / Michigan South (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=41.5 +lon_0=-84.3666666666667 +lat_1=43");
    add_proj4text (p, 1,
        ".6666666666667 +lat_2=42.1 +x_0=3999999.999984 +y_0=0 +d");
    add_proj4text (p, 2,
        "atum=NAD83 +units=ft +vunits=ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Michigan South (ft) + NAVD88 height (");
    add_srs_wkt (p, 1,
        "ft)\",PROJCS[\"NAD83 / Michigan South (ft)\",GEOGCS[\"NA");
    add_srs_wkt (p, 2,
        "D83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS");
    add_srs_wkt (p, 3,
        " 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 4,
        "]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 6,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4269\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"latitude_of_origin\",41.5],PARAMETER[\"centr");
    add_srs_wkt (p, 9,
        "al_meridian\",-84.3666666666667],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 10,
        "rallel_1\",43.6666666666667],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 11,
        "el_2\",42.1],PARAMETER[\"false_easting\",13123359.58],PA");
    add_srs_wkt (p, 12,
        "RAMETER[\"false_northing\",0],UNIT[\"foot\",0.3048,AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"9002\"]],AXIS[\"Easting\",EAST],AXIS[\"N");
    add_srs_wkt (p, 14,
        "orthing\",NORTH],AUTHORITY[\"EPSG\",\"2253\"]],VERT_CS[\"");
    add_srs_wkt (p, 15,
        "NAVD88 height (ft)\",VERT_DATUM[\"North American Vertica");
    add_srs_wkt (p, 16,
        "l Datum 1988\",2005,AUTHORITY[\"EPSG\",\"5103\"]],UNIT[\"");
    add_srs_wkt (p, 17,
        "foot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]],AXIS[\"Gravi");
    add_srs_wkt (p, 18,
        "ty-related height\",UP],AUTHORITY[\"EPSG\",\"8228\"]],AU");
    add_srs_wkt (p, 19,
        "THORITY[\"EPSG\",\"8705\"]]");
    p = add_epsg_def_ex (filter, first, last, 8706, "epsg", 8706,
        "NAD83 / Montana (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=44.25 +lon_0=-109.5 +lat_1=49 +lat_2=45");
    add_proj4text (p, 1,
        " +x_0=599999.9999976 +y_0=0 +datum=NAD83 +units=ft +vuni");
    add_proj4text (p, 2,
        "ts=ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Montana (ft) + NAVD88 height (ft)\",P");
    add_srs_wkt (p, 1,
        "ROJCS[\"NAD83 / Montana (ft)\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 2,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 3,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",44.25],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 9,
        "\",-109.5],PARAMETER[\"standard_parallel_1\",49],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"standard_parallel_2\",45],PARAMETER[\"false_easting");
    add_srs_wkt (p, 11,
        "\",1968503.937],PARAMETER[\"false_northing\",0],UNIT[\"f");
    add_srs_wkt (p, 12,
        "oot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 13,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "2256\"]],VERT_CS[\"NAVD88 height (ft)\",VERT_DATUM[\"Nor");
    add_srs_wkt (p, 15,
        "th American Vertical Datum 1988\",2005,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 16,
        ",\"5103\"]],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 17,
        "02\"]],AXIS[\"Gravity-related height\",UP],AUTHORITY[\"E");
    add_srs_wkt (p, 18,
        "PSG\",\"8228\"]],AUTHORITY[\"EPSG\",\"8706\"]]");
    p = add_epsg_def_ex (filter, first, last, 8707, "epsg", 8707,
        "NAD83 / North Dakota North (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=47 +lon_0=-100.5 +lat_1=48.733333333333");
    add_proj4text (p, 1,
        "3 +lat_2=47.4333333333333 +x_0=599999.9999976 +y_0=0 +da");
    add_proj4text (p, 2,
        "tum=NAD83 +units=ft +vunits=ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / North Dakota North (ft) + NAVD88 heig");
    add_srs_wkt (p, 1,
        "ht (ft)\",PROJCS[\"NAD83 / North Dakota North (ft)\",GEO");
    add_srs_wkt (p, 2,
        "GCS[\"NAD83\",DATUM[\"North_American_Datum_1983\",SPHERO");
    add_srs_wkt (p, 3,
        "ID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"7019\"]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 5,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 6,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 7,
        "Y[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Con");
    add_srs_wkt (p, 8,
        "ic_2SP\"],PARAMETER[\"latitude_of_origin\",47],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"central_meridian\",-100.5],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 10,
        "lel_1\",48.7333333333333],PARAMETER[\"standard_parallel_");
    add_srs_wkt (p, 11,
        "2\",47.4333333333333],PARAMETER[\"false_easting\",196850");
    add_srs_wkt (p, 12,
        "3.937],PARAMETER[\"false_northing\",0],UNIT[\"foot\",0.3");
    add_srs_wkt (p, 13,
        "048,AUTHORITY[\"EPSG\",\"9002\"]],AXIS[\"Easting\",EAST]");
    add_srs_wkt (p, 14,
        ",AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2265\"]],");
    add_srs_wkt (p, 15,
        "VERT_CS[\"NAVD88 height (ft)\",VERT_DATUM[\"North Americ");
    add_srs_wkt (p, 16,
        "an Vertical Datum 1988\",2005,AUTHORITY[\"EPSG\",\"5103\"");
    add_srs_wkt (p, 17,
        "]],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]],AX");
    add_srs_wkt (p, 18,
        "IS[\"Gravity-related height\",UP],AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 19,
        "228\"]],AUTHORITY[\"EPSG\",\"8707\"]]");
    p = add_epsg_def_ex (filter, first, last, 8708, "epsg", 8708,
        "NAD83 / North Dakota South (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=45.6666666666667 +lon_0=-100.5 +lat_1=4");
    add_proj4text (p, 1,
        "7.4833333333333 +lat_2=46.1833333333333 +x_0=599999.9999");
    add_proj4text (p, 2,
        "976 +y_0=0 +datum=NAD83 +units=ft +vunits=ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / North Dakota South (ft) + NAVD88 heig");
    add_srs_wkt (p, 1,
        "ht (ft)\",PROJCS[\"NAD83 / North Dakota South (ft)\",GEO");
    add_srs_wkt (p, 2,
        "GCS[\"NAD83\",DATUM[\"North_American_Datum_1983\",SPHERO");
    add_srs_wkt (p, 3,
        "ID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"7019\"]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 5,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 6,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 7,
        "Y[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Con");
    add_srs_wkt (p, 8,
        "ic_2SP\"],PARAMETER[\"latitude_of_origin\",45.6666666666");
    add_srs_wkt (p, 9,
        "667],PARAMETER[\"central_meridian\",-100.5],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "standard_parallel_1\",47.4833333333333],PARAMETER[\"stan");
    add_srs_wkt (p, 11,
        "dard_parallel_2\",46.1833333333333],PARAMETER[\"false_ea");
    add_srs_wkt (p, 12,
        "sting\",1968503.937],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 13,
        "T[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]],AXIS[\"E");
    add_srs_wkt (p, 14,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 15,
        "\",\"2266\"]],VERT_CS[\"NAVD88 height (ft)\",VERT_DATUM[");
    add_srs_wkt (p, 16,
        "\"North American Vertical Datum 1988\",2005,AUTHORITY[\"");
    add_srs_wkt (p, 17,
        "EPSG\",\"5103\"]],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 18,
        ",\"9002\"]],AXIS[\"Gravity-related height\",UP],AUTHORIT");
    add_srs_wkt (p, 19,
        "Y[\"EPSG\",\"8228\"]],AUTHORITY[\"EPSG\",\"8708\"]]");
    p = add_epsg_def_ex (filter, first, last, 8709, "epsg", 8709,
        "NAD83 / Oregon North (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=43.6666666666667 +lon_0=-120.5 +lat_1=4");
    add_proj4text (p, 1,
        "6 +lat_2=44.3333333333333 +x_0=2500000.0001424 +y_0=0 +d");
    add_proj4text (p, 2,
        "atum=NAD83 +units=ft +vunits=ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Oregon North (ft) + NAVD88 height (ft");
    add_srs_wkt (p, 1,
        ")\",PROJCS[\"NAD83 / Oregon North (ft)\",GEOGCS[\"NAD83\"");
    add_srs_wkt (p, 2,
        ",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 3,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4269\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",43.6666666666667],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",-120.5],PARAMETER[\"standard_para");
    add_srs_wkt (p, 10,
        "llel_1\",46],PARAMETER[\"standard_parallel_2\",44.333333");
    add_srs_wkt (p, 11,
        "3333333],PARAMETER[\"false_easting\",8202099.738],PARAME");
    add_srs_wkt (p, 12,
        "TER[\"false_northing\",0],UNIT[\"foot\",0.3048,AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"9002\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 14,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"2269\"]],VERT_CS[\"NAV");
    add_srs_wkt (p, 15,
        "D88 height (ft)\",VERT_DATUM[\"North American Vertical D");
    add_srs_wkt (p, 16,
        "atum 1988\",2005,AUTHORITY[\"EPSG\",\"5103\"]],UNIT[\"fo");
    add_srs_wkt (p, 17,
        "ot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]],AXIS[\"Gravity");
    add_srs_wkt (p, 18,
        "-related height\",UP],AUTHORITY[\"EPSG\",\"8228\"]],AUTH");
    add_srs_wkt (p, 19,
        "ORITY[\"EPSG\",\"8709\"]]");
    p = add_epsg_def_ex (filter, first, last, 8710, "epsg", 8710,
        "NAD83 / Oregon South (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=41.6666666666667 +lon_0=-120.5 +lat_1=4");
    add_proj4text (p, 1,
        "4 +lat_2=42.3333333333333 +x_0=1500000.0001464 +y_0=0 +d");
    add_proj4text (p, 2,
        "atum=NAD83 +units=ft +vunits=ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Oregon South (ft) + NAVD88 height (ft");
    add_srs_wkt (p, 1,
        ")\",PROJCS[\"NAD83 / Oregon South (ft)\",GEOGCS[\"NAD83\"");
    add_srs_wkt (p, 2,
        ",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 3,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4269\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",41.6666666666667],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",-120.5],PARAMETER[\"standard_para");
    add_srs_wkt (p, 10,
        "llel_1\",44],PARAMETER[\"standard_parallel_2\",42.333333");
    add_srs_wkt (p, 11,
        "3333333],PARAMETER[\"false_easting\",4921259.843],PARAME");
    add_srs_wkt (p, 12,
        "TER[\"false_northing\",0],UNIT[\"foot\",0.3048,AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"9002\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 14,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"2270\"]],VERT_CS[\"NAV");
    add_srs_wkt (p, 15,
        "D88 height (ft)\",VERT_DATUM[\"North American Vertical D");
    add_srs_wkt (p, 16,
        "atum 1988\",2005,AUTHORITY[\"EPSG\",\"5103\"]],UNIT[\"fo");
    add_srs_wkt (p, 17,
        "ot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]],AXIS[\"Gravity");
    add_srs_wkt (p, 18,
        "-related height\",UP],AUTHORITY[\"EPSG\",\"8228\"]],AUTH");
    add_srs_wkt (p, 19,
        "ORITY[\"EPSG\",\"8710\"]]");
    p = add_epsg_def_ex (filter, first, last, 8711, "epsg", 8711,
        "NAD83 / South Carolina (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=31.8333333333333 +lon_0=-81 +lat_1=34.8");
    add_proj4text (p, 1,
        "333333333333 +lat_2=32.5 +x_0=609600 +y_0=0 +datum=NAD83");
    add_proj4text (p, 2,
        " +units=ft +vunits=ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / South Carolina (ft) + NAVD88 height (");
    add_srs_wkt (p, 1,
        "ft)\",PROJCS[\"NAD83 / South Carolina (ft)\",GEOGCS[\"NA");
    add_srs_wkt (p, 2,
        "D83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS");
    add_srs_wkt (p, 3,
        " 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 4,
        "]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 6,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4269\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"latitude_of_origin\",31.8333333333333],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"central_meridian\",-81],PARAMETER[\"standard_para");
    add_srs_wkt (p, 10,
        "llel_1\",34.8333333333333],PARAMETER[\"standard_parallel");
    add_srs_wkt (p, 11,
        "_2\",32.5],PARAMETER[\"false_easting\",2000000],PARAMETE");
    add_srs_wkt (p, 12,
        "R[\"false_northing\",0],UNIT[\"foot\",0.3048,AUTHORITY[\"");
    add_srs_wkt (p, 13,
        "EPSG\",\"9002\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 14,
        "\",NORTH],AUTHORITY[\"EPSG\",\"2273\"]],VERT_CS[\"NAVD88");
    add_srs_wkt (p, 15,
        " height (ft)\",VERT_DATUM[\"North American Vertical Datu");
    add_srs_wkt (p, 16,
        "m 1988\",2005,AUTHORITY[\"EPSG\",\"5103\"]],UNIT[\"foot\"");
    add_srs_wkt (p, 17,
        ",0.3048,AUTHORITY[\"EPSG\",\"9002\"]],AXIS[\"Gravity-rel");
    add_srs_wkt (p, 18,
        "ated height\",UP],AUTHORITY[\"EPSG\",\"8228\"]],AUTHORIT");
    add_srs_wkt (p, 19,
        "Y[\"EPSG\",\"8711\"]]");
    p = add_epsg_def_ex (filter, first, last, 8712, "epsg", 8712,
        "NAD83 / Arkansas North (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=34.3333333333333 +lon_0=-92 +lat_1=36.2");
    add_proj4text (p, 1,
        "333333333333 +lat_2=34.9333333333333 +x_0=399999.9999898");
    add_proj4text (p, 2,
        "4 +y_0=0 +datum=NAD83 +units=us-ft +vunits=us-ft +no_def");
    add_proj4text (p, 3,
        "s");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Arkansas North (ftUS) + NAVD88 height");
    add_srs_wkt (p, 1,
        " (ftUS)\",PROJCS[\"NAD83 / Arkansas North (ftUS)\",GEOGC");
    add_srs_wkt (p, 2,
        "S[\"NAD83\",DATUM[\"North_American_Datum_1983\",SPHEROID");
    add_srs_wkt (p, 3,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "7019\"]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 5,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 6,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 7,
        "EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Conic_2");
    add_srs_wkt (p, 8,
        "SP\"],PARAMETER[\"latitude_of_origin\",34.3333333333333]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"central_meridian\",-92],PARAMETER[\"standar");
    add_srs_wkt (p, 10,
        "d_parallel_1\",36.2333333333333],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 11,
        "rallel_2\",34.9333333333333],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 12,
        ",1312333.3333],PARAMETER[\"false_northing\",0],UNIT[\"US");
    add_srs_wkt (p, 13,
        " survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 14,
        "03\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 15,
        "UTHORITY[\"EPSG\",\"3433\"]],VERT_CS[\"NAVD88 height (ft");
    add_srs_wkt (p, 16,
        "US)\",VERT_DATUM[\"North American Vertical Datum 1988\",");
    add_srs_wkt (p, 17,
        "2005,AUTHORITY[\"EPSG\",\"5103\"]],UNIT[\"US survey foot");
    add_srs_wkt (p, 18,
        "\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[");
    add_srs_wkt (p, 19,
        "\"Gravity-related height\",UP],AUTHORITY[\"EPSG\",\"6360");
    add_srs_wkt (p, 20,
        "\"]],AUTHORITY[\"EPSG\",\"8712\"]]");
    p = add_epsg_def_ex (filter, first, last, 8713, "epsg", 8713,
        "NAD83 / Arkansas South (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=32.6666666666667 +lon_0=-92 +lat_1=34.7");
    add_proj4text (p, 1,
        "666666666667 +lat_2=33.3 +x_0=399999.99998984 +y_0=39999");
    add_proj4text (p, 2,
        "9.99998984 +datum=NAD83 +units=us-ft +vunits=us-ft +no_d");
    add_proj4text (p, 3,
        "efs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Arkansas South (ftUS) + NAVD88 height");
    add_srs_wkt (p, 1,
        " (ftUS)\",PROJCS[\"NAD83 / Arkansas South (ftUS)\",GEOGC");
    add_srs_wkt (p, 2,
        "S[\"NAD83\",DATUM[\"North_American_Datum_1983\",SPHEROID");
    add_srs_wkt (p, 3,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "7019\"]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 5,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 6,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 7,
        "EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Conic_2");
    add_srs_wkt (p, 8,
        "SP\"],PARAMETER[\"latitude_of_origin\",32.6666666666667]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"central_meridian\",-92],PARAMETER[\"standar");
    add_srs_wkt (p, 10,
        "d_parallel_1\",34.7666666666667],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 11,
        "rallel_2\",33.3],PARAMETER[\"false_easting\",1312333.333");
    add_srs_wkt (p, 12,
        "3],PARAMETER[\"false_northing\",1312333.3333],UNIT[\"US ");
    add_srs_wkt (p, 13,
        "survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 14,
        "3\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 15,
        "THORITY[\"EPSG\",\"3434\"]],VERT_CS[\"NAVD88 height (ftU");
    add_srs_wkt (p, 16,
        "S)\",VERT_DATUM[\"North American Vertical Datum 1988\",2");
    add_srs_wkt (p, 17,
        "005,AUTHORITY[\"EPSG\",\"5103\"]],UNIT[\"US survey foot\"");
    add_srs_wkt (p, 18,
        ",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"");
    add_srs_wkt (p, 19,
        "Gravity-related height\",UP],AUTHORITY[\"EPSG\",\"6360\"");
    add_srs_wkt (p, 20,
        "]],AUTHORITY[\"EPSG\",\"8713\"]]");
    p = add_epsg_def_ex (filter, first, last, 8714, "epsg", 8714,
        "NAD83 / California zone 1 (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=39.3333333333333 +lon_0=-122 +lat_1=41.");
    add_proj4text (p, 1,
        "6666666666667 +lat_2=40 +x_0=2000000.0001016 +y_0=500000");
    add_proj4text (p, 2,
        ".0001016 +datum=NAD83 +units=us-ft +vunits=us-ft +no_def");
    add_proj4text (p, 3,
        "s");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / California zone 1 (ftUS) + NAVD88 hei");
    add_srs_wkt (p, 1,
        "ght (ftUS)\",PROJCS[\"NAD83 / California zone 1 (ftUS)\"");
    add_srs_wkt (p, 2,
        ",GEOGCS[\"NAD83\",DATUM[\"North_American_Datum_1983\",SP");
    add_srs_wkt (p, 3,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 4,
        "SG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"G");
    add_srs_wkt (p, 5,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 6,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal");
    add_srs_wkt (p, 8,
        "_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",39.333333");
    add_srs_wkt (p, 9,
        "3333333],PARAMETER[\"central_meridian\",-122],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"standard_parallel_1\",41.6666666666667],PARAMETER[\"st");
    add_srs_wkt (p, 11,
        "andard_parallel_2\",40],PARAMETER[\"false_easting\",6561");
    add_srs_wkt (p, 12,
        "666.667],PARAMETER[\"false_northing\",1640416.667],UNIT[");
    add_srs_wkt (p, 13,
        "\"US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 14,
        "\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 15,
        "H],AUTHORITY[\"EPSG\",\"2225\"]],VERT_CS[\"NAVD88 height");
    add_srs_wkt (p, 16,
        " (ftUS)\",VERT_DATUM[\"North American Vertical Datum 198");
    add_srs_wkt (p, 17,
        "8\",2005,AUTHORITY[\"EPSG\",\"5103\"]],UNIT[\"US survey ");
    add_srs_wkt (p, 18,
        "foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],A");
    add_srs_wkt (p, 19,
        "XIS[\"Gravity-related height\",UP],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 20,
        "6360\"]],AUTHORITY[\"EPSG\",\"8714\"]]");
    p = add_epsg_def_ex (filter, first, last, 8715, "epsg", 8715,
        "NAD83 / California zone 2 (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=37.6666666666667 +lon_0=-122 +lat_1=39.");
    add_proj4text (p, 1,
        "8333333333333 +lat_2=38.3333333333333 +x_0=2000000.00010");
    add_proj4text (p, 2,
        "16 +y_0=500000.0001016 +datum=NAD83 +units=us-ft +vunits");
    add_proj4text (p, 3,
        "=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / California zone 2 (ftUS) + NAVD88 hei");
    add_srs_wkt (p, 1,
        "ght (ftUS)\",PROJCS[\"NAD83 / California zone 2 (ftUS)\"");
    add_srs_wkt (p, 2,
        ",GEOGCS[\"NAD83\",DATUM[\"North_American_Datum_1983\",SP");
    add_srs_wkt (p, 3,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 4,
        "SG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"G");
    add_srs_wkt (p, 5,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 6,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal");
    add_srs_wkt (p, 8,
        "_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",37.666666");
    add_srs_wkt (p, 9,
        "6666667],PARAMETER[\"central_meridian\",-122],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"standard_parallel_1\",39.8333333333333],PARAMETER[\"st");
    add_srs_wkt (p, 11,
        "andard_parallel_2\",38.3333333333333],PARAMETER[\"false_");
    add_srs_wkt (p, 12,
        "easting\",6561666.667],PARAMETER[\"false_northing\",1640");
    add_srs_wkt (p, 13,
        "416.667],UNIT[\"US survey foot\",0.304800609601219,AUTHO");
    add_srs_wkt (p, 14,
        "RITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"N");
    add_srs_wkt (p, 15,
        "orthing\",NORTH],AUTHORITY[\"EPSG\",\"2226\"]],VERT_CS[\"");
    add_srs_wkt (p, 16,
        "NAVD88 height (ftUS)\",VERT_DATUM[\"North American Verti");
    add_srs_wkt (p, 17,
        "cal Datum 1988\",2005,AUTHORITY[\"EPSG\",\"5103\"]],UNIT");
    add_srs_wkt (p, 18,
        "[\"US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 19,
        ",\"9003\"]],AXIS[\"Gravity-related height\",UP],AUTHORIT");
    add_srs_wkt (p, 20,
        "Y[\"EPSG\",\"6360\"]],AUTHORITY[\"EPSG\",\"8715\"]]");
    p = add_epsg_def_ex (filter, first, last, 8716, "epsg", 8716,
        "NAD83 / California zone 3 (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=36.5 +lon_0=-120.5 +lat_1=38.4333333333");
    add_proj4text (p, 1,
        "333 +lat_2=37.0666666666667 +x_0=2000000.0001016 +y_0=50");
    add_proj4text (p, 2,
        "0000.0001016 +datum=NAD83 +units=us-ft +vunits=us-ft +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / California zone 3 (ftUS) + NAVD88 hei");
    add_srs_wkt (p, 1,
        "ght (ftUS)\",PROJCS[\"NAD83 / California zone 3 (ftUS)\"");
    add_srs_wkt (p, 2,
        ",GEOGCS[\"NAD83\",DATUM[\"North_American_Datum_1983\",SP");
    add_srs_wkt (p, 3,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 4,
        "SG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"G");
    add_srs_wkt (p, 5,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 6,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal");
    add_srs_wkt (p, 8,
        "_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",36.5],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"central_meridian\",-120.5],PARAMETER[\"standard");
    add_srs_wkt (p, 10,
        "_parallel_1\",38.4333333333333],PARAMETER[\"standard_par");
    add_srs_wkt (p, 11,
        "allel_2\",37.0666666666667],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 12,
        "6561666.667],PARAMETER[\"false_northing\",1640416.667],U");
    add_srs_wkt (p, 13,
        "NIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"EPS");
    add_srs_wkt (p, 14,
        "G\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",");
    add_srs_wkt (p, 15,
        "NORTH],AUTHORITY[\"EPSG\",\"2227\"]],VERT_CS[\"NAVD88 he");
    add_srs_wkt (p, 16,
        "ight (ftUS)\",VERT_DATUM[\"North American Vertical Datum");
    add_srs_wkt (p, 17,
        " 1988\",2005,AUTHORITY[\"EPSG\",\"5103\"]],UNIT[\"US sur");
    add_srs_wkt (p, 18,
        "vey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"");
    add_srs_wkt (p, 19,
        "]],AXIS[\"Gravity-related height\",UP],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 20,
        ",\"6360\"]],AUTHORITY[\"EPSG\",\"8716\"]]");
    p = add_epsg_def_ex (filter, first, last, 8717, "epsg", 8717,
        "NAD83 / California zone 4 (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=35.3333333333333 +lon_0=-119 +lat_1=37.");
    add_proj4text (p, 1,
        "25 +lat_2=36 +x_0=2000000.0001016 +y_0=500000.0001016 +d");
    add_proj4text (p, 2,
        "atum=NAD83 +units=us-ft +vunits=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / California zone 4 (ftUS) + NAVD88 hei");
    add_srs_wkt (p, 1,
        "ght (ftUS)\",PROJCS[\"NAD83 / California zone 4 (ftUS)\"");
    add_srs_wkt (p, 2,
        ",GEOGCS[\"NAD83\",DATUM[\"North_American_Datum_1983\",SP");
    add_srs_wkt (p, 3,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 4,
        "SG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"G");
    add_srs_wkt (p, 5,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 6,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal");
    add_srs_wkt (p, 8,
        "_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",35.333333");
    add_srs_wkt (p, 9,
        "3333333],PARAMETER[\"central_meridian\",-119],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"standard_parallel_1\",37.25],PARAMETER[\"standard_para");
    add_srs_wkt (p, 11,
        "llel_2\",36],PARAMETER[\"false_easting\",6561666.667],PA");
    add_srs_wkt (p, 12,
        "RAMETER[\"false_northing\",1640416.667],UNIT[\"US survey");
    add_srs_wkt (p, 13,
        " foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],");
    add_srs_wkt (p, 14,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 15,
        "Y[\"EPSG\",\"2228\"]],VERT_CS[\"NAVD88 height (ftUS)\",V");
    add_srs_wkt (p, 16,
        "ERT_DATUM[\"North American Vertical Datum 1988\",2005,AU");
    add_srs_wkt (p, 17,
        "THORITY[\"EPSG\",\"5103\"]],UNIT[\"US survey foot\",0.30");
    add_srs_wkt (p, 18,
        "4800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Gravi");
    add_srs_wkt (p, 19,
        "ty-related height\",UP],AUTHORITY[\"EPSG\",\"6360\"]],AU");
    add_srs_wkt (p, 20,
        "THORITY[\"EPSG\",\"8717\"]]");
    p = add_epsg_def_ex (filter, first, last, 8718, "epsg", 8718,
        "NAD83 / California zone 5 (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=33.5 +lon_0=-118 +lat_1=35.466666666666");
    add_proj4text (p, 1,
        "7 +lat_2=34.0333333333333 +x_0=2000000.0001016 +y_0=5000");
    add_proj4text (p, 2,
        "00.0001016 +datum=NAD83 +units=us-ft +vunits=us-ft +no_d");
    add_proj4text (p, 3,
        "efs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / California zone 5 (ftUS) + NAVD88 hei");
    add_srs_wkt (p, 1,
        "ght (ftUS)\",PROJCS[\"NAD83 / California zone 5 (ftUS)\"");
    add_srs_wkt (p, 2,
        ",GEOGCS[\"NAD83\",DATUM[\"North_American_Datum_1983\",SP");
    add_srs_wkt (p, 3,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 4,
        "SG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"G");
    add_srs_wkt (p, 5,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 6,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal");
    add_srs_wkt (p, 8,
        "_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",33.5],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"central_meridian\",-118],PARAMETER[\"standard_p");
    add_srs_wkt (p, 10,
        "arallel_1\",35.4666666666667],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 11,
        "lel_2\",34.0333333333333],PARAMETER[\"false_easting\",65");
    add_srs_wkt (p, 12,
        "61666.667],PARAMETER[\"false_northing\",1640416.667],UNI");
    add_srs_wkt (p, 13,
        "T[\"US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 14,
        ",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 15,
        "TH],AUTHORITY[\"EPSG\",\"2229\"]],VERT_CS[\"NAVD88 heigh");
    add_srs_wkt (p, 16,
        "t (ftUS)\",VERT_DATUM[\"North American Vertical Datum 19");
    add_srs_wkt (p, 17,
        "88\",2005,AUTHORITY[\"EPSG\",\"5103\"]],UNIT[\"US survey");
    add_srs_wkt (p, 18,
        " foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],");
    add_srs_wkt (p, 19,
        "AXIS[\"Gravity-related height\",UP],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 20,
        "6360\"]],AUTHORITY[\"EPSG\",\"8718\"]]");
    p = add_epsg_def_ex (filter, first, last, 8719, "epsg", 8719,
        "NAD83 / California zone 6 (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=32.1666666666667 +lon_0=-116.25 +lat_1=");
    add_proj4text (p, 1,
        "33.8833333333333 +lat_2=32.7833333333333 +x_0=2000000.00");
    add_proj4text (p, 2,
        "01016 +y_0=500000.0001016 +datum=NAD83 +units=us-ft +vun");
    add_proj4text (p, 3,
        "its=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / California zone 6 (ftUS) + NAVD88 hei");
    add_srs_wkt (p, 1,
        "ght (ftUS)\",PROJCS[\"NAD83 / California zone 6 (ftUS)\"");
    add_srs_wkt (p, 2,
        ",GEOGCS[\"NAD83\",DATUM[\"North_American_Datum_1983\",SP");
    add_srs_wkt (p, 3,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 4,
        "SG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"G");
    add_srs_wkt (p, 5,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 6,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal");
    add_srs_wkt (p, 8,
        "_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",32.166666");
    add_srs_wkt (p, 9,
        "6666667],PARAMETER[\"central_meridian\",-116.25],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"standard_parallel_1\",33.8833333333333],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "standard_parallel_2\",32.7833333333333],PARAMETER[\"fals");
    add_srs_wkt (p, 12,
        "e_easting\",6561666.667],PARAMETER[\"false_northing\",16");
    add_srs_wkt (p, 13,
        "40416.667],UNIT[\"US survey foot\",0.304800609601219,AUT");
    add_srs_wkt (p, 14,
        "HORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 15,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"2230\"]],VERT_CS[");
    add_srs_wkt (p, 16,
        "\"NAVD88 height (ftUS)\",VERT_DATUM[\"North American Ver");
    add_srs_wkt (p, 17,
        "tical Datum 1988\",2005,AUTHORITY[\"EPSG\",\"5103\"]],UN");
    add_srs_wkt (p, 18,
        "IT[\"US survey foot\",0.304800609601219,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 19,
        "\",\"9003\"]],AXIS[\"Gravity-related height\",UP],AUTHOR");
    add_srs_wkt (p, 20,
        "ITY[\"EPSG\",\"6360\"]],AUTHORITY[\"EPSG\",\"8719\"]]");
    p = add_epsg_def_ex (filter, first, last, 8720, "epsg", 8720,
        "NAD83 / Colorado North (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=39.3333333333333 +lon_0=-105.5 +lat_1=4");
    add_proj4text (p, 1,
        "0.7833333333333 +lat_2=39.7166666666667 +x_0=914401.8288");
    add_proj4text (p, 2,
        "03658 +y_0=304800.609601219 +datum=NAD83 +units=us-ft +v");
    add_proj4text (p, 3,
        "units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Colorado North (ftUS) + NAVD88 height");
    add_srs_wkt (p, 1,
        " (ftUS)\",PROJCS[\"NAD83 / Colorado North (ftUS)\",GEOGC");
    add_srs_wkt (p, 2,
        "S[\"NAD83\",DATUM[\"North_American_Datum_1983\",SPHEROID");
    add_srs_wkt (p, 3,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "7019\"]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 5,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 6,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 7,
        "EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Conic_2");
    add_srs_wkt (p, 8,
        "SP\"],PARAMETER[\"latitude_of_origin\",39.3333333333333]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"central_meridian\",-105.5],PARAMETER[\"stan");
    add_srs_wkt (p, 10,
        "dard_parallel_1\",40.7833333333333],PARAMETER[\"standard");
    add_srs_wkt (p, 11,
        "_parallel_2\",39.7166666666667],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 12,
        "g\",3000000],PARAMETER[\"false_northing\",1000000],UNIT[");
    add_srs_wkt (p, 13,
        "\"US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 14,
        "\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 15,
        "H],AUTHORITY[\"EPSG\",\"2231\"]],VERT_CS[\"NAVD88 height");
    add_srs_wkt (p, 16,
        " (ftUS)\",VERT_DATUM[\"North American Vertical Datum 198");
    add_srs_wkt (p, 17,
        "8\",2005,AUTHORITY[\"EPSG\",\"5103\"]],UNIT[\"US survey ");
    add_srs_wkt (p, 18,
        "foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],A");
    add_srs_wkt (p, 19,
        "XIS[\"Gravity-related height\",UP],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 20,
        "6360\"]],AUTHORITY[\"EPSG\",\"8720\"]]");
    p = add_epsg_def_ex (filter, first, last, 8721, "epsg", 8721,
        "NAD83 / Colorado Central (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=37.8333333333333 +lon_0=-105.5 +lat_1=3");
    add_proj4text (p, 1,
        "9.75 +lat_2=38.45 +x_0=914401.828803658 +y_0=304800.6096");
    add_proj4text (p, 2,
        "01219 +datum=NAD83 +units=us-ft +vunits=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Colorado Central (ftUS) + NAVD88 heig");
    add_srs_wkt (p, 1,
        "ht (ftUS)\",PROJCS[\"NAD83 / Colorado Central (ftUS)\",G");
    add_srs_wkt (p, 2,
        "EOGCS[\"NAD83\",DATUM[\"North_American_Datum_1983\",SPHE");
    add_srs_wkt (p, 3,
        "ROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"7019\"]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gre");
    add_srs_wkt (p, 5,
        "enwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 6,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 7,
        "ITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_C");
    add_srs_wkt (p, 8,
        "onic_2SP\"],PARAMETER[\"latitude_of_origin\",37.83333333");
    add_srs_wkt (p, 9,
        "33333],PARAMETER[\"central_meridian\",-105.5],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"standard_parallel_1\",39.75],PARAMETER[\"standard_para");
    add_srs_wkt (p, 11,
        "llel_2\",38.45],PARAMETER[\"false_easting\",3000000],PAR");
    add_srs_wkt (p, 12,
        "AMETER[\"false_northing\",1000000],UNIT[\"US survey foot");
    add_srs_wkt (p, 13,
        "\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[");
    add_srs_wkt (p, 14,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 15,
        "PSG\",\"2232\"]],VERT_CS[\"NAVD88 height (ftUS)\",VERT_D");
    add_srs_wkt (p, 16,
        "ATUM[\"North American Vertical Datum 1988\",2005,AUTHORI");
    add_srs_wkt (p, 17,
        "TY[\"EPSG\",\"5103\"]],UNIT[\"US survey foot\",0.3048006");
    add_srs_wkt (p, 18,
        "09601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Gravity-re");
    add_srs_wkt (p, 19,
        "lated height\",UP],AUTHORITY[\"EPSG\",\"6360\"]],AUTHORI");
    add_srs_wkt (p, 20,
        "TY[\"EPSG\",\"8721\"]]");
    p = add_epsg_def_ex (filter, first, last, 8722, "epsg", 8722,
        "NAD83 / Colorado South (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=36.6666666666667 +lon_0=-105.5 +lat_1=3");
    add_proj4text (p, 1,
        "8.4333333333333 +lat_2=37.2333333333333 +x_0=914401.8288");
    add_proj4text (p, 2,
        "03658 +y_0=304800.609601219 +datum=NAD83 +units=us-ft +v");
    add_proj4text (p, 3,
        "units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Colorado South (ftUS) + NAVD88 height");
    add_srs_wkt (p, 1,
        " (ftUS)\",PROJCS[\"NAD83 / Colorado South (ftUS)\",GEOGC");
    add_srs_wkt (p, 2,
        "S[\"NAD83\",DATUM[\"North_American_Datum_1983\",SPHEROID");
    add_srs_wkt (p, 3,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "7019\"]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 5,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 6,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 7,
        "EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Conic_2");
    add_srs_wkt (p, 8,
        "SP\"],PARAMETER[\"latitude_of_origin\",36.6666666666667]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"central_meridian\",-105.5],PARAMETER[\"stan");
    add_srs_wkt (p, 10,
        "dard_parallel_1\",38.4333333333333],PARAMETER[\"standard");
    add_srs_wkt (p, 11,
        "_parallel_2\",37.2333333333333],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 12,
        "g\",3000000],PARAMETER[\"false_northing\",1000000],UNIT[");
    add_srs_wkt (p, 13,
        "\"US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 14,
        "\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 15,
        "H],AUTHORITY[\"EPSG\",\"2233\"]],VERT_CS[\"NAVD88 height");
    add_srs_wkt (p, 16,
        " (ftUS)\",VERT_DATUM[\"North American Vertical Datum 198");
    add_srs_wkt (p, 17,
        "8\",2005,AUTHORITY[\"EPSG\",\"5103\"]],UNIT[\"US survey ");
    add_srs_wkt (p, 18,
        "foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],A");
    add_srs_wkt (p, 19,
        "XIS[\"Gravity-related height\",UP],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 20,
        "6360\"]],AUTHORITY[\"EPSG\",\"8722\"]]");
    p = add_epsg_def_ex (filter, first, last, 8723, "epsg", 8723,
        "NAD83 / Connecticut (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=40.8333333333333 +lon_0=-72.75 +lat_1=4");
    add_proj4text (p, 1,
        "1.8666666666667 +lat_2=41.2 +x_0=304800.609601219 +y_0=1");
    add_proj4text (p, 2,
        "52400.30480061 +datum=NAD83 +units=us-ft +vunits=us-ft +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Connecticut (ftUS) + NAVD88 height (f");
    add_srs_wkt (p, 1,
        "tUS)\",PROJCS[\"NAD83 / Connecticut (ftUS)\",GEOGCS[\"NA");
    add_srs_wkt (p, 2,
        "D83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS");
    add_srs_wkt (p, 3,
        " 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 4,
        "]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 6,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4269\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"latitude_of_origin\",40.8333333333333],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"central_meridian\",-72.75],PARAMETER[\"standard_p");
    add_srs_wkt (p, 10,
        "arallel_1\",41.8666666666667],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 11,
        "lel_2\",41.2],PARAMETER[\"false_easting\",1000000],PARAM");
    add_srs_wkt (p, 12,
        "ETER[\"false_northing\",500000],UNIT[\"US survey foot\",");
    add_srs_wkt (p, 13,
        "0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"E");
    add_srs_wkt (p, 14,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 15,
        "\",\"2234\"]],VERT_CS[\"NAVD88 height (ftUS)\",VERT_DATU");
    add_srs_wkt (p, 16,
        "M[\"North American Vertical Datum 1988\",2005,AUTHORITY[");
    add_srs_wkt (p, 17,
        "\"EPSG\",\"5103\"]],UNIT[\"US survey foot\",0.3048006096");
    add_srs_wkt (p, 18,
        "01219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Gravity-relat");
    add_srs_wkt (p, 19,
        "ed height\",UP],AUTHORITY[\"EPSG\",\"6360\"]],AUTHORITY[");
    add_srs_wkt (p, 20,
        "\"EPSG\",\"8723\"]]");
    p = add_epsg_def_ex (filter, first, last, 8724, "epsg", 8724,
        "NAD83 / Delaware (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38 +lon_0=-75.4166666666667 +k=0.9999");
    add_proj4text (p, 1,
        "95 +x_0=200000.0001016 +y_0=0 +datum=NAD83 +units=us-ft ");
    add_proj4text (p, 2,
        "+vunits=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Delaware (ftUS) + NAVD88 height (ftUS");
    add_srs_wkt (p, 1,
        ")\",PROJCS[\"NAD83 / Delaware (ftUS)\",GEOGCS[\"NAD83\",");
    add_srs_wkt (p, 2,
        "DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 3,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 7,
        "69\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
        "atitude_of_origin\",38],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 9,
        "75.4166666666667],PARAMETER[\"scale_factor\",0.999995],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_easting\",656166.667],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_northing\",0],UNIT[\"US survey foot\",0.304800609601219");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AX");
    add_srs_wkt (p, 13,
        "IS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2235\"]],VER");
    add_srs_wkt (p, 14,
        "T_CS[\"NAVD88 height (ftUS)\",VERT_DATUM[\"North America");
    add_srs_wkt (p, 15,
        "n Vertical Datum 1988\",2005,AUTHORITY[\"EPSG\",\"5103\"");
    add_srs_wkt (p, 16,
        "]],UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"");
    add_srs_wkt (p, 17,
        "EPSG\",\"9003\"]],AXIS[\"Gravity-related height\",UP],AU");
    add_srs_wkt (p, 18,
        "THORITY[\"EPSG\",\"6360\"]],AUTHORITY[\"EPSG\",\"8724\"]");
    add_srs_wkt (p, 19,
        "]");
    p = add_epsg_def_ex (filter, first, last, 8725, "epsg", 8725,
        "NAD83 / Florida North (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=29 +lon_0=-84.5 +lat_1=30.75 +lat_2=29.");
    add_proj4text (p, 1,
        "5833333333333 +x_0=600000 +y_0=0 +datum=NAD83 +units=us-");
    add_proj4text (p, 2,
        "ft +vunits=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Florida North (ftUS) + NAVD88 height ");
    add_srs_wkt (p, 1,
        "(ftUS)\",PROJCS[\"NAD83 / Florida North (ftUS)\",GEOGCS[");
    add_srs_wkt (p, 2,
        "\"NAD83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"");
    add_srs_wkt (p, 3,
        "GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 4,
        "19\"]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 5,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 6,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 7,
        "SG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP");
    add_srs_wkt (p, 8,
        "\"],PARAMETER[\"latitude_of_origin\",29],PARAMETER[\"cen");
    add_srs_wkt (p, 9,
        "tral_meridian\",-84.5],PARAMETER[\"standard_parallel_1\"");
    add_srs_wkt (p, 10,
        ",30.75],PARAMETER[\"standard_parallel_2\",29.58333333333");
    add_srs_wkt (p, 11,
        "33],PARAMETER[\"false_easting\",1968500],PARAMETER[\"fal");
    add_srs_wkt (p, 12,
        "se_northing\",0],UNIT[\"US survey foot\",0.3048006096012");
    add_srs_wkt (p, 13,
        "19,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 14,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2238\"]],V");
    add_srs_wkt (p, 15,
        "ERT_CS[\"NAVD88 height (ftUS)\",VERT_DATUM[\"North Ameri");
    add_srs_wkt (p, 16,
        "can Vertical Datum 1988\",2005,AUTHORITY[\"EPSG\",\"5103");
    add_srs_wkt (p, 17,
        "\"]],UNIT[\"US survey foot\",0.304800609601219,AUTHORITY");
    add_srs_wkt (p, 18,
        "[\"EPSG\",\"9003\"]],AXIS[\"Gravity-related height\",UP]");
    add_srs_wkt (p, 19,
        ",AUTHORITY[\"EPSG\",\"6360\"]],AUTHORITY[\"EPSG\",\"8725");
    add_srs_wkt (p, 20,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 8726, "epsg", 8726,
        "NAD83 / Florida East (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=24.3333333333333 +lon_0=-81 +k=0.9999");
    add_proj4text (p, 1,
        "41177 +x_0=200000.0001016 +y_0=0 +datum=NAD83 +units=us-");
    add_proj4text (p, 2,
        "ft +vunits=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Florida East (ftUS) + NAVD88 height (");
    add_srs_wkt (p, 1,
        "ftUS)\",PROJCS[\"NAD83 / Florida East (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 2,
        "NAD83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"G");
    add_srs_wkt (p, 3,
        "RS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"701");
    add_srs_wkt (p, 4,
        "9\"]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 5,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 6,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 7,
        "SG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 8,
        "METER[\"latitude_of_origin\",24.3333333333333],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"central_meridian\",-81],PARAMETER[\"scale_factor\",0.");
    add_srs_wkt (p, 10,
        "999941177],PARAMETER[\"false_easting\",656166.667],PARAM");
    add_srs_wkt (p, 11,
        "ETER[\"false_northing\",0],UNIT[\"US survey foot\",0.304");
    add_srs_wkt (p, 12,
        "800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 13,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "2236\"]],VERT_CS[\"NAVD88 height (ftUS)\",VERT_DATUM[\"N");
    add_srs_wkt (p, 15,
        "orth American Vertical Datum 1988\",2005,AUTHORITY[\"EPS");
    add_srs_wkt (p, 16,
        "G\",\"5103\"]],UNIT[\"US survey foot\",0.304800609601219");
    add_srs_wkt (p, 17,
        ",AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Gravity-related he");
    add_srs_wkt (p, 18,
        "ight\",UP],AUTHORITY[\"EPSG\",\"6360\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 19,
        "G\",\"8726\"]]");
    p = add_epsg_def_ex (filter, first, last, 8727, "epsg", 8727,
        "NAD83 / Florida West (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=24.3333333333333 +lon_0=-82 +k=0.9999");
    add_proj4text (p, 1,
        "41177 +x_0=200000.0001016 +y_0=0 +datum=NAD83 +units=us-");
    add_proj4text (p, 2,
        "ft +vunits=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Florida West (ftUS) + NAVD88 height (");
    add_srs_wkt (p, 1,
        "ftUS)\",PROJCS[\"NAD83 / Florida West (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 2,
        "NAD83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"G");
    add_srs_wkt (p, 3,
        "RS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"701");
    add_srs_wkt (p, 4,
        "9\"]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 5,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 6,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 7,
        "SG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 8,
        "METER[\"latitude_of_origin\",24.3333333333333],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"central_meridian\",-82],PARAMETER[\"scale_factor\",0.");
    add_srs_wkt (p, 10,
        "999941177],PARAMETER[\"false_easting\",656166.667],PARAM");
    add_srs_wkt (p, 11,
        "ETER[\"false_northing\",0],UNIT[\"US survey foot\",0.304");
    add_srs_wkt (p, 12,
        "800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 13,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "2237\"]],VERT_CS[\"NAVD88 height (ftUS)\",VERT_DATUM[\"N");
    add_srs_wkt (p, 15,
        "orth American Vertical Datum 1988\",2005,AUTHORITY[\"EPS");
    add_srs_wkt (p, 16,
        "G\",\"5103\"]],UNIT[\"US survey foot\",0.304800609601219");
    add_srs_wkt (p, 17,
        ",AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Gravity-related he");
    add_srs_wkt (p, 18,
        "ight\",UP],AUTHORITY[\"EPSG\",\"6360\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 19,
        "G\",\"8727\"]]");
    p = add_epsg_def_ex (filter, first, last, 8728, "epsg", 8728,
        "NAD83 / Georgia East (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=30 +lon_0=-82.1666666666667 +k=0.9999");
    add_proj4text (p, 1,
        " +x_0=200000.0001016 +y_0=0 +datum=NAD83 +units=us-ft +v");
    add_proj4text (p, 2,
        "units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Georgia East (ftUS) + NAVD88 height (");
    add_srs_wkt (p, 1,
        "ftUS)\",PROJCS[\"NAD83 / Georgia East (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 2,
        "NAD83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"G");
    add_srs_wkt (p, 3,
        "RS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"701");
    add_srs_wkt (p, 4,
        "9\"]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 5,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 6,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 7,
        "SG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 8,
        "METER[\"latitude_of_origin\",30],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",-82.1666666666667],PARAMETER[\"scale_factor\",0.");
    add_srs_wkt (p, 10,
        "9999],PARAMETER[\"false_easting\",656166.667],PARAMETER[");
    add_srs_wkt (p, 11,
        "\"false_northing\",0],UNIT[\"US survey foot\",0.30480060");
    add_srs_wkt (p, 12,
        "9601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",E");
    add_srs_wkt (p, 13,
        "AST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2239\"");
    add_srs_wkt (p, 14,
        "]],VERT_CS[\"NAVD88 height (ftUS)\",VERT_DATUM[\"North A");
    add_srs_wkt (p, 15,
        "merican Vertical Datum 1988\",2005,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 16,
        "5103\"]],UNIT[\"US survey foot\",0.304800609601219,AUTHO");
    add_srs_wkt (p, 17,
        "RITY[\"EPSG\",\"9003\"]],AXIS[\"Gravity-related height\"");
    add_srs_wkt (p, 18,
        ",UP],AUTHORITY[\"EPSG\",\"6360\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 19,
        "8728\"]]");
    p = add_epsg_def_ex (filter, first, last, 8729, "epsg", 8729,
        "NAD83 / Georgia West (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=30 +lon_0=-84.1666666666667 +k=0.9999");
    add_proj4text (p, 1,
        " +x_0=699999.9998984 +y_0=0 +datum=NAD83 +units=us-ft +v");
    add_proj4text (p, 2,
        "units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Georgia West (ftUS) + NAVD88 height (");
    add_srs_wkt (p, 1,
        "ftUS)\",PROJCS[\"NAD83 / Georgia West (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 2,
        "NAD83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"G");
    add_srs_wkt (p, 3,
        "RS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"701");
    add_srs_wkt (p, 4,
        "9\"]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 5,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 6,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 7,
        "SG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 8,
        "METER[\"latitude_of_origin\",30],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",-84.1666666666667],PARAMETER[\"scale_factor\",0.");
    add_srs_wkt (p, 10,
        "9999],PARAMETER[\"false_easting\",2296583.333],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"false_northing\",0],UNIT[\"US survey foot\",0.3048006");
    add_srs_wkt (p, 12,
        "09601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",");
    add_srs_wkt (p, 13,
        "EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2240");
    add_srs_wkt (p, 14,
        "\"]],VERT_CS[\"NAVD88 height (ftUS)\",VERT_DATUM[\"North");
    add_srs_wkt (p, 15,
        " American Vertical Datum 1988\",2005,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 16,
        "\"5103\"]],UNIT[\"US survey foot\",0.304800609601219,AUT");
    add_srs_wkt (p, 17,
        "HORITY[\"EPSG\",\"9003\"]],AXIS[\"Gravity-related height");
    add_srs_wkt (p, 18,
        "\",UP],AUTHORITY[\"EPSG\",\"6360\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 19,
        "\"8729\"]]");
    p = add_epsg_def_ex (filter, first, last, 8730, "epsg", 8730,
        "NAD83 / Idaho East (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.6666666666667 +lon_0=-112.16666666");
    add_proj4text (p, 1,
        "6667 +k=0.999947368 +x_0=200000.0001016 +y_0=0 +datum=NA");
    add_proj4text (p, 2,
        "D83 +units=us-ft +vunits=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Idaho East (ftUS) + NAVD88 height (ft");
    add_srs_wkt (p, 1,
        "US)\",PROJCS[\"NAD83 / Idaho East (ftUS)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 2,
        "3\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 3,
        "980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]");
    add_srs_wkt (p, 4,
        "],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 6,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"latitude_of_origin\",41.6666666666667],PARAMETER[\"c");
    add_srs_wkt (p, 9,
        "entral_meridian\",-112.166666666667],PARAMETER[\"scale_f");
    add_srs_wkt (p, 10,
        "actor\",0.999947368],PARAMETER[\"false_easting\",656166.");
    add_srs_wkt (p, 11,
        "667],PARAMETER[\"false_northing\",0],UNIT[\"US survey fo");
    add_srs_wkt (p, 12,
        "ot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXI");
    add_srs_wkt (p, 13,
        "S[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 14,
        "EPSG\",\"2241\"]],VERT_CS[\"NAVD88 height (ftUS)\",VERT_");
    add_srs_wkt (p, 15,
        "DATUM[\"North American Vertical Datum 1988\",2005,AUTHOR");
    add_srs_wkt (p, 16,
        "ITY[\"EPSG\",\"5103\"]],UNIT[\"US survey foot\",0.304800");
    add_srs_wkt (p, 17,
        "609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Gravity-r");
    add_srs_wkt (p, 18,
        "elated height\",UP],AUTHORITY[\"EPSG\",\"6360\"]],AUTHOR");
    add_srs_wkt (p, 19,
        "ITY[\"EPSG\",\"8730\"]]");
    p = add_epsg_def_ex (filter, first, last, 8731, "epsg", 8731,
        "NAD83 / Idaho Central (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.6666666666667 +lon_0=-114 +k=0.999");
    add_proj4text (p, 1,
        "947368 +x_0=500000.0001016 +y_0=0 +datum=NAD83 +units=us");
    add_proj4text (p, 2,
        "-ft +vunits=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Idaho Central (ftUS) + NAVD88 height ");
    add_srs_wkt (p, 1,
        "(ftUS)\",PROJCS[\"NAD83 / Idaho Central (ftUS)\",GEOGCS[");
    add_srs_wkt (p, 2,
        "\"NAD83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"");
    add_srs_wkt (p, 3,
        "GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 4,
        "19\"]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 5,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 6,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 7,
        "SG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 8,
        "METER[\"latitude_of_origin\",41.6666666666667],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"central_meridian\",-114],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 10,
        ".999947368],PARAMETER[\"false_easting\",1640416.667],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",0],UNIT[\"US survey foot\",0.3");
    add_srs_wkt (p, 12,
        "04800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"East");
    add_srs_wkt (p, 13,
        "ing\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 14,
        "\"2242\"]],VERT_CS[\"NAVD88 height (ftUS)\",VERT_DATUM[\"");
    add_srs_wkt (p, 15,
        "North American Vertical Datum 1988\",2005,AUTHORITY[\"EP");
    add_srs_wkt (p, 16,
        "SG\",\"5103\"]],UNIT[\"US survey foot\",0.30480060960121");
    add_srs_wkt (p, 17,
        "9,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Gravity-related h");
    add_srs_wkt (p, 18,
        "eight\",UP],AUTHORITY[\"EPSG\",\"6360\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 19,
        "SG\",\"8731\"]]");
    p = add_epsg_def_ex (filter, first, last, 8732, "epsg", 8732,
        "NAD83 / Idaho West (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.6666666666667 +lon_0=-115.75 +k=0.");
    add_proj4text (p, 1,
        "999933333 +x_0=800000.0001016 +y_0=0 +datum=NAD83 +units");
    add_proj4text (p, 2,
        "=us-ft +vunits=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Idaho West (ftUS) + NAVD88 height (ft");
    add_srs_wkt (p, 1,
        "US)\",PROJCS[\"NAD83 / Idaho West (ftUS)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 2,
        "3\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 3,
        "980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]");
    add_srs_wkt (p, 4,
        "],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 6,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"latitude_of_origin\",41.6666666666667],PARAMETER[\"c");
    add_srs_wkt (p, 9,
        "entral_meridian\",-115.75],PARAMETER[\"scale_factor\",0.");
    add_srs_wkt (p, 10,
        "999933333],PARAMETER[\"false_easting\",2624666.667],PARA");
    add_srs_wkt (p, 11,
        "METER[\"false_northing\",0],UNIT[\"US survey foot\",0.30");
    add_srs_wkt (p, 12,
        "4800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easti");
    add_srs_wkt (p, 13,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "2243\"]],VERT_CS[\"NAVD88 height (ftUS)\",VERT_DATUM[\"N");
    add_srs_wkt (p, 15,
        "orth American Vertical Datum 1988\",2005,AUTHORITY[\"EPS");
    add_srs_wkt (p, 16,
        "G\",\"5103\"]],UNIT[\"US survey foot\",0.304800609601219");
    add_srs_wkt (p, 17,
        ",AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Gravity-related he");
    add_srs_wkt (p, 18,
        "ight\",UP],AUTHORITY[\"EPSG\",\"6360\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 19,
        "G\",\"8732\"]]");
    p = add_epsg_def_ex (filter, first, last, 8733, "epsg", 8733,
        "NAD83 / Illinois East (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36.6666666666667 +lon_0=-88.333333333");
    add_proj4text (p, 1,
        "3333 +k=0.999975 +x_0=300000 +y_0=0 +datum=NAD83 +units=");
    add_proj4text (p, 2,
        "us-ft +vunits=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Illinois East (ftUS) + NAVD88 height ");
    add_srs_wkt (p, 1,
        "(ftUS)\",PROJCS[\"NAD83 / Illinois East (ftUS)\",GEOGCS[");
    add_srs_wkt (p, 2,
        "\"NAD83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"");
    add_srs_wkt (p, 3,
        "GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 4,
        "19\"]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 5,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 6,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 7,
        "SG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 8,
        "METER[\"latitude_of_origin\",36.6666666666667],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"central_meridian\",-88.3333333333333],PARAMETER[\"sca");
    add_srs_wkt (p, 10,
        "le_factor\",0.999975],PARAMETER[\"false_easting\",984250");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_northing\",0],UNIT[\"US survey foot\"");
    add_srs_wkt (p, 12,
        ",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"");
    add_srs_wkt (p, 13,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 14,
        "G\",\"3435\"]],VERT_CS[\"NAVD88 height (ftUS)\",VERT_DAT");
    add_srs_wkt (p, 15,
        "UM[\"North American Vertical Datum 1988\",2005,AUTHORITY");
    add_srs_wkt (p, 16,
        "[\"EPSG\",\"5103\"]],UNIT[\"US survey foot\",0.304800609");
    add_srs_wkt (p, 17,
        "601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Gravity-rela");
    add_srs_wkt (p, 18,
        "ted height\",UP],AUTHORITY[\"EPSG\",\"6360\"]],AUTHORITY");
    add_srs_wkt (p, 19,
        "[\"EPSG\",\"8733\"]]");
    p = add_epsg_def_ex (filter, first, last, 8734, "epsg", 8734,
        "NAD83 / Illinois West (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36.6666666666667 +lon_0=-90.166666666");
    add_proj4text (p, 1,
        "6667 +k=0.999941177 +x_0=699999.99998984 +y_0=0 +datum=N");
    add_proj4text (p, 2,
        "AD83 +units=us-ft +vunits=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Illinois West (ftUS) + NAVD88 height ");
    add_srs_wkt (p, 1,
        "(ftUS)\",PROJCS[\"NAD83 / Illinois West (ftUS)\",GEOGCS[");
    add_srs_wkt (p, 2,
        "\"NAD83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"");
    add_srs_wkt (p, 3,
        "GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 4,
        "19\"]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 5,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 6,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 7,
        "SG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 8,
        "METER[\"latitude_of_origin\",36.6666666666667],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"central_meridian\",-90.1666666666667],PARAMETER[\"sca");
    add_srs_wkt (p, 10,
        "le_factor\",0.999941177],PARAMETER[\"false_easting\",229");
    add_srs_wkt (p, 11,
        "6583.3333],PARAMETER[\"false_northing\",0],UNIT[\"US sur");
    add_srs_wkt (p, 12,
        "vey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"");
    add_srs_wkt (p, 13,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 14,
        "RITY[\"EPSG\",\"3436\"]],VERT_CS[\"NAVD88 height (ftUS)\"");
    add_srs_wkt (p, 15,
        ",VERT_DATUM[\"North American Vertical Datum 1988\",2005,");
    add_srs_wkt (p, 16,
        "AUTHORITY[\"EPSG\",\"5103\"]],UNIT[\"US survey foot\",0.");
    add_srs_wkt (p, 17,
        "304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Gra");
    add_srs_wkt (p, 18,
        "vity-related height\",UP],AUTHORITY[\"EPSG\",\"6360\"]],");
    add_srs_wkt (p, 19,
        "AUTHORITY[\"EPSG\",\"8734\"]]");
    p = add_epsg_def_ex (filter, first, last, 8735, "epsg", 8735,
        "NAD83 / Indiana East (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=37.5 +lon_0=-85.6666666666667 +k=0.99");
    add_proj4text (p, 1,
        "9966667 +x_0=99999.9998983998 +y_0=249999.9998984 +datum");
    add_proj4text (p, 2,
        "=NAD83 +units=us-ft +vunits=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Indiana East (ftUS) + NAVD88 height (");
    add_srs_wkt (p, 1,
        "ftUS)\",PROJCS[\"NAD83 / Indiana East (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 2,
        "NAD83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"G");
    add_srs_wkt (p, 3,
        "RS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"701");
    add_srs_wkt (p, 4,
        "9\"]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 5,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 6,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 7,
        "SG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 8,
        "METER[\"latitude_of_origin\",37.5],PARAMETER[\"central_m");
    add_srs_wkt (p, 9,
        "eridian\",-85.6666666666667],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 10,
        "0.999966667],PARAMETER[\"false_easting\",328083.333],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",820208.333],UNIT[\"US survey f");
    add_srs_wkt (p, 12,
        "oot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AX");
    add_srs_wkt (p, 13,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 14,
        "\"EPSG\",\"2965\"]],VERT_CS[\"NAVD88 height (ftUS)\",VER");
    add_srs_wkt (p, 15,
        "T_DATUM[\"North American Vertical Datum 1988\",2005,AUTH");
    add_srs_wkt (p, 16,
        "ORITY[\"EPSG\",\"5103\"]],UNIT[\"US survey foot\",0.3048");
    add_srs_wkt (p, 17,
        "00609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Gravity");
    add_srs_wkt (p, 18,
        "-related height\",UP],AUTHORITY[\"EPSG\",\"6360\"]],AUTH");
    add_srs_wkt (p, 19,
        "ORITY[\"EPSG\",\"8735\"]]");
    p = add_epsg_def_ex (filter, first, last, 8736, "epsg", 8736,
        "NAD83 / Indiana West (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=37.5 +lon_0=-87.0833333333333 +k=0.99");
    add_proj4text (p, 1,
        "9966667 +x_0=900000 +y_0=249999.9998984 +datum=NAD83 +un");
    add_proj4text (p, 2,
        "its=us-ft +vunits=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Indiana West (ftUS) + NAVD88 height (");
    add_srs_wkt (p, 1,
        "ftUS)\",PROJCS[\"NAD83 / Indiana West (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 2,
        "NAD83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"G");
    add_srs_wkt (p, 3,
        "RS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"701");
    add_srs_wkt (p, 4,
        "9\"]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 5,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 6,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 7,
        "SG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 8,
        "METER[\"latitude_of_origin\",37.5],PARAMETER[\"central_m");
    add_srs_wkt (p, 9,
        "eridian\",-87.0833333333333],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 10,
        "0.999966667],PARAMETER[\"false_easting\",2952750],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_northing\",820208.333],UNIT[\"US survey foot");
    add_srs_wkt (p, 12,
        "\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[");
    add_srs_wkt (p, 13,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 14,
        "PSG\",\"2966\"]],VERT_CS[\"NAVD88 height (ftUS)\",VERT_D");
    add_srs_wkt (p, 15,
        "ATUM[\"North American Vertical Datum 1988\",2005,AUTHORI");
    add_srs_wkt (p, 16,
        "TY[\"EPSG\",\"5103\"]],UNIT[\"US survey foot\",0.3048006");
    add_srs_wkt (p, 17,
        "09601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Gravity-re");
    add_srs_wkt (p, 18,
        "lated height\",UP],AUTHORITY[\"EPSG\",\"6360\"]],AUTHORI");
    add_srs_wkt (p, 19,
        "TY[\"EPSG\",\"8736\"]]");
    p = add_epsg_def_ex (filter, first, last, 8737, "epsg", 8737,
        "NAD83 / Iowa North (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=41.5 +lon_0=-93.5 +lat_1=43.26666666666");
    add_proj4text (p, 1,
        "67 +lat_2=42.0666666666667 +x_0=1500000 +y_0=999999.9999");
    add_proj4text (p, 2,
        "8984 +datum=NAD83 +units=us-ft +vunits=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Iowa North (ftUS) + NAVD88 height (ft");
    add_srs_wkt (p, 1,
        "US)\",PROJCS[\"NAD83 / Iowa North (ftUS)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 2,
        "3\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 3,
        "980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]");
    add_srs_wkt (p, 4,
        "],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 6,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4269\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"latitude_of_origin\",41.5],PARAMETER[\"centr");
    add_srs_wkt (p, 9,
        "al_meridian\",-93.5],PARAMETER[\"standard_parallel_1\",4");
    add_srs_wkt (p, 10,
        "3.2666666666667],PARAMETER[\"standard_parallel_2\",42.06");
    add_srs_wkt (p, 11,
        "66666666667],PARAMETER[\"false_easting\",4921250],PARAME");
    add_srs_wkt (p, 12,
        "TER[\"false_northing\",3280833.3333],UNIT[\"US survey fo");
    add_srs_wkt (p, 13,
        "ot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXI");
    add_srs_wkt (p, 14,
        "S[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 15,
        "EPSG\",\"3417\"]],VERT_CS[\"NAVD88 height (ftUS)\",VERT_");
    add_srs_wkt (p, 16,
        "DATUM[\"North American Vertical Datum 1988\",2005,AUTHOR");
    add_srs_wkt (p, 17,
        "ITY[\"EPSG\",\"5103\"]],UNIT[\"US survey foot\",0.304800");
    add_srs_wkt (p, 18,
        "609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Gravity-r");
    add_srs_wkt (p, 19,
        "elated height\",UP],AUTHORITY[\"EPSG\",\"6360\"]],AUTHOR");
    add_srs_wkt (p, 20,
        "ITY[\"EPSG\",\"8737\"]]");
    p = add_epsg_def_ex (filter, first, last, 8738, "epsg", 8738,
        "NAD83 / Iowa South (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=40 +lon_0=-93.5 +lat_1=41.7833333333333");
    add_proj4text (p, 1,
        " +lat_2=40.6166666666667 +x_0=500000.00001016 +y_0=0 +da");
    add_proj4text (p, 2,
        "tum=NAD83 +units=us-ft +vunits=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Iowa South (ftUS) + NAVD88 height (ft");
    add_srs_wkt (p, 1,
        "US)\",PROJCS[\"NAD83 / Iowa South (ftUS)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 2,
        "3\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 3,
        "980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]");
    add_srs_wkt (p, 4,
        "],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 6,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4269\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"latitude_of_origin\",40],PARAMETER[\"central");
    add_srs_wkt (p, 9,
        "_meridian\",-93.5],PARAMETER[\"standard_parallel_1\",41.");
    add_srs_wkt (p, 10,
        "7833333333333],PARAMETER[\"standard_parallel_2\",40.6166");
    add_srs_wkt (p, 11,
        "666666667],PARAMETER[\"false_easting\",1640416.6667],PAR");
    add_srs_wkt (p, 12,
        "AMETER[\"false_northing\",0],UNIT[\"US survey foot\",0.3");
    add_srs_wkt (p, 13,
        "04800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"East");
    add_srs_wkt (p, 14,
        "ing\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 15,
        "\"3418\"]],VERT_CS[\"NAVD88 height (ftUS)\",VERT_DATUM[\"");
    add_srs_wkt (p, 16,
        "North American Vertical Datum 1988\",2005,AUTHORITY[\"EP");
    add_srs_wkt (p, 17,
        "SG\",\"5103\"]],UNIT[\"US survey foot\",0.30480060960121");
    add_srs_wkt (p, 18,
        "9,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Gravity-related h");
    add_srs_wkt (p, 19,
        "eight\",UP],AUTHORITY[\"EPSG\",\"6360\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 20,
        "SG\",\"8738\"]]");
    p = add_epsg_def_ex (filter, first, last, 8739, "epsg", 8739,
        "NAD83 / Kansas North (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=38.3333333333333 +lon_0=-98 +lat_1=39.7");
    add_proj4text (p, 1,
        "833333333333 +lat_2=38.7166666666667 +x_0=399999.9999898");
    add_proj4text (p, 2,
        "4 +y_0=0 +datum=NAD83 +units=us-ft +vunits=us-ft +no_def");
    add_proj4text (p, 3,
        "s");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Kansas North (ftUS) + NAVD88 height (");
    add_srs_wkt (p, 1,
        "ftUS)\",PROJCS[\"NAD83 / Kansas North (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 2,
        "NAD83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"G");
    add_srs_wkt (p, 3,
        "RS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"701");
    add_srs_wkt (p, 4,
        "9\"]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 5,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 6,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 7,
        "SG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP");
    add_srs_wkt (p, 8,
        "\"],PARAMETER[\"latitude_of_origin\",38.3333333333333],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"central_meridian\",-98],PARAMETER[\"standard_");
    add_srs_wkt (p, 10,
        "parallel_1\",39.7833333333333],PARAMETER[\"standard_para");
    add_srs_wkt (p, 11,
        "llel_2\",38.7166666666667],PARAMETER[\"false_easting\",1");
    add_srs_wkt (p, 12,
        "312333.3333],PARAMETER[\"false_northing\",0],UNIT[\"US s");
    add_srs_wkt (p, 13,
        "urvey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003");
    add_srs_wkt (p, 14,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 15,
        "HORITY[\"EPSG\",\"3419\"]],VERT_CS[\"NAVD88 height (ftUS");
    add_srs_wkt (p, 16,
        ")\",VERT_DATUM[\"North American Vertical Datum 1988\",20");
    add_srs_wkt (p, 17,
        "05,AUTHORITY[\"EPSG\",\"5103\"]],UNIT[\"US survey foot\"");
    add_srs_wkt (p, 18,
        ",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"");
    add_srs_wkt (p, 19,
        "Gravity-related height\",UP],AUTHORITY[\"EPSG\",\"6360\"");
    add_srs_wkt (p, 20,
        "]],AUTHORITY[\"EPSG\",\"8739\"]]");
    p = add_epsg_def_ex (filter, first, last, 8740, "epsg", 8740,
        "NAD83 / Kansas South (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=36.6666666666667 +lon_0=-98.5 +lat_1=38");
    add_proj4text (p, 1,
        ".5666666666667 +lat_2=37.2666666666667 +x_0=399999.99998");
    add_proj4text (p, 2,
        "984 +y_0=399999.99998984 +datum=NAD83 +units=us-ft +vuni");
    add_proj4text (p, 3,
        "ts=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Kansas South (ftUS) + NAVD88 height (");
    add_srs_wkt (p, 1,
        "ftUS)\",PROJCS[\"NAD83 / Kansas South (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 2,
        "NAD83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"G");
    add_srs_wkt (p, 3,
        "RS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"701");
    add_srs_wkt (p, 4,
        "9\"]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 5,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 6,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 7,
        "SG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP");
    add_srs_wkt (p, 8,
        "\"],PARAMETER[\"latitude_of_origin\",36.6666666666667],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"central_meridian\",-98.5],PARAMETER[\"standar");
    add_srs_wkt (p, 10,
        "d_parallel_1\",38.5666666666667],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 11,
        "rallel_2\",37.2666666666667],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 12,
        ",1312333.3333],PARAMETER[\"false_northing\",1312333.3333");
    add_srs_wkt (p, 13,
        "],UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"");
    add_srs_wkt (p, 14,
        "EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 15,
        "\",NORTH],AUTHORITY[\"EPSG\",\"3420\"]],VERT_CS[\"NAVD88");
    add_srs_wkt (p, 16,
        " height (ftUS)\",VERT_DATUM[\"North American Vertical Da");
    add_srs_wkt (p, 17,
        "tum 1988\",2005,AUTHORITY[\"EPSG\",\"5103\"]],UNIT[\"US ");
    add_srs_wkt (p, 18,
        "survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 19,
        "3\"]],AXIS[\"Gravity-related height\",UP],AUTHORITY[\"EP");
    add_srs_wkt (p, 20,
        "SG\",\"6360\"]],AUTHORITY[\"EPSG\",\"8740\"]]");
    p = add_epsg_def_ex (filter, first, last, 8741, "epsg", 8741,
        "NAD83 / Kentucky North (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=37.5 +lon_0=-84.25 +lat_1=37.9666666666");
    add_proj4text (p, 1,
        "667 +lat_2=38.9666666666667 +x_0=500000.0001016 +y_0=0 +");
    add_proj4text (p, 2,
        "datum=NAD83 +units=us-ft +vunits=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Kentucky North (ftUS) + NAVD88 height");
    add_srs_wkt (p, 1,
        " (ftUS)\",PROJCS[\"NAD83 / Kentucky North (ftUS)\",GEOGC");
    add_srs_wkt (p, 2,
        "S[\"NAD83\",DATUM[\"North_American_Datum_1983\",SPHEROID");
    add_srs_wkt (p, 3,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "7019\"]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 5,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 6,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 7,
        "EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Conic_2");
    add_srs_wkt (p, 8,
        "SP\"],PARAMETER[\"latitude_of_origin\",37.5],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "central_meridian\",-84.25],PARAMETER[\"standard_parallel");
    add_srs_wkt (p, 10,
        "_1\",37.9666666666667],PARAMETER[\"standard_parallel_2\"");
    add_srs_wkt (p, 11,
        ",38.9666666666667],PARAMETER[\"false_easting\",1640416.6");
    add_srs_wkt (p, 12,
        "67],PARAMETER[\"false_northing\",0],UNIT[\"US survey foo");
    add_srs_wkt (p, 13,
        "t\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS");
    add_srs_wkt (p, 14,
        "[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 15,
        "EPSG\",\"2246\"]],VERT_CS[\"NAVD88 height (ftUS)\",VERT_");
    add_srs_wkt (p, 16,
        "DATUM[\"North American Vertical Datum 1988\",2005,AUTHOR");
    add_srs_wkt (p, 17,
        "ITY[\"EPSG\",\"5103\"]],UNIT[\"US survey foot\",0.304800");
    add_srs_wkt (p, 18,
        "609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Gravity-r");
    add_srs_wkt (p, 19,
        "elated height\",UP],AUTHORITY[\"EPSG\",\"6360\"]],AUTHOR");
    add_srs_wkt (p, 20,
        "ITY[\"EPSG\",\"8741\"]]");
    p = add_epsg_def_ex (filter, first, last, 8742, "epsg", 8742,
        "NAD83 / Kentucky South (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=36.3333333333333 +lon_0=-85.75 +lat_1=3");
    add_proj4text (p, 1,
        "7.9333333333333 +lat_2=36.7333333333333 +x_0=500000.0001");
    add_proj4text (p, 2,
        "016 +y_0=500000.0001016 +datum=NAD83 +units=us-ft +vunit");
    add_proj4text (p, 3,
        "s=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Kentucky South (ftUS) + NAVD88 height");
    add_srs_wkt (p, 1,
        " (ftUS)\",PROJCS[\"NAD83 / Kentucky South (ftUS)\",GEOGC");
    add_srs_wkt (p, 2,
        "S[\"NAD83\",DATUM[\"North_American_Datum_1983\",SPHEROID");
    add_srs_wkt (p, 3,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "7019\"]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 5,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 6,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 7,
        "EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Conic_2");
    add_srs_wkt (p, 8,
        "SP\"],PARAMETER[\"latitude_of_origin\",36.3333333333333]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"central_meridian\",-85.75],PARAMETER[\"stan");
    add_srs_wkt (p, 10,
        "dard_parallel_1\",37.9333333333333],PARAMETER[\"standard");
    add_srs_wkt (p, 11,
        "_parallel_2\",36.7333333333333],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 12,
        "g\",1640416.667],PARAMETER[\"false_northing\",1640416.66");
    add_srs_wkt (p, 13,
        "7],UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"");
    add_srs_wkt (p, 14,
        "EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 15,
        "\",NORTH],AUTHORITY[\"EPSG\",\"2247\"]],VERT_CS[\"NAVD88");
    add_srs_wkt (p, 16,
        " height (ftUS)\",VERT_DATUM[\"North American Vertical Da");
    add_srs_wkt (p, 17,
        "tum 1988\",2005,AUTHORITY[\"EPSG\",\"5103\"]],UNIT[\"US ");
    add_srs_wkt (p, 18,
        "survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 19,
        "3\"]],AXIS[\"Gravity-related height\",UP],AUTHORITY[\"EP");
    add_srs_wkt (p, 20,
        "SG\",\"6360\"]],AUTHORITY[\"EPSG\",\"8742\"]]");
    p = add_epsg_def_ex (filter, first, last, 8743, "epsg", 8743,
        "NAD83 / Louisiana North (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=30.5 +lon_0=-92.5 +lat_1=32.66666666666");
    add_proj4text (p, 1,
        "67 +lat_2=31.1666666666667 +x_0=999999.99998984 +y_0=0 +");
    add_proj4text (p, 2,
        "datum=NAD83 +units=us-ft +vunits=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Louisiana North (ftUS) + NAVD88 heigh");
    add_srs_wkt (p, 1,
        "t (ftUS)\",PROJCS[\"NAD83 / Louisiana North (ftUS)\",GEO");
    add_srs_wkt (p, 2,
        "GCS[\"NAD83\",DATUM[\"North_American_Datum_1983\",SPHERO");
    add_srs_wkt (p, 3,
        "ID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"7019\"]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 5,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 6,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 7,
        "Y[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Con");
    add_srs_wkt (p, 8,
        "ic_2SP\"],PARAMETER[\"latitude_of_origin\",30.5],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"central_meridian\",-92.5],PARAMETER[\"standard_para");
    add_srs_wkt (p, 10,
        "llel_1\",32.6666666666667],PARAMETER[\"standard_parallel");
    add_srs_wkt (p, 11,
        "_2\",31.1666666666667],PARAMETER[\"false_easting\",32808");
    add_srs_wkt (p, 12,
        "33.3333],PARAMETER[\"false_northing\",0],UNIT[\"US surve");
    add_srs_wkt (p, 13,
        "y foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]]");
    add_srs_wkt (p, 14,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 15,
        "TY[\"EPSG\",\"3451\"]],VERT_CS[\"NAVD88 height (ftUS)\",");
    add_srs_wkt (p, 16,
        "VERT_DATUM[\"North American Vertical Datum 1988\",2005,A");
    add_srs_wkt (p, 17,
        "UTHORITY[\"EPSG\",\"5103\"]],UNIT[\"US survey foot\",0.3");
    add_srs_wkt (p, 18,
        "04800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Grav");
    add_srs_wkt (p, 19,
        "ity-related height\",UP],AUTHORITY[\"EPSG\",\"6360\"]],A");
    add_srs_wkt (p, 20,
        "UTHORITY[\"EPSG\",\"8743\"]]");
    p = add_epsg_def_ex (filter, first, last, 8744, "epsg", 8744,
        "NAD83 / Louisiana South (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=28.5 +lon_0=-91.3333333333333 +lat_1=30");
    add_proj4text (p, 1,
        ".7 +lat_2=29.3 +x_0=999999.99998984 +y_0=0 +datum=NAD83 ");
    add_proj4text (p, 2,
        "+units=us-ft +vunits=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Louisiana South (ftUS) + NAVD88 heigh");
    add_srs_wkt (p, 1,
        "t (ftUS)\",PROJCS[\"NAD83 / Louisiana South (ftUS)\",GEO");
    add_srs_wkt (p, 2,
        "GCS[\"NAD83\",DATUM[\"North_American_Datum_1983\",SPHERO");
    add_srs_wkt (p, 3,
        "ID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"7019\"]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 5,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 6,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 7,
        "Y[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Con");
    add_srs_wkt (p, 8,
        "ic_2SP\"],PARAMETER[\"latitude_of_origin\",28.5],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"central_meridian\",-91.3333333333333],PARAMETER[\"s");
    add_srs_wkt (p, 10,
        "tandard_parallel_1\",30.7],PARAMETER[\"standard_parallel");
    add_srs_wkt (p, 11,
        "_2\",29.3],PARAMETER[\"false_easting\",3280833.3333],PAR");
    add_srs_wkt (p, 12,
        "AMETER[\"false_northing\",0],UNIT[\"US survey foot\",0.3");
    add_srs_wkt (p, 13,
        "04800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"East");
    add_srs_wkt (p, 14,
        "ing\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 15,
        "\"3452\"]],VERT_CS[\"NAVD88 height (ftUS)\",VERT_DATUM[\"");
    add_srs_wkt (p, 16,
        "North American Vertical Datum 1988\",2005,AUTHORITY[\"EP");
    add_srs_wkt (p, 17,
        "SG\",\"5103\"]],UNIT[\"US survey foot\",0.30480060960121");
    add_srs_wkt (p, 18,
        "9,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Gravity-related h");
    add_srs_wkt (p, 19,
        "eight\",UP],AUTHORITY[\"EPSG\",\"6360\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 20,
        "SG\",\"8744\"]]");
    p = add_epsg_def_ex (filter, first, last, 8745, "epsg", 8745,
        "NAD83 / Maine East (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.6666666666667 +lon_0=-68.5 +k=0.99");
    add_proj4text (p, 1,
        "99 +x_0=300000 +y_0=0 +datum=NAD83 +units=us-ft +vunits=");
    add_proj4text (p, 2,
        "us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Maine East (ftUS) + NAVD88 height (ft");
    add_srs_wkt (p, 1,
        "US)\",PROJCS[\"NAD83 / Maine East (ftUS)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 2,
        "3\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 3,
        "980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]");
    add_srs_wkt (p, 4,
        "],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 6,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"latitude_of_origin\",43.6666666666667],PARAMETER[\"c");
    add_srs_wkt (p, 9,
        "entral_meridian\",-68.5],PARAMETER[\"scale_factor\",0.99");
    add_srs_wkt (p, 10,
        "99],PARAMETER[\"false_easting\",984250],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_northing\",0],UNIT[\"US survey foot\",0.30480060960121");
    add_srs_wkt (p, 12,
        "9,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 13,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"26847\"]],V");
    add_srs_wkt (p, 14,
        "ERT_CS[\"NAVD88 height (ftUS)\",VERT_DATUM[\"North Ameri");
    add_srs_wkt (p, 15,
        "can Vertical Datum 1988\",2005,AUTHORITY[\"EPSG\",\"5103");
    add_srs_wkt (p, 16,
        "\"]],UNIT[\"US survey foot\",0.304800609601219,AUTHORITY");
    add_srs_wkt (p, 17,
        "[\"EPSG\",\"9003\"]],AXIS[\"Gravity-related height\",UP]");
    add_srs_wkt (p, 18,
        ",AUTHORITY[\"EPSG\",\"6360\"]],AUTHORITY[\"EPSG\",\"8745");
    add_srs_wkt (p, 19,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 8746, "epsg", 8746,
        "NAD83 / Maine West (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.8333333333333 +lon_0=-70.166666666");
    add_proj4text (p, 1,
        "6667 +k=0.999966667 +x_0=900000 +y_0=0 +datum=NAD83 +uni");
    add_proj4text (p, 2,
        "ts=us-ft +vunits=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Maine West (ftUS) + NAVD88 height (ft");
    add_srs_wkt (p, 1,
        "US)\",PROJCS[\"NAD83 / Maine West (ftUS)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 2,
        "3\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 3,
        "980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]");
    add_srs_wkt (p, 4,
        "],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 6,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"latitude_of_origin\",42.8333333333333],PARAMETER[\"c");
    add_srs_wkt (p, 9,
        "entral_meridian\",-70.1666666666667],PARAMETER[\"scale_f");
    add_srs_wkt (p, 10,
        "actor\",0.999966667],PARAMETER[\"false_easting\",2952750");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_northing\",0],UNIT[\"US survey foot\"");
    add_srs_wkt (p, 12,
        ",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"");
    add_srs_wkt (p, 13,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 14,
        "G\",\"26848\"]],VERT_CS[\"NAVD88 height (ftUS)\",VERT_DA");
    add_srs_wkt (p, 15,
        "TUM[\"North American Vertical Datum 1988\",2005,AUTHORIT");
    add_srs_wkt (p, 16,
        "Y[\"EPSG\",\"5103\"]],UNIT[\"US survey foot\",0.30480060");
    add_srs_wkt (p, 17,
        "9601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Gravity-rel");
    add_srs_wkt (p, 18,
        "ated height\",UP],AUTHORITY[\"EPSG\",\"6360\"]],AUTHORIT");
    add_srs_wkt (p, 19,
        "Y[\"EPSG\",\"8746\"]]");
    p = add_epsg_def_ex (filter, first, last, 8747, "epsg", 8747,
        "NAD83 / Maryland (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=37.6666666666667 +lon_0=-77 +lat_1=39.4");
    add_proj4text (p, 1,
        "5 +lat_2=38.3 +x_0=399999.9998984 +y_0=0 +datum=NAD83 +u");
    add_proj4text (p, 2,
        "nits=us-ft +vunits=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Maryland (ftUS) + NAVD88 height (ftUS");
    add_srs_wkt (p, 1,
        ")\",PROJCS[\"NAD83 / Maryland (ftUS)\",GEOGCS[\"NAD83\",");
    add_srs_wkt (p, 2,
        "DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 3,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 7,
        "69\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"latitude_of_origin\",37.6666666666667],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"central_meridian\",-77],PARAMETER[\"standard_parallel_");
    add_srs_wkt (p, 10,
        "1\",39.45],PARAMETER[\"standard_parallel_2\",38.3],PARAM");
    add_srs_wkt (p, 11,
        "ETER[\"false_easting\",1312333.333],PARAMETER[\"false_no");
    add_srs_wkt (p, 12,
        "rthing\",0],UNIT[\"US survey foot\",0.304800609601219,AU");
    add_srs_wkt (p, 13,
        "THORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 14,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2248\"]],VERT_C");
    add_srs_wkt (p, 15,
        "S[\"NAVD88 height (ftUS)\",VERT_DATUM[\"North American V");
    add_srs_wkt (p, 16,
        "ertical Datum 1988\",2005,AUTHORITY[\"EPSG\",\"5103\"]],");
    add_srs_wkt (p, 17,
        "UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"EP");
    add_srs_wkt (p, 18,
        "SG\",\"9003\"]],AXIS[\"Gravity-related height\",UP],AUTH");
    add_srs_wkt (p, 19,
        "ORITY[\"EPSG\",\"6360\"]],AUTHORITY[\"EPSG\",\"8747\"]]");
    p = add_epsg_def_ex (filter, first, last, 8748, "epsg", 8748,
        "NAD83 / Massachusetts Mainland (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=41 +lon_0=-71.5 +lat_1=42.6833333333333");
    add_proj4text (p, 1,
        " +lat_2=41.7166666666667 +x_0=200000.0001016 +y_0=750000");
    add_proj4text (p, 2,
        " +datum=NAD83 +units=us-ft +vunits=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Massachusetts Mainland (ftUS) + NAVD8");
    add_srs_wkt (p, 1,
        "8 height (ftUS)\",PROJCS[\"NAD83 / Massachusetts Mainlan");
    add_srs_wkt (p, 2,
        "d (ftUS)\",GEOGCS[\"NAD83\",DATUM[\"North_American_Datum");
    add_srs_wkt (p, 3,
        "_1983\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6269\"]],");
    add_srs_wkt (p, 5,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 6,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 7,
        "2\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert");
    add_srs_wkt (p, 8,
        "_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 9,
        ",41],PARAMETER[\"central_meridian\",-71.5],PARAMETER[\"s");
    add_srs_wkt (p, 10,
        "tandard_parallel_1\",42.6833333333333],PARAMETER[\"stand");
    add_srs_wkt (p, 11,
        "ard_parallel_2\",41.7166666666667],PARAMETER[\"false_eas");
    add_srs_wkt (p, 12,
        "ting\",656166.667],PARAMETER[\"false_northing\",2460625]");
    add_srs_wkt (p, 13,
        ",UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"E");
    add_srs_wkt (p, 14,
        "PSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 15,
        ",NORTH],AUTHORITY[\"EPSG\",\"2249\"]],VERT_CS[\"NAVD88 h");
    add_srs_wkt (p, 16,
        "eight (ftUS)\",VERT_DATUM[\"North American Vertical Datu");
    add_srs_wkt (p, 17,
        "m 1988\",2005,AUTHORITY[\"EPSG\",\"5103\"]],UNIT[\"US su");
    add_srs_wkt (p, 18,
        "rvey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"");
    add_srs_wkt (p, 19,
        "]],AXIS[\"Gravity-related height\",UP],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 20,
        ",\"6360\"]],AUTHORITY[\"EPSG\",\"8748\"]]");
    p = add_epsg_def_ex (filter, first, last, 8749, "epsg", 8749,
        "NAD83 / Massachusetts Island (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=41 +lon_0=-70.5 +lat_1=41.4833333333333");
    add_proj4text (p, 1,
        " +lat_2=41.2833333333333 +x_0=500000.0001016 +y_0=0 +dat");
    add_proj4text (p, 2,
        "um=NAD83 +units=us-ft +vunits=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Massachusetts Island (ftUS) + NAVD88 ");
    add_srs_wkt (p, 1,
        "height (ftUS)\",PROJCS[\"NAD83 / Massachusetts Island (f");
    add_srs_wkt (p, 2,
        "tUS)\",GEOGCS[\"NAD83\",DATUM[\"North_American_Datum_198");
    add_srs_wkt (p, 3,
        "3\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6269\"]],PRIM");
    add_srs_wkt (p, 5,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 6,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 8,
        "formal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",41]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"central_meridian\",-70.5],PARAMETER[\"stand");
    add_srs_wkt (p, 10,
        "ard_parallel_1\",41.4833333333333],PARAMETER[\"standard_");
    add_srs_wkt (p, 11,
        "parallel_2\",41.2833333333333],PARAMETER[\"false_easting");
    add_srs_wkt (p, 12,
        "\",1640416.667],PARAMETER[\"false_northing\",0],UNIT[\"U");
    add_srs_wkt (p, 13,
        "S survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 14,
        "003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],");
    add_srs_wkt (p, 15,
        "AUTHORITY[\"EPSG\",\"2250\"]],VERT_CS[\"NAVD88 height (f");
    add_srs_wkt (p, 16,
        "tUS)\",VERT_DATUM[\"North American Vertical Datum 1988\"");
    add_srs_wkt (p, 17,
        ",2005,AUTHORITY[\"EPSG\",\"5103\"]],UNIT[\"US survey foo");
    add_srs_wkt (p, 18,
        "t\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS");
    add_srs_wkt (p, 19,
        "[\"Gravity-related height\",UP],AUTHORITY[\"EPSG\",\"636");
    add_srs_wkt (p, 20,
        "0\"]],AUTHORITY[\"EPSG\",\"8749\"]]");
    p = add_epsg_def_ex (filter, first, last, 8750, "epsg", 8750,
        "NAD83 / Minnesota North (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=46.5 +lon_0=-93.1 +lat_1=48.63333333333");
    add_proj4text (p, 1,
        "33 +lat_2=47.0333333333333 +x_0=800000.00001016 +y_0=999");
    add_proj4text (p, 2,
        "99.99998984 +datum=NAD83 +units=us-ft +vunits=us-ft +no_");
    add_proj4text (p, 3,
        "defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Minnesota North (ftUS) + NAVD88 heigh");
    add_srs_wkt (p, 1,
        "t (ftUS)\",PROJCS[\"NAD83 / Minnesota North (ftUS)\",GEO");
    add_srs_wkt (p, 2,
        "GCS[\"NAD83\",DATUM[\"North_American_Datum_1983\",SPHERO");
    add_srs_wkt (p, 3,
        "ID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"7019\"]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 5,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 6,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 7,
        "Y[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Con");
    add_srs_wkt (p, 8,
        "ic_2SP\"],PARAMETER[\"latitude_of_origin\",46.5],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"central_meridian\",-93.1],PARAMETER[\"standard_para");
    add_srs_wkt (p, 10,
        "llel_1\",48.6333333333333],PARAMETER[\"standard_parallel");
    add_srs_wkt (p, 11,
        "_2\",47.0333333333333],PARAMETER[\"false_easting\",26246");
    add_srs_wkt (p, 12,
        "66.6667],PARAMETER[\"false_northing\",328083.3333],UNIT[");
    add_srs_wkt (p, 13,
        "\"US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 14,
        "\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 15,
        "H],AUTHORITY[\"EPSG\",\"26849\"]],VERT_CS[\"NAVD88 heigh");
    add_srs_wkt (p, 16,
        "t (ftUS)\",VERT_DATUM[\"North American Vertical Datum 19");
    add_srs_wkt (p, 17,
        "88\",2005,AUTHORITY[\"EPSG\",\"5103\"]],UNIT[\"US survey");
    add_srs_wkt (p, 18,
        " foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],");
    add_srs_wkt (p, 19,
        "AXIS[\"Gravity-related height\",UP],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 20,
        "6360\"]],AUTHORITY[\"EPSG\",\"8750\"]]");
    p = add_epsg_def_ex (filter, first, last, 8751, "epsg", 8751,
        "NAD83 / Minnesota Central (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=45 +lon_0=-94.25 +lat_1=47.05 +lat_2=45");
    add_proj4text (p, 1,
        ".6166666666667 +x_0=800000.00001016 +y_0=99999.99998984 ");
    add_proj4text (p, 2,
        "+datum=NAD83 +units=us-ft +vunits=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Minnesota Central (ftUS) + NAVD88 hei");
    add_srs_wkt (p, 1,
        "ght (ftUS)\",PROJCS[\"NAD83 / Minnesota Central (ftUS)\"");
    add_srs_wkt (p, 2,
        ",GEOGCS[\"NAD83\",DATUM[\"North_American_Datum_1983\",SP");
    add_srs_wkt (p, 3,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 4,
        "SG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"G");
    add_srs_wkt (p, 5,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 6,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal");
    add_srs_wkt (p, 8,
        "_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",45],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"central_meridian\",-94.25],PARAMETER[\"standard_p");
    add_srs_wkt (p, 10,
        "arallel_1\",47.05],PARAMETER[\"standard_parallel_2\",45.");
    add_srs_wkt (p, 11,
        "6166666666667],PARAMETER[\"false_easting\",2624666.6667]");
    add_srs_wkt (p, 12,
        ",PARAMETER[\"false_northing\",328083.3333],UNIT[\"US sur");
    add_srs_wkt (p, 13,
        "vey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"");
    add_srs_wkt (p, 14,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 15,
        "RITY[\"EPSG\",\"26850\"]],VERT_CS[\"NAVD88 height (ftUS)");
    add_srs_wkt (p, 16,
        "\",VERT_DATUM[\"North American Vertical Datum 1988\",200");
    add_srs_wkt (p, 17,
        "5,AUTHORITY[\"EPSG\",\"5103\"]],UNIT[\"US survey foot\",");
    add_srs_wkt (p, 18,
        "0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"G");
    add_srs_wkt (p, 19,
        "ravity-related height\",UP],AUTHORITY[\"EPSG\",\"6360\"]");
    add_srs_wkt (p, 20,
        "],AUTHORITY[\"EPSG\",\"8751\"]]");
    p = add_epsg_def_ex (filter, first, last, 8752, "epsg", 8752,
        "NAD83 / Minnesota South (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=43 +lon_0=-94 +lat_1=45.2166666666667 +");
    add_proj4text (p, 1,
        "lat_2=43.7833333333333 +x_0=800000.00001016 +y_0=99999.9");
    add_proj4text (p, 2,
        "9998984 +datum=NAD83 +units=us-ft +vunits=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Minnesota South (ftUS) + NAVD88 heigh");
    add_srs_wkt (p, 1,
        "t (ftUS)\",PROJCS[\"NAD83 / Minnesota South (ftUS)\",GEO");
    add_srs_wkt (p, 2,
        "GCS[\"NAD83\",DATUM[\"North_American_Datum_1983\",SPHERO");
    add_srs_wkt (p, 3,
        "ID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"7019\"]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 5,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 6,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 7,
        "Y[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Con");
    add_srs_wkt (p, 8,
        "ic_2SP\"],PARAMETER[\"latitude_of_origin\",43],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"central_meridian\",-94],PARAMETER[\"standard_parallel");
    add_srs_wkt (p, 10,
        "_1\",45.2166666666667],PARAMETER[\"standard_parallel_2\"");
    add_srs_wkt (p, 11,
        ",43.7833333333333],PARAMETER[\"false_easting\",2624666.6");
    add_srs_wkt (p, 12,
        "667],PARAMETER[\"false_northing\",328083.3333],UNIT[\"US");
    add_srs_wkt (p, 13,
        " survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 14,
        "03\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 15,
        "UTHORITY[\"EPSG\",\"26851\"]],VERT_CS[\"NAVD88 height (f");
    add_srs_wkt (p, 16,
        "tUS)\",VERT_DATUM[\"North American Vertical Datum 1988\"");
    add_srs_wkt (p, 17,
        ",2005,AUTHORITY[\"EPSG\",\"5103\"]],UNIT[\"US survey foo");
    add_srs_wkt (p, 18,
        "t\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS");
    add_srs_wkt (p, 19,
        "[\"Gravity-related height\",UP],AUTHORITY[\"EPSG\",\"636");
    add_srs_wkt (p, 20,
        "0\"]],AUTHORITY[\"EPSG\",\"8752\"]]");
    p = add_epsg_def_ex (filter, first, last, 8753, "epsg", 8753,
        "NAD83 / Mississippi East (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=29.5 +lon_0=-88.8333333333333 +k=0.99");
    add_proj4text (p, 1,
        "995 +x_0=300000 +y_0=0 +datum=NAD83 +units=us-ft +vunits");
    add_proj4text (p, 2,
        "=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Mississippi East (ftUS) + NAVD88 heig");
    add_srs_wkt (p, 1,
        "ht (ftUS)\",PROJCS[\"NAD83 / Mississippi East (ftUS)\",G");
    add_srs_wkt (p, 2,
        "EOGCS[\"NAD83\",DATUM[\"North_American_Datum_1983\",SPHE");
    add_srs_wkt (p, 3,
        "ROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"7019\"]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gre");
    add_srs_wkt (p, 5,
        "enwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 6,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 7,
        "ITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 8,
        "\"],PARAMETER[\"latitude_of_origin\",29.5],PARAMETER[\"c");
    add_srs_wkt (p, 9,
        "entral_meridian\",-88.8333333333333],PARAMETER[\"scale_f");
    add_srs_wkt (p, 10,
        "actor\",0.99995],PARAMETER[\"false_easting\",984250],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",0],UNIT[\"US survey foot\",0.3");
    add_srs_wkt (p, 12,
        "04800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"East");
    add_srs_wkt (p, 13,
        "ing\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 14,
        "\"2254\"]],VERT_CS[\"NAVD88 height (ftUS)\",VERT_DATUM[\"");
    add_srs_wkt (p, 15,
        "North American Vertical Datum 1988\",2005,AUTHORITY[\"EP");
    add_srs_wkt (p, 16,
        "SG\",\"5103\"]],UNIT[\"US survey foot\",0.30480060960121");
    add_srs_wkt (p, 17,
        "9,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Gravity-related h");
    add_srs_wkt (p, 18,
        "eight\",UP],AUTHORITY[\"EPSG\",\"6360\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 19,
        "SG\",\"8753\"]]");
    p = add_epsg_def_ex (filter, first, last, 8754, "epsg", 8754,
        "NAD83 / Mississippi West (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=29.5 +lon_0=-90.3333333333333 +k=0.99");
    add_proj4text (p, 1,
        "995 +x_0=699999.9998984 +y_0=0 +datum=NAD83 +units=us-ft");
    add_proj4text (p, 2,
        " +vunits=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Mississippi West (ftUS) + NAVD88 heig");
    add_srs_wkt (p, 1,
        "ht (ftUS)\",PROJCS[\"NAD83 / Mississippi West (ftUS)\",G");
    add_srs_wkt (p, 2,
        "EOGCS[\"NAD83\",DATUM[\"North_American_Datum_1983\",SPHE");
    add_srs_wkt (p, 3,
        "ROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"7019\"]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gre");
    add_srs_wkt (p, 5,
        "enwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 6,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 7,
        "ITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 8,
        "\"],PARAMETER[\"latitude_of_origin\",29.5],PARAMETER[\"c");
    add_srs_wkt (p, 9,
        "entral_meridian\",-90.3333333333333],PARAMETER[\"scale_f");
    add_srs_wkt (p, 10,
        "actor\",0.99995],PARAMETER[\"false_easting\",2296583.333");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_northing\",0],UNIT[\"US survey foot\"");
    add_srs_wkt (p, 12,
        ",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"");
    add_srs_wkt (p, 13,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 14,
        "G\",\"2255\"]],VERT_CS[\"NAVD88 height (ftUS)\",VERT_DAT");
    add_srs_wkt (p, 15,
        "UM[\"North American Vertical Datum 1988\",2005,AUTHORITY");
    add_srs_wkt (p, 16,
        "[\"EPSG\",\"5103\"]],UNIT[\"US survey foot\",0.304800609");
    add_srs_wkt (p, 17,
        "601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Gravity-rela");
    add_srs_wkt (p, 18,
        "ted height\",UP],AUTHORITY[\"EPSG\",\"6360\"]],AUTHORITY");
    add_srs_wkt (p, 19,
        "[\"EPSG\",\"8754\"]]");
    p = add_epsg_def_ex (filter, first, last, 8755, "epsg", 8755,
        "NAD83 / Nebraska (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=39.8333333333333 +lon_0=-100 +lat_1=43 ");
    add_proj4text (p, 1,
        "+lat_2=40 +x_0=500000.00001016 +y_0=0 +datum=NAD83 +unit");
    add_proj4text (p, 2,
        "s=us-ft +vunits=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Nebraska (ftUS) + NAVD88 height (ftUS");
    add_srs_wkt (p, 1,
        ")\",PROJCS[\"NAD83 / Nebraska (ftUS)\",GEOGCS[\"NAD83\",");
    add_srs_wkt (p, 2,
        "DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 3,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 7,
        "69\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"latitude_of_origin\",39.8333333333333],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"central_meridian\",-100],PARAMETER[\"standard_parallel");
    add_srs_wkt (p, 10,
        "_1\",43],PARAMETER[\"standard_parallel_2\",40],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"false_easting\",1640416.6667],PARAMETER[\"false_north");
    add_srs_wkt (p, 12,
        "ing\",0],UNIT[\"US survey foot\",0.304800609601219,AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"N");
    add_srs_wkt (p, 14,
        "orthing\",NORTH],AUTHORITY[\"EPSG\",\"26852\"]],VERT_CS[");
    add_srs_wkt (p, 15,
        "\"NAVD88 height (ftUS)\",VERT_DATUM[\"North American Ver");
    add_srs_wkt (p, 16,
        "tical Datum 1988\",2005,AUTHORITY[\"EPSG\",\"5103\"]],UN");
    add_srs_wkt (p, 17,
        "IT[\"US survey foot\",0.304800609601219,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 18,
        "\",\"9003\"]],AXIS[\"Gravity-related height\",UP],AUTHOR");
    add_srs_wkt (p, 19,
        "ITY[\"EPSG\",\"6360\"]],AUTHORITY[\"EPSG\",\"8755\"]]");
    p = add_epsg_def_ex (filter, first, last, 8756, "epsg", 8756,
        "NAD83 / Nevada East (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=34.75 +lon_0=-115.583333333333 +k=0.9");
    add_proj4text (p, 1,
        "999 +x_0=200000.00001016 +y_0=8000000.00001016 +datum=NA");
    add_proj4text (p, 2,
        "D83 +units=us-ft +vunits=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Nevada East (ftUS) + NAVD88 height (f");
    add_srs_wkt (p, 1,
        "tUS)\",PROJCS[\"NAD83 / Nevada East (ftUS)\",GEOGCS[\"NA");
    add_srs_wkt (p, 2,
        "D83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS");
    add_srs_wkt (p, 3,
        " 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 4,
        "]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 6,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"latitude_of_origin\",34.75],PARAMETER[\"central_meri");
    add_srs_wkt (p, 9,
        "dian\",-115.583333333333],PARAMETER[\"scale_factor\",0.9");
    add_srs_wkt (p, 10,
        "999],PARAMETER[\"false_easting\",656166.6667],PARAMETER[");
    add_srs_wkt (p, 11,
        "\"false_northing\",26246666.6667],UNIT[\"US survey foot\"");
    add_srs_wkt (p, 12,
        ",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"");
    add_srs_wkt (p, 13,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 14,
        "G\",\"3421\"]],VERT_CS[\"NAVD88 height (ftUS)\",VERT_DAT");
    add_srs_wkt (p, 15,
        "UM[\"North American Vertical Datum 1988\",2005,AUTHORITY");
    add_srs_wkt (p, 16,
        "[\"EPSG\",\"5103\"]],UNIT[\"US survey foot\",0.304800609");
    add_srs_wkt (p, 17,
        "601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Gravity-rela");
    add_srs_wkt (p, 18,
        "ted height\",UP],AUTHORITY[\"EPSG\",\"6360\"]],AUTHORITY");
    add_srs_wkt (p, 19,
        "[\"EPSG\",\"8756\"]]");
    p = add_epsg_def_ex (filter, first, last, 8757, "epsg", 8757,
        "NAD83 / Nevada Central (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=34.75 +lon_0=-116.666666666667 +k=0.9");
    add_proj4text (p, 1,
        "999 +x_0=500000.00001016 +y_0=6000000 +datum=NAD83 +unit");
    add_proj4text (p, 2,
        "s=us-ft +vunits=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Nevada Central (ftUS) + NAVD88 height");
    add_srs_wkt (p, 1,
        " (ftUS)\",PROJCS[\"NAD83 / Nevada Central (ftUS)\",GEOGC");
    add_srs_wkt (p, 2,
        "S[\"NAD83\",DATUM[\"North_American_Datum_1983\",SPHEROID");
    add_srs_wkt (p, 3,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "7019\"]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 5,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 6,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 7,
        "EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"latitude_of_origin\",34.75],PARAMETER[\"centra");
    add_srs_wkt (p, 9,
        "l_meridian\",-116.666666666667],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 10,
        "\",0.9999],PARAMETER[\"false_easting\",1640416.6667],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",19685000],UNIT[\"US survey foo");
    add_srs_wkt (p, 12,
        "t\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS");
    add_srs_wkt (p, 13,
        "[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 14,
        "EPSG\",\"3422\"]],VERT_CS[\"NAVD88 height (ftUS)\",VERT_");
    add_srs_wkt (p, 15,
        "DATUM[\"North American Vertical Datum 1988\",2005,AUTHOR");
    add_srs_wkt (p, 16,
        "ITY[\"EPSG\",\"5103\"]],UNIT[\"US survey foot\",0.304800");
    add_srs_wkt (p, 17,
        "609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Gravity-r");
    add_srs_wkt (p, 18,
        "elated height\",UP],AUTHORITY[\"EPSG\",\"6360\"]],AUTHOR");
    add_srs_wkt (p, 19,
        "ITY[\"EPSG\",\"8757\"]]");
    p = add_epsg_def_ex (filter, first, last, 8758, "epsg", 8758,
        "NAD83 / Nevada West (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=34.75 +lon_0=-118.583333333333 +k=0.9");
    add_proj4text (p, 1,
        "999 +x_0=800000.00001016 +y_0=3999999.99998984 +datum=NA");
    add_proj4text (p, 2,
        "D83 +units=us-ft +vunits=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Nevada West (ftUS) + NAVD88 height (f");
    add_srs_wkt (p, 1,
        "tUS)\",PROJCS[\"NAD83 / Nevada West (ftUS)\",GEOGCS[\"NA");
    add_srs_wkt (p, 2,
        "D83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS");
    add_srs_wkt (p, 3,
        " 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 4,
        "]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 6,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"latitude_of_origin\",34.75],PARAMETER[\"central_meri");
    add_srs_wkt (p, 9,
        "dian\",-118.583333333333],PARAMETER[\"scale_factor\",0.9");
    add_srs_wkt (p, 10,
        "999],PARAMETER[\"false_easting\",2624666.6667],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"false_northing\",13123333.3333],UNIT[\"US survey foot");
    add_srs_wkt (p, 12,
        "\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[");
    add_srs_wkt (p, 13,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 14,
        "PSG\",\"3423\"]],VERT_CS[\"NAVD88 height (ftUS)\",VERT_D");
    add_srs_wkt (p, 15,
        "ATUM[\"North American Vertical Datum 1988\",2005,AUTHORI");
    add_srs_wkt (p, 16,
        "TY[\"EPSG\",\"5103\"]],UNIT[\"US survey foot\",0.3048006");
    add_srs_wkt (p, 17,
        "09601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Gravity-re");
    add_srs_wkt (p, 18,
        "lated height\",UP],AUTHORITY[\"EPSG\",\"6360\"]],AUTHORI");
    add_srs_wkt (p, 19,
        "TY[\"EPSG\",\"8758\"]]");
    p = add_epsg_def_ex (filter, first, last, 8759, "epsg", 8759,
        "NAD83 / New Hampshire (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.5 +lon_0=-71.6666666666667 +k=0.99");
    add_proj4text (p, 1,
        "9966667 +x_0=300000 +y_0=0 +datum=NAD83 +units=us-ft +vu");
    add_proj4text (p, 2,
        "nits=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / New Hampshire (ftUS) + NAVD88 height ");
    add_srs_wkt (p, 1,
        "(ftUS)\",PROJCS[\"NAD83 / New Hampshire (ftUS)\",GEOGCS[");
    add_srs_wkt (p, 2,
        "\"NAD83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"");
    add_srs_wkt (p, 3,
        "GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 4,
        "19\"]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 5,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 6,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 7,
        "SG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 8,
        "METER[\"latitude_of_origin\",42.5],PARAMETER[\"central_m");
    add_srs_wkt (p, 9,
        "eridian\",-71.6666666666667],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 10,
        "0.999966667],PARAMETER[\"false_easting\",984250],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_northing\",0],UNIT[\"US survey foot\",0.30480");
    add_srs_wkt (p, 12,
        "0609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 13,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"343");
    add_srs_wkt (p, 14,
        "7\"]],VERT_CS[\"NAVD88 height (ftUS)\",VERT_DATUM[\"Nort");
    add_srs_wkt (p, 15,
        "h American Vertical Datum 1988\",2005,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 16,
        ",\"5103\"]],UNIT[\"US survey foot\",0.304800609601219,AU");
    add_srs_wkt (p, 17,
        "THORITY[\"EPSG\",\"9003\"]],AXIS[\"Gravity-related heigh");
    add_srs_wkt (p, 18,
        "t\",UP],AUTHORITY[\"EPSG\",\"6360\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 19,
        ",\"8759\"]]");
    p = add_epsg_def_ex (filter, first, last, 8760, "epsg", 8760,
        "NAD83 / New Jersey (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38.8333333333333 +lon_0=-74.5 +k=0.99");
    add_proj4text (p, 1,
        "99 +x_0=150000 +y_0=0 +datum=NAD83 +units=us-ft +vunits=");
    add_proj4text (p, 2,
        "us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / New Jersey (ftUS) + NAVD88 height (ft");
    add_srs_wkt (p, 1,
        "US)\",PROJCS[\"NAD83 / New Jersey (ftUS)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 2,
        "3\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 3,
        "980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]");
    add_srs_wkt (p, 4,
        "],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 6,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"latitude_of_origin\",38.8333333333333],PARAMETER[\"c");
    add_srs_wkt (p, 9,
        "entral_meridian\",-74.5],PARAMETER[\"scale_factor\",0.99");
    add_srs_wkt (p, 10,
        "99],PARAMETER[\"false_easting\",492125],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_northing\",0],UNIT[\"US survey foot\",0.30480060960121");
    add_srs_wkt (p, 12,
        "9,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 13,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3424\"]],VE");
    add_srs_wkt (p, 14,
        "RT_CS[\"NAVD88 height (ftUS)\",VERT_DATUM[\"North Americ");
    add_srs_wkt (p, 15,
        "an Vertical Datum 1988\",2005,AUTHORITY[\"EPSG\",\"5103\"");
    add_srs_wkt (p, 16,
        "]],UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"");
    add_srs_wkt (p, 17,
        "EPSG\",\"9003\"]],AXIS[\"Gravity-related height\",UP],AU");
    add_srs_wkt (p, 18,
        "THORITY[\"EPSG\",\"6360\"]],AUTHORITY[\"EPSG\",\"8760\"]");
    add_srs_wkt (p, 19,
        "]");
    p = add_epsg_def_ex (filter, first, last, 8761, "epsg", 8761,
        "NAD83 / New Mexico East (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31 +lon_0=-104.333333333333 +k=0.9999");
    add_proj4text (p, 1,
        "09091 +x_0=165000 +y_0=0 +datum=NAD83 +units=us-ft +vuni");
    add_proj4text (p, 2,
        "ts=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / New Mexico East (ftUS) + NAVD88 heigh");
    add_srs_wkt (p, 1,
        "t (ftUS)\",PROJCS[\"NAD83 / New Mexico East (ftUS)\",GEO");
    add_srs_wkt (p, 2,
        "GCS[\"NAD83\",DATUM[\"North_American_Datum_1983\",SPHERO");
    add_srs_wkt (p, 3,
        "ID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"7019\"]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 5,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 6,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 7,
        "Y[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"latitude_of_origin\",31],PARAMETER[\"centr");
    add_srs_wkt (p, 9,
        "al_meridian\",-104.333333333333],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 10,
        "r\",0.999909091],PARAMETER[\"false_easting\",541337.5],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_northing\",0],UNIT[\"US survey foot\",0");
    add_srs_wkt (p, 12,
        ".304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Ea");
    add_srs_wkt (p, 13,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 14,
        ",\"2257\"]],VERT_CS[\"NAVD88 height (ftUS)\",VERT_DATUM[");
    add_srs_wkt (p, 15,
        "\"North American Vertical Datum 1988\",2005,AUTHORITY[\"");
    add_srs_wkt (p, 16,
        "EPSG\",\"5103\"]],UNIT[\"US survey foot\",0.304800609601");
    add_srs_wkt (p, 17,
        "219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Gravity-related");
    add_srs_wkt (p, 18,
        " height\",UP],AUTHORITY[\"EPSG\",\"6360\"]],AUTHORITY[\"");
    add_srs_wkt (p, 19,
        "EPSG\",\"8761\"]]");
    p = add_epsg_def_ex (filter, first, last, 8762, "epsg", 8762,
        "NAD83 / New Mexico Central (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31 +lon_0=-106.25 +k=0.9999 +x_0=5000");
    add_proj4text (p, 1,
        "00.0001016 +y_0=0 +datum=NAD83 +units=us-ft +vunits=us-f");
    add_proj4text (p, 2,
        "t +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / New Mexico Central (ftUS) + NAVD88 he");
    add_srs_wkt (p, 1,
        "ight (ftUS)\",PROJCS[\"NAD83 / New Mexico Central (ftUS)");
    add_srs_wkt (p, 2,
        "\",GEOGCS[\"NAD83\",DATUM[\"North_American_Datum_1983\",");
    add_srs_wkt (p, 3,
        "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"");
    add_srs_wkt (p, 5,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 6,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 7,
        "HORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 8,
        "tor\"],PARAMETER[\"latitude_of_origin\",31],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "central_meridian\",-106.25],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 10,
        ".9999],PARAMETER[\"false_easting\",1640416.667],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_northing\",0],UNIT[\"US survey foot\",0.304800");
    add_srs_wkt (p, 12,
        "609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 13,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"225");
    add_srs_wkt (p, 14,
        "8\"]],VERT_CS[\"NAVD88 height (ftUS)\",VERT_DATUM[\"Nort");
    add_srs_wkt (p, 15,
        "h American Vertical Datum 1988\",2005,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 16,
        ",\"5103\"]],UNIT[\"US survey foot\",0.304800609601219,AU");
    add_srs_wkt (p, 17,
        "THORITY[\"EPSG\",\"9003\"]],AXIS[\"Gravity-related heigh");
    add_srs_wkt (p, 18,
        "t\",UP],AUTHORITY[\"EPSG\",\"6360\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 19,
        ",\"8762\"]]");
    p = add_epsg_def_ex (filter, first, last, 8763, "epsg", 8763,
        "NAD83 / New Mexico West (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31 +lon_0=-107.833333333333 +k=0.9999");
    add_proj4text (p, 1,
        "16667 +x_0=830000.0001016 +y_0=0 +datum=NAD83 +units=us-");
    add_proj4text (p, 2,
        "ft +vunits=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / New Mexico West (ftUS) + NAVD88 heigh");
    add_srs_wkt (p, 1,
        "t (ftUS)\",PROJCS[\"NAD83 / New Mexico West (ftUS)\",GEO");
    add_srs_wkt (p, 2,
        "GCS[\"NAD83\",DATUM[\"North_American_Datum_1983\",SPHERO");
    add_srs_wkt (p, 3,
        "ID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"7019\"]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 5,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 6,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 7,
        "Y[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"latitude_of_origin\",31],PARAMETER[\"centr");
    add_srs_wkt (p, 9,
        "al_meridian\",-107.833333333333],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 10,
        "r\",0.999916667],PARAMETER[\"false_easting\",2723091.667");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_northing\",0],UNIT[\"US survey foot\"");
    add_srs_wkt (p, 12,
        ",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"");
    add_srs_wkt (p, 13,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 14,
        "G\",\"2259\"]],VERT_CS[\"NAVD88 height (ftUS)\",VERT_DAT");
    add_srs_wkt (p, 15,
        "UM[\"North American Vertical Datum 1988\",2005,AUTHORITY");
    add_srs_wkt (p, 16,
        "[\"EPSG\",\"5103\"]],UNIT[\"US survey foot\",0.304800609");
    add_srs_wkt (p, 17,
        "601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Gravity-rela");
    add_srs_wkt (p, 18,
        "ted height\",UP],AUTHORITY[\"EPSG\",\"6360\"]],AUTHORITY");
    add_srs_wkt (p, 19,
        "[\"EPSG\",\"8763\"]]");
    p = add_epsg_def_ex (filter, first, last, 8764, "epsg", 8764,
        "NAD83 / New York East (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38.8333333333333 +lon_0=-74.5 +k=0.99");
    add_proj4text (p, 1,
        "99 +x_0=150000 +y_0=0 +datum=NAD83 +units=us-ft +vunits=");
    add_proj4text (p, 2,
        "us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / New York East (ftUS) + NAVD88 height ");
    add_srs_wkt (p, 1,
        "(ftUS)\",PROJCS[\"NAD83 / New York East (ftUS)\",GEOGCS[");
    add_srs_wkt (p, 2,
        "\"NAD83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"");
    add_srs_wkt (p, 3,
        "GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 4,
        "19\"]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 5,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 6,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 7,
        "SG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 8,
        "METER[\"latitude_of_origin\",38.8333333333333],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"central_meridian\",-74.5],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 10,
        "0.9999],PARAMETER[\"false_easting\",492125],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",0],UNIT[\"US survey foot\",0.3048006096");
    add_srs_wkt (p, 12,
        "01219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 13,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2260\"]");
    add_srs_wkt (p, 14,
        "],VERT_CS[\"NAVD88 height (ftUS)\",VERT_DATUM[\"North Am");
    add_srs_wkt (p, 15,
        "erican Vertical Datum 1988\",2005,AUTHORITY[\"EPSG\",\"5");
    add_srs_wkt (p, 16,
        "103\"]],UNIT[\"US survey foot\",0.304800609601219,AUTHOR");
    add_srs_wkt (p, 17,
        "ITY[\"EPSG\",\"9003\"]],AXIS[\"Gravity-related height\",");
    add_srs_wkt (p, 18,
        "UP],AUTHORITY[\"EPSG\",\"6360\"]],AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 19,
        "764\"]]");
    p = add_epsg_def_ex (filter, first, last, 8765, "epsg", 8765,
        "NAD83 / New York Central (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40 +lon_0=-76.5833333333333 +k=0.9999");
    add_proj4text (p, 1,
        "375 +x_0=249999.9998984 +y_0=0 +datum=NAD83 +units=us-ft");
    add_proj4text (p, 2,
        " +vunits=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / New York Central (ftUS) + NAVD88 heig");
    add_srs_wkt (p, 1,
        "ht (ftUS)\",PROJCS[\"NAD83 / New York Central (ftUS)\",G");
    add_srs_wkt (p, 2,
        "EOGCS[\"NAD83\",DATUM[\"North_American_Datum_1983\",SPHE");
    add_srs_wkt (p, 3,
        "ROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"7019\"]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gre");
    add_srs_wkt (p, 5,
        "enwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 6,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 7,
        "ITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 8,
        "\"],PARAMETER[\"latitude_of_origin\",40],PARAMETER[\"cen");
    add_srs_wkt (p, 9,
        "tral_meridian\",-76.5833333333333],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 10,
        "tor\",0.9999375],PARAMETER[\"false_easting\",820208.333]");
    add_srs_wkt (p, 11,
        ",PARAMETER[\"false_northing\",0],UNIT[\"US survey foot\"");
    add_srs_wkt (p, 12,
        ",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"");
    add_srs_wkt (p, 13,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 14,
        "G\",\"2261\"]],VERT_CS[\"NAVD88 height (ftUS)\",VERT_DAT");
    add_srs_wkt (p, 15,
        "UM[\"North American Vertical Datum 1988\",2005,AUTHORITY");
    add_srs_wkt (p, 16,
        "[\"EPSG\",\"5103\"]],UNIT[\"US survey foot\",0.304800609");
    add_srs_wkt (p, 17,
        "601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Gravity-rela");
    add_srs_wkt (p, 18,
        "ted height\",UP],AUTHORITY[\"EPSG\",\"6360\"]],AUTHORITY");
    add_srs_wkt (p, 19,
        "[\"EPSG\",\"8765\"]]");
    p = add_epsg_def_ex (filter, first, last, 8766, "epsg", 8766,
        "NAD83 / New York West (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40 +lon_0=-78.5833333333333 +k=0.9999");
    add_proj4text (p, 1,
        "375 +x_0=350000.0001016 +y_0=0 +datum=NAD83 +units=us-ft");
    add_proj4text (p, 2,
        " +vunits=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / New York West (ftUS) + NAVD88 height ");
    add_srs_wkt (p, 1,
        "(ftUS)\",PROJCS[\"NAD83 / New York West (ftUS)\",GEOGCS[");
    add_srs_wkt (p, 2,
        "\"NAD83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"");
    add_srs_wkt (p, 3,
        "GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 4,
        "19\"]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 5,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 6,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 7,
        "SG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 8,
        "METER[\"latitude_of_origin\",40],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",-78.5833333333333],PARAMETER[\"scale_factor\",0.");
    add_srs_wkt (p, 10,
        "9999375],PARAMETER[\"false_easting\",1148291.667],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_northing\",0],UNIT[\"US survey foot\",0.3048");
    add_srs_wkt (p, 12,
        "00609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting");
    add_srs_wkt (p, 13,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2");
    add_srs_wkt (p, 14,
        "262\"]],VERT_CS[\"NAVD88 height (ftUS)\",VERT_DATUM[\"No");
    add_srs_wkt (p, 15,
        "rth American Vertical Datum 1988\",2005,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 16,
        "\",\"5103\"]],UNIT[\"US survey foot\",0.304800609601219,");
    add_srs_wkt (p, 17,
        "AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Gravity-related hei");
    add_srs_wkt (p, 18,
        "ght\",UP],AUTHORITY[\"EPSG\",\"6360\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 19,
        "\",\"8766\"]]");
    p = add_epsg_def_ex (filter, first, last, 8767, "epsg", 8767,
        "NAD83 / New York Long Island (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=40.1666666666667 +lon_0=-74 +lat_1=41.0");
    add_proj4text (p, 1,
        "333333333333 +lat_2=40.6666666666667 +x_0=300000 +y_0=0 ");
    add_proj4text (p, 2,
        "+datum=NAD83 +units=us-ft +vunits=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / New York Long Island (ftUS) + NAVD88 ");
    add_srs_wkt (p, 1,
        "height (ftUS)\",PROJCS[\"NAD83 / New York Long Island (f");
    add_srs_wkt (p, 2,
        "tUS)\",GEOGCS[\"NAD83\",DATUM[\"North_American_Datum_198");
    add_srs_wkt (p, 3,
        "3\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6269\"]],PRIM");
    add_srs_wkt (p, 5,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 6,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 8,
        "formal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",40.");
    add_srs_wkt (p, 9,
        "1666666666667],PARAMETER[\"central_meridian\",-74],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"standard_parallel_1\",41.0333333333333],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"standard_parallel_2\",40.6666666666667],PARAMETER[\"f");
    add_srs_wkt (p, 12,
        "alse_easting\",984250],PARAMETER[\"false_northing\",0],U");
    add_srs_wkt (p, 13,
        "NIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"EPS");
    add_srs_wkt (p, 14,
        "G\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",");
    add_srs_wkt (p, 15,
        "NORTH],AUTHORITY[\"EPSG\",\"2263\"]],VERT_CS[\"NAVD88 he");
    add_srs_wkt (p, 16,
        "ight (ftUS)\",VERT_DATUM[\"North American Vertical Datum");
    add_srs_wkt (p, 17,
        " 1988\",2005,AUTHORITY[\"EPSG\",\"5103\"]],UNIT[\"US sur");
    add_srs_wkt (p, 18,
        "vey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"");
    add_srs_wkt (p, 19,
        "]],AXIS[\"Gravity-related height\",UP],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 20,
        ",\"6360\"]],AUTHORITY[\"EPSG\",\"8767\"]]");
    p = add_epsg_def_ex (filter, first, last, 8768, "epsg", 8768,
        "NAD83 / North Carolina (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=33.75 +lon_0=-79 +lat_1=36.166666666666");
    add_proj4text (p, 1,
        "7 +lat_2=34.3333333333333 +x_0=609601.219202438 +y_0=0 +");
    add_proj4text (p, 2,
        "datum=NAD83 +units=us-ft +vunits=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / North Carolina (ftUS) + NAVD88 height");
    add_srs_wkt (p, 1,
        " (ftUS)\",PROJCS[\"NAD83 / North Carolina (ftUS)\",GEOGC");
    add_srs_wkt (p, 2,
        "S[\"NAD83\",DATUM[\"North_American_Datum_1983\",SPHEROID");
    add_srs_wkt (p, 3,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "7019\"]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 5,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 6,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 7,
        "EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Conic_2");
    add_srs_wkt (p, 8,
        "SP\"],PARAMETER[\"latitude_of_origin\",33.75],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"central_meridian\",-79],PARAMETER[\"standard_parallel_");
    add_srs_wkt (p, 10,
        "1\",36.1666666666667],PARAMETER[\"standard_parallel_2\",");
    add_srs_wkt (p, 11,
        "34.3333333333333],PARAMETER[\"false_easting\",2000000],P");
    add_srs_wkt (p, 12,
        "ARAMETER[\"false_northing\",0],UNIT[\"US survey foot\",0");
    add_srs_wkt (p, 13,
        ".304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Ea");
    add_srs_wkt (p, 14,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 15,
        ",\"2264\"]],VERT_CS[\"NAVD88 height (ftUS)\",VERT_DATUM[");
    add_srs_wkt (p, 16,
        "\"North American Vertical Datum 1988\",2005,AUTHORITY[\"");
    add_srs_wkt (p, 17,
        "EPSG\",\"5103\"]],UNIT[\"US survey foot\",0.304800609601");
    add_srs_wkt (p, 18,
        "219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Gravity-related");
    add_srs_wkt (p, 19,
        " height\",UP],AUTHORITY[\"EPSG\",\"6360\"]],AUTHORITY[\"");
    add_srs_wkt (p, 20,
        "EPSG\",\"8768\"]]");
    p = add_epsg_def_ex (filter, first, last, 8769, "epsg", 8769,
        "NAD83 / Ohio North (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=39.6666666666667 +lon_0=-82.5 +lat_1=41");
    add_proj4text (p, 1,
        ".7 +lat_2=40.4333333333333 +x_0=600000 +y_0=0 +datum=NAD");
    add_proj4text (p, 2,
        "83 +units=us-ft +vunits=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Ohio North (ftUS) + NAVD88 height (ft");
    add_srs_wkt (p, 1,
        "US)\",PROJCS[\"NAD83 / Ohio North (ftUS)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 2,
        "3\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 3,
        "980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]");
    add_srs_wkt (p, 4,
        "],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 6,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4269\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"latitude_of_origin\",39.6666666666667],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"central_meridian\",-82.5],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 10,
        "rallel_1\",41.7],PARAMETER[\"standard_parallel_2\",40.43");
    add_srs_wkt (p, 11,
        "33333333333],PARAMETER[\"false_easting\",1968500],PARAME");
    add_srs_wkt (p, 12,
        "TER[\"false_northing\",0],UNIT[\"US survey foot\",0.3048");
    add_srs_wkt (p, 13,
        "00609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting");
    add_srs_wkt (p, 14,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 15,
        "734\"]],VERT_CS[\"NAVD88 height (ftUS)\",VERT_DATUM[\"No");
    add_srs_wkt (p, 16,
        "rth American Vertical Datum 1988\",2005,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 17,
        "\",\"5103\"]],UNIT[\"US survey foot\",0.304800609601219,");
    add_srs_wkt (p, 18,
        "AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Gravity-related hei");
    add_srs_wkt (p, 19,
        "ght\",UP],AUTHORITY[\"EPSG\",\"6360\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 20,
        "\",\"8769\"]]");
    p = add_epsg_def_ex (filter, first, last, 8770, "epsg", 8770,
        "NAD83 / Ohio South (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=38 +lon_0=-82.5 +lat_1=40.0333333333333");
    add_proj4text (p, 1,
        " +lat_2=38.7333333333333 +x_0=600000 +y_0=0 +datum=NAD83");
    add_proj4text (p, 2,
        " +units=us-ft +vunits=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Ohio South (ftUS) + NAVD88 height (ft");
    add_srs_wkt (p, 1,
        "US)\",PROJCS[\"NAD83 / Ohio South (ftUS)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 2,
        "3\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 3,
        "980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]");
    add_srs_wkt (p, 4,
        "],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 6,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4269\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"latitude_of_origin\",38],PARAMETER[\"central");
    add_srs_wkt (p, 9,
        "_meridian\",-82.5],PARAMETER[\"standard_parallel_1\",40.");
    add_srs_wkt (p, 10,
        "0333333333333],PARAMETER[\"standard_parallel_2\",38.7333");
    add_srs_wkt (p, 11,
        "333333333],PARAMETER[\"false_easting\",1968500],PARAMETE");
    add_srs_wkt (p, 12,
        "R[\"false_northing\",0],UNIT[\"US survey foot\",0.304800");
    add_srs_wkt (p, 13,
        "609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 14,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"373");
    add_srs_wkt (p, 15,
        "5\"]],VERT_CS[\"NAVD88 height (ftUS)\",VERT_DATUM[\"Nort");
    add_srs_wkt (p, 16,
        "h American Vertical Datum 1988\",2005,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 17,
        ",\"5103\"]],UNIT[\"US survey foot\",0.304800609601219,AU");
    add_srs_wkt (p, 18,
        "THORITY[\"EPSG\",\"9003\"]],AXIS[\"Gravity-related heigh");
    add_srs_wkt (p, 19,
        "t\",UP],AUTHORITY[\"EPSG\",\"6360\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 20,
        ",\"8770\"]]");
    p = add_epsg_def_ex (filter, first, last, 8771, "epsg", 8771,
        "NAD83 / Oklahoma North (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=35 +lon_0=-98 +lat_1=36.7666666666667 +");
    add_proj4text (p, 1,
        "lat_2=35.5666666666667 +x_0=600000 +y_0=0 +datum=NAD83 +");
    add_proj4text (p, 2,
        "units=us-ft +vunits=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Oklahoma North (ftUS) + NAVD88 height");
    add_srs_wkt (p, 1,
        " (ftUS)\",PROJCS[\"NAD83 / Oklahoma North (ftUS)\",GEOGC");
    add_srs_wkt (p, 2,
        "S[\"NAD83\",DATUM[\"North_American_Datum_1983\",SPHEROID");
    add_srs_wkt (p, 3,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "7019\"]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 5,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 6,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 7,
        "EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Conic_2");
    add_srs_wkt (p, 8,
        "SP\"],PARAMETER[\"latitude_of_origin\",35],PARAMETER[\"c");
    add_srs_wkt (p, 9,
        "entral_meridian\",-98],PARAMETER[\"standard_parallel_1\"");
    add_srs_wkt (p, 10,
        ",36.7666666666667],PARAMETER[\"standard_parallel_2\",35.");
    add_srs_wkt (p, 11,
        "5666666666667],PARAMETER[\"false_easting\",1968500],PARA");
    add_srs_wkt (p, 12,
        "METER[\"false_northing\",0],UNIT[\"US survey foot\",0.30");
    add_srs_wkt (p, 13,
        "4800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easti");
    add_srs_wkt (p, 14,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 15,
        "2267\"]],VERT_CS[\"NAVD88 height (ftUS)\",VERT_DATUM[\"N");
    add_srs_wkt (p, 16,
        "orth American Vertical Datum 1988\",2005,AUTHORITY[\"EPS");
    add_srs_wkt (p, 17,
        "G\",\"5103\"]],UNIT[\"US survey foot\",0.304800609601219");
    add_srs_wkt (p, 18,
        ",AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Gravity-related he");
    add_srs_wkt (p, 19,
        "ight\",UP],AUTHORITY[\"EPSG\",\"6360\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 20,
        "G\",\"8771\"]]");
    p = add_epsg_def_ex (filter, first, last, 8772, "epsg", 8772,
        "NAD83 / Oklahoma South (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=33.3333333333333 +lon_0=-98 +lat_1=35.2");
    add_proj4text (p, 1,
        "333333333333 +lat_2=33.9333333333333 +x_0=600000 +y_0=0 ");
    add_proj4text (p, 2,
        "+datum=NAD83 +units=us-ft +vunits=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Oklahoma South (ftUS) + NAVD88 height");
    add_srs_wkt (p, 1,
        " (ftUS)\",PROJCS[\"NAD83 / Oklahoma South (ftUS)\",GEOGC");
    add_srs_wkt (p, 2,
        "S[\"NAD83\",DATUM[\"North_American_Datum_1983\",SPHEROID");
    add_srs_wkt (p, 3,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "7019\"]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 5,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 6,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 7,
        "EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Conic_2");
    add_srs_wkt (p, 8,
        "SP\"],PARAMETER[\"latitude_of_origin\",33.3333333333333]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"central_meridian\",-98],PARAMETER[\"standar");
    add_srs_wkt (p, 10,
        "d_parallel_1\",35.2333333333333],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 11,
        "rallel_2\",33.9333333333333],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 12,
        ",1968500],PARAMETER[\"false_northing\",0],UNIT[\"US surv");
    add_srs_wkt (p, 13,
        "ey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]");
    add_srs_wkt (p, 14,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 15,
        "ITY[\"EPSG\",\"2268\"]],VERT_CS[\"NAVD88 height (ftUS)\"");
    add_srs_wkt (p, 16,
        ",VERT_DATUM[\"North American Vertical Datum 1988\",2005,");
    add_srs_wkt (p, 17,
        "AUTHORITY[\"EPSG\",\"5103\"]],UNIT[\"US survey foot\",0.");
    add_srs_wkt (p, 18,
        "304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Gra");
    add_srs_wkt (p, 19,
        "vity-related height\",UP],AUTHORITY[\"EPSG\",\"6360\"]],");
    add_srs_wkt (p, 20,
        "AUTHORITY[\"EPSG\",\"8772\"]]");
    p = add_epsg_def_ex (filter, first, last, 8773, "epsg", 8773,
        "NAD83 / Pennsylvania North (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=40.1666666666667 +lon_0=-77.75 +lat_1=4");
    add_proj4text (p, 1,
        "1.95 +lat_2=40.8833333333333 +x_0=600000 +y_0=0 +datum=N");
    add_proj4text (p, 2,
        "AD83 +units=us-ft +vunits=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Pennsylvania North (ftUS) + NAVD88 he");
    add_srs_wkt (p, 1,
        "ight (ftUS)\",PROJCS[\"NAD83 / Pennsylvania North (ftUS)");
    add_srs_wkt (p, 2,
        "\",GEOGCS[\"NAD83\",DATUM[\"North_American_Datum_1983\",");
    add_srs_wkt (p, 3,
        "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"");
    add_srs_wkt (p, 5,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 6,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 7,
        "HORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 8,
        "l_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",40.16666");
    add_srs_wkt (p, 9,
        "66666667],PARAMETER[\"central_meridian\",-77.75],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"standard_parallel_1\",41.95],PARAMETER[\"standard_p");
    add_srs_wkt (p, 11,
        "arallel_2\",40.8833333333333],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 12,
        ",1968500],PARAMETER[\"false_northing\",0],UNIT[\"US surv");
    add_srs_wkt (p, 13,
        "ey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]");
    add_srs_wkt (p, 14,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 15,
        "ITY[\"EPSG\",\"2271\"]],VERT_CS[\"NAVD88 height (ftUS)\"");
    add_srs_wkt (p, 16,
        ",VERT_DATUM[\"North American Vertical Datum 1988\",2005,");
    add_srs_wkt (p, 17,
        "AUTHORITY[\"EPSG\",\"5103\"]],UNIT[\"US survey foot\",0.");
    add_srs_wkt (p, 18,
        "304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Gra");
    add_srs_wkt (p, 19,
        "vity-related height\",UP],AUTHORITY[\"EPSG\",\"6360\"]],");
    add_srs_wkt (p, 20,
        "AUTHORITY[\"EPSG\",\"8773\"]]");
    p = add_epsg_def_ex (filter, first, last, 8774, "epsg", 8774,
        "NAD83 / Pennsylvania South (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=39.3333333333333 +lon_0=-77.75 +lat_1=4");
    add_proj4text (p, 1,
        "0.9666666666667 +lat_2=39.9333333333333 +x_0=600000 +y_0");
    add_proj4text (p, 2,
        "=0 +datum=NAD83 +units=us-ft +vunits=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Pennsylvania South (ftUS) + NAVD88 he");
    add_srs_wkt (p, 1,
        "ight (ftUS)\",PROJCS[\"NAD83 / Pennsylvania South (ftUS)");
    add_srs_wkt (p, 2,
        "\",GEOGCS[\"NAD83\",DATUM[\"North_American_Datum_1983\",");
    add_srs_wkt (p, 3,
        "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"");
    add_srs_wkt (p, 5,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 6,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 7,
        "HORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 8,
        "l_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",39.33333");
    add_srs_wkt (p, 9,
        "33333333],PARAMETER[\"central_meridian\",-77.75],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"standard_parallel_1\",40.9666666666667],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "standard_parallel_2\",39.9333333333333],PARAMETER[\"fals");
    add_srs_wkt (p, 12,
        "e_easting\",1968500],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 13,
        "T[\"US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 14,
        ",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 15,
        "TH],AUTHORITY[\"EPSG\",\"2272\"]],VERT_CS[\"NAVD88 heigh");
    add_srs_wkt (p, 16,
        "t (ftUS)\",VERT_DATUM[\"North American Vertical Datum 19");
    add_srs_wkt (p, 17,
        "88\",2005,AUTHORITY[\"EPSG\",\"5103\"]],UNIT[\"US survey");
    add_srs_wkt (p, 18,
        " foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],");
    add_srs_wkt (p, 19,
        "AXIS[\"Gravity-related height\",UP],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 20,
        "6360\"]],AUTHORITY[\"EPSG\",\"8774\"]]");
    p = add_epsg_def_ex (filter, first, last, 8775, "epsg", 8775,
        "NAD83 / Rhode Island (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.0833333333333 +lon_0=-71.5 +k=0.99");
    add_proj4text (p, 1,
        "999375 +x_0=99999.99998984 +y_0=0 +datum=NAD83 +units=us");
    add_proj4text (p, 2,
        "-ft +vunits=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Rhode Island (ftUS) + NAVD88 height (");
    add_srs_wkt (p, 1,
        "ftUS)\",PROJCS[\"NAD83 / Rhode Island (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 2,
        "NAD83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"G");
    add_srs_wkt (p, 3,
        "RS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"701");
    add_srs_wkt (p, 4,
        "9\"]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 5,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 6,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 7,
        "SG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 8,
        "METER[\"latitude_of_origin\",41.0833333333333],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"central_meridian\",-71.5],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 10,
        "0.99999375],PARAMETER[\"false_easting\",328083.3333],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",0],UNIT[\"US survey foot\",0.3");
    add_srs_wkt (p, 12,
        "04800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"East");
    add_srs_wkt (p, 13,
        "ing\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 14,
        "\"3438\"]],VERT_CS[\"NAVD88 height (ftUS)\",VERT_DATUM[\"");
    add_srs_wkt (p, 15,
        "North American Vertical Datum 1988\",2005,AUTHORITY[\"EP");
    add_srs_wkt (p, 16,
        "SG\",\"5103\"]],UNIT[\"US survey foot\",0.30480060960121");
    add_srs_wkt (p, 17,
        "9,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Gravity-related h");
    add_srs_wkt (p, 18,
        "eight\",UP],AUTHORITY[\"EPSG\",\"6360\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 19,
        "SG\",\"8775\"]]");
    p = add_epsg_def_ex (filter, first, last, 8776, "epsg", 8776,
        "NAD83 / South Dakota North (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=43.8333333333333 +lon_0=-100 +lat_1=45.");
    add_proj4text (p, 1,
        "6833333333333 +lat_2=44.4166666666667 +x_0=600000 +y_0=0");
    add_proj4text (p, 2,
        " +datum=NAD83 +units=us-ft +vunits=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / South Dakota North (ftUS) + NAVD88 he");
    add_srs_wkt (p, 1,
        "ight (ftUS)\",PROJCS[\"NAD83 / South Dakota North (ftUS)");
    add_srs_wkt (p, 2,
        "\",GEOGCS[\"NAD83\",DATUM[\"North_American_Datum_1983\",");
    add_srs_wkt (p, 3,
        "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"");
    add_srs_wkt (p, 5,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 6,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 7,
        "HORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 8,
        "l_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",43.83333");
    add_srs_wkt (p, 9,
        "33333333],PARAMETER[\"central_meridian\",-100],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"standard_parallel_1\",45.6833333333333],PARAMETER[\"s");
    add_srs_wkt (p, 11,
        "tandard_parallel_2\",44.4166666666667],PARAMETER[\"false");
    add_srs_wkt (p, 12,
        "_easting\",1968500],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 13,
        "[\"US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 14,
        ",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 15,
        "TH],AUTHORITY[\"EPSG\",\"4457\"]],VERT_CS[\"NAVD88 heigh");
    add_srs_wkt (p, 16,
        "t (ftUS)\",VERT_DATUM[\"North American Vertical Datum 19");
    add_srs_wkt (p, 17,
        "88\",2005,AUTHORITY[\"EPSG\",\"5103\"]],UNIT[\"US survey");
    add_srs_wkt (p, 18,
        " foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],");
    add_srs_wkt (p, 19,
        "AXIS[\"Gravity-related height\",UP],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 20,
        "6360\"]],AUTHORITY[\"EPSG\",\"8776\"]]");
    p = add_epsg_def_ex (filter, first, last, 8777, "epsg", 8777,
        "NAD83 / South Dakota South (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=42.3333333333333 +lon_0=-100.3333333333");
    add_proj4text (p, 1,
        "33 +lat_1=44.4 +lat_2=42.8333333333333 +x_0=600000 +y_0=");
    add_proj4text (p, 2,
        "0 +datum=NAD83 +units=us-ft +vunits=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / South Dakota South (ftUS) + NAVD88 he");
    add_srs_wkt (p, 1,
        "ight (ftUS)\",PROJCS[\"NAD83 / South Dakota South (ftUS)");
    add_srs_wkt (p, 2,
        "\",GEOGCS[\"NAD83\",DATUM[\"North_American_Datum_1983\",");
    add_srs_wkt (p, 3,
        "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"");
    add_srs_wkt (p, 5,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 6,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 7,
        "HORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 8,
        "l_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",42.33333");
    add_srs_wkt (p, 9,
        "33333333],PARAMETER[\"central_meridian\",-100.3333333333");
    add_srs_wkt (p, 10,
        "33],PARAMETER[\"standard_parallel_1\",44.4],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "standard_parallel_2\",42.8333333333333],PARAMETER[\"fals");
    add_srs_wkt (p, 12,
        "e_easting\",1968500],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 13,
        "T[\"US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 14,
        ",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 15,
        "TH],AUTHORITY[\"EPSG\",\"3455\"]],VERT_CS[\"NAVD88 heigh");
    add_srs_wkt (p, 16,
        "t (ftUS)\",VERT_DATUM[\"North American Vertical Datum 19");
    add_srs_wkt (p, 17,
        "88\",2005,AUTHORITY[\"EPSG\",\"5103\"]],UNIT[\"US survey");
    add_srs_wkt (p, 18,
        " foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],");
    add_srs_wkt (p, 19,
        "AXIS[\"Gravity-related height\",UP],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 20,
        "6360\"]],AUTHORITY[\"EPSG\",\"8777\"]]");
    p = add_epsg_def_ex (filter, first, last, 8778, "epsg", 8778,
        "NAD83 / Tennessee (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=34.3333333333333 +lon_0=-86 +lat_1=36.4");
    add_proj4text (p, 1,
        "166666666667 +lat_2=35.25 +x_0=600000 +y_0=0 +datum=NAD8");
    add_proj4text (p, 2,
        "3 +units=us-ft +vunits=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Tennessee (ftUS) + NAVD88 height (ftU");
    add_srs_wkt (p, 1,
        "S)\",PROJCS[\"NAD83 / Tennessee (ftUS)\",GEOGCS[\"NAD83\"");
    add_srs_wkt (p, 2,
        ",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 3,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4269\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",34.3333333333333],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",-86],PARAMETER[\"standard_paralle");
    add_srs_wkt (p, 10,
        "l_1\",36.4166666666667],PARAMETER[\"standard_parallel_2\"");
    add_srs_wkt (p, 11,
        ",35.25],PARAMETER[\"false_easting\",1968500],PARAMETER[\"");
    add_srs_wkt (p, 12,
        "false_northing\",0],UNIT[\"US survey foot\",0.3048006096");
    add_srs_wkt (p, 13,
        "01219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 14,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2274\"]");
    add_srs_wkt (p, 15,
        "],VERT_CS[\"NAVD88 height (ftUS)\",VERT_DATUM[\"North Am");
    add_srs_wkt (p, 16,
        "erican Vertical Datum 1988\",2005,AUTHORITY[\"EPSG\",\"5");
    add_srs_wkt (p, 17,
        "103\"]],UNIT[\"US survey foot\",0.304800609601219,AUTHOR");
    add_srs_wkt (p, 18,
        "ITY[\"EPSG\",\"9003\"]],AXIS[\"Gravity-related height\",");
    add_srs_wkt (p, 19,
        "UP],AUTHORITY[\"EPSG\",\"6360\"]],AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 20,
        "778\"]]");
    p = add_epsg_def_ex (filter, first, last, 8779, "epsg", 8779,
        "NAD83 / Texas North (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=34 +lon_0=-101.5 +lat_1=36.183333333333");
    add_proj4text (p, 1,
        "3 +lat_2=34.65 +x_0=200000.0001016 +y_0=999999.9998984 +");
    add_proj4text (p, 2,
        "datum=NAD83 +units=us-ft +vunits=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Texas North (ftUS) + NAVD88 height (f");
    add_srs_wkt (p, 1,
        "tUS)\",PROJCS[\"NAD83 / Texas North (ftUS)\",GEOGCS[\"NA");
    add_srs_wkt (p, 2,
        "D83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS");
    add_srs_wkt (p, 3,
        " 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 4,
        "]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 6,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4269\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"latitude_of_origin\",34],PARAMETER[\"central");
    add_srs_wkt (p, 9,
        "_meridian\",-101.5],PARAMETER[\"standard_parallel_1\",36");
    add_srs_wkt (p, 10,
        ".1833333333333],PARAMETER[\"standard_parallel_2\",34.65]");
    add_srs_wkt (p, 11,
        ",PARAMETER[\"false_easting\",656166.667],PARAMETER[\"fal");
    add_srs_wkt (p, 12,
        "se_northing\",3280833.333],UNIT[\"US survey foot\",0.304");
    add_srs_wkt (p, 13,
        "800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 14,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 15,
        "2275\"]],VERT_CS[\"NAVD88 height (ftUS)\",VERT_DATUM[\"N");
    add_srs_wkt (p, 16,
        "orth American Vertical Datum 1988\",2005,AUTHORITY[\"EPS");
    add_srs_wkt (p, 17,
        "G\",\"5103\"]],UNIT[\"US survey foot\",0.304800609601219");
    add_srs_wkt (p, 18,
        ",AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Gravity-related he");
    add_srs_wkt (p, 19,
        "ight\",UP],AUTHORITY[\"EPSG\",\"6360\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 20,
        "G\",\"8779\"]]");
    p = add_epsg_def_ex (filter, first, last, 8780, "epsg", 8780,
        "NAD83 / Texas North Central (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=31.6666666666667 +lon_0=-98.5 +lat_1=33");
    add_proj4text (p, 1,
        ".9666666666667 +lat_2=32.1333333333333 +x_0=600000 +y_0=");
    add_proj4text (p, 2,
        "2000000.0001016 +datum=NAD83 +units=us-ft +vunits=us-ft ");
    add_proj4text (p, 3,
        "+no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Texas North Central (ftUS) + NAVD88 h");
    add_srs_wkt (p, 1,
        "eight (ftUS)\",PROJCS[\"NAD83 / Texas North Central (ftU");
    add_srs_wkt (p, 2,
        "S)\",GEOGCS[\"NAD83\",DATUM[\"North_American_Datum_1983\"");
    add_srs_wkt (p, 3,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"");
    add_srs_wkt (p, 5,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 6,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 7,
        "HORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 8,
        "l_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",31.66666");
    add_srs_wkt (p, 9,
        "66666667],PARAMETER[\"central_meridian\",-98.5],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"standard_parallel_1\",33.9666666666667],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "standard_parallel_2\",32.1333333333333],PARAMETER[\"fals");
    add_srs_wkt (p, 12,
        "e_easting\",1968500],PARAMETER[\"false_northing\",656166");
    add_srs_wkt (p, 13,
        "6.667],UNIT[\"US survey foot\",0.304800609601219,AUTHORI");
    add_srs_wkt (p, 14,
        "TY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Nor");
    add_srs_wkt (p, 15,
        "thing\",NORTH],AUTHORITY[\"EPSG\",\"2276\"]],VERT_CS[\"N");
    add_srs_wkt (p, 16,
        "AVD88 height (ftUS)\",VERT_DATUM[\"North American Vertic");
    add_srs_wkt (p, 17,
        "al Datum 1988\",2005,AUTHORITY[\"EPSG\",\"5103\"]],UNIT[");
    add_srs_wkt (p, 18,
        "\"US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 19,
        "\"9003\"]],AXIS[\"Gravity-related height\",UP],AUTHORITY");
    add_srs_wkt (p, 20,
        "[\"EPSG\",\"6360\"]],AUTHORITY[\"EPSG\",\"8780\"]]");
    p = add_epsg_def_ex (filter, first, last, 8781, "epsg", 8781,
        "NAD83 / Texas Central (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=29.6666666666667 +lon_0=-100.3333333333");
    add_proj4text (p, 1,
        "33 +lat_1=31.8833333333333 +lat_2=30.1166666666667 +x_0=");
    add_proj4text (p, 2,
        "699999.9998984 +y_0=3000000 +datum=NAD83 +units=us-ft +v");
    add_proj4text (p, 3,
        "units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Texas Central (ftUS) + NAVD88 height ");
    add_srs_wkt (p, 1,
        "(ftUS)\",PROJCS[\"NAD83 / Texas Central (ftUS)\",GEOGCS[");
    add_srs_wkt (p, 2,
        "\"NAD83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"");
    add_srs_wkt (p, 3,
        "GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 4,
        "19\"]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 5,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 6,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 7,
        "SG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP");
    add_srs_wkt (p, 8,
        "\"],PARAMETER[\"latitude_of_origin\",29.6666666666667],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"central_meridian\",-100.333333333333],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"standard_parallel_1\",31.8833333333333],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "standard_parallel_2\",30.1166666666667],PARAMETER[\"fals");
    add_srs_wkt (p, 12,
        "e_easting\",2296583.333],PARAMETER[\"false_northing\",98");
    add_srs_wkt (p, 13,
        "42500],UNIT[\"US survey foot\",0.304800609601219,AUTHORI");
    add_srs_wkt (p, 14,
        "TY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Nor");
    add_srs_wkt (p, 15,
        "thing\",NORTH],AUTHORITY[\"EPSG\",\"2277\"]],VERT_CS[\"N");
    add_srs_wkt (p, 16,
        "AVD88 height (ftUS)\",VERT_DATUM[\"North American Vertic");
    add_srs_wkt (p, 17,
        "al Datum 1988\",2005,AUTHORITY[\"EPSG\",\"5103\"]],UNIT[");
    add_srs_wkt (p, 18,
        "\"US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 19,
        "\"9003\"]],AXIS[\"Gravity-related height\",UP],AUTHORITY");
    add_srs_wkt (p, 20,
        "[\"EPSG\",\"6360\"]],AUTHORITY[\"EPSG\",\"8781\"]]");
    p = add_epsg_def_ex (filter, first, last, 8782, "epsg", 8782,
        "NAD83 / Texas South Central (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=27.8333333333333 +lon_0=-99 +lat_1=30.2");
    add_proj4text (p, 1,
        "833333333333 +lat_2=28.3833333333333 +x_0=600000 +y_0=39");
    add_proj4text (p, 2,
        "99999.9998984 +datum=NAD83 +units=us-ft +vunits=us-ft +n");
    add_proj4text (p, 3,
        "o_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Texas South Central (ftUS) + NAVD88 h");
    add_srs_wkt (p, 1,
        "eight (ftUS)\",PROJCS[\"NAD83 / Texas South Central (ftU");
    add_srs_wkt (p, 2,
        "S)\",GEOGCS[\"NAD83\",DATUM[\"North_American_Datum_1983\"");
    add_srs_wkt (p, 3,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"");
    add_srs_wkt (p, 5,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 6,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 7,
        "HORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 8,
        "l_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",27.83333");
    add_srs_wkt (p, 9,
        "33333333],PARAMETER[\"central_meridian\",-99],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"standard_parallel_1\",30.2833333333333],PARAMETER[\"st");
    add_srs_wkt (p, 11,
        "andard_parallel_2\",28.3833333333333],PARAMETER[\"false_");
    add_srs_wkt (p, 12,
        "easting\",1968500],PARAMETER[\"false_northing\",13123333");
    add_srs_wkt (p, 13,
        ".333],UNIT[\"US survey foot\",0.304800609601219,AUTHORIT");
    add_srs_wkt (p, 14,
        "Y[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 15,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"2278\"]],VERT_CS[\"NA");
    add_srs_wkt (p, 16,
        "VD88 height (ftUS)\",VERT_DATUM[\"North American Vertica");
    add_srs_wkt (p, 17,
        "l Datum 1988\",2005,AUTHORITY[\"EPSG\",\"5103\"]],UNIT[\"");
    add_srs_wkt (p, 18,
        "US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 19,
        "9003\"]],AXIS[\"Gravity-related height\",UP],AUTHORITY[\"");
    add_srs_wkt (p, 20,
        "EPSG\",\"6360\"]],AUTHORITY[\"EPSG\",\"8782\"]]");
    p = add_epsg_def_ex (filter, first, last, 8783, "epsg", 8783,
        "NAD83 / Texas South (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=25.6666666666667 +lon_0=-98.5 +lat_1=27");
    add_proj4text (p, 1,
        ".8333333333333 +lat_2=26.1666666666667 +x_0=300000 +y_0=");
    add_proj4text (p, 2,
        "5000000.0001016 +datum=NAD83 +units=us-ft +vunits=us-ft ");
    add_proj4text (p, 3,
        "+no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Texas South (ftUS) + NAVD88 height (f");
    add_srs_wkt (p, 1,
        "tUS)\",PROJCS[\"NAD83 / Texas South (ftUS)\",GEOGCS[\"NA");
    add_srs_wkt (p, 2,
        "D83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS");
    add_srs_wkt (p, 3,
        " 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 4,
        "]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 6,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4269\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"latitude_of_origin\",25.6666666666667],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"central_meridian\",-98.5],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 10,
        "rallel_1\",27.8333333333333],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 11,
        "el_2\",26.1666666666667],PARAMETER[\"false_easting\",984");
    add_srs_wkt (p, 12,
        "250],PARAMETER[\"false_northing\",16404166.667],UNIT[\"U");
    add_srs_wkt (p, 13,
        "S survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 14,
        "003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],");
    add_srs_wkt (p, 15,
        "AUTHORITY[\"EPSG\",\"2279\"]],VERT_CS[\"NAVD88 height (f");
    add_srs_wkt (p, 16,
        "tUS)\",VERT_DATUM[\"North American Vertical Datum 1988\"");
    add_srs_wkt (p, 17,
        ",2005,AUTHORITY[\"EPSG\",\"5103\"]],UNIT[\"US survey foo");
    add_srs_wkt (p, 18,
        "t\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS");
    add_srs_wkt (p, 19,
        "[\"Gravity-related height\",UP],AUTHORITY[\"EPSG\",\"636");
    add_srs_wkt (p, 20,
        "0\"]],AUTHORITY[\"EPSG\",\"8783\"]]");
    p = add_epsg_def_ex (filter, first, last, 8784, "epsg", 8784,
        "NAD83 / Utah North (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=40.3333333333333 +lon_0=-111.5 +lat_1=4");
    add_proj4text (p, 1,
        "1.7833333333333 +lat_2=40.7166666666667 +x_0=500000.0000");
    add_proj4text (p, 2,
        "1016 +y_0=999999.99998984 +datum=NAD83 +units=us-ft +vun");
    add_proj4text (p, 3,
        "its=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Utah North (ftUS) + NAVD88 height (ft");
    add_srs_wkt (p, 1,
        "US)\",PROJCS[\"NAD83 / Utah North (ftUS)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 2,
        "3\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 3,
        "980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]");
    add_srs_wkt (p, 4,
        "],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 6,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4269\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"latitude_of_origin\",40.3333333333333],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"central_meridian\",-111.5],PARAMETER[\"standard_p");
    add_srs_wkt (p, 10,
        "arallel_1\",41.7833333333333],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 11,
        "lel_2\",40.7166666666667],PARAMETER[\"false_easting\",16");
    add_srs_wkt (p, 12,
        "40416.6667],PARAMETER[\"false_northing\",3280833.3333],U");
    add_srs_wkt (p, 13,
        "NIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"EPS");
    add_srs_wkt (p, 14,
        "G\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",");
    add_srs_wkt (p, 15,
        "NORTH],AUTHORITY[\"EPSG\",\"3560\"]],VERT_CS[\"NAVD88 he");
    add_srs_wkt (p, 16,
        "ight (ftUS)\",VERT_DATUM[\"North American Vertical Datum");
    add_srs_wkt (p, 17,
        " 1988\",2005,AUTHORITY[\"EPSG\",\"5103\"]],UNIT[\"US sur");
    add_srs_wkt (p, 18,
        "vey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"");
    add_srs_wkt (p, 19,
        "]],AXIS[\"Gravity-related height\",UP],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 20,
        ",\"6360\"]],AUTHORITY[\"EPSG\",\"8784\"]]");
    p = add_epsg_def_ex (filter, first, last, 8785, "epsg", 8785,
        "NAD83 / Utah Central (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=38.3333333333333 +lon_0=-111.5 +lat_1=4");
    add_proj4text (p, 1,
        "0.65 +lat_2=39.0166666666667 +x_0=500000.00001016 +y_0=2");
    add_proj4text (p, 2,
        "000000.00001016 +datum=NAD83 +units=us-ft +vunits=us-ft ");
    add_proj4text (p, 3,
        "+no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Utah Central (ftUS) + NAVD88 height (");
    add_srs_wkt (p, 1,
        "ftUS)\",PROJCS[\"NAD83 / Utah Central (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 2,
        "NAD83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"G");
    add_srs_wkt (p, 3,
        "RS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"701");
    add_srs_wkt (p, 4,
        "9\"]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 5,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 6,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 7,
        "SG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP");
    add_srs_wkt (p, 8,
        "\"],PARAMETER[\"latitude_of_origin\",38.3333333333333],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"central_meridian\",-111.5],PARAMETER[\"standa");
    add_srs_wkt (p, 10,
        "rd_parallel_1\",40.65],PARAMETER[\"standard_parallel_2\"");
    add_srs_wkt (p, 11,
        ",39.0166666666667],PARAMETER[\"false_easting\",1640416.6");
    add_srs_wkt (p, 12,
        "667],PARAMETER[\"false_northing\",6561666.6667],UNIT[\"U");
    add_srs_wkt (p, 13,
        "S survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 14,
        "003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],");
    add_srs_wkt (p, 15,
        "AUTHORITY[\"EPSG\",\"3566\"]],VERT_CS[\"NAVD88 height (f");
    add_srs_wkt (p, 16,
        "tUS)\",VERT_DATUM[\"North American Vertical Datum 1988\"");
    add_srs_wkt (p, 17,
        ",2005,AUTHORITY[\"EPSG\",\"5103\"]],UNIT[\"US survey foo");
    add_srs_wkt (p, 18,
        "t\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS");
    add_srs_wkt (p, 19,
        "[\"Gravity-related height\",UP],AUTHORITY[\"EPSG\",\"636");
    add_srs_wkt (p, 20,
        "0\"]],AUTHORITY[\"EPSG\",\"8785\"]]");
    p = add_epsg_def_ex (filter, first, last, 8786, "epsg", 8786,
        "NAD83 / Utah South (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=36.6666666666667 +lon_0=-111.5 +lat_1=3");
    add_proj4text (p, 1,
        "8.35 +lat_2=37.2166666666667 +x_0=500000.00001016 +y_0=3");
    add_proj4text (p, 2,
        "000000 +datum=NAD83 +units=us-ft +vunits=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Utah South (ftUS) + NAVD88 height (ft");
    add_srs_wkt (p, 1,
        "US)\",PROJCS[\"NAD83 / Utah South (ftUS)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 2,
        "3\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 3,
        "980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]");
    add_srs_wkt (p, 4,
        "],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 6,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4269\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"latitude_of_origin\",36.6666666666667],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"central_meridian\",-111.5],PARAMETER[\"standard_p");
    add_srs_wkt (p, 10,
        "arallel_1\",38.35],PARAMETER[\"standard_parallel_2\",37.");
    add_srs_wkt (p, 11,
        "2166666666667],PARAMETER[\"false_easting\",1640416.6667]");
    add_srs_wkt (p, 12,
        ",PARAMETER[\"false_northing\",9842500],UNIT[\"US survey ");
    add_srs_wkt (p, 13,
        "foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],A");
    add_srs_wkt (p, 14,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 15,
        "[\"EPSG\",\"3567\"]],VERT_CS[\"NAVD88 height (ftUS)\",VE");
    add_srs_wkt (p, 16,
        "RT_DATUM[\"North American Vertical Datum 1988\",2005,AUT");
    add_srs_wkt (p, 17,
        "HORITY[\"EPSG\",\"5103\"]],UNIT[\"US survey foot\",0.304");
    add_srs_wkt (p, 18,
        "800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Gravit");
    add_srs_wkt (p, 19,
        "y-related height\",UP],AUTHORITY[\"EPSG\",\"6360\"]],AUT");
    add_srs_wkt (p, 20,
        "HORITY[\"EPSG\",\"8786\"]]");
    p = add_epsg_def_ex (filter, first, last, 8787, "epsg", 8787,
        "NAD83 / Vermont (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.5 +lon_0=-72.5 +k=0.999964286 +x_0");
    add_proj4text (p, 1,
        "=500000.00001016 +y_0=0 +datum=NAD83 +units=us-ft +vunit");
    add_proj4text (p, 2,
        "s=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 / Vermont (ftUS) + NAVD88 height (ftUS)");
    add_srs_wkt (p, 1,
        "\",PROJCS[\"NAD83 / Vermont (ftUS)\",GEOGCS[\"NAD83\",DA");
    add_srs_wkt (p, 2,
        "TUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",");
    add_srs_wkt (p, 3,
        "6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 6,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"426");
    add_srs_wkt (p, 7,
        "9\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 8,
        "titude_of_origin\",42.5],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 9,
        "-72.5],PARAMETER[\"scale_factor\",0.999964286],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_easting\",1640416.6667],PARAMETER[\"false_north");
    add_srs_wkt (p, 11,
        "ing\",0],UNIT[\"US survey foot\",0.304800609601219,AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"N");
    add_srs_wkt (p, 13,
        "orthing\",NORTH],AUTHORITY[\"EPSG\",\"5646\"]],VERT_CS[\"");
    add_srs_wkt (p, 14,
        "NAVD88 height (ftUS)\",VERT_DATUM[\"North American Verti");
    add_srs_wkt (p, 15,
        "cal Datum 1988\",2005,AUTHORITY[\"EPSG\",\"5103\"]],UNIT");
    add_srs_wkt (p, 16,
        "[\"US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 17,
        ",\"9003\"]],AXIS[\"Gravity-related height\",UP],AUTHORIT");
    add_srs_wkt (p, 18,
        "Y[\"EPSG\",\"6360\"]],AUTHORITY[\"EPSG\",\"8787\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

