//************************************************************
//   commandSet classe definition for the speakerphone app.
//************************************************************
#include "incall.h"

CommandSet::CommandSet()
{
   Name = NULL;
   Commands = NULL;
   next = NULL;
}

int CommandSet::Init(ConfigInfo* conf)
{
   FILE* fp;
   int ret = 1;
   fp = fopen(conf->CommandSet, "r");

   if (!fp) return 0;
   ret = ReadFile(fp);
   fclose(fp);
   return ret;
}

int CommandSet::ReadFile(FILE* fp)
{
   int   state = 0;
   int   num;
   char  buf[1024];
   char  buf1[1024];
   char  buf2[1024];
   CommandSequence*  CurrCmd = NULL;
   CommandSequence*  LastCmd = NULL;

   while (NULL != fgets(buf, sizeof(buf), fp))
   {
      if (buf[0] == '#' || buf[0] == '\n') continue;

      buf[1023] = 0;
      switch (state)
      {
         case 0:
            if (sscanf(buf, " COMMAND %s", buf1) == 1)
            {
               state = 1;
               Name = new char[strlen(buf1) + 1];
               strcpy(Name, buf1);
            }
         break;
         case 1:
            num = sscanf(buf, " %s %s ", buf1, buf2);
            if (num == 1 && 0 == strcmp(buf1, "END_COMMAND"))
            {
               state = 2;
            }
            if (num == 2)
            {
               CurrCmd = new CommandSequence(buf1, buf2);
               if (LastCmd == NULL)
               {
                  LastCmd = CurrCmd;
                  Commands = LastCmd;
               } else
               {
                  LastCmd->SetNext( CurrCmd );
                  LastCmd = CurrCmd;
               }
            }
         break;
      }
      if (state == 2) break;
   }

   if (state == 2) 
   {
      next = new CommandSet();
      if (!next->ReadFile(fp))
      {
         delete next;
         next = NULL;
      }
      return 1;
   }
   return 0;
};

CommandSet::~CommandSet()
{
   if (Name) delete Name;
   if (next) delete next;
   if (Commands) delete Commands;
};

CommandSequence* CommandSet::GetSequence(char* Nm)
{
   if (Name && (0 == strcmp(Name, Nm)))
   {
      return Commands;
   } else 
   {
      if (next)
      {
         return next->GetSequence(Nm);
      }
   }
   return NULL;
};

