package Templates::Admin;

use SmallPigVars qw($config);
use Templates::Default;
use Templates::Admin::StandardIndex;

use strict;
use vars qw(@ISA $template);

@ISA = qw(Templates::Default);

my $lang;

sub new{
  my ($class, $spcgi, $spdb, $pagetype) = @_;

  $template = Templates::Default->new($spcgi, $spdb, $pagetype);

  $template->{'spcgi'} ||= $spcgi;
  $template->{'STATE'} = $spcgi->{'STATE'};
  $template->{'STATE'}->{'theme'} = $template->{'theme'};
  $template->{'STATE'}->{'langptr'} = $template->{'lang'};
  $template->{'spdb'} ||= $spdb;
  
  bless $template, $class;

  $template->initialize();
  
  return $template;
}

#########################################################################
# --- Sun Dec 19 23:06:10 PST 1999
# ---
sub initialize{
  my ($template) = @_;
  
  my $pagefiles = {};
  $pagefiles->{'default'} = "default.temp";
  $pagefiles->{'index'} = "adminindex.temp";
  
  $template->{'pagefiles'} = $pagefiles;

  my $pagesubs = {};
  $pagesubs->{'default'} = \&whole;
  $pagesubs->{'grantadmin'} = \&grantadmin;
  $pagesubs->{'revokeadmin'} = \&revokeadmin;
  $pagesubs->{'assignmod'} = \&assignmod;
  $pagesubs->{'revokemod'} = \&revokemod;
  $pagesubs->{'grantgroup'} = \&grantgroup;
  $pagesubs->{'revokegroup'} = \&revokegroup;
  $pagesubs->{'modifyuser'} = \&modifyuser;
  $pagesubs->{'createcat'} = \&createcat;
  $pagesubs->{'modifycat'} = \&modifycat;
  $pagesubs->{'createboard'} = \&createboard;
  $pagesubs->{'modifyboard'} = \&modifyboard;
  $pagesubs->{'threads'} = \&threads;
  $pagesubs->{'showstat'} = \&showstat;  

  $template->{'pagesubs'} = $pagesubs;

  $lang = $template->{'lang'};

}

sub grantadmin{
  my $STATE = $template->STATE;
  require Templates::Admin::GAOMU;
  my $gaomu = Templates::Admin::GAOMU->new();
  print $gaomu->display($STATE);
}

sub revokeadmin{
  my $STATE = $template->STATE;
  require Templates::Admin::RevokeAdmin;
  my $obj = Templates::Admin::RevokeAdmin->new();
  print $obj->display($STATE);
}

sub assignmod{
  my $STATE = $template->STATE;
  require Templates::Admin::AssignUsers;
  my $assignusers = Templates::Admin::AssignUsers->new();
  print $assignusers->display($STATE);
}

sub revokemod{
  my $STATE = $template->STATE;  
  require Templates::Admin::RevokeUsers;
  my $revokemodorgroup = Templates::Admin::RevokeUsers->new();
  print $revokemodorgroup->display($STATE);
}

sub grantgroup{
  my $STATE = $template->STATE;
  require Templates::Admin::AssignUsers;
  my $assignusers = Templates::Admin::AssignUsers->new();
  print $assignusers->display($STATE);
}

sub revokegroup{
  my $STATE = $template->STATE;  
  require Templates::Admin::RevokeUsers;
  my $revokemodorgroup = Templates::Admin::RevokeUsers->new();
  print $revokemodorgroup->display($STATE);
}

sub modifyuser{
  my $STATE = $template->STATE;
  require Templates::Admin::GAOMU;
  my $gaomu = Templates::Admin::GAOMU->new();
  print $gaomu->display($STATE);
}

sub createcat{
    my $STATE = $template->STATE;
    require Templates::Admin::Cats;
    my $obj = Templates::Admin::Cats->new();
    print $obj->display($STATE);
}

sub modifycat{
    my $STATE = $template->STATE;
    require Templates::Admin::ModifyCat;
    my $modifycategory = Templates::Admin::ModifyCat->new();
    print $modifycategory->get($STATE);
    #$title = $lang->{'modify_cat1'};
}

sub createboard{
    my $STATE = $template->STATE;
    require Templates::Admin::CreateBoard;
    my $createboard = Templates::Admin::CreateBoard->new();
    print $createboard->display($STATE);
}

sub modifyboard{
    my $STATE = $template->STATE;
    require Templates::Admin::ModifyBoard;
    my $modifyboard = Templates::Admin::ModifyBoard->new($STATE);
    print $modifyboard->display();	
}

sub threads{
    my $STATE = $template->STATE; 
    unless($STATE->{'sid'}){
	require Templates::Admin::BoardsBlock;
	my $boardblock = Templates::Admin::BoardsBlock->new($STATE->{'op'});
	print $boardblock->get($STATE);
    }
    else{
	require Templates::Admin::ThreadsBlock;
	my $threads = Templates::Admin::ThreadsBlock->new();
	print $threads->get($STATE);
    }
}

sub showstat{
    my $STATE = $template->STATE; 
    require Templates::Admin::ShowStat;
    my $showstat = Templates::Admin::ShowStat->new($STATE);
    print $showstat->display();
}

return 1;





