package Templates::Admin::Cats;

use SmallPigVars qw($config);
use Templates::Admin::SmallPig;
use SPDB;
use CGI qw(:standard :cgi-lib);
use CGI::Cookie ();

use Templates::Admin::Block;
use Templates::Admin::OptBlock;

use strict;

my @ISA = qw(Templates::Admin::Block);

my %CACHE;

my $lang;

sub new{
  my ($class) = @_;
  my $self = Templates::Admin::Block->new("catsblock");
  $self->{'spdb'} = SPDB->new();
  
  my $id = join '', sort values %$self, "catsblock";
  return $CACHE{$id} if $CACHE{$id};
  return $CACHE{$id} = bless $self, $class;
}

sub DESTROY{
    my $self = shift;
    my $spdb = $self->{'spdb'};
    $spdb->db_disconnect($spdb->{'dbh'});
}

sub display{
  my ($self, $STATE) = @_;
  my $op = $STATE->{'op'};
  my $prev_op = $STATE->{'prev_op'};
  my $theme = $STATE->{'theme'};
 
  $lang = $STATE->{'langptr'};

  my $standardindex = Templates::Admin::StandardIndex->new($STATE);

  my $content = $self->_get_createcategory($STATE);
  my $classvars = {('title' => (($prev_op ne "modifycategory")?
				$lang->{'create_cat1'}:
				$lang->{'modify_cat3'}),
		    'content' => $content)};
  my $createcategory = Templates::Admin::OptBlock->new($classvars, $theme);

  my $ret;
  $ret = start_form(-method=>"post", -action=>"$config->{'cgidir'}/admin.cgi");
  $ret .= $standardindex->get();
  $ret .= $createcategory->get();
  $ret .= "<INPUT TYPE=hidden NAME=prev_op VALUE=$prev_op><font size=1>";
  $ret .= submit(-name=>"op", -value=>$lang->{'SaveCategory'});
  $ret .= "</font>".end_form()."</TD>";
  return $ret;
}

sub _get_createcategory{
  my ($self, $STATE) = @_;
  my $spdb = $self->{'spdb'};
  my $DBH = $spdb->{'dbh'};
  
  my $op = $STATE->{'prev_op'};
  my $ret = "";
  my $selectedcategory = $STATE->{selectedcategory};

  my $catidq = $DBH->quote($selectedcategory);
  my ($catidv, $titlev, $catorderv); 
  ($catidv, $titlev, $catorderv) = 
    $spdb->db_select_cols("catid, cattitle, catorder", 
			 "Cats", "catid=$catidq") if $catidq;

  my $catid = textfield(-name=>'categoryid', -size=>30, -value=>$catidv);
  my $title = textfield(-name=>'categorytitle', -size=>30, -value=>$titlev);

  # --- find the number of categories
  my $cnt = $spdb->db_count("Cats");
  my $tmp = {}; $cnt++ if $op ne "modifycategory";
  for(my $i=1; $i<=$cnt; $i++){ $tmp->{$i} = $i; }
  my $order = Templates::Admin::SmallPig::select_option($tmp, "categoryorder", $catorderv);
  
  $ret .= qq!
      <TR><TD><TABLE BORDER=0 CELLPADDING=10><TR><TD>
	<B>$lang->{'cat_title'}:</B><BR><font size=1>$title</font><BR><BR>
	<B>$lang->{'keyword'}:</B> ($lang->{'must_be_20c'})<BR><font size=1>$catid</font><BR><BR>
	<B>$lang->{'cat_order'}</B><BR><font size=1>$order</font><BR>
      </TD></TR></TABLE></TD><TR>
      <INPUT TYPE=hidden NAME=prev_catid VALUE="$selectedcategory">
      <INPUT TYPE=hidden NAME=prev_catorder VALUE=$catorderv>
    !;
  return $ret;
}

return 1;
