package Templates::Admin::ShowStat;

use SmallPigVars qw($config);
use SPDB;
use CGI qw(:standard :cgi-lib);
use Templates::Admin::Block;
use Templates::Admin::OptBlock;
use strict;
use vars qw(@ISA);

@ISA = qw(Templates::Admin::Block);
my %CACHE;

my $lang;

sub new{
  my ($class, $STATE) = @_;
  my $self = Templates::Admin::Block->new($STATE);
  $self->{'spdb'} = SPDB->new();
  $self->{'STATE'} = $STATE;
  
  my $id = join '', sort values %$self, "showstatblock";
  return $CACHE{$id} if $CACHE{$id};
  return $CACHE{$id} = bless $self, $class;
}

sub display{
  my ($self) = @_;
  my ($STATE, $spdb) = map{$self->{$_}} qw(STATE spdb);
  my $DBH = $spdb->{'dbh'};
  my $theme = $STATE->{'theme'};

  $lang = $STATE->{'langptr'};

  my $standardindex = Templates::Admin::StandardIndex->new($STATE);

  my $content = $self->_get_geninfo();
  my $classvars = {('title' => $lang->{'gen_info'},
		    'content' => $content)};
  my $geninfo = Templates::Admin::OptBlock->new($classvars, $theme);
  
  $content = $self->_get_boardinfo();
  $classvars = {('content' => $content, 'space' => "<P>")};
  my $boardinfo = Templates::Admin::OptBlock->new($classvars, $theme);
    
  my $ret;
  $ret  = $standardindex->get();
  $ret .= $geninfo->get();
  $ret .= $boardinfo->get();

  return $ret;
}

sub _get_geninfo{
  my ($self) = @_;
  my ($STATE, $spdb) = map{$self->{$_}} qw(STATE spdb);
  my $ret;

  my ($ta, $tm, $tu, $th, $tp, $cp, $tmp);
  
  $ta = $spdb->db_count("Users", "isadmin=1");
  my ($mods, $cnt) = $spdb->db_select_many(1, "DISTINCT uid", "Moderators");
  $tm = $cnt;
  $tu = $spdb->db_count("Users");
  $tu = $tu - ($ta+$tm);
  $th = $spdb->db_sum("hits", "Posts");
  $tp = $spdb->db_count("Posts");
  $cp = $spdb->db_count("Posts", "DAYOFYEAR(NOW())=DAYOFYEAR(date)");
  $tm ||= 0;
  
  $ret .= qq!
<TR>
<TD WIDTH=30%><B>$lang->{'total_admins'}:</B></TD>
<TD>$ta</TD>
</TR>
<TR>
<TD WIDTH=30%><B>$lang->{'total_mods'}:</B></TD>
<TD>$tm</TD>
</TR>
<TR>
<TD WIDTH=30%><B>$lang->{'total_users'}:</B></TD>
<TD>$tu</TD>
</TR>
<TR>
<TD WIDTH=30%><B>$lang->{'total_hits'}:</B></TD>
<TD>$th</TD>
</TR>
<TR>
<TD WIDTH=30%><B>$lang->{'total_posts'}:</B></TD>
<TD>$tp</TD>
</TR>
<TR>
<TD WIDTH=30%><B>$lang->{'curr_date_posts'}:</B></TD>
<TD>$cp</TD>
</TR>
  !;

  return $ret;
}

sub _get_boardinfo{
  my ($self) = @_;
  my ($STATE, $spdb) = map{$self->{$_}} qw(STATE spdb);
  my $DBH = $spdb->{'dbh'};
  my $ret;
  my $theme = $STATE->{'theme'};
  my ($uid, $userstatus) = map{ $STATE->{$_} } qw(uid userstatus);

  $ret .= qq!
<TR BGCOLOR=$theme->{'dhdrcolor'} CELLPADDING=2>
  <TD WIDTH=10>&nbsp;</TD>
  <TD CLASS=bheader2 WIDTH=40%>$lang->{'forums'}</TD>
  <TD WIDTH=15% CLASS=bheader2>$lang->{'total_hits'}</TD>
  <TD WIDTH=15% CLASS=bheader2>$lang->{'total_posts'}</TD>
  <TD WIDTH=15% CLASS=bheader2>$lang->{'today_posts'}</TD>
  <TD WIDTH=15% CLASS=bheader2>$lang->{'avg_posts'}</TD>
</TR>
  !;
  
  my ($cats) = $spdb->db_select_many(1, "catid, cattitle",
				    "Cats","", "ORDER BY catorder");

  # --- if there is no categories
  unless($cats){
    $ret .= qq| 
<TR><TD COLSPAN=3>$lang->{'no_categories'}
</TD></TR> 
  |;
  }

   # --- loop through all the categories
  foreach (@$cats){
    my ($catid, $cattitle) = @$_;
    my $catidq = $DBH->quote($catid);
    
    my $select = "hits, B.sid, title";
    my $from;
    my $where = " B.sid=BC.sid AND
                  BC.catid=$catidq ";
    
    # --- user forum visible for ruser, gmem, mod
    $where .= "AND level>=56 AND active=1 " if($userstatus =~ /mod/);

    if($userstatus eq "admin"){}
    # --- from admin page
    else{
      $where .= "AND B.sid=M.sid AND uid=$uid";
      $from = "Moderators AS M, ";
    }
    $from .= " Boards AS B, BoardBelongToCat AS BC";
    
    my ($boards) = $spdb->db_select_many(1, $select, 
					$from, 
					$where);

    # --- if user is a moderator in group private forums
    if($userstatus =~ /mod/){
	$where = "BC.sid=M.sid AND uid=$uid AND active=1 AND
                (level=32 OR level=48) AND B.sid=M.sid AND
                BC.catid=$catidq ";
	$from = "Boards AS B, BoardBelongToCat AS BC, Moderators AS M";
	my ($boards1) = 
	    $spdb->db_select_many(1, $select, $from, $where);
	unshift @$boards, @$boards1 if $boards1;      
    }
    
    # --- sort the boards by sorder
    @$boards = sort { $a->[6] <=> $b->[6]; } @$boards if $boards;
    
    $ret .= qq!
      <TR BGCOLOR=$theme->{'lhdrcolor'}>
	<TD COLSPAN=6>
	  <B>$cattitle</B>
	</TD>
      </TR>
	!;
    
    # --- no forums
    unless($boards){
      $ret .= qq| 
  <TR BGCOLOR=$theme->{'boxbgcolor'}>
    <TD WIDTH=10 BGCOLOR=$theme->{'lhdrcolor'}>&nbsp;
    </TD><TD COLSPAN=5>
      $lang->{'no_forums'}
    </TD>
  </TR>
 <TR BGCOLOR=$theme->{'dhdrcolor'}><TD WIDTH=10></TD>
	<TD COLSPAN=5>
      </TD>
      </TR>
    |;
    }
    else {
      foreach (@$boards) {
	my ($hits, $sid, $title) = @$_;
	my $sidq = $DBH->quote($sid);
	
	$hits = $spdb->db_sum("hits", "Posts", "sid=$sidq");
	my $tp1 = $spdb->db_count("Posts", 
				"sid=$sidq AND 
                                 DAYOFYEAR(NOW())=DAYOFYEAR(date)");
	my $tp2 = $spdb->db_count("Posts", "sid=$sidq");

	my $max = $spdb->db_max("TO_DAYS(date)", "Posts");
	my $min = $spdb->db_min("TO_DAYS(date)", "Posts");
	my $diff = ($max - $min) || 1;
	my $ap = $tp2/$diff;
	$ap = sprintf("%10.2f", $ap);

	$ret .= qq!
      <TR BGCOLOR=$theme->{'boxbgcolor'}>
	<TD WIDTH=10 BGCOLOR=$theme->{'lhdrcolor'}>&nbsp;</TD>
	<TD WIDTH=40%><B>$title</B></TD>
	<TD WIDTH=15%>$hits</TD>
	<TD WIDTH=15%>$tp2</TD>
        <TD WIDTH=15%>$tp1</TD>
	<TD WIDTH=15%>$ap</TD>
      </TR>
      <TR BGCOLOR=$theme->{'dhdrcolor'}><TD WIDTH=10></TD>
	<TD COLSPAN=5>
      </TD>
      </TR>
	!;
      }
    }
    
  }

  return $ret;
}

return 1;
