#!/usr/local/bin/perl

use SmallPig;
use SPDB;
use SPCGI;

use strict;

my $lang;

sub main{
  #print "Content-type: text/html\n\n";
    
  # --- create a SPDB object
  my $spdb = SPDB->new;
  
  my $spcgi = SPCGI->new($spdb);
  $spcgi->set_state_for_client();
  
  # --- load the lang module
  $lang = $spcgi->{STATE}->{langptr} = SmallPig::get_lang_ptr($spcgi->{STATE}->{lang}, 
							      "user");

  my $STATE = $spcgi->{'STATE'};
  my $op = $STATE->{'op'};

  my ($template);
  my $cookie = "";
  if($op eq "whosonline"){
      require Templates::User;
      
      $template = Templates::User->new($spcgi, $spdb, "whosonline");
  }
  elsif($op eq "logout"){
        
      require Ops::User;
      my $obj = Ops::User->new($STATE, $spdb);
      
      my ($succ, $err_msg, $btitle, $url);
      
      ($succ, $err_msg, $btitle, $url, $cookie) = $obj->logout();

      require Templates::Caution;
      
      # --- create a template object
      $template = 
	Templates::Caution->new($spcgi, $spdb,
				$btitle, 
				$err_msg, $url);

  }
  elsif($op eq $lang->{'Login'}){
  
      require Ops::User;
      my $obj = Ops::User->new($STATE, $spdb);
      
      my ($succ, $err_msg, $btitle, $url);
      
      ($succ, $err_msg, $btitle, $url, $cookie) = $obj->login();

      require Templates::Caution;
      
      # --- create a template object
      $template = 
	Templates::Caution->new($spcgi, $spdb,
				$btitle, 
				$err_msg, $url);

  }
  elsif($op eq $lang->{'Mailpasswd'}){

      require Ops::User;
      my $obj = Ops::User->new($STATE, $spdb);
      
      my ($succ, $err_msg, $btitle, $url);
      
      ($succ, $err_msg, $btitle, $url, $cookie) = $obj->forget_passwd();
      
      require Templates::Caution;
      
      # --- create a template object
      $template = 
	Templates::Caution->new($spcgi, $spdb,
				$btitle, 
				$err_msg, $url);

  }
  elsif($op eq "userinfo"){
      my ($succ, $err_msg) = check_user_privlev($STATE, $spdb);

      if($succ){  
	  require Templates::User;
	  
	  $template = Templates::User->new($spcgi, $spdb);

#	  $title = "User profile";
      }
      else{
	  require Templates::Caution;
      
	  # --- create a template object
	  $template = 
	    Templates::Caution->new($spcgi, $spdb,"", $err_msg);
      }
	  
  }
  elsif($op eq "confirm"){
      require Ops::User;
      my $obj = Ops::User->new($STATE, $spdb);
      
      my ($succ, $err_msg, $btitle, $url);
      
      ($succ, $err_msg, $btitle, $url, $cookie) = $obj->confirm();
      
      require Templates::Caution;
      
      # --- create a template object
      $template = 
	Templates::Caution->new($spcgi, $spdb,
				$btitle, 
				$err_msg, $url);

  }
  elsif($STATE->{'userstatus'} ne "anon"){
      if($op eq "edituser"){
	  require Templates::User;
	  
	  $template = Templates::User->new($spcgi, $spdb, "edituser");

#      $title = "$lang->{'edit_user'} $user";
      }
      elsif($op eq $lang->{'saveuser'}){
	  require Ops::User;
	  my $obj = Ops::User->new($STATE, $spdb);
	  
	  my ($succ, $err_msg, $btitle, $url);
      
	  ($succ, $err_msg, $btitle, $url, $cookie) = $obj->save_user1();
	  
	  require Templates::Caution;
	  
	  # --- create a template object
	  $template = 
	    Templates::Caution->new($spcgi, $spdb,
				    $btitle, 
				    $err_msg, $url);

      }
      elsif($op eq "preferences"){
	  require Templates::User;
	  
	  $template = Templates::User->new($spcgi, $spdb, "preferences");
	  
#	$title = $lang->{'edit_pref'};
      }
      elsif($op eq $lang->{'SavePreferences'}){
	  require Ops::User;
	  my $obj = Ops::User->new($STATE, $spdb);
	  
	  my ($succ, $err_msg, $btitle, $url);
      
	  ($succ, $err_msg, $btitle, $url, $cookie) = $obj->save_preferences1();
	  
	  require Templates::Caution;
	  
	  # --- create a template object
	  $template = 
	    Templates::Caution->new($spcgi, $spdb,
				    $btitle, 
				    $err_msg, $url);
      }
      elsif($op eq "posthist"){
	  require Templates::UserPost;
	  
	  $template = Templates::UserPost->new($spcgi, $spdb);

#      $opt_blocks = posthist($STATE);
#      $title = $lang->{'posthist1'};
      }
      elsif($op eq "subscription"){
	  require Templates::Subscription;
	  
	  $template = Templates::Subscription->new($spcgi, $spdb, "subscribe");
	  
#	  $opt_blocks = subscription($STATE);
#      $title = $lang->{'user_subscription1'};
      }
      elsif($op eq "subscribe"){
	  require Templates::Subscription;
	  
	  $template = Templates::Subscription->new($spcgi, $spdb, "subscription");
#      $opt_blocks = subscribe($STATE);
#      $title = $lang->{'subscribe3'};
      }
      elsif($op eq "unsubscribe"){
	  require Ops::Subscribe;
	  my $obj = Ops::Subscribe->new($STATE);
	  my ($succ, $err_msg, $btitle, $url) = $obj->user_unsubscribe();

	  require Templates::Caution;
	  
	  # --- create a template object
	  $template = 
	    Templates::Caution->new($spcgi, $spdb,
				    $btitle, 
				    $err_msg, $url);  
      }
      elsif($op eq $lang->{'Subscribe'}){
	  require Ops::Subscribe;
	  my $obj = Ops::Subscribe->new($STATE);
	  my ($succ, $err_msg, $btitle, $url) = $obj->user_subscribe();
	  
	  require Templates::Caution;
	  
	  # --- create a template object
	  $template = 
	    Templates::Caution->new($spcgi, $spdb,
				    $btitle, 
				    $err_msg, $url);
      }
      elsif($op eq "editsub"){
	   require Templates::Subscription;
	  
	  $template = Templates::Subscription->new($spcgi, $spdb, "editsub");
#      $title = $lang->{'edit_sub1'};
      }
      elsif($op eq $lang->{'SaveSubscription'}){
	  require Ops::Subscribe;
	  my $obj = Ops::Subscribe->new($STATE);
	  my ($succ, $err_msg, $btitle, $url) = $obj->save_subscription();
	  
	  require Templates::Caution;
	  
	  # --- create a template object
	  $template = 
	    Templates::Caution->new($spcgi, $spdb,
				    $btitle, 
				    $err_msg, $url);
      }
      elsif($op eq "umovethreads"){
	  require Templates::UserPost;
	  $template = Templates::UserPost->new($spcgi, $spdb, "threads");

#	$title = $lang->{'movecopy_threads1'};
      }
      elsif($op eq $lang->{'MoveThreads'}){
	  require Ops::User;
	  
	  my $obj = Ops::User->new($STATE, $spdb);
	  
	  my ($succ, $err_msg, $btitle, $url);
      
	  ($succ, $err_msg, $btitle, $url, $cookie) = $obj->move_threads();
	  
	  require Templates::Caution;
	  
	  # --- create a template object
	  $template = 
	    Templates::Caution->new($spcgi, $spdb,
				    $btitle, 
				    $err_msg, $url);
      }
      else{
	  require Templates::User;
	  
	  $template = Templates::User->new($spcgi, $spdb);
	  
#	  $title = "$lang->{'user_profile'} $user";
      }
  }
  elsif($op eq $lang->{'Register'}){
      require Ops::User;
      my $obj = Ops::User->new($STATE, $spdb);
      
      my ($succ, $err_msg, $btitle, $url);
      
      ($succ, $err_msg, $btitle, $url, $cookie) = $obj->register();

      if(!$succ){
	  require Templates::User;
	  
	  $template = Templates::User->new($spcgi, $spdb, "register");
	  
	  $template->{'caution'} = $err_msg;
      }
      else{
	  require Templates::Caution;
	  
	  # --- create a template object
	  $template = 
	    Templates::Caution->new($spcgi, $spdb,
				    $btitle, 
				    $err_msg, $url);
      }
  }
  elsif($op eq "login"){

      require Templates::User;
      
      $template = Templates::User->new($spcgi, $spdb, "login");
      
#    $title = $lang->{'Login'};
  }
  elsif($op eq "register"){

      require Templates::User;
      
      $template = Templates::User->new($spcgi, $spdb, "register");
      
#    $title = $lang->{'Register'};
  }
  elsif($op eq "forgetpasswd"){
      require Templates::User;
      
      $template = Templates::User->new($spcgi, $spdb, "forgetpasswd");
      
  }
  else{
      require Templates::Caution;
	
      # --- create a template object
      $template = 
	Templates::Caution->new($spcgi, $spdb,
				"", 
				$lang->{'cant_found_page'}, 
				$ENV{SCRIPT_NAME}."?op=login");
  }
  
  if(defined($template)){
      $template->print_http_header($cookie);
      $template->print_template();	
  }
}

sub check_user_privlev{
  my ($STATE, $spdb) = @_;
  # --- get the caution obj
  my ($uid, $userstatus) = map{ $STATE->{$_} } qw(uid userstatus);
  my ($privlev) = $spdb->db_select_cols("privlev", "Users", "uid=$uid");
  if($privlev==1 && $userstatus ne "admin"){
      return (0, $lang->{'user_info_not_avail'});
  }
  return (1); 
}

main();
