# $Id: fix_indexes.py,v 1.2 2003/01/07 17:39:42 fresh Exp $
from Products.UpdateSupport.updatesupport import _updateall,_log

metatype_mapping = {
    'Field Index':'FieldIndex',
    'Text Index':'TextIndex',
    'Keyword Index':'KeywordIndex'
    }

def do_update(self):
    """ Set the reply count and moderated count to what they should be """
    
    thestring=''
    reindex=0
    for id,index in self._catalog.indexes.items():
        mt = index.meta_type
        if mt in ['Field Index','Text Index','Keyword Index']and not hasattr(index,'__implements__'):
            self.delIndex(id)
            self.addIndex(id,metatype_mapping[mt])
            reindex=1
            thestring = _log(thestring,'Index %s of type %s updated, currently empty' % (id,mt))

    if reindex:
        self.recatalogPostings()
        thestring = _log(thestring,'Re-catalogued everything.')
    
    return thestring

def updateall(self):
    return _updateall(self,do_update, metatypes=['Squishdot Site'])
