/*
	writer	: Ma Su An
	E-Mail	: msa@wri.com.cn
	
	Copyright by Ma Su An.
	All rights reserved.
	Permission to use ,copy,modify,and distribute this software for
	individual use and without fee is granted with that condition:

    	Every copy of this software must have the writer's name displayed 
	on the top label.
*/

// filename : trans.h
// msa 1999.1

#ifndef TRANS_H
#define TRANS_H

#include <assert.h>
#include <ctype.h>
#include <unistd.h>
#include <time.h>
#include <fcntl.h>
#include <stdlib.h>
#include <X11/Xlib.h>
#include <Xm/Xm.h>
#include <X11/extensions/shape.h>
#include <Xm/CutPaste.h>
#include <Xm/Protocols.h>
#include <Xm/TextF.h>
#include <Xm/Separator.h>
#include <Xm/List.h>
#include <Xm/Frame.h>
#include <Xm/ToggleB.h>
#include <Xm/RowColumn.h>
#include <Xm/Form.h>
#include <Xm/Label.h>
#include <Xm/LabelG.h>
#include <Xm/ScrolledW.h>
#include <Xm/CascadeB.h>
#include <Xm/PushB.h>
#include <Xm/DrawnB.h>
#include <Xm/ArrowB.h>
#include <strstream.h>
#include <fstream.h>

#include "regdef.h"

const int MAX_HIS_NUM=8;
const int MAX_STR_LEN=256;
const int START_CAPACITY=80000;
const int MAX_MATCH_ITEM=20;
const int INTERVAL=500; 		// check selection interval.
const int FLOAT_TIMEOUT=600;		// interval used by float window.
const int OFFSETX=16;
const int OFFSETY=0;
const int DISAPPEAR_DISTANCE=32;
const int CLIPBUFFLEN=100;
const int MAX_SELTIME_COUNT=3;
const int MAX_COLOR_LOST=0;
const char* const HZFONT_S="hz*";
const char* const YBFONT_S="yb*";
const char* const DICFILE_S="/transdic";
const char* const YBFILE_S="/yblib";
const char* const FONTDIR_S="/hzfont";
const char* const DEFAULTTRANSHOME_S="/opt/dic";
const char* const HISTORY_S="ʷ";
const char* const CURRENT_S="ǰ";
const char* const RULE_MATCH_S="ƥ";
const char* const SCAN_S="Ļѡȡ";
const char* const HELP_S="";
const char* const EXIT_S="˳";
const char* const LAST_S="һ";
const char* const NEXT_S="һ";
const char* const NOTFOUND_S="[ ûз! ]";
const char* const RULE_ERR_S="[ ! ]";
const char* const BACKIMAGEFILE_S="/back.gif";
const char* const ICONIMAGEFILE_S="/icon.gif";
const char* const ICONMASKFILE_S="/iconmask.xbm";
const char* const HELPIMAGEFILE_S="/help.gif";
const char* const HELPMASKFILE_S="/helpmask.xbm";
const char* const EXITIMAGEFILE_S="/exit.gif";
const char* const EXITMASKFILE_S="/exitmask.xbm";
const char* const LASTIMAGEFILE_S="/last.gif";
const char* const LASTMASKFILE_S="/lastmask.xbm";
const char* const NEXTIMAGEFILE_S="/next.gif";
const char* const NEXTMASKFILE_S="/nextmask.xbm";

// AD gifs
const char* const JOYOLINUX_S="/joyo.gif";
const char* const SINA_S="/sina.gif";
const char* const CHINABYTE_S="/chinabyte.gif";
const char* const NETEASE_S="/netease.gif";
const char* const WUHAN_S="/wuhan.gif";
const char* const WRI_S="/wri.gif";

class WordItem;
class Lib;
class ListWin;
class Selection;
class FloatWin;
class HistoryList;
class UserWin;
class AppCore;
class AppFrame;

extern char sErrorMessage[];

//=============================================================================
/* 
  MyString is a string class. It doesn't alloce memory itsself to store data.
  It just has a pointer to point the string.That is unlike CString.
  If you use CString instead of MyString,every CString instance will alloce
memory and copy string into itsself,it will very slow when there are a large
number of instances.
  In this programme,the word library file is mapped into memory,and MyString
instances point to the strings stored in the memory block.No need to alloce 
memory and copy strings. 
*/

class MyString
{
private:
	char *sContent;
	friend int operator==(const MyString &oLItem,const MyString &oRItem);
	friend int operator<(const MyString &oLItem,const MyString &oRItem);
public:
	MyString();
	MyString(char *str);
	char *data() const { return(sContent); }
	int operator==(const char *sString);
	int operator<(const char *sString);
};

//=============================================================================
class WordItem
{
private:
	MyString msEnglish;
	MyString msChinese;
	friend int operator==(const WordItem &oLItem,const WordItem &oRItem);
	friend int operator<(const WordItem &oLItem,const WordItem &oRItem);
public:
	WordItem(char *sNewEnglish,char *sNewChinese);
	int operator==(const char* sItem);
	int operator<(const char* sItem);
	const char *sGetMeaning() const;
	const char *sGetWord() const;
};

//=============================================================================
int operator==(const WordItem &oLItem,const WordItem &oRItem);
int operator<(const WordItem &oLItem,const WordItem &oRItem);

//=============================================================================
class Lib
{
private:
	WordItem** aWordLib;
	int iLength;
	int iCapacity;
public:
	Lib();
        Boolean bGetLib(const char *sDictionaryFile);// read dictionary file.
	Boolean bLookup(const char* sWord,int *pIndex);
	Boolean bLookupWithRule(const MSARegExp& rule,int* aIndex,int iBuffLen);
	Boolean bSimpleLookup(const char* rule,int* aIndex);
	class WordItem &operator[](int i);
	int length() { return(iLength); }
	void vSaveIt();
};

//============================================================================
class Libs
{
private:
	Lib oLib;		// word library.
	Lib oYBLib;		// YinBiao library.
	Boolean bMakeRule(const char* sWord,char* sRuleString,int iLength);
public:
	Libs();
	Boolean bGetWordsWithRule(const char* sWord,int* aiIndexes,int iLen);
	Boolean bSimpleGetWord(const char* sWord,int& iWordIndex);
	const char* sGetYB(const char* sWord);
	const WordItem* poGetWordItem(int iIndex);
	Boolean bGetLib();
	int iLength();
};

//=============================================================================
class ListWin
{
private:
	AppCore* poAppCore;
	Widget wList;		// list to contain history or current Lib words.

	static void vChooseCallback(Widget w,XtPointer thisObj,XtPointer cbs);
	static void vClickCallback(Widget w,XtPointer thisObj,XtPointer cbs);
	void vChoose(XmString xmsWord);
	void vClick(XmString xmsWord);
public:
	ListWin(AppCore* pAppCore);
	Widget wCreate(Widget wParent);
	void vSetBackground(Pixmap pixBack);
	void vClear();
	void vInsertLast(const char* sNewItem);
	void vInsertFirst(const char* sNewItem);
	void vDeleteFirst(int iCount);
	void vDeleteLast(int iCount);
	int iVisibleCount();
	int iLength();
};

//=============================================================================
class HistoryList
{
private:
	AppCore* poAppCore;
	Widget wList;
	static void vChooseCallback(Widget w,XtPointer thisObj,XtPointer cbs);
	void vChoose(XmString xmsWord);
	static void vButtonEventCallback(Widget w,XtPointer thisObj,
		XEvent* , Boolean* );
	void vButtonEvent(Boolean* continue_to);
public:
	HistoryList(AppCore* pAppCore);
	Widget wCreate(Widget wParent);
	void vInsert(const char* sNewItem);
	int iLength();
	int iVisibleCount();
	void vPopup();
	void vPopdown();
	void vToggle();
};

//=============================================================================
class AD
{
private:
	Widget wForm;
	Widget wJoyo;
	Widget wWuhan;
	Widget wSina;
	Widget wChinabyte;
	Widget wWri;
	static void vCallNetscape(Widget,XtPointer,XtPointer);
public:
	Widget wCreate(Widget wParent);
	void vSetPixmap();
	void vShow();
	void vHide();
};

//=============================================================================
class UserWin 
{
private:
	AppCore *poAppCore;
	Widget wWordText; 	// the textfield to input word.
	Widget wMeaning;	// meaning label.
	Widget wWordLabel;
	Widget wArrow;

	HistoryList oHistoryList;
	AD oAD;

	static void vEnterWordCallback(Widget w,XtPointer thisObj,
		XtPointer cbs);
	static void vWordChangeCallback(Widget w,XtPointer thisObj,
		XtPointer cbs);
	static void vArrowCallback(Widget w,XtPointer thisObj,XtPointer cbs);
	void vEnterWord();
	void vWordChange();
	void vArrowActivate();
	Widget wCreateMeaningWin(Widget wParent);
public:
	UserWin(AppCore *pAppCore);
	Widget wCreate(Widget wParent);
	void vSetBackground(Pixmap pixBack);
	void vClearMeaningWin();
	void vShowToMeaningWin(const char *sMessage);
	void vShowToLabel(XmString xmsLabelString);
	void vShowToLabel(const char* sWord);
	void vPutToText(const char *sWord);
	void vClearText();
	void vToggleHisList();
	void vInsertHisList(const char* sWord);
	void vActivateText();
	void vSetADPixmap();
	void vADHide();
	void vADShow();
	Boolean bTextSelected();
	void vSetTextSelection();
};

//=============================================================================
class FloatWin
{
private:
	Widget wShell;
	Widget wLabel;
	int iRecordX;
	int iRecordY;
	Boolean bMapped;
	void vRecordXY();
	static void vTimeOutCallback(XtPointer thisObj,XtIntervalId *nouse);
	void vTimeOut();
	void vGoTo(int iX,int iY);
public:
	FloatWin();
	~FloatWin();
	void vSetBackground(Pixmap pixBack);
	Widget wCreate(Widget wParent);
	void vShow(const char *sMessage);
	void vShow(const XmString sMessage);
	void vPopup();
	void vPopdown();
	void vGoToRecordedXY();
};

//============================================================================
class Selection
{
private:
	AppCore* poAppCore;
	Widget w;
	char sLastClipWord[MAX_STR_LEN+1];
	Boolean bSelectionReach;
	int iSelTimeCount;

	static void vTimeOutCallback(XtPointer thisObj,XtIntervalId *nouse);
	static void vSelectionCallback(Widget w,XtPointer thisObj,
		Atom *selection,Atom *type,XtPointer value,
		unsigned long *length,int *format);
	void vSelectionReceived(char* sValue,int iLength);
	void vTimeOut();
	void vRequireSelection();
	Boolean bEnable();
public:
	Selection(AppCore* pAppCore);
	void vStart(Widget wToUse);
};

//============================================================================
class CfgWin
{
private:
	AppCore* poAppCore;
	Widget wUseRuleToggle;
	Widget wScanClipBoardToggle;
	Widget wHelpButton;
	Widget wExitButton;
	Widget wLastButton;
	Widget wNextButton;
	static void vHelpCallback(Widget w,XtPointer thisObj,XtPointer cbs);
	static void vExitCallback(Widget w,XtPointer thisObj,XtPointer cbs);
	static void vLastCallback(Widget w,XtPointer thisObj,XtPointer cbs);
	static void vNextCallback(Widget w,XtPointer thisObj,XtPointer cbs);
	void vHelp();
	void vExit();
	void vLast();
	void vNext();
public:
	CfgWin(AppCore* pAppCore);
	Boolean bUseRule();	// whether to use regular expression
	Boolean bScanClipBoard(); // whether to scan clipboard.
	Widget wCreate(Widget wParent);
	void vSetBackground(Pixmap pixBack);
	void vSetButtonPixmap();
};

//============================================================================
class AppCore
{
private:
	AppFrame* poAppFrame;
	int iCurrentIndex;

	// view
	Widget wTopLabel;
	UserWin oUserWin;
	ListWin oListWin;
	CfgWin oCfgWin;
	FloatWin oFloatWin;

	// doc
	Libs oLibs;
	Selection oSelection;

	void vSetBackground();
	Widget wCreateTopLabel(Widget wParent);
	void vSimpleLookupToFloat(const char* sWord);
	void vSimpleLookupToUserWin(const char* sWord,int* piIndex=NULL);
	void vLookupWithRuleToUserWin(const char* sWord);
	void vListWords(int iStartIndex);
	XmString xmsWordWithYB(const char* sWord,const char* sYB);
	void vShowWordToUserWin(const WordItem &oWordToShow,const char* sYB);
	void vShowWordToFloat(const WordItem &oWordToShow,const char* sYB);
	void vAddListFirst(int iIndex,int iCount);
	void vAddListLast(int iIndex,int iCount);
	void vFillList(int iIndex);
public:
	AppCore(AppFrame* pAppFrame);
	Widget wCreate(Widget wParent);
	Boolean bScreenFetchEnable();
	void vShowHelp();
	void vArrowActivate();
	void vQuit();
	void vAfterRealize();
	void vNext();
	void vLast();

	void vShowNotFoundToFloat(const char* sWord,const char* sReason);
	void vShowNotFoundToUserWin(const char* sWord,const char* sReason);

	void vUserWinEnterWord(const char* sWord);
	void vUserWinWordChange(const char* sWord);
	void vHistoryChoose(const char* sWord);
	void vWordSelected(const char* sWord);
	void vListClick(const char* sWord);
	void vListChoose(const char* sWord);
};

//============================================================================
class AppFrame
{
private:
	XtAppContext app;
	Widget wToplevel;

	AppCore oAppCore;

	static void vDeleteCallback(Widget w,XtPointer thisObj,XtPointer cbs);
	void vSetIcon();
	void vSetFontPath();
	void vRaiseUp();
public:
	AppFrame();
	void vInit(int argc,char **argv);
	void vQuit();
	void vLoop();
};

//============================================================================
int mystrcmp(const char *s1,const char *s2);
void vShowErrorToTerm(const char *sMessage);
XmString xmsCreateChinese(const char *sWord);
XmString xmsGetYB(const char *sWord);
XmString xmsGetYBWithBracket(const char *sWord);
Boolean bGetHomeDir();
Pixmap pixCreatePixmap(Widget w,const char *sImageFile,int* piColorLost);
Pixmap pixGetPixmap(Widget w,const char *sImageFile);
Pixmap pixForceGetPixmap(Widget w,const char *sImageFile);
Pixmap pixGetBitmap(Widget w,const char *sImageFile);
Boolean bIsChinese(char ch);
Boolean bHaveFont(Display* display,const char* sFontName);
Boolean bDirOK(const char* sPath);
Boolean bPointerIn(Widget w);
void vGetPointerXY(Display* display,int& iX,int& iY);
Boolean bContainRule(const char* sWord);
int main(int argc,char **argv);

/************************************* END ***********************************/
	
#endif
