/*
 * Storm Package Manager
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */


#include <sys/types.h>
#include <sys/stat.h>
#include <sys/vfs.h>
#include <unistd.h>

#include "../libstormpkg/libstormpkg_app_include.h"

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "stormpkg.h"
#include "depend.h"
#include "list.h"
#include "main.h"

extern int maxID;
extern char *MainState;
extern package_node ** nodes;
extern pkgCache *MainPkgCache;
extern pkgRecords *MainPkgRecords;
extern pkgDepCache *MainPkgDepCache;
extern pkgCacheFile *MainPkgCacheFile;

unsigned int ScreenWidth=60;

// Mark_Install - Put the package in the install state		
// ---------------------------------------------------------------------
void Mark_Install(struct pkgCache::PkgIterator &Pkg) {

    if (Pkg.end() == true)
        return;

    if  (MainState[Pkg->ID]&selDoing)  { //goto goback;
        //goto goback;//return;
        MainState[Pkg->ID]&=~selDoing;
        return;
        }


    MainState[Pkg->ID]|=selDoing;

    struct pkgDepCache::StateCache &S = (*MainPkgDepCache)[Pkg];
    if (S.InstBroken() == false && (S.Mode == pkgDepCache::ModeInstall ||
	        S.CandidateVer == (pkgCache::Version *)Pkg.CurrentVer())) {
        if (S.CandidateVer == (pkgCache::Version *)Pkg.CurrentVer() && S.InstallVer == 0)
	        Mark_Keep(Pkg);

        //goto goback;//return;
        MainState[Pkg->ID]&=~selDoing;
        return;
        }


   	if	(!S.CandidateVer)   {  //goto goback;
        //goto goback;//return;
        MainState[Pkg->ID]&=~selDoing;
        return;
        }
   	

    set_package_dep(Pkg);

//    if  (Pkg->CurrentVer){
//    if  (S.CandidateVer == (pkgCache::Version *)Pkg.CurrentVer()) {
    if  (!strcmp(S.CandVersion, S.CurVersion)) {
        if  ((nodes[Pkg->ID]->Selected==pkgCache::State::Purge)||(nodes[Pkg->ID]->Selected==pkgCache::State::DeInstall)){
            nodes[Pkg->ID]->Selected =pkgCache::State::Unknown;
//            struct package_node *n;
//            n=nodes[Pkg->ID];
//            n->dep_up->Selected =pkgCache::State::Unknown;
//            nodes[Pkg->ID]=n->dep_up;
////            free_structure(n);
            }
        }
    else
        nodes[Pkg->ID]->Selected =pkgCache::State::Install;

    struct pkgCache::DepIterator Dep = S.CandidateVerIter(*MainPkgCache).DependsList();
    for (; Dep.end() != true;) {
        // Grok or groups
        pkgCache::DepIterator Start = Dep;
        bool Result = true;
       for (bool LastOR = true; Dep.end() == false && LastOR == true; Dep++) {
    	    LastOR = (Dep->CompareOp & pkgCache::Dep::Or) == pkgCache::Dep::Or;
            if (((*MainPkgDepCache)[Dep] & pkgDepCache::DepInstall) == pkgDepCache::DepInstall)
	            Result = false;
            }

        if (Result == false)
            continue;

        if (MainPkgDepCache->IsImportantDep(Start) == false)
            if  (Start->Type!=pkgCache::Dep::Suggests)
                continue;

        if (Pkg->CurrentVer != 0 && Start.IsCritical() == false)
            continue;

        // Now we have to take action...
        pkgCache::PkgIterator P = Start.SmartTargetPkg();
//if  (!strcmp(P.Name(), "wish"))
        string n="";

        n+=Pkg.Name();
        n+=" ";
        n+=Start.DepType();
        n+=" ";
        n+=P.Name();
        n+="\n";
        if  (P->VersionList)
            *(nodes[Pkg->ID]->relations)+=n.c_str();
        else
            *(nodes[P->ID]->relations)="";

        *(nodes[P->ID]->relations)+=n.c_str();

//        if (((*MainPkgDepCache)[Start] & pkgDepCache::DepCVer) == pkgDepCache::DepCVer) {
        if (Start->Type != pkgCache::Dep::Conflicts) {
            if  ((Start->Type==pkgCache::Dep::Suggests)&&(P->VersionList))  set_package_dep(P);
            else  Mark_Install(P);
            continue;
            }

        // For conflicts we just de-install the package and mark as auto
//        if (Start->Type == pkgCache::Dep::Conflicts) {
        else{
            pkgCache::Version **List = Start.AllTargets();
            for (pkgCache::Version **I = List; *I != 0; I++) {
                pkgCache::VerIterator Ver(*MainPkgDepCache,*I);
                pkgCache::PkgIterator pr = Ver.ParentPkg();
                Mark_Delete(pr, true, false);
                if  (!P->VersionList){
                    string n1="";
                    n1+=pr.Name();
                    n1+=_(" provides ");
                    n1+=P.Name();
                    n1+="\n";
                    n+=n1.c_str();
                    (*(nodes[pr->ID]->relations))+=nodes[P->ID]->relations->c_str();
                    (*(nodes[pr->ID]->relations))+=n1.c_str();
                    }
	            }
            delete [] List;
            if  (!P->VersionList)
                (*(nodes[Pkg->ID]->relations))+=n.c_str();
            continue;
            }
        }
//goback:
    MainState[Pkg->ID]&=~selDoing;
    }

void Mark_Delete(struct pkgCache::PkgIterator &Pkg, bool rPurge, bool Auto)  {

    if (Pkg.end() == true)
        return;

   	pkgDepCache::StateCache &S=(*MainPkgDepCache)[Pkg];
   	if	(!S.CandidateVer)
        return;

    set_package_dep(Pkg);
    if  (!Pkg->CurrentVer){
        if ((rPurge)&&(Pkg->CurrentState!=pkgCache::State::NotInstalled))
            nodes[Pkg->ID]->Selected = pkgCache::State::Purge;
        else //if  (nodes[Pkg->ID]->Selected==pkgCache::State::Install)
            nodes[Pkg->ID]->Selected = pkgCache::State::Unknown;
        }
    else{
        if  (rPurge)
            nodes[Pkg->ID]->Selected = pkgCache::State::Purge;
        else
            nodes[Pkg->ID]->Selected = pkgCache::State::DeInstall;
        }
    if  (Auto==true){
        MainState[Pkg->ID]|=selRemove;
        MainState[Pkg->ID]|=selSelected;
        check_remove();
        }
    }


void Mark_Keep(struct pkgCache::PkgIterator &Pkg,bool Soft) {

    // Simplifies other routines.
    if (Pkg.end() == true)
        return;

   	pkgDepCache::StateCache &S=(*MainPkgDepCache)[Pkg];
   	if	(!S.CandidateVer)
        return;

    set_package_dep(Pkg);
    nodes[Pkg->ID]->Selected = pkgCache::State::Hold;
}



//set up the package wanted and add it in dependencies output anchor
void set_package_dep(struct pkgCache::PkgIterator &pi){

    package_node * node, *dnode;

    node=nodes[pi->ID];
//    dnode=node;
    //add node into dependency list, don't add twices
    if  (!node->dep_up) {
        dnode = alloc_structure_stretchable(struct package_node,strlen("noname"));
        dnode->relations=node->relations;
        strcpy(dnode->Name,"noname");
        dnode->pkg=node->pkg;
        dnode->dep_up=node;
        nodes[pi->ID]=dnode;
        list_add_tail(&dnode->up_down,&dependencies_output_anchor);
        dnode->Selected=node->Selected;
        }
    }

char *package_s[7] = {
   N_("UnInstalled"),
   N_("Unpacked"),
   N_("Partially configured"),
   N_("NotInstalled"),
   N_("Partially installed"),
   N_("Residual configuration"),
   N_("Installed")
};

char* get_selection_string(package_node * node){
//printf("node->Selected=%i\n", node->Selected);
    switch((int)node->Selected){
        case pkgCache::State::Purge:
            return _("Purge");
        case pkgCache::State::DeInstall:
            return _("Remove");
        case pkgCache::State::Install:
            return _("Install");
        case pkgCache::State::Hold:
            return _("Hold");
        case pkgCache::State::Unknown:
            if  (node->pkg->VersionList)
                return _(package_s[(int)node->pkg->CurrentState]);
            else
                fprintf(stderr, _("cant get state of a virtual package %s\n"), node->Name);
        default:
            break;
        }
    return _("UnKnown");
    }



int selection_to_state(package_node* node, int sel){
    switch(sel){
        case pkgCache::State::Install:
            return (int)pkgCache::State::Installed;
        case pkgCache::State::DeInstall:
        case pkgCache::State::Purge:
            return (int)pkgCache::State::NotInstalled;
        case pkgCache::State::Hold:
        case pkgCache::State::Unknown:
        default:
            break;
        }
    return (int)node->pkg->CurrentState;
    }





bool loop;
string desc="";

void check_remove() {

    do  {
        loop=false;
        pkgCache::PkgIterator pi=MainPkgCache->PkgBegin();
        for (;pi.end()==false;pi++){
            if  (!pi->CurrentVer)   continue;
            if  ((MainState[pi->ID]&selRemove)==selRemove)  continue;
            if  (depsafe(pi)==false)    loop=true;
            }
        }while(loop==true);

    for (pkgCache::PkgIterator pi=MainPkgCache->PkgBegin();pi.end()==false;pi++){
        if  ((MainState[pi->ID]&selRemove)!=selRemove)    continue;
        if  ((MainState[pi->ID]&selSelected)==selSelected)
            (*(nodes[pi->ID]->relations))+=_("You Want to Remove It\n");
        else{
            desc="";
            get_relation(pi);
            (*(nodes[pi->ID]->relations))+=desc.c_str();
            }
        }

    memset(MainState, 0, maxID);
    }


void get_relation(pkgCache::PkgIterator &pi) {

//if  (!strcmp(pi.Name(), "kdenetwork"))
//    printf("get_relation name=%s\n", pi.Name());

//    if  ((MainState[pi->ID]&selDoing)==selDoing) return;

    MainState[pi->ID]|=selDoing;
   	
   	pkgDepCache::StateCache &State=(*MainPkgDepCache)[pi];
   	if	(!State.CandidateVer)  {
        if  (pi->ProvidesList)  {
            struct pkgCache::PrvIterator I=pi.ProvidesList();
            for (;I.end()==false;I++)   {
                struct pkgCache::PkgIterator p=I.OwnerPkg();
                if  ((MainState[p->ID]&selRemove)!=selRemove)    continue;
                desc+=p.Name();
                if  ((MainState[p->ID]&selSelected)==selSelected)
                    desc+=_("(You Want to Remove it)");
                desc+=_(" provides ");
                desc+=pi.Name();
                desc+="\n";
                if  ((MainState[p->ID]&selSelected)!=selSelected)
                    get_relation(p);
                break;
                }
            }
        }
    else{
        struct pkgDepCache::StateCache &S = (*MainPkgDepCache)[pi];
        struct pkgCache::DepIterator Dep = S.CandidateVerIter(*MainPkgCache).DependsList();

        for (;Dep.end()==false;Dep++){
            if  (Dep->Type!=pkgCache::Dep::Depends)
            if  (Dep->Type!=pkgCache::Dep::PreDepends)
                continue;
            pkgCache::PkgIterator T=Dep.SmartTargetPkg();
            if  ((MainState[T->ID]&selRemove)!=selRemove)    continue;
            if  ((MainState[T->ID]&selDoing)==selDoing) {
                fprintf(stderr, _("Warn:: %s loop depends\n"), T.Name());
                continue;
                }
//printf("T=%s\n", T.Name());
            desc+=pi.Name();
            desc+=" ";
            desc+=Dep.DepType();
            desc+=_(" on ");
            desc+=T.Name();
            if  ((MainState[T->ID]&selSelected)==selSelected)
                desc+=_("(You Want to Remove it)");
            desc+="\n";
            if  ((MainState[T->ID]&selSelected)!=selSelected) get_relation(T);
            break;
            }
        }
    MainState[pi->ID]&=~selDoing;
    }



bool depsafe(pkgCache::PkgIterator &pi) {
    bool r=true;

   	pkgDepCache::StateCache &State=(*MainPkgDepCache)[pi];
   	if	(!State.CandidateVer)  {
        if  (pi->ProvidesList)  {
            struct pkgCache::PrvIterator I=pi.ProvidesList();
            bool  sel=false;
            for (;I.end()==false;I++)   {
                struct pkgCache::PkgIterator p=I.OwnerPkg();
                if  ((MainState[p->ID]&selRemove)==selRemove)   {
                    sel=true;
                    continue;
                    }
                if  ((p->VersionList!=0)&&(p->CurrentVer==0))   continue;
                if  (p->CurrentVer!=0)
                    if  (depsafe(p)!=false)
                        return true;
                }
            if  (sel==true){
                MainState[pi->ID]|=selRemove;
                loop=true;
                return false;
                }
            }
        return r;
        }

    struct pkgDepCache::StateCache &S = (*MainPkgDepCache)[pi];
    struct pkgCache::DepIterator Dep = S.CandidateVerIter(*MainPkgCache).DependsList();
    for (; Dep.end() != true;) {
        pkgCache::DepIterator Start, End;
        bool Result = true, relate=false;
        Dep.GlobOr(Start, End);
        while(1){
            pkgCache::PkgIterator T=Start.SmartTargetPkg();
    	    if  ((MainState[T->ID]&selRemove)==selRemove)  relate=true;
            if  (((MainState[T->ID]&selRemove)!=selRemove)&&(T->CurrentVer!=0))
                Result = false;
            if  (Start==End)    break;
            else    Start++;
            }
        if  (Result == false)
            continue;
        if  ((Start->Type!=pkgCache::Dep::Depends)&&(Start->Type!=pkgCache::Dep::PreDepends))
            continue;
        pkgCache::PkgIterator P = Start.SmartTargetPkg();
        if  (((MainState[P->ID]&selRemove)==selRemove)||((P->CurrentVer==0)&&(relate==true))||(depsafe(P)==false)) {
            MainState[pi->ID]|=selRemove;
            set_package_dep(pi);
//            if  ((P->CurrentVer!=0))
                nodes[pi->ID]->Selected=pkgCache::State::DeInstall;
            r=false;
            loop=true;
            break;
            }
        }
    return r;
    }



bool apply_change(int clean){

    pkgCache::PkgIterator   pi=MainPkgCache->PkgBegin();
    for (;pi.end()==false;pi++){
       	pkgDepCache::StateCache &State=(*MainPkgDepCache)[pi];
//if  (nodes[pi->ID]->Selected)
//{
//    printf("Apply Install %s\n", pi.Name());
//}
        if  (nodes[pi->ID]==0)  continue;
       	if	(State.CandidateVer){
//printf("Iamhere\n");
            switch(nodes[pi->ID]->Selected){
                case pkgCache::State::Purge:
                	MainPkgDepCache->MarkDelete(pi, true);
                	break;
                case pkgCache::State::DeInstall:
                	MainPkgDepCache->MarkDelete(pi);
                	break;
                case pkgCache::State::Install:
                    MainPkgDepCache->MarkInstall(pi);
                default:
                    break;
                }
            }
        }

    AcqTextStatus Stat(ScreenWidth,_config->FindI("quiet",0));
    pkgAcquire Fetcher(&Stat);

    // Read the source list
    pkgSourceList List;
    if (List.ReadMainList() == false)
        return _error->Error(_("The list of sources could not be read."));

    // Create the package manager and prepare to download
    SPtr<pkgPackageManager> PM = _system->CreatePM(MainPkgDepCache);
    if (PM->GetArchives(&Fetcher,&List,MainPkgRecords) == false ||
        _error->PendingError() == true)
        return false;

    // Display statistics
    double FetchBytes = Fetcher.FetchNeeded();
    double FetchPBytes = Fetcher.PartialPresent();
    double DebBytes = Fetcher.TotalNeeded();
    if (DebBytes != MainPkgDepCache->DebSize()) {
        cout << DebBytes << ',' << MainPkgDepCache->DebSize() << endl;
        cout << _("How odd.. The sizes didn't match, email apt@packages.debian.org") << endl;
        }

    // Number of bytes
    cout << _("Need to get ");
    if (DebBytes != FetchBytes)
        cout << autosize(FetchBytes) << "/" << autosize(DebBytes);
    else
        cout << autosize(DebBytes);
    cout << _(" of archives. After unpacking ");

    // Size delta
    if (MainPkgDepCache->UsrSize() >= 0)
        cout << autosize(MainPkgDepCache->UsrSize()) << _(" will be used.") << endl;
    else
        cout << autosize(-1*MainPkgDepCache->UsrSize()) << _(" will be freed.") << endl;

    if (_error->PendingError() == true)
        return false;

    // Check for enough free space
    struct statfs Buf;
    string OutputDir = _config->FindDir("Dir::Cache::Archives");
    if (statfs(OutputDir.c_str(),&Buf) != 0)
        return _error->Errno("statfs", _("Couldn't determine free space in %s"), OutputDir.c_str());
    if (unsigned(Buf.f_bfree) < (FetchBytes - FetchPBytes)/Buf.f_bsize)
        return _error->Error(_("Sorry, you don't have enough free space in %s"), OutputDir.c_str());


/*
    // Fail safe check
    if (_config->FindI("quiet",0) >= 2 || _config->FindB("APT::Get::Assume-Yes",false) == true){
        if (Fail == true && _config->FindB("APT::Get::Force-Yes",false) == false)
	        return _error->Error("There are problems and -y was used without --force-yes");
        }

    if (1){//}Essential == true && Saftey == true) {
        cout << "You are about to do something potentially harmful" << endl;
        cout << "To continue type in the phrase 'Yes, I understand this may be bad'" << endl;
        cout << " ?] " << flush;
        if (AnalPrompt("Yes, I understand this may be bad") == false) {
	        cout << "Abort." << endl;
	        exit(1);
            }
    }
    else {
        // Prompt to continue
        if (1){//}Ask == true || Fail == true) {
	        if (_config->FindI("quiet",0) < 2 && _config->FindB("APT::Get::Assume-Yes",false) == false) {
	            cout << "Do you want to continue? [Y/n] " << flush;
	
	        if (YnPrompt() == false) {
	            cout << "Abort." << endl;
	            exit(1);
	            }
	        }	
        }
    }
*/
    // Just print out the uris an exit if the --print-uris flag was used
    if (_config->FindB("APT::Get::Print-URIs") == true) {
        pkgAcquire::UriIterator I = Fetcher.UriBegin();
        for (; I != Fetcher.UriEnd(); I++)
            cout << '\'' << I->URI << "' " << flNotDir(I->Owner->DestFile) << ' ' <<
	        I->Owner->FileSize << ' ' << I->Owner->MD5Sum() << endl;
        return true;
        }

    // Run it
    if (_config->FindB("APT::Get::No-Download",false) == false)
        if( Fetcher.Run() == pkgAcquire::Failed)
	        return false;

    // Print out errors
    bool Failed = false;
    bool Transient = false;
    for (pkgAcquire::ItemIterator I = Fetcher.ItemsBegin(); I != Fetcher.ItemsEnd(); I++) {
        if ((*I)->Status == pkgAcquire::Item::StatDone && (*I)->Complete == true)
    	    continue;

        (*I)->Finished();

        if ((*I)->Status == pkgAcquire::Item::StatIdle) {
	        Transient = true;
	        Failed = true;
	        continue;
            }

        cerr << _("Failed to fetch ") << (*I)->DescURI() << endl;
        cerr << "  " << (*I)->ErrorText << endl;
        Failed = true;
        }

    if (_config->FindB("APT::Get::Download-Only",false) == true) {
        if (Failed == true && _config->FindB("APT::Get::Fix-Missing",false) == false)
	        return _error->Error(_("Some files failed to download"));
        return true;
        }

    if (Failed == true && _config->FindB("APT::Get::Fix-Missing",false) == false) {
        if (Transient == true) {
	        cout << _("Upgrading with disk swapping is not supported in this version.") << endl;
	        cout << _("Try running multiple times with --fix-missing") << endl;
            }

        return _error->Error(_("Unable to fetch some archives, maybe try with --fix-missing?"));
        }

    // Try to deal with missing package files
    if (PM->FixMissing() == false) {
        cerr << _("Unable to correct missing packages.") << endl;
        return _error->Error(_("Aborting Install."));
        }

//    MainPkgCacheFile->Close();
    _system->UnLock();
//    if  (PM->DoInstall()==false)  return false;
    pkgPackageManager::OrderResult Res = PM->DoInstall();
    if (Res == pkgPackageManager::Failed ||
        Res != pkgPackageManager::Completed ||
        _error->PendingError() == true ) return false;

    if  (clean){
        Fetcher.Clean(_config->FindDir("Dir::Cache::archives"));
        Fetcher.Clean(_config->FindDir("Dir::Cache::archives")+"partial/");
        }

    // Reload the fetcher object and loop again for media swapping
    Fetcher.Shutdown();
    if (PM->GetArchives(&Fetcher,&List,MainPkgRecords) == false)
        return false;
    _system->Lock();
    return true;
    }



bool DoUpdate()
{
   // Get the source list
   pkgSourceList List;
   if (List.ReadMainList() == false)
      return false;

   // Lock the list directory
   FileFd Lock;
   if (_config->FindB("Debug::NoLocking",false) == false)
   {
      Lock.Fd(GetLock(_config->FindDir("Dir::State::Lists") + "lock"));
      if (_error->PendingError() == true)
	 return _error->Error(_("Unable to lock the list directory"));
   }

   // Create the download object
   AcqTextStatus Stat(ScreenWidth,_config->FindI("quiet",0));
   pkgAcquire Fetcher(&Stat);

   // Populate it with the source selection
   if (List.GetIndexes(&Fetcher) == false)
	return false;
#if 0
   pkgSourceList::const_iterator I;
   for (I = List.begin(); I != List.end(); I++)
   {
      new pkgAcqIndex(&Fetcher,I);
      if (_error->PendingError() == true)
	 return false;
   }
#endif
   // Run it
   if (Fetcher.Run() == pkgAcquire::Failed)
      return false;

   // Clean out any old list files
   if (Fetcher.Clean(_config->FindDir("Dir::State::lists")) == false ||
       Fetcher.Clean(_config->FindDir("Dir::State::lists") + "partial/") == false)
      return false;

#if _USE_MSG_WINDOW_
    GdkEventClient  event;
    gboolean        result;
    event.data.l[4]=2;
    gtk_signal_emit_by_name((GtkObject*)main_window, "client_event", &event, &result);
#else
   GtkCTree *ctree;
   ctree = GTK_CTREE(lookup_widget(main_window,"package_tree"));
   populate_package_tree_nodes(ctree);
#endif
   return true;
}



