#import "Globals.h"

void getline(FILE *file, char *string, int maxlen)
{
	int i;
	
	for (i = 0; i < maxlen - 1 && !feof(file) && !ferror(file); i++) {
		string[i] = fgetc(file);
		if (string[i] == 0x0A) {
			string[i + 1] = 0;
			return;
		}
	}
	string[i - 1] = 0;
}

void putline(FILE *file, char *string)
{
	int i;
	
	for (i = 0; string[i] != 0 && !ferror(file); i++)
		fputc(string[i], file);
}

BOOL replace(char *string, char *value, char *newvalue)
{
	int nvlen = strlen(newvalue), vlen = strlen(value), olen = strlen(string);
	char *resultPos, *original;
	int i, pos;
	
	original = malloc(olen + 1);
	resultPos = strstr(string, value);
	strcpy(original, string);
	if (resultPos) {
		pos = resultPos - string;
		string[olen + nvlen - vlen] = 0; 
		for (i = 0; i < nvlen; i++)
			string[pos + i] = newvalue[i];
		for (i = olen - pos - vlen - 1; i > -1; i--)
			string[pos + nvlen + i] = original[pos + vlen + i];
	}
	free(original);
	
	return (resultPos != NULL);
}

BOOL musicconfig(char *cclDir, char *titleSong, char *songDir)
{
	FILE *input, *output;
	char *freeString, *revString;
	char tempString[1536];
	
	freeString = malloc(strlen(cclDir) + 128);
	strcpy(freeString, cclDir);
	strcat(freeString, "/freecraft.ccl");
	
	revString = malloc(strlen(cclDir) + 128);
	strcpy(revString, cclDir);
	strcat(revString, "/revised.ccl");
	
	input = fopen(freeString, "r");
	if (!input) return NO;
	output = fopen(revString, "w");
	if (!output) return NO;
	
	while (!feof(input) && !ferror(input) && !ferror(output)) {
		getline(input, tempString, 1024);
		if (titleSong) replace(tempString, "music/default.mod", titleSong);
		if (songDir) replace(tempString, "(dir->list (string-append (library-path) \"/music\") \"music/\")))", songDir);
		putline(output, tempString);
	}
	
	fclose(output);
	fclose(input);
	
	unlink(freeString);
	rename(revString, freeString);
	
	free(revString);
	free(freeString);
	
	return YES;
}
