/* This file is part of Strigi Desktop Search
 *
 * Copyright (C) 2007 Canonical Ltd
 * Author: Jonathan Riddell <jriddell @ ubuntu.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */
#include "trayicon.h"

#include <kdebug.h>
#include <kaction.h>
#include <kpopupmenu.h>
#include <klocale.h>
#include <kapplication.h>
#include <krun.h>
#include <kkeydialog.h>
#include <qpixmap.h>
#include <qlayout.h>
#include <qtimer.h>
#include <qdesktopwidget.h>
#include <qapplication.h>

/*
 setup quit connection and menu item
*/
TrayIcon::TrayIcon(QWidget* parent, const char* name): KSystemTray(parent, name) {
  // parent is not the app's main widget, so we need to connect to quit
  connect( this, SIGNAL(quitSelected()), this, SLOT(slotQuit()) );
  KAction* newAct = new KAction(i18n("Configure Strigi Desktop Search"), "configure",
				0,
				this, SLOT(slotConfigure()),
				actionCollection(), "configure");
  KPopupMenu* popupMenu = contextMenu();
  newAct->plug(popupMenu);

  globalAccel = new KGlobalAccel(this);
  globalAccel->insert( "Do Something", i18n("Do Something"),
	  i18n("This action allows you to do something really great with this program to "
	       "the currently open document."),
	  CTRL+Key_1, 0, this, SLOT(slotPopup()) );
  globalAccel->updateConnections();

  KAction* configureGlobal = new KAction( i18n( "Configure &Global Shortcuts..." ), "configure_shortcuts", 0, this,
					  SLOT( configureGlobalShortcuts() ), actionCollection(), "settings_global" );
  configureGlobal->plug(popupMenu);
}

/*
 move the line edit above tray icon before showing it
*/
void TrayIcon::mousePressEvent(QMouseEvent* event) {
  moveParent();
  KSystemTray::mousePressEvent(event);
}

/*
 called from menu, needed because we do not have a main widget
*/
void TrayIcon::slotQuit() {
  KApplication* app = KApplication::kapp;
  app->quit();
}

/*
 open ioslave to configure
*/
void TrayIcon::slotConfigure() {
  QString cmd = "kfmclient openURL 'strigi:/config' 'text/html'";
  KRun::runCommand(cmd);
}

/*
 called from global accelarator
*/
void TrayIcon::slotPopup() {
  QWidget* widget = (QWidget*)(parent());
  moveParent();
  widget->show();
  widget->setActiveWindow();
}

/*
 move the line edit to be above the tray icon
 FIXME this probably needs fixed for icons near the left or top of screen
*/
void TrayIcon::moveParent() {
  QWidget* widget = (QWidget*)(parent());
  int x = mapToGlobal( QPoint( 0, 0 ) ).x();
  int y = mapToGlobal( QPoint( 0, 0 ) ).y();
  // if at top of screen move it below, else move above icon
  if (y < 100) {
    y = y + height();
  } else {
    y = y - height();
  }
  //stop it falling off the edge of the screen
  QDesktopWidget* vdesktop = QApplication::desktop();
  if (x + widget->width() > vdesktop->width()) {
    x = QApplication::desktop()->width() - widget->width();
  }
  widget->move(x, y);
}

void TrayIcon::configureGlobalShortcuts() {
  KKeyDialog::configure( globalAccel, 0, false ) ;
  globalAccel->writeSettings();
  globalAccel->updateConnections();
}
