/* ------------------------------------------------------------------------ */
/*                                                                          */
/* [ptm_gen.h]              Parse Term Construction                         */
/*                          - during parse process -                        */
/*                                                                          */
/* Copyright (c) 1993 by D\olle, Manns                                      */
/* ------------------------------------------------------------------------ */

/* File generated by 'ctoh'. Don't change manually. */

#ifndef ptm_gen_INCL
#define ptm_gen_INCL


#include "symbols.h"
#include "scn_base.h"
#include "scn_abs.h"
#include "prs_dfn.h"
#include "prs_abs.h"
#include "ptm.h"


#ifdef __cplusplus
extern "C" {
#endif


/*  
   The module [ptm_gen] provides a high-level parse interface. It implements
   the construction of the parse tree / term during the parse process.
   The scan, parse and term construction functions are reentrant which offers
   the possibility of multiple concurrent parse operations.
*/

/* ------------------------- Types ------------------------------------------ */

AbstractType(PT_Diag); /* Abstract parse term diagnose type */

AbstractType(PT_Cfg); /* Abstract parse term configuration type */

/* ------------------------ Parsing & Term Construction -------------------- */

PT_Cfg PT_init(PLR_Tab PTab, Scn_Stream cStream)
/* initializes parse term construction
   for parse table 'PTab' and scan stream 'cStream';
   creates a configuration
*/
;

PT_Cfg PT_init_extscn(PLR_Tab PTab, AbsScn_T sconfig)
/* initializes parse term construction
   for parse table 'PTab' and external scanner 'sconfig';
   creates a configuration
*/
;

PT_Cfg PT_init_ext(AbsPlr_T pconfig, AbsScn_T sconfig)
/* initializes parse term construction
   for external parser 'pconfig' and external scanner 'sconfig';
   creates a configuration
*/
;

void PT_setMsgFun(void (*prMsg)(c_string msg))
/* defines 'prMsg' as ( static ) default message function
   ( 'msg': single byte character set or UTF-8 )
*/
;

void PT_setDiagFun(PT_Cfg PCfg, PT_Diag PDiag)
/* adds diagnose environment 'PDiag' to
   parse term configuration 'PCfg'
*/
;

void PT_setTokConvFun(PT_Cfg PCfg, symbol convTok(symbol tok, symbol val))
/* adds token value converter 'convTok' to
   parse term configuration 'PCfg'
   ( user-defined shift-handler )
*/
;

void PT_setNtmConvFun(PT_Cfg PCfg, PT_Term convNtm(PT_Term Tree))
/* adds nonterminal value converter 'convNtm' to
   parse term configuration 'PCfg'
   ( user-defined reduce-handler; must release each replaced source tree )
*/
;

void PT_setTokConvFunEx
     (
       PT_Cfg PCfg,
       symbol convTok(symbol tok, symbol val, Any_T ctx),
       Any_T ctx
     )
/* like PT_setTokConvFun
   Additionally, a non-NULL context 'ctx' will be passed
   to the shift-handler.
   Both handler must use the same context.
   ( currently not supported by 'pim_test' )
*/
;

void PT_setNtmConvFunEx
     (
       PT_Cfg PCfg, PT_Term convNtm(PT_Term Tree, Any_T ctx),
       Any_T ctx
     )
/* like PT_setNtmConvFun
   Additionally, a non-NULL context 'ctx' will be passed
   to the reduce-handler.
   Both handler must use the same context.
   ( currently not supported by 'pim_test' )
*/
;

void PT_setEParser
     (
       PT_Cfg PCfg,
       Abs_T newEParser(Any_T ePlrCtx, c_string language),
       void  freeEParser(Abs_T eParser),
       Any_T ePlrCtx
     )
/* adds embedded parser constructor 'newEParser',
   destructor 'freeEParser' and some context 'ePlrCtx' to
   parse term configuration 'PCfg';
   must be set for embedded languages
*/
;

void PT_quit(PT_Cfg PCfg)
/* terminates parse term construction;
   removes configuration 'PCfg'
*/
;

PT_Term PT_parse(PT_Cfg PCfg, c_string StartSymbol, c_bool interprete)
#define PT_PARSE(pcfg,start)      PT_parse((pcfg),(start),C_False)
#define PT_INTERPRETE(pcfg,start) PT_parse((pcfg),(start),C_True)
/* parses and constructs parse term of type C ( see [ptm] )
   according configuration 'PCfg';
   uses 'StartSymbol' as start nonterminal or default if empty
   ( interprete --> early reduction )
*/
;

PT_Term XPT_parse(PT_Cfg PCfg, c_string StartSymbol, c_bool interprete)
#define XPT_PARSE(pcfg,start)      XPT_parse((pcfg),(start),C_False)
#define XPT_INTERPRETE(pcfg,start) XPT_parse((pcfg),(start),C_True)
/* parses and constructs parse term of type Xaron ( see [ptm] )
   according configuration 'PCfg';
   uses 'StartSymbol' as start nonterminal or default if empty
   ( interprete --> early reduction )
*/
;

int PT_synErrorCnt(PT_Cfg PCfg)
/* number of syntax errors in parse term configuration 'PCfg' */
;

symbol PT_ErrorSymbol(PT_Cfg PCfg)
/* symbol of error token in parse term configuration 'PCfg' */
;


/* --------------------------- Semantic Analysis ---------------------------- */

/* ---------------- ... using the default environment ( static ) ------------ */

void PT_diagnose(PT_Term PTree, c_string format, ...)
/* prints a test message for parse term node 'PTree'
   according variable format specification 'format' and '...'
*/
;

void PT_error(PT_Term PTree, c_string format, ...)
/* increments the number of semantic errors and
   prints an error message for parse term node 'PTree'
   according variable format specification 'format' and '...'
*/
;

void PT_warn(PT_Term PTree, c_string format, ...)
/* increments the number of warnings and
   prints a warning message for parse term node 'PTree'
   according variable format specification 'format' and '...'
*/
;

void PT_setErrorCnt(int cnt)
/* resets the number of semantic errors with 'cnt' */
;

int  PT_errorCnt(void);         /* number of semantic errors                */
void PT_setWarningCnt(int cnt); /* resets the number of warnings with 'cnt' */
int  PT_warnCnt(void);          /* number of warnings                       */

/* ---------------- ... using the diagnose environment ( reentrant ) -------- */

PT_Diag PT_diag_init(void (*prMsg)(c_string msg))
/* creates a diagnose environment
   using 'prMsg' as message function
   ( 'msg': single byte character set or UTF-8 )
*/
;

void PT_diag_quit(PT_Diag PDiag);   /* removes diagnose environment 'PDiag' */

void PT_diag_msg(PT_Term PTree, PT_Diag PDiag, c_string format, ...)
/* prints a message for parse term node 'PTree'
   according diagnose environment 'PDiag',
   variable format specification 'format' and '...'
*/
;

void PT_diag_test(PT_Term PTree, PT_Diag PDiag, c_string format, ...)
/* like PT_diag_msg; prints a test message */
;

void PT_diag_err(PT_Term PTree, PT_Diag PDiag, c_string format, ...)
/* increments the number of semantic errors
   in diagnose environment 'PDiag' and
   prints an error message for parse term node 'PTree'
   according variable format specification 'format' and '...'
*/
;

void PT_diag_warn(PT_Term PTree, PT_Diag PDiag, c_string format, ...)
/* increments the number of warnings
   in diagnose environment 'PDiag' and
   prints a warning message for parse term node 'PTree'
   according variable format specification 'format' and '...'
*/
;

void PT_diag_setErrorCnt(PT_Diag PDiag, int cnt)
/* resets the number of semantic errors
   in diagnose environment 'PDiag' with 'cnt'
*/
;

int PT_diag_errorCnt(PT_Diag PDiag)
/* number of semantic errors in diagnose environment 'PDiag' */
;

void PT_diag_setWarningCnt(PT_Diag PDiag, int cnt)
/* resets number of warnings
   in diagnose environment 'PDiag' with 'cnt'
*/
;

int PT_diag_warnCnt(PT_Diag PDiag)
/* number of warnings in diagnose environment 'PDiag' */
;

void (*PT_diag_msgFun(PT_Diag PDiag))(c_string msg)
/* message function in diagnose environment 'PDiag' */
;


/* ---------------- Accessing configuration ( Xaron support ) --------------- */

Scn_Stream PT_stream(PT_Cfg PCfg)
/* current scan stream in parse term configuration 'PCfg' */
;

PLR_Tab PT_ptab(PT_Cfg PCfg)
/* current parse table in parse term configuration 'PCfg' */
;



#ifdef __cplusplus
}
#endif

#endif
