/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_SWITCHPARAM_H
#define _SC_SWITCHPARAM_H

// sc
#include "ScParam.h"
#include "util/String.h"
#include "svn/Revision.h"


/**
 * Parameter class for SwitchCmd.
 */
class SwitchParam : public ScParam
{
public:
  SwitchParam( const sc::String& path, const sc::String& url, const svn::Revision* rev,
    bool recurse )
    : _path(path), _url(url), _rev(rev), _recurse(recurse)
  {
  }

  ~SwitchParam()
  {
    delete _rev;
  }

  const sc::String& getPath() const
  {
    return _path;
  }

  const sc::String& getUrl() const
  {
    return _url;
  }

  const svn::Revision* getRevision() const
  {
    return _rev;
  }

  bool getRecurse() const
  {
    return _recurse;
  }

  svn::Revnumber& getRevnumber()
  {
    return _revnum;
  }

  ScParamAccept(SwitchParam);

private:
  // in
  sc::String           _path;
  sc::String           _url;
  const svn::Revision* _rev;
  bool                 _recurse;

  // out
  svn::Revnumber       _revnum;
};

#endif // _SC_SWITCHPARAM_H
