/* ====================================================================
 * Copyright (c) 2007,      Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_ICONFACTORY_H
#define _SC_ICONFACTORY_H

// qt
#include <QtCore/QString>
#include <QtGui/QIcon>


/**
 * Factory class to create icons for the QActions.
 */
class IconFactory
{
public:
  /** create command button icon */
  static QIcon createIcon( const QString& iconImage, const QString& overlayImage = QString() );

  /** create toggle button icon */
  static QIcon createToggleIcon( const QString& iconImage, const QString& overlayImage );

private:
  IconFactory();
};

#endif // _SC_ICONFACTORY_H
