/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_REVERTCMD_H
#define _SC_REVERTCMD_H

// sc
#include "ScCmd.h"
class RevertParam;
class CmdResultCallback;

/**
 * Command for reverting modifications.
 */
class RevertCmd : public ScCmd
{
public:
  /**
   * Construct a RevertCmd.
   *
   * \param param the parameters for the command.
   * \param cb the callback that gets called when the command has finished.
   * The command takes ownership the callback.
   */
  RevertCmd( RevertParam* param, CmdResultCallback* cb );
  ~RevertCmd();

  void run();

private:
  // in
  RevertParam*       _param;

  // out
  CmdResultCallback* _cb;
};

#endif // _SC_REVERTCMD_H
