/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SVN_LOCK_H
#define _SVN_LOCK_H

// sc
#include "svn.h"
#include "util/String.h"

// svn
struct svn_lock_t;

namespace svn
{

// svn_lock_t
class Lock
{
public:
  Lock( const svn_lock_t* );
  
  const sc::String& getPath() const;
  const sc::String& getToken() const;
  const sc::String& getOwner() const;
  const sc::String& getComment() const;
  Date getCreationDate() const;
  Date getExpirationDate() const;

private:
  sc::String  _path;
  sc::String  _token;
  sc::String  _owner;
  sc::String  _comment;
  Date        _creationDate;
  Date        _expirationDate;
};

} // namespace

#endif // _SVN_LOCK_H
