#!/usr/bin/env python
#
# Copyright (C) 2007 Lemur Consulting Ltd
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
r"""errors.py: Exceptions for the search engine core.

"""
__docformat__ = "restructuredtext en"

class SearchEngineError(Exception):
    r"""Base class for exceptions thrown by the search engine.

    Any errors generated by the python level interface to xapian will be
    instances of this class or its subclasses.

    """

class IndexerError(SearchEngineError):
    r"""Class used to report errors from the indexing API.

    """

class SearchError(SearchEngineError):
    r"""Class used to report errors from the search API.

    """

