/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.map.proj;

import com.jhlabs.map.proj.Projection;
import java.awt.geom.Point2D;

public class RectangularPolyconicProjection
extends Projection {
    private double phi0;
    private double phi1;
    private double fxa;
    private double fxb;
    private boolean mode;
    private static final double EPS = 1.0E-9;

    public Point2D.Double project(double lplam, double lpphi, Point2D.Double out) {
        double fa = this.mode ? Math.tan(lplam * this.fxb) * this.fxa : 0.5 * lplam;
        if (Math.abs(lpphi) < 1.0E-9) {
            out.x = fa + fa;
            out.y = -this.phi0;
        } else {
            out.y = 1.0 / Math.tan(lpphi);
            fa = 2.0 * Math.atan(fa * Math.sin(lpphi));
            out.x = Math.sin(fa) * out.y;
            out.y = lpphi - this.phi0 + (1.0 - Math.cos(fa)) * out.y;
        }
        return out;
    }

    public void initialize() {
        super.initialize();
    }

    public String toString() {
        return "Rectangular Polyconic";
    }
}

