/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.map.proj;

import com.jhlabs.map.MapMath;
import com.jhlabs.map.proj.Projection;
import java.awt.geom.Point2D;

public class Wagner2Projection
extends Projection {
    private static final double C_x = 0.92483;
    private static final double C_y = 1.38725;
    private static final double C_p1 = 0.88022;
    private static final double C_p2 = 0.8855;

    public Point2D.Double project(double lplam, double lpphi, Point2D.Double out) {
        out.y = MapMath.asin(0.88022 * Math.sin(0.8855 * lpphi));
        out.x = 0.92483 * lplam * Math.cos(lpphi);
        out.y = 1.38725 * lpphi;
        return out;
    }

    public Point2D.Double projectInverse(double xyx, double xyy, Point2D.Double out) {
        out.y = xyy / 1.38725;
        out.x = xyx / (0.92483 * Math.cos(out.y));
        out.y = MapMath.asin(Math.sin(out.y) / 0.88022) / 0.8855;
        return out;
    }

    public boolean hasInverse() {
        return true;
    }

    public String toString() {
        return "Wagner II";
    }
}

