/*
 * Decompiled with CFR 0.152.
 */
package bioroute;

import bioroute.Configurable;
import bioroute.NetworkLoader;
import bioroute.NetworkPreprocessor;
import bioroute.PathGenerator;
import bioroute.PathWriter;
import cadyts.supply.network.Network;
import cadyts.supply.network.Node;
import cadyts.utilities.config.Config;
import cadyts.utilities.config.ConfigReader;
import cadyts.utilities.misc.Misc;
import cadyts.utilities.misc.Tuple;
import java.util.ArrayList;
import java.util.List;

public class BiorouteRunner {
    public static final String BIOROUTE_ELEMENT = "bioroute";
    public static final String NETWORKLOADER_ELEMENT = "networkloader";
    public static final String CLASSNAME_ELEMENT = "classname";
    public static final String NETWORKPREPROCESSOR_ELEMENT = "networkpreprocessor";
    public static final String ODPAIRS_ELEMENT = "odpairs";
    public static final String ODPAIR_ELEMENT = "odpair";
    public static final String ORIGIN_ELEMENT = "origin";
    public static final String DESTINATION_ELEMENT = "destination";
    public static final String PATHGENERATOR_ELEMENT = "pathgenerator";
    public static final String PATHWRITER_ELEMENT = "pathwriter";

    private BiorouteRunner() {
    }

    public static Configurable loadAndConfigure(Config config, String ... elements) {
        String className = config.get(Misc.append(elements, CLASSNAME_ELEMENT));
        Configurable result = null;
        try {
            Class<?> clazz = Class.forName(className);
            result = (Configurable)clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Config subConfig = config.newSubConfig(elements);
        result.configure(subConfig);
        return result;
    }

    public static List<Tuple<Node, Node>> extractOdPairs(Network net, Config config) {
        int odPairCnt = config.size(BIOROUTE_ELEMENT, ODPAIRS_ELEMENT, ODPAIR_ELEMENT, ORIGIN_ELEMENT);
        ArrayList<Tuple<Node, Node>> result = new ArrayList<Tuple<Node, Node>>(odPairCnt);
        int i = 0;
        while (i < odPairCnt) {
            Node origin = net.getNode(config.get(i, BIOROUTE_ELEMENT, ODPAIRS_ELEMENT, ODPAIR_ELEMENT, ORIGIN_ELEMENT));
            Node destination = net.getNode(config.get(i, BIOROUTE_ELEMENT, ODPAIRS_ELEMENT, ODPAIR_ELEMENT, DESTINATION_ELEMENT));
            result.add(new Tuple<Node, Node>(origin, destination));
            ++i;
        }
        return result;
    }

    public static void main(String[] args) {
        System.out.println("STARTED..");
        if (args == null || args.length == 0) {
            System.err.println("name of configuration file is missing");
            System.exit(-1);
        }
        String configFileName = args[0];
        Config config = new ConfigReader().read(configFileName);
        NetworkLoader networkLoader = (NetworkLoader)BiorouteRunner.loadAndConfigure(config, BIOROUTE_ELEMENT, NETWORKLOADER_ELEMENT);
        Network network = networkLoader.loadNetwork();
        NetworkPreprocessor networkPreprocessor = (NetworkPreprocessor)BiorouteRunner.loadAndConfigure(config, BIOROUTE_ELEMENT, NETWORKPREPROCESSOR_ELEMENT);
        networkPreprocessor.preprocess(network);
        PathWriter pathWriter = (PathWriter)BiorouteRunner.loadAndConfigure(config, BIOROUTE_ELEMENT, PATHWRITER_ELEMENT);
        PathGenerator pathGenerator = (PathGenerator)BiorouteRunner.loadAndConfigure(config, BIOROUTE_ELEMENT, PATHGENERATOR_ELEMENT);
        pathGenerator.setNetwork(network);
        pathGenerator.setPathWriter(pathWriter);
        pathWriter.open();
        for (Tuple<Node, Node> odPair : BiorouteRunner.extractOdPairs(network, config)) {
            pathWriter.startOdPair(odPair.getA(), odPair.getB());
            pathGenerator.run(odPair.getA(), odPair.getB());
            pathWriter.endOdPair();
        }
        pathWriter.close();
        System.out.println("..DONE");
    }
}

