/*
 * Decompiled with CFR 0.152.
 */
package bioroute.analysis;

import bioroute.BiorouteRunner;
import bioroute.NetworkLoader;
import bioroute.NetworkPreprocessor;
import bioroute.analysis.ScatterPlotAnalyzer;
import bioroute.pathgenerator.metropolishastings.MHLinkCostPathWeight;
import cadyts.supply.network.Network;
import cadyts.utilities.config.Config;
import cadyts.utilities.config.ConfigReader;
import cadyts.utilities.misc.CommandLineParser;
import cadyts.utilities.misc.CommandLineParserElement;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;

public class AnalysisRunner {
    private static final String CONFIGFILE_KEY = "-configfile";
    private static final String ANALYSISINTERVAL_KEY = "-analysisinterval";
    private static final String ANALYSISBURNIN_KEY = "-analysisburnin";
    private static final String TOTALS_KEY = "-totals";
    private static final String PROMPTCHI2_KEY = "-promptchi2";

    public static void main(String[] args) throws IOException {
        System.out.println("STARTED..");
        CommandLineParser clp = new CommandLineParser();
        clp.defineParameter(CONFIGFILE_KEY, true, null, "the interval at which path samples were generated");
        clp.defineParameter(ANALYSISINTERVAL_KEY, true, null, "the interval at which path samples are analzyed from file");
        clp.defineParameter(ANALYSISBURNIN_KEY, true, null, "the number of inital samples in the file that are discarded");
        clp.defineParameter(TOTALS_KEY, false, null, "file where to print the route totals");
        clp.defineParameter(PROMPTCHI2_KEY, false, "false", "if the chi2 is to be prompted (requires -totals)");
        if (args == null || args.length == 0) {
            for (CommandLineParserElement element : clp.getElements()) {
                System.out.println(element);
            }
            System.exit(0);
        } else {
            clp.parse(args);
        }
        String configFile = clp.getString(CONFIGFILE_KEY);
        int analysisBurnIn = clp.getInteger(ANALYSISBURNIN_KEY);
        int analysisInterval = clp.getInteger(ANALYSISINTERVAL_KEY);
        Config config = new ConfigReader().read(configFile);
        String pathsFilename = config.get("bioroute", "pathwriter", "filename");
        double scale = Double.parseDouble(config.get("bioroute", "pathgenerator", "scale"));
        NetworkLoader networkLoader = (NetworkLoader)BiorouteRunner.loadAndConfigure(config, "bioroute", "networkloader");
        Network network = networkLoader.loadNetwork();
        NetworkPreprocessor networkPreprocessor = (NetworkPreprocessor)BiorouteRunner.loadAndConfigure(config, "bioroute", "networkpreprocessor");
        networkPreprocessor.preprocess(network);
        MHLinkCostPathWeight linkCostPathWeight = new MHLinkCostPathWeight();
        linkCostPathWeight.configure(config.newSubConfig("bioroute", "pathgenerator"));
        linkCostPathWeight.initialize(network);
        int fileBurnInIterations = Integer.parseInt(config.get("bioroute", "pathwriter", "burniniterations"));
        int fileSampleInterval = Integer.parseInt(config.get("bioroute", "pathwriter", "sampleinterval"));
        if (clp.containsKey(TOTALS_KEY)) {
            ScatterPlotAnalyzer spa = new ScatterPlotAnalyzer(network, analysisBurnIn, analysisInterval, Integer.MAX_VALUE, scale, linkCostPathWeight);
            spa.setPrintTotals(true);
            spa.run(pathsFilename, clp.getString(TOTALS_KEY));
        }
        if (clp.containsKey(PROMPTCHI2_KEY) && clp.getBoolean(PROMPTCHI2_KEY)) {
            String line;
            double chi2 = 0.0;
            BufferedReader reader = new BufferedReader(new FileReader(clp.getString(TOTALS_KEY)));
            while ((line = reader.readLine()) != null) {
                String[] columns = line.split("\\s");
                double e = Double.parseDouble(columns[0]);
                double o = Double.parseDouble(columns[1]);
                chi2 += (o - e) / e * (o - e);
            }
            reader.close();
            System.out.println("chi2 = " + chi2);
        }
        System.out.println("..DONE");
    }
}

