/*
 * Decompiled with CFR 0.152.
 */
package bioroute.pathwriter;

import bioroute.PathWriter;
import cadyts.supply.network.Link;
import cadyts.supply.network.Node;
import cadyts.utilities.config.Config;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.List;

public class PlainTextPathWriter
implements PathWriter {
    public static final String FILENAME_ELEMENT = "filename";
    public static final String BURNINITERATIONS_ELEMENT = "burniniterations";
    public static final String SAMPLEINTERVAL_ELEMENT = "sampleinterval";
    private String fileName = null;
    private Integer burnInIterations = null;
    private Integer sampleInterval = null;
    private int odCnt;
    private int pathCnt;
    private PrintWriter writer = null;

    @Override
    public void configure(Config config) {
        this.fileName = config.get("pathwriter", FILENAME_ELEMENT);
        this.burnInIterations = Integer.parseInt(config.get("pathwriter", BURNINITERATIONS_ELEMENT));
        this.sampleInterval = Integer.parseInt(config.get("pathwriter", SAMPLEINTERVAL_ELEMENT));
    }

    @Override
    public void open() {
        try {
            this.writer = new PrintWriter(this.fileName);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        this.odCnt = 0;
        this.pathCnt = 0;
    }

    @Override
    public void startOdPair(Node from, Node to) {
        ++this.odCnt;
        this.pathCnt = 0;
    }

    @Override
    public void writePath(List<Link> path) {
        ++this.pathCnt;
        if (this.pathCnt <= this.burnInIterations || this.pathCnt % this.sampleInterval != 0) {
            return;
        }
        for (Link link : path) {
            this.writer.print(link.getFromNode().getId());
            this.writer.print("\t");
        }
        this.writer.println(path.get(path.size() - 1).getToNode().getId());
    }

    @Override
    public void endOdPair() {
        this.writer.println();
    }

    @Override
    public void close() {
        this.writer.flush();
        this.writer.close();
    }
}

