/*
 * Decompiled with CFR 0.152.
 */
package cadyts.supply.network;

import cadyts.supply.network.Link;
import cadyts.supply.network.Network;
import cadyts.supply.network.NetworkLoaderXML;
import cadyts.supply.network.Node;
import org.xml.sax.Attributes;

public class MATSimNetworkLoader
extends NetworkLoaderXML {
    public static final String NETWORK = "network";
    public static final String NETWORK_NAME = "name";
    public static final String NODES = "nodes";
    public static final String LINKS = "links";
    public static final String NODE = "node";
    public static final String NODE_ID = "id";
    public static final String LINK = "link";
    public static final String LINK_ID = "id";
    public static final String LINK_FROM = "from";
    public static final String LINK_TO = "to";

    @Override
    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) {
        if (NETWORK.equals(qName)) {
            this.startNetwork(attrs);
        } else if (NODES.equals(qName)) {
            this.startNodes(attrs);
        } else if (LINKS.equals(qName)) {
            this.startLinks(attrs);
        } else if (NODE.equals(qName)) {
            this.startNode(attrs);
        } else if (LINK.equals(qName)) {
            this.startLink(attrs);
        }
    }

    private void startNetwork(Attributes attrs) {
        String networkId = attrs.getValue(NETWORK_NAME);
        this.net = networkId == null ? new Network("MATSim network") : new Network(networkId);
        int i = 0;
        while (i < attrs.getLength()) {
            String name = attrs.getLocalName(i);
            if (!NETWORK_NAME.equals(name)) {
                this.net.setAttr(name, attrs.getValue(i));
            }
            ++i;
        }
    }

    private void startNodes(Attributes attrs) {
        int i = 0;
        while (i < attrs.getLength()) {
            this.net.setNodesAttr(attrs.getLocalName(i), attrs.getValue(i));
            ++i;
        }
    }

    private void startLinks(Attributes attrs) {
        int i = 0;
        while (i < attrs.getLength()) {
            this.net.setLinksAttr(attrs.getLocalName(i), attrs.getValue(i));
            ++i;
        }
    }

    private void startNode(Attributes attrs) {
        Node node = new Node(attrs.getValue("id"));
        int i = 0;
        while (i < attrs.getLength()) {
            String name = attrs.getLocalName(i);
            if (!"id".equals(name)) {
                node.setAttr(name, attrs.getValue(i));
            }
            ++i;
        }
        this.net.add(node);
    }

    private void startLink(Attributes attrs) {
        Link link = new Link(attrs.getValue("id"));
        Node fromNode = this.net.getNode(attrs.getValue(LINK_FROM));
        if (fromNode == null) {
            throw new RuntimeException("unknown from-node for link " + link.getId());
        }
        Node toNode = this.net.getNode(attrs.getValue(LINK_TO));
        if (toNode == null) {
            throw new RuntimeException("unknown to-node for link " + link.getId());
        }
        link.setFromNode(fromNode);
        link.setToNode(toNode);
        fromNode.addOutLink(link);
        toNode.addInLink(link);
        int i = 0;
        while (i < attrs.getLength()) {
            String name = attrs.getLocalName(i);
            if (!("id".equals(name) || LINK_FROM.equals(name) || LINK_TO.equals(name))) {
                link.setAttr(name, attrs.getValue(i));
            }
            ++i;
        }
        this.net.add(link);
    }
}

