/*
 * Decompiled with CFR 0.152.
 */
package cadyts.supply.network;

import cadyts.supply.network.Link;
import cadyts.supply.network.NetworkElement;
import cadyts.supply.network.Node;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class Network
extends NetworkElement {
    private final Map<String, String> nodesAttr = new LinkedHashMap<String, String>();
    private final Map<String, String> linksAttr = new LinkedHashMap<String, String>();
    private final Map<String, Node> nodes = new LinkedHashMap<String, Node>();
    private final Map<String, Link> links = new LinkedHashMap<String, Link>();

    public Network(String id) {
        super(id);
    }

    public Network(Network parent) {
        super(parent);
        this.nodesAttr.putAll(parent.nodesAttr);
        this.linksAttr.putAll(parent.linksAttr);
        for (Node node : parent.nodes.values()) {
            this.nodes.put(node.getId(), new Node(node));
        }
        for (Link link : parent.links.values()) {
            this.links.put(link.getId(), new Link(link));
        }
        for (Link link : parent.links.values()) {
            Link newLink = this.getLink(link.getId());
            Node newFromNode = this.getNode(link.getFromNode().getId());
            Node newToNode = this.getNode(link.getToNode().getId());
            newLink.setFromNode(newFromNode);
            newLink.setToNode(newToNode);
            newFromNode.addOutLink(newLink);
            newToNode.addInLink(newLink);
        }
    }

    public static void connect(Node fromNode, Node toNode, Link link) {
        fromNode.getOutLinks().add(link);
        toNode.getInLinks().add(link);
        link.setFromNode(fromNode);
        link.setToNode(toNode);
    }

    public void remove(Node node, boolean removeAdjacentLinks) {
        for (Link link : node.getInLinks()) {
            this.remove(link);
        }
        for (Link link : node.getOutLinks()) {
            this.remove(link);
        }
    }

    public void remove(Link link) {
        this.links.remove(link);
    }

    public void setNodesAttr(String key, String value) {
        this.nodesAttr.put(key, value);
    }

    public String getNodesAttr(String key) {
        return this.nodesAttr.get(key);
    }

    public void setLinksAttr(String key, String value) {
        this.linksAttr.put(key, value);
    }

    public String getLinksAttr(String key) {
        return this.linksAttr.get(key);
    }

    public Node add(Node node) {
        return this.nodes.put(node.getId(), node);
    }

    public Link add(Link link) {
        return this.links.put(link.getId(), link);
    }

    public boolean isConsistent() {
        for (Link link : this.links.values()) {
            if (!this.nodes.containsValue(link.getFromNode())) {
                return false;
            }
            if (this.nodes.containsValue(link.getToNode())) continue;
            return false;
        }
        for (Node node : this.nodes.values()) {
            for (Link link : node.getInLinks()) {
                if (this.links.containsValue(link)) continue;
                return false;
            }
            for (Link link : node.getOutLinks()) {
                if (this.links.containsValue(link)) continue;
                return false;
            }
        }
        return true;
    }

    public Node getNode(String nodeId) {
        return this.nodes.get(nodeId);
    }

    public Link getLink(String linkId) {
        return this.links.get(linkId);
    }

    public Link getLink(String fromNodeId, String toNodeId) {
        Node fromNode = this.getNode(fromNodeId);
        if (fromNode == null) {
            return null;
        }
        for (Link link : fromNode.getOutLinks()) {
            if (!link.getToNode().getId().equals(toNodeId)) continue;
            return link;
        }
        return null;
    }

    public Collection<Node> getNodes() {
        return this.nodes.values();
    }

    public Collection<Link> getLinks() {
        return this.links.values();
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer(this.getClass().getSimpleName());
        result.append("(id = ");
        result.append(this.getId());
        result.append(", #nodes = ");
        result.append(this.getNodes().size());
        result.append(", #links = ");
        result.append(this.getLinks().size());
        result.append(", super = ");
        result.append(super.toString());
        result.append(")");
        return result.toString();
    }
}

