/*
 * Decompiled with CFR 0.152.
 */
package cadyts.utilities.math.networks;

import cadyts.supply.network.Link;
import cadyts.supply.network.Node;
import cadyts.utilities.math.networks.LinkCost;
import cadyts.utilities.math.networks.UnsettledNodes;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Router {
    protected final LinkCost linkCost;

    public Router(LinkCost linkCost) {
        if (linkCost == null) {
            throw new IllegalArgumentException("link cost is null");
        }
        this.linkCost = linkCost;
    }

    static double treeCost(Node node, Map<Node, Double> treeCost) {
        Double result = treeCost.get(node);
        if (result == null) {
            return Double.POSITIVE_INFINITY;
        }
        return result;
    }

    private void expand(Node currentNode, Node candidateNode, Link connectingLink, UnsettledNodes unsettled) {
        double oldCost = unsettled.cost(candidateNode);
        double newCost = this.linkCost.getCost(connectingLink) + unsettled.cost(currentNode);
        unsettled.update(candidateNode, Math.min(oldCost, newCost));
    }

    protected Map<Node, Double> treeCost(Node root, Set<Node> targets, Direction direction, UnsettledNodes unsettled, Set<Node> settled) {
        Node currentNode;
        HashSet<Object> targetsLeft;
        if (targets == null) {
            targetsLeft = new HashSet<Node>();
            targetsLeft.add(new Node(">>>>> NON-EXISTING NODE <<<<<"));
        } else {
            targetsLeft = new HashSet<Node>(targets);
        }
        if (unsettled == null) {
            unsettled = new UnsettledNodes();
            currentNode = root;
            unsettled.update(root, 0.0);
        } else {
            currentNode = unsettled.first();
        }
        if (settled == null) {
            settled = new HashSet<Node>();
        }
        while (currentNode != null && !targetsLeft.isEmpty()) {
            if (Direction.FWD.equals((Object)direction)) {
                for (Link outLink : currentNode.getOutLinks()) {
                    Node outNode = outLink.getToNode();
                    if (settled.contains(outNode)) continue;
                    this.expand(currentNode, outNode, outLink, unsettled);
                }
            } else {
                for (Link inLink : currentNode.getInLinks()) {
                    Node inNode = inLink.getFromNode();
                    if (settled.contains(inNode)) continue;
                    this.expand(currentNode, inNode, inLink, unsettled);
                }
            }
            settled.add(currentNode);
            unsettled.remove(currentNode);
            targetsLeft.remove(currentNode);
            currentNode = unsettled.isEmpty() ? null : unsettled.first();
        }
        return unsettled.cost();
    }

    private Map<Node, Double> treeCost(Node root, Set<Node> targets, Direction direction) {
        return this.treeCost(root, targets, direction, null, null);
    }

    public Map<Node, Double> fwdCost(Node origin, Set<Node> destinations) {
        return this.treeCost(origin, destinations, Direction.FWD);
    }

    public Map<Node, Double> bwdCost(Set<Node> origins, Node destination) {
        return this.treeCost(destination, origins, Direction.BWD);
    }

    public Map<Node, LinkedList<Node>> bestRoutes(Set<Node> origins, Node destination, Map<Node, Double> bwdCostTree) {
        HashMap<Node, LinkedList<Node>> result = new HashMap<Node, LinkedList<Node>>();
        for (Node origin : origins) {
            LinkedList<Node> route = new LinkedList<Node>();
            route.addFirst(origin);
            while (route != null && !((Node)route.getLast()).equals(destination)) {
                Node bestNode = null;
                double bestCost = Double.POSITIVE_INFINITY;
                for (Link candLink : ((Node)route.getLast()).getOutLinks()) {
                    Node candNode = candLink.getToNode();
                    double bwdCost = Router.treeCost(candNode, bwdCostTree);
                    double candCost = this.linkCost.getCost(candLink) + bwdCost;
                    if (!(candCost < bestCost)) continue;
                    bestNode = candNode;
                    bestCost = candCost;
                }
                if (Double.isInfinite(bestCost)) {
                    route = null;
                    continue;
                }
                route.addLast(bestNode);
            }
            result.put(origin, route);
        }
        return result;
    }

    public Map<Node, LinkedList<Node>> bestRoutes(Node origin, Set<Node> destinations, Map<Node, Double> fwdCostTree) {
        HashMap<Node, LinkedList<Node>> result = new HashMap<Node, LinkedList<Node>>();
        for (Node destination : destinations) {
            LinkedList<Node> route = new LinkedList<Node>();
            route.addLast(destination);
            while (route != null && !((Node)route.getFirst()).equals(origin)) {
                Node bestNode = null;
                double bestCost = Double.POSITIVE_INFINITY;
                for (Link candLink : ((Node)route.getFirst()).getInLinks()) {
                    Node candNode = candLink.getFromNode();
                    double fwdCost = Router.treeCost(candNode, fwdCostTree);
                    double candCost = this.linkCost.getCost(candLink) + fwdCost;
                    if (!(candCost < bestCost)) continue;
                    bestNode = candNode;
                    bestCost = candCost;
                }
                if (Double.isInfinite(bestCost)) {
                    route = null;
                    continue;
                }
                route.addFirst(bestNode);
            }
            result.put(destination, route);
        }
        return result;
    }

    public LinkedList<Node> bestRouteBwd(Node origin, Node destination, Map<Node, Double> bwdCost) {
        HashSet<Node> origins = new HashSet<Node>();
        origins.add(origin);
        return this.bestRoutes(origins, destination, bwdCost).get(origin);
    }

    public LinkedList<Node> bestRouteFwd(Node origin, Node destination, Map<Node, Double> fwdCost) {
        HashSet<Node> destinations = new HashSet<Node>();
        destinations.add(destination);
        return this.bestRoutes(origin, destinations, fwdCost).get(destination);
    }

    public Map<Node, LinkedList<Node>> bestRoutes(Node origin, Set<Node> destinations) {
        Map<Node, Double> fwdCost = this.fwdCost(origin, destinations);
        return this.bestRoutes(origin, destinations, fwdCost);
    }

    public Map<Node, LinkedList<Node>> bestRoutes(Set<Node> origins, Node destination) {
        Map<Node, Double> bwdCost = this.bwdCost(origins, destination);
        return this.bestRoutes(origins, destination, bwdCost);
    }

    public LinkedList<Node> bestRoute(Node origin, Node destination) {
        HashSet<Node> destinations = new HashSet<Node>();
        destinations.add(destination);
        return this.bestRoutes(origin, destinations).get(destination);
    }

    public boolean equals(List<Node> route1, int start1, int end1, List<Node> route2, int start2, int end2) {
        if (end1 - start1 != end2 - start2) {
            return false;
        }
        int i = 0;
        while (i <= end1 - start1) {
            if (!route1.get(start1 + i).equals(route2.get(start2 + i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static Link connectingLink(Node from, Node to) {
        for (Link link : from.getOutLinks()) {
            if (!link.getToNode().equals(to)) continue;
            return link;
        }
        return null;
    }

    public static List<Link> toLinkRoute(List<Node> nodeRoute) {
        LinkedList<Link> linkRoute = new LinkedList<Link>();
        int i = 0;
        while (i < nodeRoute.size() - 1) {
            Link link = Router.connectingLink(nodeRoute.get(i), nodeRoute.get(i + 1));
            if (link == null) {
                return null;
            }
            linkRoute.add(link);
            ++i;
        }
        return linkRoute;
    }

    public double cost(List<Link> linkRoute) {
        double result = 0.0;
        for (Link link : linkRoute) {
            result += this.linkCost.getCost(link);
        }
        return result;
    }

    protected static enum Direction {
        FWD,
        BWD;

    }
}

