/*
 * Decompiled with CFR 0.152.
 */
package cadyts.utilities.math.simulatedannealing;

import cadyts.utilities.math.BasicStatistics;
import cadyts.utilities.math.simulatedannealing.SolutionEvaluator;
import cadyts.utilities.math.simulatedannealing.SolutionGenerator;

public class SimulatedAnnealing<S> {
    private final SolutionGenerator<S> generator;
    private final SolutionEvaluator<S> evaluator;
    private S xOpt;
    private double xQOpt;

    public SimulatedAnnealing(SolutionGenerator<S> generator, SolutionEvaluator<S> evaluator) {
        if (generator == null) {
            throw new IllegalArgumentException("generator is null");
        }
        if (evaluator == null) {
            throw new IllegalArgumentException("evaluator is null");
        }
        this.generator = generator;
        this.evaluator = evaluator;
        this.reset();
    }

    public S getOptimalSolution() {
        return this.xOpt;
    }

    public double getOptimalEvaluation() {
        return this.xQOpt;
    }

    private void msg(int it, double xQ) {
        System.out.println("it. " + it + ": f(x) = " + xQ + ", fOpt(x) = " + this.xQOpt + ", xOpt = " + this.xOpt);
    }

    private S newRandomFeasibleSolution() {
        S x = null;
        while (!this.evaluator.feasible(x = (S)this.generator.randomGeneration())) {
        }
        return x;
    }

    private void updateBestSolution(S x, double xQ) {
        if (xQ < this.xQOpt) {
            this.xOpt = this.generator.copy(x);
            this.xQOpt = xQ;
        }
    }

    public void reset() {
        this.xOpt = null;
        this.xQOpt = Double.POSITIVE_INFINITY;
    }

    public double proposeGreediness(int maxPrepIt) {
        S x = null;
        double xQ = Double.POSITIVE_INFINITY;
        BasicStatistics stats = new BasicStatistics();
        int it = 1;
        while (it <= maxPrepIt) {
            x = this.newRandomFeasibleSolution();
            xQ = this.evaluator.evaluation(x);
            this.updateBestSolution(x, xQ);
            this.msg(it, xQ);
            stats.add(xQ);
            ++it;
        }
        return 1.0 / stats.getStddev();
    }

    public void run(S initialSolution, int maxIt, double greediness) {
        S x = initialSolution == null ? this.newRandomFeasibleSolution() : initialSolution;
        double xQ = this.evaluator.evaluation(x);
        this.updateBestSolution(x, xQ);
        this.msg(1, xQ);
        int it = 2;
        while (it <= maxIt) {
            S y = this.generator.variation(x);
            double yQ = this.evaluator.evaluation(y);
            this.updateBestSolution(y, yQ);
            double lambda = greediness * Math.log(it);
            double alpha = Math.exp(lambda * (xQ - yQ));
            if (Math.random() < alpha) {
                x = y;
                xQ = yQ;
            }
            this.msg(it, xQ);
            ++it;
        }
    }
}

