/*
 * Decompiled with CFR 0.152.
 */
package cadyts.utilities.visualization.network;

import cadyts.utilities.misc.DynamicData;

public class RenderableDynamicData<K>
extends DynamicData<K> {
    private static final long serialVersionUID = 1L;
    private int bin = 0;

    public RenderableDynamicData(DynamicData<K> data) {
        this(data.getStartTime_s(), data.getBinSize_s(), data.getBinCnt());
        for (K key : data.keySet()) {
            int bin = 0;
            while (bin < data.getBinCnt()) {
                this.put(key, bin, data.getBinValue(key, bin));
                ++bin;
            }
        }
    }

    public RenderableDynamicData(int startTime_s, int binSize_s, int binCnt) {
        super(startTime_s, binSize_s, binCnt);
    }

    public int currentBin() {
        return this.bin;
    }

    public void toStart() {
        this.bin = 0;
    }

    public void toEnd() {
        this.bin = this.getBinCnt() - 1;
    }

    public void toTime(int time_s) {
        this.bin = this.bin(time_s);
        if (this.bin < 0) {
            this.bin = 0;
        } else if (this.bin >= this.getBinCnt()) {
            this.bin = this.getBinCnt() - 1;
        }
    }

    public void fwd() {
        ++this.bin;
        if (this.bin >= this.getBinCnt()) {
            this.bin = 0;
        }
    }

    public void bwd() {
        --this.bin;
        if (this.bin < 0) {
            this.bin = this.getBinCnt() - 1;
        }
    }

    public double getCurrentValue(K key) {
        return this.getBinValue(key, this.bin);
    }
}

