/*
 * Decompiled with CFR 0.152.
 */
package trafficdefinition;

import classes.Pair;
import classes.Project;
import classes.TypeSelection;
import enums.MotionRestriction;
import helpers.DrawingHelper;
import helpers.TimeConverter;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import shapes.Ellipse2DExt;
import shapes.Line2DExt;
import shapes.Point2DExt;
import shapes.Rectangle2DExt;
import simulation.VehicleType;
import tdl.XMLHelpers;
import trafficdefinition.Handle;
import trafficdefinition.TrafficDefinitionElement;

public class AreaFlow
extends TrafficDefinitionElement
implements Serializable {
    private static final long serialVersionUID = 1L;
    public int constructionPhase = 0;
    private int beginTime = 0;
    private int endTime = 100;
    private int numberOfVehicles = 100;
    private Color color = new Color((float)Math.random(), (float)Math.random(), (float)Math.random());
    private Line2DExt arrow;
    private Ellipse2DExt startArea;
    private Ellipse2DExt endArea;
    private Point2DExt startAreaCenter;
    private double startAreaRadiusX;
    private double startAreaRadiusY;
    private Point2DExt endAreaCenter;
    private double endAreaRadiusX;
    private double endAreaRadiusY;
    private TypeSelection<VehicleType> vehicleSelection;

    public AreaFlow() {
        this.name = "Area Flow " + String.valueOf(increment++);
        this.startArea = new Ellipse2DExt();
        this.endArea = new Ellipse2DExt();
        this.arrow = new Line2DExt();
        this.vehicleSelection = new TypeSelection();
        this.vehicleSelection.add(new Pair<VehicleType, Float>(Project.getCurrentlyLoadedProject().getDefaultVehicleType(), Float.valueOf(1.0f)));
    }

    private AreaFlow(AreaFlow source) {
        super(source);
        this.constructionPhase = source.constructionPhase;
        this.beginTime = source.beginTime;
        this.endTime = source.endTime;
        this.numberOfVehicles = source.numberOfVehicles;
        this.color = new Color(source.color.getRGB());
        this.startArea = new Ellipse2DExt(source.startArea);
        this.startAreaCenter = new Point2DExt(source.startAreaCenter);
        this.startAreaRadiusX = source.startAreaRadiusX;
        this.startAreaRadiusY = source.startAreaRadiusY;
        this.endArea = new Ellipse2DExt(source.endArea);
        this.endAreaCenter = new Point2DExt(source.endAreaCenter);
        this.endAreaRadiusX = source.endAreaRadiusX;
        this.endAreaRadiusY = source.endAreaRadiusY;
        this.arrow = new Line2DExt(source.arrow);
        this.vehicleSelection = new TypeSelection<VehicleType>(source.vehicleSelection);
    }

    @Override
    public void Draw(Graphics2D g, double zoomFactor, boolean isDeleted, boolean isSelected) {
        Color prev = g.getColor();
        if (!isSelected) {
            g.setColor(new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), 100));
        }
        if (isSelected) {
            g.setColor(new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), 200));
        }
        if (this.startArea != null) {
            g.fill(this.startArea);
        }
        if (this.endArea != null) {
            g.fill(this.endArea);
        }
        if (this.arrow != null) {
            g.setColor(Color.BLACK);
            DrawingHelper.drawArrowHead(g, this.arrow.x1, this.arrow.y1, this.arrow.x2, this.arrow.y2, 1.0f);
            g.draw(this.arrow);
        }
        super.Draw(g, zoomFactor, isDeleted, isSelected);
        g.setColor(prev);
    }

    public void createHandles() {
        ArrayList<Handle> handles = new ArrayList<Handle>();
        Handle startAreaCenterHandle = new Handle(this.startAreaCenter, "StartAreaCenter", MotionRestriction.None);
        Handle startAreaXRadiusHandle = new Handle(new Point2D.Double(this.startAreaCenter.x + this.startAreaRadiusX, this.startAreaCenter.y), "StartAreaRadiusX", MotionRestriction.Horizontal);
        Handle startAreaYRadiusHandle = new Handle(new Point2D.Double(this.startAreaCenter.x, this.startAreaCenter.y + this.startAreaRadiusY), "StartAreaRadiusY", MotionRestriction.Vertical);
        Handle endAreaCenterHandle = new Handle(this.endAreaCenter, "EndAreaCenter", MotionRestriction.None);
        Handle endAreaXRadiusHandle = new Handle(new Point2D.Double(this.endAreaCenter.x + this.endAreaRadiusX, this.endAreaCenter.y), "EndAreaRadiusX", MotionRestriction.Horizontal);
        Handle endAreaYRadiusHandle = new Handle(new Point2D.Double(this.endAreaCenter.x, this.endAreaCenter.y + this.endAreaRadiusY), "EndAreaRadiusY", MotionRestriction.Vertical);
        handles.add(startAreaCenterHandle);
        handles.add(startAreaXRadiusHandle);
        handles.add(startAreaYRadiusHandle);
        handles.add(endAreaCenterHandle);
        handles.add(endAreaXRadiusHandle);
        handles.add(endAreaYRadiusHandle);
        super.addHandles(handles);
    }

    @Override
    public Rectangle2DExt getBounds() {
        Rectangle2D bounds = this.startArea.getBounds2D();
        bounds.add(this.endArea.getBounds2D());
        return new Rectangle2DExt(bounds.getCenterX(), bounds.getCenterY(), bounds.getWidth(), bounds.getHeight());
    }

    public int getBeginTime() {
        return this.beginTime;
    }

    public Color getColor() {
        return this.color;
    }

    public Ellipse2DExt getEndArea() {
        return this.endArea;
    }

    public int getEndTime() {
        return this.endTime;
    }

    public int getNumberOfVehicles() {
        return this.numberOfVehicles;
    }

    public Ellipse2DExt getStartArea() {
        return this.startArea;
    }

    @Override
    public String getToolTip() {
        return "<html><b>Area flow</b> " + this.name + "<br>" + "<b>Number of vehicles:</b> " + String.valueOf(this.numberOfVehicles) + "<br>" + "<b>Start time:</b> " + TimeConverter.toString(this.beginTime) + "<br>" + "<b>End time:</b> " + TimeConverter.toString(this.endTime) + "</html>";
    }

    public TypeSelection<VehicleType> getVehicleSelection() {
        return this.vehicleSelection;
    }

    @Override
    public void handleLocationChanged(Handle h) {
        if (h.getName().equals("StartAreaCenter")) {
            this.startAreaCenter = new Point2DExt(h.getLocation());
            ((Handle)this.handles.get("StartAreaRadiusX")).setUnrestrictedLocation(new Point2D.Double(this.startAreaCenter.x + this.startAreaRadiusX, this.startAreaCenter.y));
            ((Handle)this.handles.get("StartAreaRadiusY")).setUnrestrictedLocation(new Point2D.Double(this.startAreaCenter.x, this.startAreaCenter.y + this.startAreaRadiusY));
        } else if (h.getName().equals("StartAreaRadiusX")) {
            this.startAreaRadiusX = h.getLocation().x - this.startAreaCenter.x;
        } else if (h.getName().equals("StartAreaRadiusY")) {
            this.startAreaRadiusY = h.getLocation().y - this.startAreaCenter.y;
        } else if (h.getName().equals("EndAreaCenter")) {
            this.endAreaCenter = new Point2DExt(h.getLocation());
            ((Handle)this.handles.get("EndAreaRadiusX")).setUnrestrictedLocation(new Point2D.Double(this.endAreaCenter.x + this.endAreaRadiusX, this.endAreaCenter.y));
            ((Handle)this.handles.get("EndAreaRadiusY")).setUnrestrictedLocation(new Point2D.Double(this.endAreaCenter.x, this.endAreaCenter.y + this.endAreaRadiusY));
        } else if (h.getName().equals("EndAreaRadiusX")) {
            this.endAreaRadiusX = h.getLocation().x - this.endAreaCenter.x;
        } else if (h.getName().equals("EndAreaRadiusY")) {
            this.endAreaRadiusY = h.getLocation().y - this.endAreaCenter.y;
        }
        this.startArea.setFrameFromCenter(this.startAreaCenter, new Point2D.Double(this.startAreaCenter.x + this.startAreaRadiusX, this.startAreaCenter.y + this.startAreaRadiusY));
        this.endArea.setFrameFromCenter(this.endAreaCenter, new Point2D.Double(this.endAreaCenter.x + this.endAreaRadiusX, this.endAreaCenter.y + this.endAreaRadiusY));
        this.arrow.setLine(this.startAreaCenter, this.endAreaCenter);
    }

    @Override
    public boolean Hit(Point p) {
        if (this.arrow.getBounds2D().contains(p.x, p.y) && this.arrow.contains(p.x, p.y)) {
            return true;
        }
        if (this.startArea.getBounds2D().contains(p.x, p.y) && this.startArea.contains(p.x, p.y)) {
            return true;
        }
        return this.endArea.getBounds2D().contains(p.x, p.y) && this.endArea.contains(p.x, p.y);
    }

    @Override
    public boolean Hit(Rectangle transformedRectangle) {
        return this.arrow.intersects(transformedRectangle) || this.startArea.intersects(transformedRectangle) || this.endArea.intersects(transformedRectangle);
    }

    public void setBeginTime(int beginTime) {
        this.beginTime = beginTime;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setEndAreaCenter(Point2D.Double p) {
        this.endAreaCenter = new Point2DExt(p.x, p.y);
        this.arrow.setLine(this.startAreaCenter, this.endAreaCenter);
    }

    public void setEndAreaRadius(Point2D.Double p) {
        this.endAreaRadiusX = p.x - this.endAreaCenter.x;
        this.endAreaRadiusY = p.y - this.endAreaCenter.y;
        this.endArea.setFrameFromCenter(this.endAreaCenter, new Point2D.Double(this.endAreaCenter.x + this.endAreaRadiusX, this.endAreaCenter.y + this.endAreaRadiusY));
    }

    public void setEndTime(int endTime) {
        this.endTime = endTime;
    }

    public void setNumberOfVehicles(int numberOfVehicles) {
        this.numberOfVehicles = numberOfVehicles;
    }

    public void setStartAreaCenter(Point2D.Double p) {
        this.startAreaCenter = new Point2DExt(p.x, p.y);
    }

    public void setStartAreaRadius(Point2D.Double p) {
        this.startAreaRadiusX = p.x - this.startAreaCenter.x;
        this.startAreaRadiusY = p.y - this.startAreaCenter.y;
        this.startArea.setFrameFromCenter(this.startAreaCenter, new Point2D.Double(this.startAreaCenter.x + this.startAreaRadiusX, this.startAreaCenter.y + this.startAreaRadiusY));
    }

    public void setVehicleSelection(TypeSelection<VehicleType> vehicleSelection) {
        this.vehicleSelection = vehicleSelection;
    }

    @Override
    public TrafficDefinitionElement elementClone() {
        return new AreaFlow(this);
    }

    @Override
    public String toXML() {
        StringBuilder sb = new StringBuilder();
        sb.append("<areaFlow name=\"" + this.name + "\" numberOfVehicles=\"" + String.valueOf(this.numberOfVehicles) + "\" startingTime=\"" + String.valueOf(this.beginTime) + "\" endingTime=\"" + String.valueOf(this.endTime) + "\">\n");
        sb.append(XMLHelpers.vehicleSelectionToXML("vehicleSelection", this.vehicleSelection));
        sb.append("<sourceAreaShape>");
        sb.append(XMLHelpers.shapeToXML(this.startArea));
        sb.append("</sourceAreaShape>\n");
        sb.append("<destinationAreaShape>");
        sb.append(XMLHelpers.shapeToXML(this.endArea));
        sb.append("</destinationAreaShape>\n");
        sb.append("</areaFlow>\n");
        return sb.toString();
    }
}

