/*
 * Decompiled with CFR 0.152.
 */
package trafficdefinition;

import classes.Pair;
import classes.Project;
import classes.TypeSelection;
import helpers.DrawingHelper;
import helpers.TimeConverter;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import roadnetwork.Edge;
import shapes.Line2DExt;
import shapes.Point2DExt;
import shapes.Rectangle2DExt;
import simulation.VehicleType;
import trafficdefinition.Handle;
import trafficdefinition.TrafficDefinitionElement;

public class Flow
extends TrafficDefinitionElement
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int beginTime = 0;
    private int endTime = 100;
    private int numberOfVehicles = 100;
    private Color color = Color.BLUE;
    private Edge start = null;
    private Edge end = null;
    private TypeSelection<VehicleType> vehicleSelection;
    private Line2DExt shape;
    private Point2DExt from;

    public Flow() {
        this.name = "Flow " + String.valueOf(increment++);
        this.vehicleSelection = new TypeSelection();
        this.vehicleSelection.add(new Pair<VehicleType, Float>(Project.getCurrentlyLoadedProject().getDefaultVehicleType(), Float.valueOf(1.0f)));
    }

    public Flow(Flow source) {
        super(source);
        this.beginTime = source.beginTime;
        this.endTime = source.endTime;
        this.numberOfVehicles = source.numberOfVehicles;
        this.color = new Color(source.color.getRGB());
        this.start = source.start;
        this.end = source.end;
        this.shape = new Line2DExt(source.shape);
        this.from = new Point2DExt(source.from);
        this.vehicleSelection = new TypeSelection<VehicleType>(source.vehicleSelection);
        this.SetDependencies();
    }

    @Override
    public void Draw(Graphics2D g, double zoomFactor, boolean isDeleted, boolean isSelected) {
        Color prev = g.getColor();
        if (!isSelected) {
            g.setColor(this.color);
        }
        if (isSelected) {
            g.setColor(Color.GREEN);
        }
        if (this.shape != null) {
            DrawingHelper.drawArrowHead(g, this.shape.x1, this.shape.y1, this.shape.x2, this.shape.y2, 1.0f);
            g.draw(this.shape);
        }
        g.setColor(prev);
    }

    @Override
    public Rectangle2DExt getBounds() {
        return new Rectangle2DExt((Rectangle2D.Double)this.shape.getBounds2D());
    }

    public int getBeginTime() {
        return this.beginTime;
    }

    public Color getColor() {
        return this.color;
    }

    public Edge getEnd() {
        return this.end;
    }

    public int getEndTime() {
        return this.endTime;
    }

    public int getNumberOfVehicles() {
        return this.numberOfVehicles;
    }

    public Edge getStart() {
        return this.start;
    }

    @Override
    public String getToolTip() {
        return "<html><b>Flow</b> " + this.name + "<br>" + "<b>From:</b> " + this.start.getId() + "<br>" + "<b>To:</b> " + this.end.getId() + "<br>" + "<b>Number of vehicles:</b> " + this.numberOfVehicles + "<br>" + "<b>Start time:</b> " + TimeConverter.toString(this.beginTime) + "<br>" + "<b>End time:</b> " + TimeConverter.toString(this.endTime) + "</html>";
    }

    public TypeSelection<VehicleType> getVehicleSelection() {
        return this.vehicleSelection;
    }

    @Override
    public void handleLocationChanged(Handle h) {
    }

    @Override
    public boolean Hit(Point p) {
        return this.shape.getBounds2D().contains(p.x, p.y) && this.shape.contains(p.x, p.y);
    }

    @Override
    public boolean Hit(Rectangle transformedRectangle) {
        return this.shape.intersects(transformedRectangle);
    }

    public void setBeginTime(int beginTime) {
        this.beginTime = beginTime;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void SetDependencies() {
        this.start.AddDependentTrafficElement(this);
        this.end.AddDependentTrafficElement(this);
    }

    public void ReleaseDependencies() {
        this.start.RemoveDependentTrafficElement(this);
        this.end.RemoveDependentTrafficElement(this);
    }

    public void setEnd(Edge end) {
        this.end = end;
    }

    public void setEndTime(int endTime) {
        this.endTime = endTime;
    }

    public void setFrom(Point2D.Float from) {
        this.from = new Point2DExt(from.x, from.y);
    }

    public void setNumberOfVehicles(int numberOfVehicles) {
        this.numberOfVehicles = numberOfVehicles;
    }

    public void setStart(Edge start) {
        this.start = start;
    }

    public void setTo(Point2D.Double to) {
        this.shape = new Line2DExt(this.from, to);
    }

    public void setVehicleSelection(TypeSelection<VehicleType> vehicleSelection) {
        this.vehicleSelection = vehicleSelection;
    }

    @Override
    public TrafficDefinitionElement elementClone() {
        return new Flow(this);
    }

    @Override
    public String toXML() {
        StringBuilder sb = new StringBuilder();
        sb.append("<flow name=\"" + this.name + "\" from=\"" + this.start.getId() + "\" to=\"" + this.end.getId() + "\" startingTime=\"" + String.valueOf(this.beginTime) + "\" endingTime=\"" + String.valueOf(this.endTime) + "\" numberOfVehicles=\"" + String.valueOf(this.numberOfVehicles) + "\">\n");
        sb.append("<vehicleSelection>\n");
        for (Pair pair : this.vehicleSelection) {
            sb.append("<selectedVehicle vehicleType=\"" + ((VehicleType)pair.getFirst()).getName() + "\" probability=\"" + ((Float)pair.getSecond()).toString() + "\"/>\n");
        }
        sb.append("</vehicleSelection>\n");
        sb.append("</flow>\n");
        return sb.toString();
    }
}

