'''
 ====================================================================
 Copyright (c) 2003-2006 Barry A Scott.  All rights reserved.

 This software is licensed as described in the file LICENSE.txt,
 which you should have received as part of this distribution.

 ====================================================================

    wb_show_diff_frame.py

'''

import wx

import wb_diff_frame

class ShowDiffFrame(wx.Frame):
    def __init__( self, app, raw_text, title_left, title_right):

        # fix up line endings CRLF to LF and CR to LF
        text = raw_text.replace( '\r\n', '\n' ).replace( '\r', '\n' )

        diff_prefs = app.prefs.getDiffWindow()

        extra_style = 0
        if diff_prefs.maximized:
            extra_style = wx.MAXIMIZE
        wx.Frame.__init__( self, None, -1, "Diff %s and %s" % (title_left, title_right),
                diff_prefs.frame_position,
                diff_prefs.frame_size,
                wx.DEFAULT_FRAME_STYLE|extra_style )

        text_control = wx.TextCtrl( self, -1, style=wx.TE_MULTILINE|wx.MAXIMIZE )
        text_control.SetEditable( False )
        text_control.SetFont( wx.Font(wb_diff_frame.point_size, wx.DEFAULT,
                                     wx.NORMAL, wx.NORMAL, False, wb_diff_frame.face) )
        text_control.AppendText( text )

        self.CreateStatusBar()
        self.Show( True )
