'''
 ====================================================================
 Copyright (c) 2003-2006 Barry A Scott.  All rights reserved.

 This software is licensed as described in the file LICENSE.txt,
 which you should have received as part of this distribution.

 ====================================================================

    wb_source_control_providers.py

'''
import wb_exceptions

_source_code_providers = {}


def hasProvider( name ):
    return _source_code_providers.has_key( name )

def getProvider( name ):
    return _source_code_providers[ name ]

def registerProvider( provider ):
    _source_code_providers[ provider.name ] = provider

def getProviderAboutStrings():
    about_string = ''
    for provider in _source_code_providers.values():
        about_string += provider.getAboutString()

    return about_string

class Provider:
    def __init__( self, name ):
        self.name = name

    def getProjectInfo( self, app, parent ):
        raise wb_exceptions.InternalError( 'getProjectInfo not implemented' )

    def getProjectTreeItem( self, app, project_info ):
        raise wb_exceptions.InternalError( 'getProjectTreeItem not implemented' )

    def getListHandler( self, app, list_panel, project_info ):
        raise wb_exceptions.InternalError( 'getListHandler not implemented' )

    def getAboutString( self ):
        raise wb_exceptions.InternalError( 'getAboutString not implemented' )

class ProjectInfo:
    def __init__( self, app, parent, provider_name ):
        self.app = app
        self.parent = parent
        self.provider_name = provider_name
        self.project_name = None
        self.new_file_template_dir = ''
        self.menu_name = None
        self.menu_folder = ''

    def init( self, project_name, **kws ):
        self.project_name = project_name

    def isChild( self, pi ):
        # return tree if pi is a child of this pi
        raise wb_exceptions.InternalError( 'isChild not implemented' )

    def readPreferences( self, get_option ):
        if get_option.has( 'new_file_template_dir' ):
            self.new_file_template_dir = get_option.getstr( 'new_file_template_dir' )
        if get_option.has( 'menu_folder' ):
            self.menu_folder = get_option.getstr( 'menu_folder' )
        if get_option.has( 'menu_name' ):
            self.menu_name = get_option.getstr( 'menu_name' )

    def writePreferences( self, set_option ):
        set_option.set( 'provider', self.provider_name )
        set_option.set( 'name', self.project_name )
        set_option.set( 'new_file_template_dir', self.new_file_template_dir )
        if self.menu_name is not None:
            set_option.set( 'menu_name', self.menu_name )
        set_option.set( 'menu_folder', self.menu_folder )
