/*
 * SwamiLog.h - Message logging and debugging functions
 *
 * Swami
 * Copyright (C) 1999-2003 Josh Green <jgreen@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA or point your web browser to http://www.gnu.org.
 *
 * To contact the author of this program:
 * Email: Josh Green <jgreen@users.sourceforge.net>
 * Swami homepage: http://swami.sourceforge.net
 */

#ifndef __SWAMI_LOG_H__
#define __SWAMI_LOG_H__

#include <glib.h>
#include "swamidll.h"

/* FIXME */
#define SWAMI_DEBUG_ENABLED


SWAMI_API extern void _swami_pretty_log_handler (GLogLevelFlags flags,
						 char *file, char *function,
						 int line, char *format, ...);

#ifdef SWAMI_DEBUG_ENABLED
#define SWAMI_DEBUG(format, args...) \
  _swami_pretty_log_handler (G_LOG_LEVEL_DEBUG, \
	 	 	     __FILE__, __PRETTY_FUNCTION__, __LINE__, \
	 	 	     format, ## args);
#else
#define SWAMI_DEBUG(format, args...)
#endif

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L
#define SWAMI_INFO(...) \
  _swami_pretty_log_handler (G_LOG_LEVEL_INFO, \
                             __FILE__, G_GNUC_PRETTY_FUNCTION__, __LINE__, \
                             __VA_ARGS__);
#define SWAMI_PARAM_ERROR(param) \
  _swami_pretty_log_handler (G_LOG_LEVEL_CRITICAL, \
                             __FILE__, G_GNUC_PRETTY_FUNCTION__, __LINE__, \
                             "Invalid function parameter value for '%s'.", \
                             param);
#define SWAMI_CRITICAL(...) \
  _swami_pretty_log_handler (G_LOG_LEVEL_CRITICAL, \
                             __FILE__, G_GNUC_PRETTY_FUNCTION__, __LINE__, \
                             __VA_ARGS__);
#elif defined (__GNUC__)
#define SWAMI_INFO(format...) \
  _swami_pretty_log_handler (G_LOG_LEVEL_INFO, \
	 	 	     __FILE__, __PRETTY_FUNCTION__, __LINE__, \
	 	 	     format);

#define SWAMI_PARAM_ERROR(param) \
  _swami_pretty_log_handler (G_LOG_LEVEL_CRITICAL, \
	 	 	     __FILE__, __PRETTY_FUNCTION__, __LINE__, \
	 	 	     "Invalid function parameter value for '%s'.", \
	 	 	     param);

#define SWAMI_CRITICAL(format...) \
  _swami_pretty_log_handler (G_LOG_LEVEL_CRITICAL, \
	 	 	     __FILE__, __PRETTY_FUNCTION__, __LINE__, \
	 	 	     format);
#else  /* !__GNUC__ */
#warning("Not GNU C compiler!")
#define SWAMI_INFO
#define SWAMI_PARAM_ERROR(param)
  _swami_pretty_log_handler (G_LOG_LEVEL_CRITICAL, \
                             __FILE__, G_GNUC_PRETTY_FUNCTION, __LINE__, \
                             "Invalid function parameter value for '%s'.", \
                             param);

#define SWAMI_CRITICAL
#endif /* !__GNUC__ */

#endif /* __SWAMI_LOG_H__ */
