
#ifndef GVERB_H
#define GVERB_H

#define FDNORDER 4

typedef struct {
  int rate;
  float inputbandwidth;
  float taillevel;
  float earlylevel;
  ty_damper *inputdamper;
  float maxroomsize;
  float roomsize;
  float revtime;
  float maxdelay;
  float largestdelay;
  ty_fixeddelay **fdndels;
  float *fdngains;
  int *fdnlens;
  ty_damper **fdndamps; 
  float fdndamping;
  ty_diffuser **ldifs;
  ty_diffuser **rdifs;
  ty_fixeddelay *tapdelay;
  int *taps;
  float *tapgains;
  float *d;
  float *u;
  float *f;
  double alpha;
} ty_gverb;


ty_gverb *gverb_new(int, float, float, float, float, float, float, float, float);
void gverb_free(ty_gverb *);
void gverb_do(ty_gverb *, float, float *, float *);
void gverb_set_roomsize(ty_gverb *, float);
void gverb_set_revtime(ty_gverb *, float);
void gverb_set_damping(ty_gverb *, float);
void gverb_set_inputbandwidth(ty_gverb *, float);
void gverb_set_earlylevel(ty_gverb *, float);
void gverb_set_taillevel(ty_gverb *, float);

#endif
