
#ifndef GVERBDSP_H
#define GVERBDSP_H

typedef struct {
  int size;
  int idx;
  float *buf;
} ty_fixeddelay;

typedef struct {
  int size;
  float coeff;
  int idx;
  float *buf;
} ty_diffuser;

typedef struct {
  float damping;
  float delay;
} ty_damper;

ty_diffuser *diffuser_make(int, float);
void diffuser_free(ty_diffuser *);
float diffuser_do(ty_diffuser *, float);

ty_damper *damper_make(float);
void damper_free(ty_damper *);
void damper_set(ty_damper *, float);
float damper_do(ty_damper *, float);

ty_fixeddelay *fixeddelay_make(int);
void fixeddelay_free(ty_fixeddelay *);
float fixeddelay_read(ty_fixeddelay *, int);
void fixeddelay_write(ty_fixeddelay *, float);

int isprime(int);
int nearest_prime(int, float);
inline int ff_round(float f);
inline int ff_trunc(float f);

#endif
