/*
 * Decompiled with CFR 0.152.
 */
package demo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class SwingBrowser
extends JFrame
implements HyperlinkListener,
ActionListener {
    private JButton homeButton;
    private JTextField urlField;
    private JEditorPane htmlPane;
    private String initialURL;

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            new SwingBrowser();
        } else {
            new SwingBrowser(stringArray[0]);
        }
    }

    public SwingBrowser() {
        this("");
    }

    public SwingBrowser(String string) {
        super("Simple Swing Browser");
        Serializable serializable;
        this.initialURL = string;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout());
        jPanel.add((Component)jPanel2, "West");
        this.homeButton = new JButton();
        this.homeButton.setIcon(new ImageIcon(this.getClass().getResource("/demo/Homepage.png")));
        this.homeButton.addActionListener(this);
        this.urlField = new JTextField(100);
        this.urlField.setText(string);
        jPanel.add((Component)this.urlField, "Center");
        this.urlField.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    String string = SwingBrowser.this.urlField.getText();
                    try {
                        SwingBrowser.this.htmlPane.setPage(new URL(string));
                        SwingBrowser.this.urlField.setText(string);
                    }
                    catch (IOException iOException) {
                        SwingBrowser.this.warnUser("Can't follow link to " + string + ": " + iOException);
                    }
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
            }

            public void keyTyped(KeyEvent keyEvent) {
            }
        });
        jPanel2.add(this.homeButton);
        this.getContentPane().add((Component)jPanel, "North");
        String string2 = "<html><body><h2>Test HTML</h2><p>This is a simple browser test. Type in a URL at the top to go to a new location, or hit the home button to go back to the URL you supplied.</p></body></html>";
        try {
            this.htmlPane = string.equals("") ? new JEditorPane("text/html", string2) : new JEditorPane(string);
            this.htmlPane.setEditable(false);
            this.htmlPane.addHyperlinkListener(this);
            serializable = new JScrollPane(this.htmlPane);
            this.getContentPane().add((Component)serializable, "Center");
        }
        catch (IOException iOException) {
            this.warnUser("Can't build HTML pane for " + string + ": " + iOException);
        }
        serializable = Toolkit.getDefaultToolkit().getScreenSize();
        int n = serializable.width * 8 / 10;
        int n2 = serializable.height * 8 / 10;
        this.setBounds(n / 8, n2 / 8, n, n2);
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = this.initialURL;
        if (string.equals("")) {
            this.warnUser("You didn't supply an initial home URL!");
            return;
        }
        try {
            this.htmlPane.setPage(new URL(string));
            this.urlField.setText(string);
        }
        catch (IOException iOException) {
            this.warnUser("Can't follow link to " + string + ": " + iOException);
        }
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            try {
                this.htmlPane.setPage(hyperlinkEvent.getURL());
                this.urlField.setText(hyperlinkEvent.getURL().toExternalForm());
            }
            catch (IOException iOException) {
                this.warnUser("Can't follow link to " + hyperlinkEvent.getURL().toExternalForm() + ": " + iOException);
            }
        }
    }

    private void warnUser(String string) {
        JOptionPane.showMessageDialog(this, string, "Error", 0);
    }
}

