/*
 * Decompiled with CFR 0.152.
 */
package swingwtx.swing;

import java.util.Iterator;
import java.util.Vector;
import swingwt.awt.BorderLayout;
import swingwt.awt.Component;
import swingwt.awt.Container;
import swingwt.awt.Dimension;
import swingwt.awt.event.AdjustmentEvent;
import swingwt.awt.event.AdjustmentListener;
import swingwt.awt.event.FocusListener;
import swingwt.awt.event.KeyAdapter;
import swingwt.awt.event.KeyEvent;
import swingwt.awt.event.KeyListener;
import swingwtx.swing.JPanel;
import swingwtx.swing.JScrollBar;
import swingwtx.swing.JTextField;
import swingwtx.swing.SpinnerModel;
import swingwtx.swing.SpinnerNumberModel;
import swingwtx.swing.event.ChangeEvent;
import swingwtx.swing.event.ChangeListener;

public class JSpinner
extends JPanel
implements ChangeListener {
    protected Vector changeListeners = new Vector();
    protected SpinnerModel model = null;
    protected JTextField text = new JTextField(1);
    protected JScrollBar spin = new JScrollBar(0);
    protected int lastValue = 300000;
    protected static final int CANCELED = 0;
    protected static final int INVISIBLE = 1;
    protected static final int VISIBLE = 2;

    public JSpinner() {
        this(new SpinnerNumberModel());
    }

    public JSpinner(SpinnerModel model) {
        this.setPreferredSize(new Dimension(100, 30));
        this.setModel(model);
        this.setLayout(new BorderLayout());
        this.text.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 0x1000002) {
                    JSpinner.this.nextItem();
                    e.consume();
                } else if (e.getKeyCode() == 0x1000001) {
                    JSpinner.this.previousItem();
                    e.consume();
                }
            }
        });
        this.spin.setMinimum(0);
        this.spin.setMaximum(650000);
        this.spin.setValue(30000);
        this.spin.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent e) {
                if (e.getValue() > JSpinner.this.lastValue) {
                    JSpinner.this.previousItem();
                } else {
                    JSpinner.this.nextItem();
                }
                JSpinner.this.lastValue = e.getValue();
            }
        });
        this.add((Component)this.text, "Center");
        this.add((Component)this.spin, "East");
    }

    public void setModel(SpinnerModel model) {
        this.model = model;
        model.addChangeListener(this);
    }

    public SpinnerModel getModel() {
        return this.model;
    }

    public void addFocusListener(FocusListener l) {
        this.text.addFocusListener(l);
    }

    public void removeFocusListener(FocusListener l) {
        this.text.removeFocusListener(l);
    }

    public void addKeyListener(KeyListener l) {
        this.text.addKeyListener(l);
    }

    public void removeKeyListener(KeyListener l) {
        this.text.removeKeyListener(l);
    }

    public void addChangeListener(ChangeListener l) {
        this.changeListeners.add(l);
    }

    public void removeItemListener(ChangeListener l) {
        this.changeListeners.remove(l);
    }

    public void processChangeEvent(ChangeEvent e) {
        Iterator i = this.changeListeners.iterator();
        while (i.hasNext()) {
            ChangeListener l = (ChangeListener)i.next();
            l.stateChanged(e);
        }
    }

    public void setValue(Object o) {
        this.model.setValue(o);
    }

    public Object getValue() {
        return this.model.getValue();
    }

    public void setEnabled(boolean b) {
        this.text.setEnabled(b);
        this.spin.setEnabled(b);
    }

    public boolean isEnabled() {
        return this.spin.isEnabled();
    }

    public String getToolTipText() {
        return this.text.getToolTipText();
    }

    public void setToolTipText(String tip) {
        this.text.setToolTipText(tip);
    }

    protected void previousItem() {
        this.model.setValue(this.model.getPreviousValue());
    }

    protected void nextItem() {
        this.model.setValue(this.model.getNextValue());
    }

    public void requestFocus() {
        this.text.requestFocus();
    }

    public void grabFocus() {
        this.text.grabFocus();
    }

    public JTextField getJTextField() {
        return this.text;
    }

    public void stateChanged(ChangeEvent e) {
        this.text.setText(this.model.getValue().toString());
    }

    public void setBounds(int x, int y, int width, int height) {
        if (height > 30) {
            height = 30;
        }
        super.setBounds(x, y, width, height);
    }

    protected Dimension calculatePreferredSize() {
        Dimension size = new Dimension(100, 30);
        this.setSize(size);
        return size;
    }

    public void setSwingWTParent(Container parent) throws Exception {
        super.setSwingWTParent(parent);
        this.stateChanged(new ChangeEvent(this.model));
    }
}

