/*
 * Decompiled with CFR 0.152.
 */
package swingwtx.swing;

import java.util.Iterator;
import java.util.Vector;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import swingwt.awt.Component;
import swingwt.awt.Container;
import swingwt.awt.Image;
import swingwtx.swing.Icon;
import swingwtx.swing.ImageIcon;
import swingwtx.swing.JComponent;
import swingwtx.swing.SwingConstants;
import swingwtx.swing.SwingUtilities;
import swingwtx.swing.SwingWTUtils;
import swingwtx.swing.TabItemCache;
import swingwtx.swing.event.ChangeEvent;
import swingwtx.swing.event.ChangeListener;

public class JTabbedPane
extends JComponent
implements SwingConstants {
    protected TabFolder ppeer = null;
    protected int pTabPlacement = 1;
    protected Vector changeListeners = new Vector();
    protected Vector tabs = new Vector();
    private int iRetVal = 0;
    private String sRetVal = "";
    private Object retval;

    public void addChangeListener(ChangeListener l) {
        this.changeListeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeListeners.remove(l);
    }

    public void addTab(String title, Component component) {
        this.addTab(title, null, component);
    }

    public void addTab(String title, Icon icon, Component component) {
        this.addTab(title, icon, component, null, true);
    }

    public void addTab(String title, Icon icon, Component component, String tip) {
        this.addTab(title, icon, component, tip, true);
    }

    public void addTab(String title, Icon icon, Component component, String tip, boolean enabled) {
        this.addTab(title, icon, component, tip, enabled, false);
    }

    public void add(Component component, Object modifiers) {
        this.addTab("", component);
    }

    public Component add(Component component) {
        this.addTab("", component);
        return component;
    }

    public Component add(String title, Component component) {
        this.addTab(title, component);
        return component;
    }

    public void addTab(final String title, final Icon icon, final Component component, final String tip, final boolean enabled, boolean fromcache) {
        if (!fromcache) {
            TabItemCache t = new TabItemCache();
            t.title = title;
            t.icon = icon;
            t.component = component;
            t.tip = tip;
            t.enabled = enabled;
            this.tabs.add(t);
            t = null;
            return;
        }
        final JTabbedPane me = this;
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                if (!SwingWTUtils.isSWTControlAvailable((Control)JTabbedPane.this.ppeer)) {
                    return;
                }
                TabItem t = new TabItem(JTabbedPane.this.ppeer, 0);
                try {
                    component.setSwingWTParent(me);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (title != null) {
                    t.setText(SwingWTUtils.removeHTML(title));
                }
                if (icon != null) {
                    t.setImage(SwingWTUtils.getSWTImageFromSwingIcon(me, icon));
                }
                if (component != null && enabled) {
                    t.setControl(component.getSWTPeer());
                }
                if (tip != null) {
                    t.setToolTipText(tip);
                }
                t.setData("enabled", (Object)(enabled ? "true" : "false"));
                JTabbedPane.this.postponeLayout();
            }
        });
    }

    public Icon getIconAt(final int index) {
        if (!SwingWTUtils.isSWTControlAvailable((Control)this.ppeer)) {
            TabItemCache t = (TabItemCache)this.tabs.get(index);
            return t.icon;
        }
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                Image image = new Image();
                image.image = JTabbedPane.this.ppeer.getItem(index).getImage();
                JTabbedPane.this.retval = new ImageIcon(image);
            }
        });
        return (Icon)this.retval;
    }

    public void setIconAt(final int index, final Icon icon) {
        final JTabbedPane pthis = this;
        if (!SwingWTUtils.isSWTControlAvailable((Control)this.ppeer)) {
            TabItemCache t = (TabItemCache)this.tabs.get(index);
            t.icon = icon;
        } else {
            SwingUtilities.invokeSync(new Runnable(){

                public void run() {
                    JTabbedPane.this.ppeer.getItem(index).setImage(SwingWTUtils.getSWTImageFromSwingIcon(pthis, icon));
                }
            });
        }
    }

    public void setEnabledAt(final int index, final boolean b) {
        if (SwingWTUtils.isSWTControlAvailable((Control)this.ppeer)) {
            SwingUtilities.invokeSync(new Runnable(){

                public void run() {
                    JTabbedPane.this.ppeer.getItem(index).setData("enabled", (Object)(b ? "true" : "false"));
                    if (!b) {
                        JTabbedPane.this.ppeer.getItem(index).setControl(null);
                    } else {
                        JTabbedPane.this.ppeer.getItem(index).setControl(((TabItemCache)JTabbedPane.this.tabs.get((int)index)).component.getSWTPeer());
                    }
                }
            });
        } else {
            TabItemCache t = (TabItemCache)this.tabs.get(index);
            t.enabled = b;
        }
    }

    public int getTabCount() {
        if (!SwingWTUtils.isSWTControlAvailable((Control)this.ppeer)) {
            return this.tabs.size();
        }
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                JTabbedPane.this.iRetVal = JTabbedPane.this.ppeer.getItemCount();
            }
        });
        return this.iRetVal;
    }

    public int getSelectedIndex() {
        if (SwingWTUtils.isSWTControlAvailable((Control)this.ppeer)) {
            SwingUtilities.invokeSync(new Runnable(){

                public void run() {
                    JTabbedPane.this.iRetVal = JTabbedPane.this.ppeer.getSelectionIndex();
                }
            });
        } else {
            this.iRetVal = -1;
        }
        return this.iRetVal;
    }

    public Component getSelectedComponent() {
        int i = this.getSelectedIndex();
        if (i != -1) {
            return ((TabItemCache)this.tabs.get((int)i)).component;
        }
        return null;
    }

    public void setSelectedIndex(final int index) {
        if (SwingWTUtils.isSWTControlAvailable((Control)this.ppeer)) {
            SwingUtilities.invokeSync(new Runnable(){

                public void run() {
                    JTabbedPane.this.ppeer.setSelection(index);
                }
            });
        }
    }

    public void removeTabAt(final int index) {
        if (SwingWTUtils.isSWTControlAvailable((Control)this.ppeer)) {
            SwingUtilities.invokeSync(new Runnable(){

                public void run() {
                    JTabbedPane.this.tabs.removeElementAt(index);
                    JTabbedPane.this.ppeer.getItem(index).dispose();
                }
            });
        } else {
            this.tabs.removeElementAt(index);
        }
    }

    public String getTitleAt(final int index) {
        if (SwingWTUtils.isSWTControlAvailable((Control)this.ppeer)) {
            SwingUtilities.invokeSync(new Runnable(){

                public void run() {
                    JTabbedPane.this.sRetVal = JTabbedPane.this.ppeer.getItem(index).getText();
                }
            });
            return this.sRetVal;
        }
        TabItemCache t = (TabItemCache)this.tabs.get(index);
        return t.title;
    }

    public void setTitleAt(final int index, final String title) {
        if (SwingWTUtils.isSWTControlAvailable((Control)this.ppeer)) {
            SwingUtilities.invokeSync(new Runnable(){

                public void run() {
                    JTabbedPane.this.ppeer.getItem(index).setText(SwingWTUtils.removeHTML(title));
                }
            });
        } else {
            TabItemCache t = (TabItemCache)this.tabs.get(index);
            t.title = title;
        }
    }

    public String getToolTipTextAt(final int index) {
        if (SwingWTUtils.isSWTControlAvailable((Control)this.ppeer)) {
            SwingUtilities.invokeSync(new Runnable(){

                public void run() {
                    JTabbedPane.this.sRetVal = JTabbedPane.this.ppeer.getItem(index).getToolTipText();
                }
            });
            return this.sRetVal;
        }
        TabItemCache t = (TabItemCache)this.tabs.get(index);
        return t.tooltip;
    }

    public void setToolTipTextAt(final int index, final String text) {
        if (SwingWTUtils.isSWTControlAvailable((Control)this.ppeer)) {
            SwingUtilities.invokeSync(new Runnable(){

                public void run() {
                    JTabbedPane.this.ppeer.getItem(index).setToolTipText(text);
                }
            });
        } else {
            TabItemCache t = (TabItemCache)this.tabs.get(index);
            t.tooltip = text;
        }
    }

    public int indexOfComponent(final Component c) {
        final int[] ret = new int[1];
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                if (SwingWTUtils.isSWTControlAvailable((Control)JTabbedPane.this.ppeer)) {
                    TabItem[] tabs = JTabbedPane.this.ppeer.getItems();
                    for (int i = 0; i < tabs.length; ++i) {
                        if (!tabs[i].getControl().equals(c.getSWTPeer())) continue;
                        ret[0] = i;
                        break;
                    }
                } else {
                    for (int i = 0; i < JTabbedPane.this.tabs.size(); ++i) {
                        if (!((TabItemCache)JTabbedPane.this.tabs.get((int)i)).component.equals(c)) continue;
                        ret[0] = i;
                        break;
                    }
                }
            }
        });
        return ret[0];
    }

    public int indexOfTab(final String name) {
        final int[] ret = new int[1];
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                if (SwingWTUtils.isSWTControlAvailable((Control)JTabbedPane.this.ppeer)) {
                    TabItem[] tabs = JTabbedPane.this.ppeer.getItems();
                    for (int i = 0; i < tabs.length; ++i) {
                        if (!tabs[i].getText().equals(name)) continue;
                        ret[0] = i;
                        break;
                    }
                } else {
                    for (int i = 0; i < JTabbedPane.this.tabs.size(); ++i) {
                        if (!((TabItemCache)JTabbedPane.this.tabs.get((int)i)).title.equals(name)) continue;
                        ret[0] = i;
                        break;
                    }
                }
            }
        });
        return ret[0];
    }

    public int indexOfTab(final Icon icon) {
        final int[] ret = new int[1];
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                for (int i = 0; i < JTabbedPane.this.tabs.size(); ++i) {
                    if (!((TabItemCache)JTabbedPane.this.tabs.get((int)i)).icon.equals(icon)) continue;
                    ret[0] = i;
                    break;
                }
            }
        });
        return ret[0];
    }

    public Component getComponentAt(int index) {
        return ((TabItemCache)this.tabs.get((int)index)).component;
    }

    public int getTabPlacement() {
        return this.pTabPlacement;
    }

    public void setTabPlacement(int place) {
        this.pTabPlacement = place;
    }

    public Control getSWTPeer() {
        return this.ppeer;
    }

    protected void postponeLayout() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JTabbedPane.this.layoutTab();
            }
        });
    }

    protected void layoutTab() {
        Control p = this.ppeer.getItem(this.ppeer.getSelectionIndex()).getControl();
        if (p instanceof Composite) {
            ((Composite)p).layout(true);
        } else {
            this.parent.invalidate();
        }
    }

    protected void processChangeEvent(ChangeEvent e) {
        Iterator i = this.changeListeners.iterator();
        while (i.hasNext()) {
            ChangeListener l = (ChangeListener)i.next();
            l.stateChanged(e);
        }
    }

    public void setSwingWTParent(Container parent) throws Exception {
        this.descendantHasPeer = true;
        this.ppeer = new TabFolder(parent.getComposite(), SwingWTUtils.translateSwingAlignmentConstant(this.pTabPlacement));
        this.peer = this.ppeer;
        this.composite = this.ppeer;
        this.parent = parent;
        if (this.tabs.size() > 0) {
            Object[] tabso = this.tabs.toArray();
            for (int i = 0; i < tabso.length; ++i) {
                TabItemCache t = (TabItemCache)tabso[i];
                this.addTab(t.title, t.icon, t.component, t.tip, t.enabled, true);
            }
        }
        final JTabbedPane me = this;
        this.ppeer.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (JTabbedPane.this.checkTabEnabled(e)) {
                    JTabbedPane.this.postponeLayout();
                    ChangeEvent ce = new ChangeEvent(me);
                    JTabbedPane.this.processChangeEvent(ce);
                    JTabbedPane.this.getSelectedComponent().show();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        if (this.ppeer.getItemCount() > 0) {
            this.postponeLayout();
        }
    }

    protected boolean checkTabEnabled(SelectionEvent e) {
        e.doit = e.item.getData("enabled").toString().equals("true");
        return e.doit;
    }

    public Component getComponent(int i) {
        return ((TabItemCache)this.tabs.get((int)i)).component;
    }

    public Component[] getComponents() {
        TabItemCache[] comp = this.tabs.toArray(new TabItemCache[0]);
        Component[] cps = new Component[comp.length];
        for (int i = 0; i < comp.length; ++i) {
            cps[i] = comp[i].component;
        }
        return cps;
    }
}

