/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.ui.internal.DefaultStackPresentationSite;
import org.eclipse.ui.internal.Perspective;
import org.eclipse.ui.internal.ViewPane;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.dnd.DragUtil;
import org.eclipse.ui.internal.presentations.SystemMenuClose;
import org.eclipse.ui.internal.presentations.SystemMenuMaximize;
import org.eclipse.ui.internal.presentations.SystemMenuMinimize;
import org.eclipse.ui.internal.presentations.SystemMenuMoveView;
import org.eclipse.ui.internal.presentations.SystemMenuRestore;
import org.eclipse.ui.internal.presentations.SystemMenuSizeFastView;
import org.eclipse.ui.presentations.AbstractPresentationFactory;
import org.eclipse.ui.presentations.IPresentablePart;
import org.eclipse.ui.presentations.IStackPresentationSite;
import org.eclipse.ui.presentations.StackPresentation;

public class FastViewPane {
    private int side = 16384;
    private ViewPane currentPane;
    private Composite clientComposite;
    private static final int SASH_SIZE = 3;
    private static final int MIN_FASTVIEW_SIZE = 10;
    private int size;
    private Sash sash;
    private int redrawCounter = 0;
    private DefaultStackPresentationSite site = new DefaultStackPresentationSite(){

        public void setState(int newState) {
            super.setState(newState);
            FastViewPane.this.currentPane;
            switch (newState) {
                case 0: {
                    FastViewPane.this.currentPane.getPage().toggleFastView(FastViewPane.this.currentPane.getViewReference());
                    break;
                }
                case 1: {
                    FastViewPane.this.sash.setVisible(false);
                    this.getPresentation().setBounds(FastViewPane.this.getBounds());
                    break;
                }
                case 2: {
                    FastViewPane.this.sash.setVisible(true);
                    this.getPresentation().setBounds(FastViewPane.this.getBounds());
                }
            }
        }

        public void close(IPresentablePart part) {
            if (!this.isCloseable(part)) {
                return;
            }
            FastViewPane.this.currentPane.getPage().hideView(FastViewPane.this.currentPane.getViewReference());
        }

        public void dragStart(IPresentablePart beingDragged, Point initialPosition, boolean keyboard) {
            this.dragStart(initialPosition, keyboard);
        }

        public void dragStart(Point initialPosition, boolean keyboard) {
            ViewPane pane = FastViewPane.this.currentPane;
            Control control = this.getPresentation().getControl();
            Rectangle bounds = Geometry.toDisplay((Control)FastViewPane.this.clientComposite, (Rectangle)control.getBounds());
            Perspective persp = FastViewPane.this.currentPane.getPage().getActivePerspective();
            persp.setActiveFastView(null, 0);
            DragUtil.performDrag(pane, bounds, initialPosition, !keyboard);
        }
    };
    private IContributionItem systemMenuContribution;
    private Listener resizeListener = new Listener(){

        public void handleEvent(Event event) {
            if (event.type == 11 && FastViewPane.this.currentPane != null) {
                FastViewPane.this.setSize(FastViewPane.this.size);
            }
        }
    };
    private SelectionAdapter selectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            if (FastViewPane.this.currentPane != null) {
                Point location;
                Rectangle bounds = FastViewPane.this.clientComposite.getClientArea();
                int distanceFromEdge = Geometry.getDistanceFromEdge((Rectangle)bounds, (Point)(location = new Point(e.x, e.y)), (int)FastViewPane.this.side);
                if (distanceFromEdge < 10) {
                    distanceFromEdge = 10;
                }
                if (FastViewPane.this.side != 128 && FastViewPane.this.side != 16384) {
                    distanceFromEdge -= 3;
                }
                FastViewPane.this.setSize(distanceFromEdge);
                if (e.detail != 1) {
                    FastViewPane.this.updateFastViewSashBounds();
                    FastViewPane.this.sash.redraw();
                }
            }
        }
    };

    public void moveSash() {
        KeyAdapter listener = new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u001b' || e.character == '\r') {
                    FastViewPane.this.currentPane.setFocus();
                }
            }
        };
        this.sash.addFocusListener((FocusListener)new FocusAdapter((KeyListener)listener){
            private final /* synthetic */ KeyListener val$listener;
            {
                this.val$listener = keyListener;
            }

            public void focusGained(FocusEvent e) {
                FastViewPane.this.sash.setBackground(FastViewPane.this.sash.getDisplay().getSystemColor(26));
                FastViewPane.this.sash.addKeyListener(this.val$listener);
            }

            public void focusLost(FocusEvent e) {
                FastViewPane.this.sash.setBackground(null);
                FastViewPane.this.sash.removeKeyListener(this.val$listener);
            }
        });
        this.sash.setFocus();
    }

    private void setSize(int size) {
        this.size = size;
        ++this.redrawCounter;
        this.getPresentation().getControl().getDisplay().asyncExec(new Runnable(){

            public void run() {
                FastViewPane fastViewPane = FastViewPane.this;
                fastViewPane.redrawCounter = fastViewPane.redrawCounter - 1;
                StackPresentation presentation = FastViewPane.this.getPresentation();
                if (presentation == null || presentation.getControl().isDisposed()) {
                    return;
                }
                if (FastViewPane.this.redrawCounter == 0) {
                    FastViewPane.this.getPresentation().setBounds(FastViewPane.this.getBounds());
                    FastViewPane.this.updateFastViewSashBounds();
                }
            }
        });
    }

    public float getCurrentRatio() {
        if (this.currentPane == null) {
            return 0.0f;
        }
        boolean isVertical = !Geometry.isHorizontal((int)this.side);
        Rectangle clientArea = this.clientComposite.getClientArea();
        int clientSize = Geometry.getDimension((Rectangle)clientArea, (boolean)isVertical);
        return (float)this.size / (float)clientSize;
    }

    private Rectangle getClientArea() {
        return this.clientComposite.getClientArea();
    }

    private Rectangle getBounds() {
        Rectangle bounds = this.getClientArea();
        if (this.site.getState() == 1) {
            return bounds;
        }
        boolean horizontal = Geometry.isHorizontal((int)this.side);
        int available = Geometry.getDimension((Rectangle)bounds, (!horizontal ? 1 : 0) != 0);
        return Geometry.getExtrudedEdge((Rectangle)bounds, (int)Math.min(this.size, available), (int)this.side);
    }

    public void showView(Composite newClientComposite, ViewPane pane, int newSide, float sizeRatio) {
        this.side = newSide;
        if (this.currentPane != null) {
            this.hideView();
        }
        this.currentPane = pane;
        this.clientComposite = newClientComposite;
        this.clientComposite.addListener(11, this.resizeListener);
        Control ctrl = pane.getControl();
        if (ctrl == null) {
            pane.createControl(this.clientComposite);
            ctrl = pane.getControl();
        }
        AbstractPresentationFactory factory = ((WorkbenchWindow)pane.getWorkbenchWindow()).getWindowConfigurer().getPresentationFactory();
        StackPresentation presentation = factory.createPresentation(newClientComposite, this.site, 1, 1152, pane.getPage().getPerspective().getId(), pane.getID());
        this.site.setPresentation(presentation);
        this.site.setPresentationState(2);
        presentation.addPart(pane.getPresentablePart(), null);
        presentation.selectPart(pane.getPresentablePart());
        presentation.setActive(true);
        presentation.setVisible(true);
        this.systemMenuContribution = new SystemMenuContribution(this.site, this);
        presentation.getSystemMenuManager().add(this.systemMenuContribution);
        ctrl.setEnabled(true);
        Composite parent = ctrl.getParent();
        pane.setVisible(true);
        pane.setFocus();
        boolean horizontal = Geometry.isHorizontal((int)this.side);
        this.sash = new Sash(parent, Geometry.getSwtHorizontalOrVerticalConstant((boolean)horizontal));
        this.sash.addSelectionListener((SelectionListener)this.selectionListener);
        Rectangle clientArea = newClientComposite.getClientArea();
        this.getPresentation().getControl().moveAbove(null);
        this.currentPane.moveAbove(null);
        this.sash.moveAbove(null);
        this.setSize((int)((float)Geometry.getDimension((Rectangle)clientArea, (!horizontal ? 1 : 0) != 0) * sizeRatio));
    }

    private void updateFastViewSashBounds() {
        Rectangle oldBounds;
        int oppositeSide;
        Rectangle bounds = this.getBounds();
        Rectangle newBounds = Geometry.getExtrudedEdge((Rectangle)bounds, (int)-3, (int)(oppositeSide = Geometry.getOppositeSide((int)this.side)));
        if (!newBounds.equals((Object)(oldBounds = this.sash.getBounds()))) {
            this.sash.setBounds(newBounds);
        }
    }

    public void dispose() {
        StackPresentation presentation;
        if (this.sash != null) {
            this.sash.dispose();
        }
        if ((presentation = this.getPresentation()) != null) {
            presentation.getSystemMenuManager().remove(this.systemMenuContribution);
            this.systemMenuContribution.dispose();
            this.systemMenuContribution = null;
        }
        this.site.dispose();
    }

    private Rectangle getFastViewBounds() {
        Rectangle clientArea = this.clientComposite.getClientArea();
        boolean isVertical = !Geometry.isHorizontal((int)this.side);
        int clientSize = Geometry.getDimension((Rectangle)clientArea, (boolean)isVertical);
        int viewSize = Math.min(Geometry.getDimension((Rectangle)this.getBounds(), (boolean)isVertical), clientSize - 10);
        return Geometry.getExtrudedEdge((Rectangle)clientArea, (int)viewSize, (int)this.side);
    }

    private StackPresentation getPresentation() {
        return this.site.getPresentation();
    }

    public void hideFastViewSash() {
        if (this.sash != null) {
            this.sash.setVisible(false);
        }
    }

    public void hideView() {
        if (this.currentPane == null) {
            return;
        }
        if (this.sash != null) {
            this.sash.dispose();
            this.sash = null;
        }
        this.clientComposite.removeListener(11, this.resizeListener);
        Control ctrl = this.currentPane.getControl();
        this.getPresentation().setVisible(false);
        this.site.dispose();
        ctrl.setEnabled(false);
        this.currentPane = null;
    }

    public ViewPane getCurrentPane() {
        return this.currentPane;
    }

    public void toggleZoom() {
        if (this.site.getState() == 1) {
            this.site.setState(2);
        } else {
            this.site.setState(1);
        }
    }

    private class SystemMenuContribution
    extends ContributionItem {
        private SystemMenuClose systemMenuClose;
        private SystemMenuMaximize systemMenuMaximize;
        private SystemMenuMinimize systemMenuMinimize;
        private SystemMenuMoveView systemMenuMoveView;
        private SystemMenuRestore systemMenuRestore;
        private SystemMenuSizeFastView systemMenuSizeFastView;

        SystemMenuContribution(IStackPresentationSite stackPresentationSite, FastViewPane fastViewPane2) {
            this.systemMenuClose = new SystemMenuClose(fastViewPane2.getCurrentPane().getPresentablePart(), stackPresentationSite);
            this.systemMenuMaximize = new SystemMenuMaximize(stackPresentationSite);
            this.systemMenuMinimize = new SystemMenuMinimize(stackPresentationSite);
            this.systemMenuMoveView = new SystemMenuMoveView(fastViewPane2.getCurrentPane().getPresentablePart(), stackPresentationSite);
            this.systemMenuRestore = new SystemMenuRestore(stackPresentationSite);
            this.systemMenuSizeFastView = new SystemMenuSizeFastView(fastViewPane2);
        }

        public void fill(Menu menu, int index) {
            this.systemMenuRestore.fill(menu, index);
            this.systemMenuMoveView.fill(menu, index);
            this.systemMenuSizeFastView.fill(menu, index);
            this.systemMenuMinimize.fill(menu, index);
            this.systemMenuMaximize.fill(menu, index);
            new MenuItem(menu, 2);
            this.systemMenuClose.fill(menu, index);
        }

        public void dispose() {
            this.systemMenuClose.dispose();
            this.systemMenuMaximize.dispose();
            this.systemMenuMinimize.dispose();
            this.systemMenuMoveView.dispose();
            this.systemMenuRestore.dispose();
            this.systemMenuSizeFastView.dispose();
        }

        public boolean isDynamic() {
            return true;
        }
    }
}

