/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.NavigationHistory;
import org.eclipse.ui.internal.NavigationHistoryEntry;
import org.eclipse.ui.internal.PageEventAction;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;

public class NavigationHistoryAction
extends PageEventAction {
    private boolean forward;
    private Menu historyMenu;
    private int MAX_HISTORY_LENGTH = 9;

    public NavigationHistoryAction(IWorkbenchWindow window, boolean forward) {
        super("", window);
        ISharedImages sharedImages = window.getWorkbench().getSharedImages();
        if (forward) {
            this.setText(WorkbenchMessages.getString("NavigationHistoryAction.forward.text"));
            this.setToolTipText(WorkbenchMessages.getString("NavigationHistoryAction.forward.toolTip"));
            WorkbenchHelp.setHelp((IAction)this, "org.eclipse.ui.navigation_history_forward");
            this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_FORWARD"));
            this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_FORWARD_DISABLED"));
            this.setActionDefinitionId("org.eclipse.ui.navigate.forwardHistory");
        } else {
            this.setText(WorkbenchMessages.getString("NavigationHistoryAction.backward.text"));
            this.setToolTipText(WorkbenchMessages.getString("NavigationHistoryAction.backward.toolTip"));
            WorkbenchHelp.setHelp((IAction)this, "org.eclipse.ui.navigation_history_backward");
            this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_BACK"));
            this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_BACK_DISABLED"));
            this.setActionDefinitionId("org.eclipse.ui.navigate.backwardHistory");
        }
        this.setEnabled(false);
        this.forward = forward;
        this.setMenuCreator(new MenuCreator());
    }

    public void pageClosed(IWorkbenchPage page) {
        super.pageClosed(page);
        this.setEnabled(false);
    }

    private NavigationHistoryEntry[] colapseEntries(NavigationHistoryEntry[] entries, int[] entriesCount) {
        ArrayList<NavigationHistoryEntry> allEntries = new ArrayList<NavigationHistoryEntry>(Arrays.asList(entries));
        NavigationHistoryEntry previousEntry = null;
        int i = -1;
        Iterator<NavigationHistoryEntry> iter = allEntries.iterator();
        while (iter.hasNext()) {
            String text;
            NavigationHistoryEntry entry = iter.next();
            if (previousEntry != null && (text = previousEntry.getHistoryText()) != null && text.equals(entry.getHistoryText()) && previousEntry.editorInfo == entry.editorInfo) {
                iter.remove();
                int n = i;
                entriesCount[n] = entriesCount[n] + 1;
                continue;
            }
            previousEntry = entry;
            ++i;
        }
        entries = new NavigationHistoryEntry[allEntries.size()];
        return allEntries.toArray(entries);
    }

    public void pageActivated(IWorkbenchPage page) {
        super.pageActivated(page);
        NavigationHistory nh = (NavigationHistory)page.getNavigationHistory();
        if (this.forward) {
            nh.setForwardAction(this);
        } else {
            nh.setBackwardAction(this);
        }
    }

    public void run() {
        if (this.getWorkbenchWindow() == null) {
            return;
        }
        IWorkbenchPage page = this.getActivePage();
        if (page != null) {
            NavigationHistory nh = (NavigationHistory)page.getNavigationHistory();
            if (this.forward) {
                nh.forward();
            } else {
                nh.backward();
            }
        }
    }

    public void update() {
        WorkbenchPage page = (WorkbenchPage)this.getActivePage();
        if (page == null) {
            return;
        }
        NavigationHistory history = (NavigationHistory)page.getNavigationHistory();
        if (this.forward) {
            this.setEnabled(history.canForward());
            NavigationHistoryEntry[] entries = history.getForwardEntries();
            if (entries.length > 0) {
                NavigationHistoryEntry entry = entries[0];
                String text = WorkbenchMessages.format("NavigationHistoryAction.forward.toolTipName", new String[]{entry.getHistoryText()});
                this.setToolTipText(text);
            } else {
                this.setToolTipText(WorkbenchMessages.getString("NavigationHistoryAction.forward.toolTip"));
            }
        } else {
            this.setEnabled(history.canBackward());
            NavigationHistoryEntry[] entries = history.getBackwardEntries();
            if (entries.length > 0) {
                NavigationHistoryEntry entry = entries[0];
                String text = WorkbenchMessages.format("NavigationHistoryAction.backward.toolTipName", new String[]{entry.getHistoryText()});
                this.setToolTipText(text);
            } else {
                this.setToolTipText(WorkbenchMessages.getString("NavigationHistoryAction.backward.toolTip"));
            }
        }
    }

    private class MenuCreator
    implements IMenuCreator {
        MenuCreator() {
        }

        public void dispose() {
            if (NavigationHistoryAction.this.historyMenu != null) {
                int i = 0;
                while (i < NavigationHistoryAction.this.historyMenu.getItemCount()) {
                    MenuItem menuItem = NavigationHistoryAction.this.historyMenu.getItem(i);
                    menuItem.setData(null);
                    ++i;
                }
                NavigationHistoryAction.this.historyMenu.dispose();
                NavigationHistoryAction.this.historyMenu = null;
            }
        }

        public Menu getMenu(Menu parent) {
            return null;
        }

        public Menu getMenu(Control parent) {
            this.dispose();
            NavigationHistoryAction.this.historyMenu = new Menu(parent);
            IWorkbenchPage page = NavigationHistoryAction.this.getWorkbenchWindow().getActivePage();
            if (page == null) {
                return NavigationHistoryAction.this.historyMenu;
            }
            NavigationHistory history = (NavigationHistory)NavigationHistoryAction.this.getWorkbenchWindow().getActivePage().getNavigationHistory();
            NavigationHistoryEntry[] entries = NavigationHistoryAction.this.forward ? history.getForwardEntries() : history.getBackwardEntries();
            int[] entriesCount = new int[entries.length];
            int i = 0;
            while (i < entriesCount.length) {
                entriesCount[i] = 1;
                ++i;
            }
            entries = NavigationHistoryAction.this.colapseEntries(entries, entriesCount);
            i = 0;
            while (i < entries.length) {
                if (i > NavigationHistoryAction.this.MAX_HISTORY_LENGTH) break;
                String text = entries[i].getHistoryText();
                if (text != null) {
                    MenuItem item = new MenuItem(NavigationHistoryAction.this.historyMenu, 0);
                    item.setData((Object)entries[i]);
                    if (entriesCount[i] > 1) {
                        text = WorkbenchMessages.format("NavigationHistoryAction.locations", new String[]{text, new Integer(entriesCount[i]).toString()});
                    }
                    item.setText(text);
                    item.addSelectionListener((SelectionListener)new SelectionAdapter(this, history){
                        final /* synthetic */ MenuCreator this$1;
                        private final /* synthetic */ NavigationHistory val$history;
                        {
                            this.this$1 = menuCreator;
                            this.val$history = navigationHistory;
                        }

                        public void widgetSelected(SelectionEvent e) {
                            this.val$history.shiftCurrentEntry((NavigationHistoryEntry)e.widget.getData());
                        }
                    });
                }
                ++i;
            }
            return NavigationHistoryAction.this.historyMenu;
        }
    }
}

