/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.dialogs.DialogUtil;
import org.eclipse.ui.internal.dialogs.NewWizardCollectionSorter;
import org.eclipse.ui.internal.dialogs.NewWizardSelectionPage;
import org.eclipse.ui.internal.dialogs.WizardCollectionElement;
import org.eclipse.ui.internal.dialogs.WizardContentProvider;
import org.eclipse.ui.internal.dialogs.WorkbenchWizardElement;
import org.eclipse.ui.internal.dialogs.WorkbenchWizardNode;
import org.eclipse.ui.model.AdaptableList;
import org.eclipse.ui.model.WorkbenchAdapter;
import org.eclipse.ui.model.WorkbenchLabelProvider;

class NewWizardNewPage
implements ISelectionChangedListener,
IDoubleClickListener {
    private static final int DESCRIPTION_IMAGE_HEIGHT = 150;
    private static final int DESCRIPTION_IMAGE_WIDTH = 200;
    private static final String DIALOG_SETTING_SECTION_NAME = "NewWizardSelectionPage.";
    private static final int SIZING_LISTS_HEIGHT = 200;
    private static final int SIZING_VIEWER_WIDTH = 300;
    private static final int SIZING_DESC_WIDTH = 200;
    private static final String STORE_EXPANDED_CATEGORIES_ID = "NewWizardSelectionPage.STORE_EXPANDED_CATEGORIES_ID";
    private static final String STORE_SELECTED_ID = "NewWizardSelectionPage.STORE_SELECTED_ID";
    private static final String SHOW_ALL_ENABLED = "NewWizardSelectionPage..SHOW_ALL_SELECTED";
    private TreeViewer viewer;
    private NewWizardSelectionPage page;
    private Hashtable selectedWizards = new Hashtable();
    private IDialogSettings settings;
    private Button showAllCheck;
    private Text descriptionText;
    private WizardCollectionElement wizardCategories;
    private WorkbenchWizardElement[] primaryWizards;
    private WizardContentProvider contentProvider;
    private ToolItem helpButton;
    private String wizardHelpHref;
    private Canvas descImageCanvas;
    private Map imageTable = new HashMap();
    private Label imageSeperator;
    private WorkbenchWizardElement selectedElement;
    private boolean needShowAll;

    public NewWizardNewPage(NewWizardSelectionPage mainPage, IWorkbench aWorkbench, WizardCollectionElement wizardCategories, WorkbenchWizardElement[] primaryWizards) {
        this.page = mainPage;
        this.wizardCategories = wizardCategories;
        this.primaryWizards = primaryWizards;
        this.trimPrimaryWizards();
        boolean bl = this.needShowAll = this.primaryWizards.length > 0;
        if (this.needShowAll && this.allPrimary(wizardCategories)) {
            this.wizardCategories = null;
            this.needShowAll = false;
        }
    }

    private void trimPrimaryWizards() {
        ArrayList<WorkbenchWizardElement> newPrimaryWizards = new ArrayList<WorkbenchWizardElement>(this.primaryWizards.length);
        int i = 0;
        while (i < this.primaryWizards.length) {
            if (this.wizardCategories.findWizard(this.primaryWizards[i].getID(), true) != null) {
                newPrimaryWizards.add(this.primaryWizards[i]);
            }
            ++i;
        }
        this.primaryWizards = newPrimaryWizards.toArray(new WorkbenchWizardElement[newPrimaryWizards.size()]);
    }

    private boolean allPrimary(WizardCollectionElement category) {
        Object[] wizards = category.getWizards();
        int i = 0;
        while (i < wizards.length) {
            WorkbenchWizardElement wizard = (WorkbenchWizardElement)wizards[i];
            if (!this.isPrimary(wizard)) {
                return false;
            }
            ++i;
        }
        Object[] children = category.getChildren();
        int i2 = 0;
        while (i2 < children.length) {
            if (!this.allPrimary((WizardCollectionElement)children[i2])) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    private boolean isPrimary(WorkbenchWizardElement wizard) {
        int j = 0;
        while (j < this.primaryWizards.length) {
            if (this.primaryWizards[j].equals(wizard)) {
                return true;
            }
            ++j;
        }
        return false;
    }

    public void activate() {
        this.page.setDescription(WorkbenchMessages.getString("NewWizardNewPage.description"));
    }

    protected Control createControl(Composite parent) {
        Font wizardFont = parent.getFont();
        Composite outerContainer = new Composite(parent, 0);
        outerContainer.setLayout((Layout)new GridLayout(2, false));
        outerContainer.setFont(wizardFont);
        this.createViewer(outerContainer);
        this.createDescription(outerContainer);
        if (this.needShowAll) {
            this.showAllCheck = new Button(outerContainer, 32);
            GridData data = new GridData(768);
            data.horizontalSpan = 2;
            this.showAllCheck.setLayoutData((Object)data);
            this.showAllCheck.setFont(wizardFont);
            this.showAllCheck.setText(WorkbenchMessages.getString("NewWizardNewPage.showAll"));
            this.showAllCheck.setSelection(false);
            this.showAllCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){
                private Object[] expandedElements = new Object[0];

                /*
                 * Exception decompiling
                 */
                public void widgetSelected(SelectionEvent e) {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 116->120)] java.lang.Throwable
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }
            });
        }
        this.updateDescription(null);
        this.restoreWidgetValues();
        return outerContainer;
    }

    private void createDescription(Composite parent) {
        Composite descParent = new Composite(parent, 0);
        GridData data = new GridData(1808);
        data.widthHint = 200;
        descParent.setLayoutData((Object)data);
        GridLayout layout = new GridLayout(2, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        descParent.setLayout((Layout)layout);
        Label descLabel = new Label(descParent, 0);
        descLabel.setFont(parent.getFont());
        descLabel.setText(WorkbenchMessages.getString("NewWizardNewPage.descriptionLabel"));
        data = new GridData(768);
        descLabel.setLayoutData((Object)data);
        Image buttonImage = WorkbenchImages.getImage("IMGS_LCL_LINKTO_HELP");
        ToolBar toolBar = new ToolBar(descParent, 0x800100);
        this.helpButton = new ToolItem(toolBar, 0);
        this.helpButton.setImage(buttonImage);
        this.helpButton.setToolTipText(WorkbenchMessages.getString("NewWizardNewPage.moreHelp"));
        data = new GridData(896);
        toolBar.setLayoutData((Object)data);
        this.helpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkbenchHelp.displayHelpResource(NewWizardNewPage.this.wizardHelpHref);
            }
        });
        this.descriptionText = new Text(descParent, 74);
        this.descriptionText.setFont(parent.getFont());
        data = new GridData(1808);
        data.grabExcessVerticalSpace = true;
        data.horizontalSpan = 2;
        this.descriptionText.setLayoutData((Object)data);
        this.imageSeperator = new Label(descParent, 258);
        data = new GridData(768);
        data.horizontalSpan = 2;
        this.imageSeperator.setLayoutData((Object)data);
        this.descImageCanvas = new Canvas(descParent, 0);
        data = new GridData(68);
        data.horizontalSpan = 2;
        data.widthHint = 200;
        data.heightHint = 150;
        this.descImageCanvas.setLayoutData((Object)data);
        this.descImageCanvas.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Iterator i = NewWizardNewPage.this.imageTable.values().iterator();
                while (i.hasNext()) {
                    ((Image)i.next()).dispose();
                }
                NewWizardNewPage.this.imageTable.clear();
            }
        });
        this.descImageCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                ImageDescriptor descriptor = null;
                if (NewWizardNewPage.this.selectedElement != null) {
                    descriptor = NewWizardNewPage.this.selectedElement.getDescriptionImage();
                }
                Point size = NewWizardNewPage.this.descImageCanvas.getSize();
                if (descriptor != null) {
                    Image image = (Image)NewWizardNewPage.this.imageTable.get(descriptor);
                    if (image == null && (image = descriptor.createImage(false)) != null) {
                        ImageData scaledData = this.scale(image.getImageData());
                        if (scaledData != null) {
                            Image newImage = new Image((Device)NewWizardNewPage.this.descImageCanvas.getDisplay(), scaledData);
                            image.dispose();
                            image = newImage;
                        }
                        NewWizardNewPage.this.imageTable.put(descriptor, image);
                    }
                    if (image != null) {
                        NewWizardNewPage.this.imageSeperator.setVisible(true);
                        GC gc = new GC((Drawable)NewWizardNewPage.this.descImageCanvas);
                        Rectangle bounds = image.getBounds();
                        int xOffset = (size.x - bounds.width) / 2;
                        int yOffset = (size.y - bounds.height) / 2;
                        gc.drawImage(image, xOffset, yOffset);
                        gc.dispose();
                        return;
                    }
                }
                NewWizardNewPage.this.imageSeperator.setVisible(false);
                GC gc = new GC((Drawable)NewWizardNewPage.this.descImageCanvas);
                gc.fillRectangle(0, 0, size.x, size.y);
                gc.dispose();
            }

            private ImageData scale(ImageData imageData) {
                int width = imageData.width;
                int height = imageData.height;
                float scale = 1.0f;
                Point size = NewWizardNewPage.this.descImageCanvas.getSize();
                if (width > height) {
                    if (width > size.x) {
                        scale = (float)size.x / (float)width;
                    } else if (height > size.y) {
                        scale = (float)size.y / (float)height;
                    }
                }
                if (scale == 1.0f) {
                    return null;
                }
                width = (int)((float)width * scale);
                height = (int)((float)height * scale);
                return imageData.scaledTo(width, height);
            }
        });
    }

    private void createViewer(Composite parent) {
        Composite treeParent = new Composite(parent, 0);
        treeParent.setFont(parent.getFont());
        GridData data = new GridData(1808);
        data.widthHint = 300;
        boolean needsHint = DialogUtil.inRegularFontMode(treeParent.getParent());
        if (needsHint) {
            data.heightHint = 200;
        }
        treeParent.setLayoutData((Object)data);
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        treeParent.setLayout((Layout)layout);
        Label wizardLabel = new Label(treeParent, 0);
        wizardLabel.setFont(parent.getFont());
        wizardLabel.setText(WorkbenchMessages.getString("NewWizardNewPage.wizardsLabel"));
        data = new GridData(768);
        wizardLabel.setLayoutData((Object)data);
        Tree tree = new Tree(treeParent, 2820);
        this.viewer = new TreeViewer(tree);
        this.contentProvider = new WizardContentProvider(false);
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.viewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.viewer.setSorter((ViewerSorter)NewWizardCollectionSorter.INSTANCE);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.viewer.addDoubleClickListener((IDoubleClickListener)this);
        ArrayList<Object> inputArray = new ArrayList<Object>();
        int i = 0;
        while (i < this.primaryWizards.length) {
            inputArray.add(this.primaryWizards[i]);
            ++i;
        }
        boolean expandTop = false;
        if (this.wizardCategories != null) {
            if (this.wizardCategories.getParent(this.wizardCategories) == null) {
                Object[] children = this.wizardCategories.getChildren();
                int i2 = 0;
                while (i2 < children.length) {
                    inputArray.add(children[i2]);
                    ++i2;
                }
            } else {
                expandTop = true;
                inputArray.add(this.wizardCategories);
            }
        }
        if (expandTop) {
            this.viewer.setAutoExpandLevel(2);
        }
        AdaptableList input = new AdaptableList(inputArray);
        this.viewer.setInput((Object)input);
        tree.setFont(parent.getFont());
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection s = (IStructuredSelection)event.getSelection();
                Object element = s.getFirstElement();
                if (NewWizardNewPage.this.viewer.isExpandable(element)) {
                    NewWizardNewPage.this.viewer.setExpandedState(element, !NewWizardNewPage.this.viewer.getExpandedState(element));
                } else if (element instanceof WorkbenchWizardElement) {
                    NewWizardNewPage.this.page.advanceToNextPage();
                }
            }
        });
        data = new GridData(1808);
        tree.setLayoutData((Object)data);
    }

    public void doubleClick(DoubleClickEvent event) {
        this.selectionChanged(new SelectionChangedEvent((ISelectionProvider)event.getViewer(), event.getViewer().getSelection()));
        this.page.advanceToNextPage();
    }

    protected void expandPreviouslyExpandedCategories() {
        String[] expandedCategoryPaths;
        boolean showAll = this.settings.getBoolean(SHOW_ALL_ENABLED);
        if (this.showAllCheck != null) {
            this.showAllCheck.setSelection(showAll);
            this.contentProvider.setFiltering(!showAll);
        }
        if ((expandedCategoryPaths = this.settings.getArray(STORE_EXPANDED_CATEGORIES_ID)) == null || expandedCategoryPaths.length == 0) {
            return;
        }
        ArrayList<WizardCollectionElement> categoriesToExpand = new ArrayList<WizardCollectionElement>(expandedCategoryPaths.length);
        int i = 0;
        while (i < expandedCategoryPaths.length) {
            WizardCollectionElement category = this.wizardCategories.findChildCollection((IPath)new Path(expandedCategoryPaths[i]));
            if (category != null) {
                categoriesToExpand.add(category);
            }
            ++i;
        }
        if (!categoriesToExpand.isEmpty()) {
            this.viewer.setExpandedElements(categoriesToExpand.toArray());
        }
    }

    protected Object getSingleSelection(IStructuredSelection selection) {
        return selection.size() == 1 ? selection.getFirstElement() : null;
    }

    protected void restoreWidgetValues() {
        this.expandPreviouslyExpandedCategories();
        this.selectPreviouslySelected();
    }

    public void saveWidgetValues() {
        this.storeExpandedCategories();
        this.storeSelectedCategoryAndWizard();
    }

    public void selectionChanged(SelectionChangedEvent selectionEvent) {
        this.page.setErrorMessage(null);
        this.page.setMessage(null);
        Object selectedObject = this.getSingleSelection((IStructuredSelection)selectionEvent.getSelection());
        if (selectedObject instanceof WizardCollectionElement) {
            this.updateCategorySelection((WizardCollectionElement)selectedObject);
        } else if (selectedObject instanceof WorkbenchWizardElement) {
            this.updateWizardSelection((WorkbenchWizardElement)selectedObject);
        } else {
            this.updateDescription(null);
        }
    }

    protected void selectPreviouslySelected() {
        String selectedId = this.settings.get(STORE_SELECTED_ID);
        if (selectedId == null) {
            return;
        }
        WorkbenchAdapter selected = this.wizardCategories.findChildCollection((IPath)new Path(selectedId));
        if (selected == null && (selected = this.wizardCategories.findWizard(selectedId, true)) == null) {
            return;
        }
        StructuredSelection selection = new StructuredSelection((Object)selected);
        this.viewer.setSelection((ISelection)selection);
    }

    public void setDialogSettings(IDialogSettings settings) {
        this.settings = settings;
    }

    protected void storeExpandedCategories() {
        Object[] expandedElements = this.viewer.getExpandedElements();
        ArrayList<String> expandedElementPaths = new ArrayList<String>(expandedElements.length);
        int i = 0;
        while (i < expandedElements.length) {
            if (expandedElements[i] instanceof WizardCollectionElement) {
                expandedElementPaths.add(((WizardCollectionElement)expandedElements[i]).getPath().toString());
            }
            ++i;
        }
        this.settings.put(STORE_EXPANDED_CATEGORIES_ID, expandedElementPaths.toArray(new String[expandedElementPaths.size()]));
    }

    protected void storeSelectedCategoryAndWizard() {
        if (this.showAllCheck != null && this.showAllCheck.getSelection()) {
            this.settings.put(SHOW_ALL_ENABLED, true);
        } else {
            this.settings.put(SHOW_ALL_ENABLED, false);
        }
        Object selected = this.getSingleSelection((IStructuredSelection)this.viewer.getSelection());
        if (selected != null) {
            if (selected instanceof WizardCollectionElement) {
                this.settings.put(STORE_SELECTED_ID, ((WizardCollectionElement)selected).getPath().toString());
            } else {
                this.settings.put(STORE_SELECTED_ID, ((WorkbenchWizardElement)selected).getID());
            }
        }
    }

    private void updateCategorySelection(WizardCollectionElement selectedCategory) {
        this.selectedElement = null;
        this.page.selectWizardNode(null);
        this.updateDescription(null);
    }

    private void updateDescription(WorkbenchWizardElement selectedObject) {
        String string = "";
        if (selectedObject != null) {
            string = selectedObject.getDescription();
        }
        if (this.descriptionText != null && !this.descriptionText.isDisposed()) {
            this.descriptionText.setText(string);
        }
        this.wizardHelpHref = selectedObject != null ? selectedObject.getHelpHref() : null;
        if (this.wizardHelpHref != null) {
            this.helpButton.getParent().setVisible(true);
        } else {
            this.helpButton.getParent().setVisible(false);
        }
        this.descImageCanvas.redraw();
    }

    private void updateWizardSelection(WorkbenchWizardElement selectedObject) {
        WorkbenchWizardNode selectedNode;
        this.selectedElement = selectedObject;
        if (this.selectedWizards.containsKey(selectedObject)) {
            selectedNode = (WorkbenchWizardNode)this.selectedWizards.get(selectedObject);
        } else {
            selectedNode = new WorkbenchWizardNode(this.page, selectedObject){

                public IWorkbenchWizard createWizard() throws CoreException {
                    return (INewWizard)this.wizardElement.createExecutableExtension();
                }
            };
            this.selectedWizards.put(selectedObject, selectedNode);
        }
        this.page.selectWizardNode(selectedNode);
        this.updateDescription(selectedObject);
    }

    static /* synthetic */ Button access$0(NewWizardNewPage newWizardNewPage) {
        return newWizardNewPage.showAllCheck;
    }

    static /* synthetic */ WizardContentProvider access$2(NewWizardNewPage newWizardNewPage) {
        return newWizardNewPage.contentProvider;
    }
}

