/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.progress.ProgressLabelProvider;
import org.eclipse.ui.internal.progress.ProgressMessages;
import org.eclipse.ui.internal.progress.ProgressTreeContentProvider;
import org.eclipse.ui.internal.progress.ProgressTreeViewer;

public class ProgressMonitorJobsDialog
extends ProgressMonitorDialog {
    private ProgressTreeViewer viewer;
    private int viewerHeight = -1;
    Composite viewerComposite;
    private Button detailsButton;

    public ProgressMonitorJobsDialog(Shell parent) {
        super(parent);
    }

    protected Control createDialogArea(Composite parent) {
        Composite top = (Composite)super.createDialogArea(parent);
        this.viewerComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.viewerComposite.setLayout((Layout)layout);
        GridData viewerData = new GridData(1808);
        viewerData.horizontalSpan = 2;
        viewerData.heightHint = 0;
        this.viewerComposite.setLayoutData((Object)viewerData);
        return top;
    }

    void handleDetailsButtonSelect() {
        Shell shell = this.getShell();
        Point shellSize = shell.getSize();
        Composite composite = (Composite)this.getDialogArea();
        if (this.viewer != null) {
            this.viewer.getControl().dispose();
            this.viewer = null;
            composite.layout();
            shell.setSize(shellSize.x, shellSize.y - this.viewerHeight);
            this.detailsButton.setText(ProgressMessages.getString("ProgressMonitorJobsDialog.DetailsTitle"));
        } else {
            int heightHint;
            this.viewer = new ProgressTreeViewer(this.viewerComposite, 2818);
            this.viewer.setUseHashlookup(true);
            this.viewer.setSorter(new ViewerSorter(){

                public int compare(Viewer testViewer, Object e1, Object e2) {
                    return ((Comparable)e1).compareTo(e2);
                }
            });
            ProgressTreeContentProvider provider = new ProgressTreeContentProvider(this.viewer);
            this.viewer.setContentProvider((IContentProvider)provider);
            this.viewer.setInput(provider);
            this.viewer.setLabelProvider((IBaseLabelProvider)new ProgressLabelProvider());
            GridData viewerData = new GridData(1808);
            viewerData.heightHint = heightHint = this.convertHeightInCharsToPixels(10);
            this.viewer.getControl().setLayoutData((Object)viewerData);
            Point size = this.viewer.getControl().computeSize(this.viewerComposite.getBounds().width, heightHint);
            this.viewer.getControl().setSize(size);
            this.viewerComposite.layout();
            this.viewer.getControl().setVisible(true);
            this.viewerHeight = this.viewer.getControl().getBounds().height;
            this.detailsButton.setText(ProgressMessages.getString("ProgressMonitorJobsDialog.HideTitle"));
            shell.setSize(shellSize.x, shellSize.y + this.viewerHeight);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.detailsButton = this.createButton(parent, 13, ProgressMessages.getString("ProgressMonitorJobsDialog.DetailsTitle"), false);
        this.detailsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProgressMonitorJobsDialog.this.handleDetailsButtonSelect();
            }
        });
        this.detailsButton.setCursor(this.arrowCursor);
        Label spacer = new Label(parent, 0);
        spacer.setLayoutData((Object)new GridData(768));
        super.createButtonsForButtonBar(parent);
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = false;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        data.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)data);
        composite.setFont(parent.getFont());
        this.createButtonsForButtonBar(composite);
        return composite;
    }

    protected void clearCursors() {
        if (this.detailsButton != null && !this.detailsButton.isDisposed()) {
            this.detailsButton.setCursor(null);
        }
        super.clearCursors();
    }
}

