/*
   SwingWT
   Copyright(c)2003-2004, R. Rawson-Tetley

   For more information on distributing and using this program, please
   see the accompanying "COPYING" file.

   Contact me by electronic mail: bobintetley@users.sourceforge.net

   $Log: JRadioButton.java,v $
   Revision 1.24  2004/05/06 12:35:22  bobintetley
   Parity with Swing constants for Binary Compatibility + fixes to JDesktopPane

   Revision 1.23  2004/04/30 13:20:43  bobintetley
   Fix to unrealised peer preferred sizes, forwarding window events to
   content panes and fix for mouse drag events.

   Revision 1.22  2004/04/28 08:38:11  bobintetley
   Hierarchy fixes, code cleanup for base classes, additional javadocs and use of flag to identify JComponent descendants with peers

   Revision 1.21  2004/03/30 10:42:46  bobintetley
   Many minor bug fixes, event improvements by Dan Naab. Full swing.Icon support

   Revision 1.20  2004/02/13 15:09:23  bobintetley
   JComboBox/Abstract button non-peer selection and JTable threading fixed

   Revision 1.19  2004/01/26 08:11:00  bobintetley
   Many bugfixes and addition of SwingSet

   Revision 1.18  2004/01/20 07:38:05  bobintetley
   Bug fixes and compatibility methods

   Revision 1.17  2004/01/16 15:53:32  bobintetley
   Many compatibility methods added to Container, Component, JInternalFrame,
      UIManager, SwingUtilities, JTabbedPane, JPasswordField, JCheckBox
      and JRadioButton.

   Revision 1.16  2003/12/17 16:30:42  bobintetley
   Flowlayout fix, vertical toolbar support and cleaned up text alignment
   hierarchy.

   Revision 1.15  2003/12/16 18:04:10  bobintetley
   Fixes to handling of mnemonics

   Revision 1.14  2003/12/16 17:46:17  bobintetley
   Additional thread safety methods

   Revision 1.13  2003/12/16 13:14:33  bobintetley
   Use of SwingWTUtils.isSWTControlAvailable instead of null test

   Revision 1.12  2003/12/15 18:29:57  bobintetley
   Changed setParent() method to setSwingWTParent() to avoid conflicts with applications

   Revision 1.11  2003/12/15 15:54:25  bobintetley
   Additional core methods

   Revision 1.10  2003/12/14 09:37:39  bobintetley
   Cached selection support

   Revision 1.9  2003/12/14 09:13:38  bobintetley
   Added CVS log to source headers

*/


package swingwtx.swing;

import org.eclipse.swt.widgets.*;
import org.eclipse.swt.*;

import swingwt.awt.event.*;

import java.util.*;

public class JRadioButton extends swingwtx.swing.AbstractButton implements ButtonModel, SwingConstants {
    
    /** boolean thread safe accessor */
    private boolean bRetVal;
    
    public JRadioButton() {this(""); }
    public JRadioButton(String text) { this(text, false); }
    public JRadioButton(String text, Icon icon) { this(text, false); }
    public JRadioButton(String text, boolean selected) { pSelection = selected; pText = text; setModel(this);  showMnemonic(); }
    
    /**
     *  Sends mouse events to component listeners 
     *  Overriden from Component to handle ItemEvents
     */
    public void processMouseEvent(MouseEvent e) {
        Iterator i = mouseListeners.iterator();
        while (i.hasNext()) {
            MouseListener ml = (MouseListener) i.next();
            if (e.eventID == MouseEvent.CLICKED) { ml.mouseClicked(e); processItemEvent(); }
            if (e.eventID == MouseEvent.ENTERED) ml.mouseEntered(e);
            if (e.eventID == MouseEvent.EXITED) ml.mouseExited(e);
            if (e.eventID == MouseEvent.PRESSED) ml.mousePressed(e);
            if (e.eventID == MouseEvent.RELEASED) ml.mouseReleased(e);
        }
    }
    
    /**
     * Sends KeyEvents to component listeners
     * Overriden from Component to handle ItemEvents
     */
    public void processKeyEvent(KeyEvent e) {
        Iterator i = keyListeners.iterator();
        while (i.hasNext()) {
            KeyListener ml = (KeyListener) i.next();
            if (e.eventID == KeyEvent.PRESSED) { ml.keyTyped(e); processItemEvent(); }
            if (e.eventID == KeyEvent.RELEASED) ml.keyReleased(e);
            if (e.eventID == KeyEvent.PRESSED) ml.keyPressed(e);
        }  
    }

    /** Overriden to calculate non-realised
     *  preferred size.
     */
    protected swingwt.awt.Dimension calculatePreferredSize() {
        // Use the text height/width + 2 pixels for
        // borders and an extra 8 pixels for the radio itself.
        swingwt.awt.Dimension size = new swingwt.awt.Dimension( 
            SwingWTUtils.getRenderStringWidth(pText) + 10, 
            SwingWTUtils.getRenderStringHeight(pText) + 6);
        setSize(size);
        return size;
    }
    
    
    /**
     * Once a parent component receives an "add" call for a child, this being
     * the child, this should be called to tell us to instantiate the peer
     * and load in any cached properties.
     */
    public void setSwingWTParent(swingwt.awt.Container parent) throws Exception {
        descendantHasPeer = true;
        ppeer = new Button(parent.getComposite(), SWT.RADIO);
        ppeer.setText(pText);
        ppeer.setSelection(pSelection);
        ppeer.setAlignment(SwingWTUtils.translateSwingAlignmentConstant(pVAlign) | 
            SwingWTUtils.translateSwingAlignmentConstant(pHAlign));
        peer = ppeer;
        this.parent = parent;
    }
    
    public boolean isSelected() { 
        bRetVal = false;
        SwingUtilities.invokeSync(new Runnable() {
            public void run() {
                if (!SwingWTUtils.isSWTControlAvailable(ppeer)) bRetVal = pSelection; else bRetVal = ppeer.getSelection();
            }
        });
        return bRetVal;
    }
        
    public void setSelected(final boolean b) { 
        SwingUtilities.invokeSync(new Runnable() {
            public void run() {
                if (SwingWTUtils.isSWTControlAvailable(ppeer)) ppeer.setSelection(b); else pSelection = b; 
            }
        });
        processItemEvent();
    }

    public Object[] getSelectedObjects() {
        return null;
    }          
    
    public boolean isArmed() {
        return false;
    }
    
    public boolean isPressed() {
        return false;
    }
    
    public boolean isRollover() {
        return false;
    }
    
    public void setArmed(boolean b) {
    }
    
    public void setPressed(boolean b) {
    }
    
    public void setRollover(boolean b) {
    }
    
}
