//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "AppBar.h"
#include "DockCanvas.h"
#include "ModTabPanel.h"
#include "biblecsmgr.h"
#include "BookMarkPanel.h"
#include "DeskTopNameForm.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "MenuBar"
#pragma resource "*.dfm"
TAppBarFrm *AppBarFrm;
//---------------------------------------------------------------------------
__fastcall TAppBarFrm::TAppBarFrm(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------

void __fastcall TAppBarFrm::FormCreate(TObject *Sender)
{
	ImageList1->Add(BackBtnImage->Picture->Bitmap, NULL);
	ImageList1->Add(SearchBtnImage->Picture->Bitmap, NULL);
	mainmgr = new BibleCSMGR(ModInstFrm);
	activeDesktop = 0;
}
//---------------------------------------------------------------------------
void __fastcall TAppBarFrm::SpeedButton2Click(TObject *Sender)
{
	if (activeDesktop) {
		TModTabPanel *textTabs = new TModTabPanel(activeDesktop, mainmgr, "Biblical Texts");
		textTabs->ManualDock(activeDesktop, NULL, alLeft);
	}
}
//---------------------------------------------------------------------------
void __fastcall TAppBarFrm::SpeedButton5Click(TObject *Sender)
{
	if (activeDesktop) {
		TBookMarkPanel *bookmarks = new TBookMarkPanel(activeDesktop);
		bookmarks->ManualDock(activeDesktop, NULL, alLeft);
	}
}
//---------------------------------------------------------------------------

void __fastcall TAppBarFrm::SpeedButton3Click(TObject *Sender)
{
	if (activeDesktop) {
		TModTabPanel *textTabs = new TModTabPanel(activeDesktop, mainmgr, "Commentaries");
		textTabs->ManualDock(activeDesktop, NULL, alLeft);
	}
}
//---------------------------------------------------------------------------

void __fastcall TAppBarFrm::SpeedButton4Click(TObject *Sender)
{
	if (activeDesktop) {
		TModTabPanel *textTabs = new TModTabPanel(activeDesktop, mainmgr, "Lexicons / Dictionaries");
		textTabs->ManualDock(activeDesktop, NULL, alLeft);
	}
}
//---------------------------------------------------------------------------

void __fastcall TAppBarFrm::TabControl1Change(TObject *Sender)
{
	int index = TabControl1->TabIndex;
	if (index > -1) {
		activeDesktop = ((TForm *)(TabControl1->Tabs->Objects[index]));
		activeDesktop->Show();
	}
	else activeDesktop = 0;
}
//---------------------------------------------------------------------------

void __fastcall TAppBarFrm::SpeedButton1Click(TObject *Sender)
{
	DeskTopNameFrm->ShowModal();
	activeDesktop = new TDockCanvasFrm(this);
	activeDesktop->OnClose = FormClose;
	activeDesktop->OnActivate = FormActivate;
	activeDesktop->Caption = DeskTopNameFrm->desktopName->Text;
	TabControl1->Tabs->AddObject(activeDesktop->Caption, activeDesktop);
	if (activeDesktop->Top < (this->Top + this->Height))
		activeDesktop->Top = this->Top + this->Height + 1;
	activeDesktop->Show();
}
//---------------------------------------------------------------------------

void __fastcall TAppBarFrm::FormClose(TObject *Sender,
	 TCloseAction &Action)
{
	int index = TabControl1->Tabs->IndexOfObject(Sender);
	TabControl1->Tabs->Delete(index);
	TabControl1->TabIndex = 0;
	TabControl1Change(Sender);
}
//---------------------------------------------------------------------------

void __fastcall TAppBarFrm::FormActivate(TObject *Sender)
{
	int index = TabControl1->Tabs->IndexOfObject(Sender);
	TabControl1->TabIndex = index;
	TabControl1Change(Sender);
}
//---------------------------------------------------------------------------

