/***************************************************************************
 *   Copyright (C) 2004 by Ivan Forcada Atienza                            *
 *   ivan@forcada.info                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "config.h"
#include "mainwindow.h"
#include "swsglobals.h"

#include <kuniqueapplication.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>

static const char description[] =
        I18N_NOOP("Simple Wireless Scanner (SWScanner). A wireless network organizer, scanner and wardriving tool");

static const char version[] = VERSION;

static KCmdLineOptions options[] =
        {
                { "i", 0, 0 },
                { "iface <interface>", I18N_NOOP( "Set the preselected interface" ), 0 },
                { "f", 0, 0 },
                { "fileopen <file>", I18N_NOOP( "Set the file to open on start (.sws, .nsf)" ), 0 },
		{ "+file" , I18N_NOOP( "File to open at start (.sws, .nsf)" ), 0 },
		{ "startscan", I18N_NOOP( "Automatically starts scanning" ), 0 },
		{ "on", I18N_NOOP( "Automatically starts scanning" ), 0 },
		{ "enable-sound", I18N_NOOP( "Enable sound on start (disabled by default)" ), 0 },
                KCmdLineLastOption
        };

APList * SWSglobals::aplist;

int main(int argc, char **argv)
{
	KAboutData about("swscanner", "SWScanner", VERSION, description,
			KAboutData::License_GPL, "(c) 2005 Ivan Forcada Atienza", 0, "http://www.swscanner.org", "swscanner@swscanner.org");
	about.addAuthor( "Ivan Forcada Atienza", I18N_NOOP("Original autor. Developer"), "ivan@swscanner.org", "http://ivan.forcada.info");
	about.addCredit( "Andres Seco Hernandez", I18N_NOOP("Creator and maintainer of Debian package"), "andressh@alamin.org");
	//about.addCredit( "Pablo Bustamante", I18N_NOOP("SWScanner icon and web page CSS styles creator"), "pablobh@gmail.com");
	about.addCredit( "Eugenio J. Sanchez", I18N_NOOP("Initial testing. Beta packager"), "eugenio@humaneswireless.net");
	about.setTranslator(	I18N_NOOP("_: NAME OF TRANSLATORS\nYour names"),
				I18N_NOOP("_: EMAIL OF TRANSLATORS\nYour emails") );

        KCmdLineArgs::init(argc, argv, &about);
        KCmdLineArgs::addCmdLineOptions( options );
	
	//TODO: use KUniqueApplication when client-server model implemented
        //KUniqueApplication * app = new KUniqueApplication();
        KApplication * app = new KApplication();
        int ret;
	
	#if SWSDEBUG
          printf("SWScanner compiled to send extra debug information to stdout.\n");
	#endif

	printf("Running SWScanner version: %s\n", VERSION);

	SWSglobals::setnodes( new APList );	// Create the list of ap's before the main GUI form

	MainWindow * mw = new MainWindow( "SWScanner" , Qt::WType_TopLevel); // Don't set WDestructiveClose (I will delete it at the end)

	app->setMainWidget( mw );
	mw->show();

        ret = app->exec();

	delete mw;
	delete app;
        delete SWSglobals::nodes();	// Free list memory and... bye bye ;-)
        printf("Return with: %d\n",ret);
        return ret;
}

